META
key;value
description;District PB in Warszawa, Wola
country;Poland
unit;Warszawa
district;Wola
subunit;Wola
instance;2024
num_projects;61
num_votes;5689
budget;5679919
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
1367;1115000;2988;Drzewa i zieleń urządzona na Woli;education,culture,environmental protection,public space,sport,urban greenery;children,seniors;1;52.25033239135709;20.963381767796818
1372;854000;2272;Odbetonujmy podwórka;environmental protection,public space,urban greenery;children,seniors;1;52.23202417604147;20.963604926801057
856;1100000;2150;Naprawa alejek w Parku Moczydło;public space,sport,urban greenery;children,seniors;1;52.24137396248642;20.954137801600154
1345;456000;2078;Więcej zieleni i bezpiecznych przejść dla pieszych;public transit and roads,public space,urban greenery;children,seniors;1;52.2393162949615;20.956915712304184
1040;50000;1869;Kino plenerowe w Parku Szymańskiego;culture,public space;children,seniors;1;52.23189994867243;20.951185226440433
251;720000;1805;Targi śniadaniowe na Woli;culture,public space;children,seniors;1;52.23702780729178;20.95033153013916
644;193000;1791;Na Woli czytamy do woli-wsparcie wolskich bibliotek;education,culture,welfare;children,seniors;1;52.23806947857143;20.961759035244604
1391;129700;1758;Kamery monitoringu na Woli - etap 2 - cała Wola;public transit and roads,public space;children,seniors;1;52.24764133728613;20.9886646270752
977;900000;1737;Wolskie podwórka bez betonu, ale z zielenią;environmental protection,public space,urban greenery;children,seniors;1;52.246184362124495;20.983049869537357
1504;689000;1712;BO warto dbać o Wole - psi wybieg, nasadzenia drzew i zieleni, nowe ławki, śmietniki, nowe aktywności kulturalne i wiele więcej!;education,public transit and roads,culture,environmental protection,welfare,public space,sport,urban greenery;children,seniors;0;52.23797600037877;20.960044860839847
1102;252000;1704;Celujemy do koszy (na śmieci): więcej koszy na Woli;public space;children,seniors;0;;
384;30000;1654;Zapobieganie bezdomności zwierząt;environmental protection;;1;;
1279;84000;1577;Krzewy na Wolskiej i Połczyńskiej;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.222620644603026;20.926852226293697
1645;50000;1524;Skrzynki lęgowe dla ptaków w Lasku na Kole;environmental protection;;0;52.25018913044668;20.95122814178467
1285;42000;1503;Krzewy na Kasprzaka;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.22859535;20.973732177934536
571;165000;1480;Zielona Wola – renowacja zieleni oraz nowe nasadzenia przy ul. Ciołka i Obozowa;education,public space,urban greenery;children,seniors;0;52.24659040380471;20.944147109985355
1627;980000;1443;Bo warto dbać o wolskie parki - nowe altany w wolskich parkach, remont placu zabaw - Skwer Psa Fafika!;environmental protection,public space,urban greenery;children,seniors;0;52.23529729649147;20.96448575234922
1418;371600;1394;Bardziej naturalne place zabaw;environmental protection,public space,urban greenery;children;0;52.23710392185826;20.94532299015555
1392;997000;1353;Przyjazna Żelazna, Nowa Redutowa, Lepsza Obozowa;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.23950381811952;20.959430694056213
715;980000;1310;Zielona Wola - ekologicznie, zdrowo, sportowo.;education,environmental protection,public space,sport,urban greenery;children,seniors;0;52.22827995;20.977576535725667
1404;90560;1293;Zazieleńmy ulicę Żelazną;public transit and roads,public space,urban greenery;children,seniors;0;52.22961578550515;20.993800163269047
1522;808000;1264;Przywracamy dziecięcą radość! - remonty placów zabaw na Woli. BO warto!;education,public space,sport;children;0;52.22898126190823;20.947109447839658
1077;61500;1229;Stojaki na hulajnogi i rowery przy wolskich szkołach podstawowych;education,public transit and roads,public space,sport;children,seniors;0;52.23965136788365;20.979166030883793
1269;371400;1227;Nowy mini-park na Odolanach (przy Karlińskiego);environmental protection,public space,urban greenery;children,seniors;0;52.22432944398149;20.93474896481886
1385;958000;1196;Wola: Zielona metamorfoza Koła - park kieszonkowy, nowe drzewa i krzewy;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.24344635447257;20.941510881602884
1042;47740;1122;Rodzicu - reaguj na zdrowie psychiczne dziecka;education,welfare;;0;;
186;261000;1088;Nasz eko skwer na Woli;education,environmental protection,public space,sport,urban greenery;children;0;52.24020498947616;20.97002506256104
1380;800000;957;5 koncertów na Woli;culture;children,seniors;0;52.23268030264037;20.948724746594962
248;605000;921;Zieleń zamiast betonu na Skwerze Bohdana Lacherta;education,culture,environmental protection,public space,urban greenery;children,seniors;0;52.24050982865415;20.98845720291138
575;60000;890;Wybieg dla psów;public space,urban greenery;seniors;0;52.24230728495245;20.95951080322266
634;196000;849;Książkomat na Woli;education,culture,public space;children,seniors;0;52.2337003;20.9684318
1304;80000;840;Wieczorki taneczne w Parku Szymańskiego przy muzyce na żywo;culture;children,seniors;0;52.23363467419075;20.949425697326664
1403;10000;787;Zazieleńmy ulicę Twardą;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.22849600907438;20.99319934844971
1048;55400;785;Bezpieczna Wola. Kurs samoobrony i ratownictwa;education,welfare,sport;seniors;0;52.241080925000006;20.94693330078186
1362;48000;759;WOLA. Neony na szkołach.;public space;children,seniors;0;52.23486578165614;20.959097358958854
914;80000;750;Plenerowa przestrzeń warsztatowo-relaksacyjna przy ul. Elekcyjnej.;public space;children,seniors;0;52.23413155;20.947573419115354
1376;28000;700;Potańcówki dla wolskich emerytów;culture,welfare;seniors;0;52.236156113552006;20.967473983182575
1036;8208;679;Darmowe konwersacje w języku angielskim dla mieszkańców Woli;education;children,seniors;0;;
1294;83025;647;Drzewa przy ul. Brożka;environmental protection,urban greenery;children,seniors;0;;
688;400000;637;Stop betonozie - remont podwórka przy Anielewicza;environmental protection,public space,urban greenery;children,seniors;0;52.24638019903023;20.98414421081543
393;29000;635;Zajęcia stolarskie dla pań, dzieci i rodzin na Woli;education,culture,environmental protection;children,seniors;0;52.234642;20.967604700000003
1361;120000;549;Sąsiedzkie spotkania ze sztuką - warsztaty artystyczne na Woli dla osób dorosłych.;education,culture,welfare;seniors;0;;
1613;42700;543;Reorganizacja ruchu pieszego w łuku ul. Krępowieckiego;public transit and roads,public space,urban greenery;children,seniors;0;52.239626840760245;20.935649871826175
1539;241000;542;Warszawa zrywa z betonem - rewitalizacja podwórka Żelazna 43A;education,public transit and roads,culture,environmental protection,public space,sport,urban greenery;children,seniors;0;52.2308556;20.992853293964334
1043;17608;500;Kurs Mindfulness - uważności dla dzieci i młodzieży (Elekcyjna);education;children;0;52.23413155;20.947573419115354
1395;6215;484;Spotkania z historią Woli dla uczniów wolskich szkół oraz wszystkich chętnych;education,culture;children,seniors;1;52.238057271428566;20.97788634625053
1045;103816;454;Centrum Uwagi Słuchowej przy SP 236;education,welfare;children,seniors;0;52.23387647935197;20.94778633065289
1369;90000;428;Sąsiedzkie gotowanie na Woli - warsztaty kulinarno - edukacyjne dla rodzin z dziećmi oraz dorosłych.;education,culture;seniors;0;52.23634000982047;20.940628051757816
1350;10408;413;Darmowe zajęcia z programowania w SP 236;education;children;0;52.233844939344046;20.94775199890137
916;61668;395;Darmowy cykl warsztatów Minecrafta dla dzieci;education;children;0;52.23413155;20.947573419115354
855;800000;373;Naprawa alejek na skwerze przy ul. Żytniej (tzw. Klimczok);public space,urban greenery;children,seniors;0;52.23868339116089;20.973192214441955
1179;576000;370;Zagospodarowanie terenu podwórza Miedziana/Twarda;environmental protection,public space,urban greenery;children,seniors;0;52.22822500833333;20.991374281114798
983;460000;367;Budowa schodów od ronda im. Jana Himilsbacha do Al. Jana Pawła II;public transit and roads,public space;children,seniors;0;52.258045057918444;20.980882644653324
1386;9086;354;Międzypokoleniowe spotkania sąsiedzkie na Woli;culture,welfare;children,seniors;0;52.230793250000005;20.95063802297184
1052;12845;348;Poznaj swoje prawa. Szkolenie dla uczniów szkół ponadpodstawowych z prawa pracy i działalności związków zawodowych;education;;0;52.249839099999996;20.966041331977255
938;4000;343;Summer yoga in English - Joga po angielsku w parku;education,welfare,sport;seniors;0;52.23100627573675;20.9480094909668
1046;15207;302;Zajęcia taneczne dla dzieci przy ul. Elekcyjnej;culture,sport;children;0;52.23413155;20.947573419115354
276;45000;275;Poprawa bezpieczeństwa: Instalacja dwóch progów zwalniających na ulicy Dzielnej;public transit and roads,public space;children,seniors;0;52.2452240549692;20.98895072937012
1184;144000;268;Zielona i sąsiedzka przestrzeń przy Piaskowej 7;public space,sport,urban greenery;children,seniors;0;52.255680807361;20.97611904144287
1182;120000;250;Bezpieczna droga do przedszkola - Koło Dobiszewskiego 3A;public transit and roads,public space;children,seniors;0;52.2450472;20.955791785373748
957;70000;227;Doświetlenie ulicy Kłopot pomiędzy budynkami Kłopot 2 i Kłopot 4;public transit and roads;children,seniors;0;52.25746714164266;20.979294776916507
VOTES
voter_id;vote;age;sex
36;186;46;F
73;571;53;F
212;1522,1404,186,1269,1285,977,1279,1627,571,1184,1504,248,1418,1367,1372;36;M
226;1380,1392,644,1404,977,571,1040,1367,1372,1294,1102,634;48;F
260;1269,1645,575,1285,1392,1391,977,1613,571,1367,1372,1279,1627,1504,384;34;F
313;856,1102,1645,1269,1285,1345,977,1613,914,1040,1279,1367,1372,1392,1391;50;M
376;1367;41;M
389;1350,1046,1380,634,1392,688,1048,276,644,1404,1391,251,1040,1504,1627;32;F
394;1392,1269,1102,634,575,1345,251,938,914,1279,1504,1036,1048,644,1391;36;M
437;384,248,644,1042,1504,1539,1345,1403,1372,1392,1404,715,1077,1179,1627;39;F
451;1380,1386,1504,1045,1395,384,1369,1043,1645,1392,1304,1345,1391,251,1040;60;F
588;1304,1522,1345,1391,1613,1504,186,571,1362,1102,1392,977,1279,1367,1372;31;M
600;1285,1304,1539,688,1345,1404,1403,977,1279,1179,186,571,1395,248,1184;44;F
604;983,957;41;F
614;575,1304,1522,1391,251,938,1279,1627,384,1036,1362,856,1613,1040,1179;21;F
623;1504,1345,1522,1285,1042,715,856,1269,644,251,1279,1040,1077,1362,916;33;F
634;1372,1367,1418,571,186,1279,977,1403,1404,1345,1522,1285,1182,856;26;M
649;1285,1102;29;M
653;1367;45;M
654;644,1040,571,1077,1418,1367,1036,1372,1376;73;F
681;1367;7;M
726;1294,1042,856,715,1269,1645,1285,1522,1345,1391,1504,1077,1418,1367,1372;32;F
790;1042,575,1504,248,1372,856,1645,1279,1367;36;M
802;1102,1345,1367,1279;29;F
820;1522,1102,1504,1627,1367,1372,977,1345,715,1385,856,1269,1380,1392,1279;41;F
823;644,1404,1403,1391,977,186,1627,248,1418,384,1036,1369,1372,393,1362;22;F
826;1367,571,1627,1504,977,1345,1285,575,1645,1269,856,1613,384,1372,1279;38;M
969;1522,634,1380,715,1102,856,1285,1077,384,1269,1362;38;F
1032;856,1391,1367,1376;22;M
1063;1102,1042,575,1285,1048,1052,1345,644,1391,1504,1077,1395,1367,1036,1372;42;F
1165;393,1102,938,1395,1043;27;F
1201;1279,1627,248,1362,1376,1385,1102,1285,1404,186,571,1418,1367,384,1372;20;M
1233;1048,1369,1046,393,1036,1418,1522;40;F
1278;1627,1269,1279,1392,1418,1042,1294,856,1380,1522,644,1040,1077,1372,1362;34;F
1299;715,644,251,571,1367,1504,1392;38;F
1394;1052,1380,634,1645,1040,644;50;F
1410;644,634,1042,1361,1645,1036,1369,1040,916,393,251,1048,1522,1380,1046;45;F
1418;1376,1285,1052,1391,914,1279,1040,186,1395,1418,393,1362,1361,1269,1048;30;M
1493;715,1048,1345,1040,1372,1418,1627,856,1102,1391,938,1504,571,1367,575;26;M
1501;1361,1042,1380,634,1048,1345,1391,251,914,1040,186,1077,384,1367,1036;45;F
1511;1369,1385,644,1361,1645,1304,1404,1403,1627,1504,186,1184,1367,977,938;35;F
1553;856,1102,1522,1391,1418;39;M
1691;1385,1304,1102,856,1182,251,571,1367,1376;62;F
1768;1404,1048,1304,983,1645,1046,1269,575,1285,276,1345,1391,1279,384,1362;43;M
1780;977,1279,251,644;44;M
1798;1504,1043,916,1048,1392,1350,1042,1182,1645,1285,1522,1391,1613,1418,384;46;F
1904;1269,1285,1613,1279,1522,1392,1504;37;M
1932;1102,1285,1304,1048,1052,644,1386,1279,1040,1077,384,1036,393,916,1376;35;F
1956;977,1627,1418,1369,393,1043,1361,856,1048,644,1077;34;F
2073;1645,983,1285,1304,957,1345,644,1391,977,1279,1040,1504,1184,1372,1367;44;F
2115;575,251,571,384,856,1367,1269,1285,1279;47;F
2144;1361,1350,1042,634,1392,1048,1052,644,1404,1045,1376,1386,1040,1395,1372;20;F
2159;1392,1102,715,1048,1345,1404,977,1179,186,1627,571,248,1418,1367,1372;40;M
2242;384,1184,248,571,856,1385,1350,715,1645,1372,1367,1395,1504,575;47;F
2283;1036,1367,977,1043,1102,1042,1048,914,856,1361,575,251,1504,384,1372;29;F
2334;1645,1077,1367,1372,856,715,1269,1285,1522,1345,644,1279,1504,1418,1362;35;F
2448;1040,1504,1627,384,1367,1036,1645,634,1042,1102,1361,1285,1048,644,1404;26;F
2463;186,571,1385,1392,1367,1345,1102,634,855,644,1391,977,248,1418,1372;39;F
2473;1380,251,1040,248,1102,688,977,1372;27;F
2578;1391,856,1361,1362,1102,1380,634,855,575,644,251,186,248,384,393;38;F
2599;856,1269,1285,1392,276,1613,1279,1040,571,1077,1395,1367;36;M
2606;1345,1304,1285,856,1385,1380,855;57;F
2635;384,1102,1539,1522,1403,1077,634,276,1345,644,1404,1179,248,1367,1372;42;F
2701;1269,715,856,1102,1385,1645,575,1392,1345,1391,1504,1627,571,384,1367;44;F
2702;1367;36;M
2743;1372,1391,1345,1392,1285,1042,1361,1102,1269,1304,1048,251,1279,1040,393;29;F
2787;186,393,1042,575,384;44;F
2819;1522,1345,1391,1077,1418;45;F
2833;1380,1182,856,1385,715,1304,1391,1040,1392,1522,251,1504,186,571,1418;38;F
2905;1367,983,1042,957,1345,938,1627,1045,644,276,977,688,1395,1391,1043;39;F
3099;1376,856,1102,1392,1048,1403,1404,644,1077,1395,1036,1350,384,634,938;34;F
3147;186,1040,977,251,644,1345,1380,1042,1269,1285,1304,1522,1391,1418;33;F
3215;1385,248,1345,251,1279,856,1102,1285,1392,1404,1403,977,1040,571,1269;28;M
3232;1042,1645,855,575,688,1048,251,977,1504,1627,384,1367,1372,1043,1376;22;F
3253;977,1279,1504,571,1184,1367,856,1539,688,1345,1404,1403,1391,248,1372;30;F
3285;571,1040,1386,251,1391,1404,644,1042,1294,856,1367,1372,1362,1376;50;F
3295;1043,1040,251,1304,1392,1269;37;F
3301;575;16;F
3346;1522,251,977,1504,571,1077,1418,1372,1362,715,856,1367,1040,914,644;39;F
3370;856,1102,634,1645,1392,1304,1345,644,1040,1285,1279,1372;34;M
3398;1102,1645,1048,977,1395,1418,384,1367,1372;50;F
3402;914,1102,856,1048,251;42;F
3405;1048,1392,1042,1385,856,1380,634,1522,644,251,571,1077,1367,1036;34;F
3415;1367,983,957;32;M
3421;1294,1361,1102,1645,575,1522,1345,1404,1040,1504,186,1627,248,1418,384;43;F
3422;856,1046,1392,1522,1345,1391,914,1504,1627,571,1385,1380,644,384,1367;28;F
3505;1645,1304,1372,856,1385,1269,1392,1522,1345,914,1279,1040,1504,1418,1367;33;F
3539;1285,1345,1391,251,977,1279,1179,1504,1627,248,1418,384,1367,1372,393;27;F
3557;856,1361,1102,1645,1285,251,977,1279,1504,384,1367;32;F
3564;1361,1645,688,276,1345,1391,977,248;34;M
3639;1380,1522,977,1367,856,1285,1391,251,1279,1040,1627,644,1269,384,1362;32;F
3642;1285,575,1294,1385,856,715,1269,1645,1304,914,1279,1504,384,1367,1372;38;F
3712;571,1040,938,251,1391,1304,1392,1361,1385,715,1418,1372,1036;31;F
3750;1102,1042,1645,251,1040,384,1372;26;F
3805;914,1279,1367,1043,856,1102,1350,1294,1645,1392,1613,1040,571,1045,1362;33;M
3810;1372,634,1269;18;M
3939;186,1627,1395,1036,393,1350,1385,1361,1052,914,1040,1045,384,1043,1042;36;F
3951;1048,1345,384,1367,1376;24;F
3987;575,983,1285,1392,1345,1391,251,938,977,1279,1504,186,1627,571,384;41;F
4005;1046,1539,1504,1077,1184,1048,715,856;30;M
4012;856,1102,634,1522,1345,644,1613,251,977,1040,1418,1367,1372,916,1376;37;F
4072;1361,1102,1645,1285,1304,1048,1391,938,634,186,1269,644,393,1040,1042;34;F
4117;856,1645,575,1304,1345,1391,251,1040,1504,571,384,1367,1036,1369,1372;36;F
4119;1042,1294,856,1385,1269,1285,1522,644,251,977,1040,1627,1367,1369,393;36;F
4121;575,384;71;F
4126;1102,1285,1304,1391,977,1279,1040,1504,186,1627,1367,1372;30;F
4171;384,1102,575,251;25;F
4212;1048,1391,1386,1279,1040,1504,1627,1077,1367,1036,1372,393,1043,1361,1042;22;F
4213;1184,1376;50;F
4246;1052,1391,1077,1395,393,1372,856,1385,1182,1522,251,977,186,1418,1362;36;F
4274;1350,715,1285,1404,977,1077,1184,384,1294,1645,644,1418,248,571,1372;41;M
4282;983,957;50;M
4286;1350,1046,914,1045,1036,1043,916;39;F
4326;1403,1391,977,914,1279,1179,248,1418,1367,1372,856,1269,1285,1404,1345;34;M
4329;1372,393,1362,1361,1102,1645,1539,1391,977,1386,1179,571,1376,688,248;44;F
4394;575;35;F
4468;856;28;F
4501;1052,384,1645,1627,1522,1386,1376,1369,1362,1304,1040,977,938,575,251;25;M
4506;1613,644,1392,1285,1269,715,1385,856,1294,1522,251,977,1279,1418,1367;42;F
4533;393,856,1102,1345,1404,1403,977,1367,1392,1285,1613,1279,248,1418,1372;37;M
4594;914,977,1294,856,1345,1279,1627,1102,1380,1392,1304,1613,1040,1504,1376;39;F
4636;1345;51;M
4641;1042,1102,1345,856,1385,1294,1645,575,1040,1504,1627,571,384,1367,1372;36;F
4668;1345,251,1279,1395,1418,1367,1361,1380,634,688,977,1040,1627,571,248;37;F
4682;1418,1392,916,1386,1380,1372,1504,914,1046,1627,1522,251,1269,1362,644;39;F
4689;1522,1392,186,914,1391,575,1102,1294,1042,1645,1048,276,1404,1403,571;38;M
4696;1385,1102,856,1361,1269,634,1522,644,251,977,1504,186,1418,1367,1372;34;F
4724;1645,983,688,1403,1404,276,1345,977,1372,1367,1627,186,248,393,384;35;F
4782;715;37;F
4839;1645,977,1279,1385,1294,1345,1404,856,1522,186,571,1077,248,1418,1367;37;F
4882;1269,1102,1279,856,251;28;M
4893;1380,575,644,938,1040,186,1395,384,393;43;F
4899;1367,1184,1627,1504,977,251,1391,1404,1345,1285,575,1645,393;24;M
4924;276,1539,1645,1102,1367,1372,1404;29;F
4932;1522,688,276,1391;37;F
4977;957,983;31;F
4994;957,983;36;M
4996;1539,1042,1380,575,1345,1404,938,977,1504,186,1627,384,1367,1036,1372;22;F
5014;1385,1077,1418,1102,634,1048,856,1294,1042,1645,644,1391,571,1367,1362;39;F
5107;1522,1345,1627,1045,1395,1043,1362,856,1042,634,1304,644,251,186,393;46;F
5132;1361,1102,1042,1269,634,1645,1285,1304,1048,644,1391,938,1040,186,393;6;F
5194;1179;41;M
5204;977,1522,1392,1627,1404,1418,1372,1046,1369,1304;45;F
5244;1179;4;M
5247;688,1522,1392,983,575,1042,715,276,1404,1391,977,248,1367,384,1372;41;F
5301;1522,856,1102,855,1539,688,1404,1391,977,1504,1627,571,384,1367,1372;40;M
5320;1380,575,644,938,1040,186,1395,384,393;11;M
5344;1048,1391,571,1269,1645,575,1285,1345,977,1279,1179,1504,1627,384,1367;39;F
5357;1403,393,1179;41;F
5384;1380,575,644,938,1040,186,1395,384,393;15;M
5400;1048,251,914,1040,1392,1345,1391,1077;36;F
5406;856,1404,1040,1077,1367,1372,715,1504,1345,1362,1179,1285;44;M
5426;1404,1391,977,384,1367,1372;41;F
5429;1179;2;F
5438;715,1392,1285,1345,977,1279,1504,186,1627,856,1304,251,1040,1367,1372;22;F
5476;855,1391,977,1372;34;F
5512;856,1380,1392,1048,1345,251,977,914,1279,1040,1077,1369,393,916;37;M
5524;1385,1294,1285,1304,1403,1404,977,1279,634,1645,855,644,1367,1372,393;37;F
5533;1102,1285,1522,1048,1040,1418,393,715,1350,1046,914,1045,1036,1043,916;38;F
5567;715,1102,1345,1403,1504,1392,1539,688,276,1404,977,1179,1627,1418,1372;30;M
5605;1539,1404,977,1179,571,248,1367,1372;29;F
5657;276,1345,977,1504,186,1367,1036,1102,1046,688,1404,1391,1418,384,1372;35;F
5684;1380,251,1036;35;M
5749;1418,1376,1077,186,1279,1391,1385,856,1645,644,1367;46;M
5751;276,644,1391,977,1279,1504,186,1627,571,1077,1395,248,1418,1367,1372;36;F
5781;856,1042,1077,1040,914,644,1522,1392,1285,715;35;F
5813;1102,1391,977,1040,1627,856,1042,1380,983,688,276,1345,1077,1372,1376;40;F
5816;1102,1269,938,1279,1627,856,1380,1285,1048,1040;40;F
5817;1380,1285,1304,251,1279,1040,384,1367,1369,1372;33;F
5828;575,1040,715,571,1376;40;F
5835;575,1285,916,856,1102,1380,1042,1345,1279,186,1077,1040,251,1392,715;38;M
5927;1279,1179,186,571,384,634,1645,1285,644,1404,1403,977,248,1367,1372;38;F
5937;715;27;F
5981;1392,715;7;M
6006;1645,575,1392,1522,1345,251,977,914,1504,1285,1404,1403,1279;39;F
6008;688;48;F
6010;1102,1380,634,575,855,1345,644,1391,1279,1504,384,1367;44;M
6038;1362,916,1045,186,644,957,1350,1042,1102,1385,1269,634,983,1052,1043;30;M
6059;1386,914,977,938,1391,1048,1392,1645,1385,1102,1042,644,571,384,1367;30;F
6102;1345,1040,1504,1627,1395,248,1102,1269,575,1522,251,1077,1418,1367,1372;31;F
6117;1504,856,1269,1392,1304,1279,1627,1418;54;F
6241;575,1380,856,1613,1627,1040,251,1345,1392,1504,1279,1269,1418,1367,1372;31;F
6252;1042,1391,1362,1102,1345;28;M
6283;1102,1182,1522,977,1040;34;M
6305;1522,1418;19;F
6313;1269,1285,1392,1404,1613,1279,571,248;48;F
6342;1279,1040,1179,1627,571,248,1367,1036,1380,1304,688,644,1391,251,977;68;F
6463;1102,634,1392,1522,644,1391,977,1504,1627,571,1395,1418,384,1367,1372;68;F
6478;571,1627,186,1504,1279,983,1294,1285,1613,1077,1391,1367,1102,856,1376;40;M
6513;1522,855,1294,1385,715,1645,1285,1392,1539,1404,1403,977,1279,1395,1362;19;M
6544;715,1279,571,1385,1102,1367,1613,1645,251,856,1345,1392,1380,1627,1040;46;M
6583;715,251,1040,1418,393,916;37;F
6714;856,1102,1350,1042,1345,644,1391,1613,914,1279,1040,1077,1418;36;F
6718;1345,1040,1395,1392,644,1404,1179,977,1386,1036,1372,1627,1367,393,1376;62;F
6751;1345,251,914,1504,1077,1036,916,1362,1040,1386,276,1048,1361,644,634;28;M
6793;276,1376;62;F
6803;856,1102,1294,983,1285,1404,1391,1613,1279,1504,186,1627,571,1077,1367;11;M
6807;1362,1361,856,1102,1294,1345,1404,1403,251,977,1279,1179,1372,983,957;33;M
6817;248,384,393,977;65;F
6828;1645,1391,1279,1627,571,1362,1392,715,1367,1504;35;M
6854;1404,856,1102,1294,983,1285,1391,1613,1279,1504,186,1627,571,1077,1367;8;M
6890;856,1102,1294,983,1285,1391,1404,1613,1279,1504,186,1627,571,1077,1367;8;F
6911;1539,856,1522,1279,571,248,1367,393,186,1345,1392,855,1404,644,1362;48;F
6920;571,1627,186,1504,1040,1391,1522,1285,1380,1269,1042,715,1102,856;37;M
6923;1522,1345,1279;38;M
6933;1279,186,1395,1048,1522,1304,1285,575,1380,644,251,1040,384,1036,1372;53;F
6963;1361,688,1345,1403,1404,1391,251,977,1040,1504,248,1367,1362,1372;37;F
6993;1279,1077,1367,1372,1102,856,1345,1391,977,1294,1052,251,1504,571,384;40;F
7027;1077,688,957,1522,1048,1345,644,1613,977,1395,1418,1367,1036,1372,393;17;F
7038;1102,715,1392,1404,1504,1367,1179;39;M
7176;1285,1304,1522,1048,1345,1391,1279,1040,1504,1627,1367,1269,251,384,1372;60;F
7207;1179;37;F
7212;1182,1294,715,983,1392,1539,1522,1404,1403,251,1627,248,1418,1372,1362;37;F
7213;634,1077,1613,1361,1042,1269,1627,1045,1418,1036,1294,1182,1395,393,1376;38;F
7234;856,1380,251,914,1040,1627,1395,1418,393,1362;43;F
7284;384,977,1367,1385,1539,688,1345,1403,1404,248,1372;47;F
7356;715,1269,634,1285,1522,644,1391,977,1279,186,1627,571,1077,1367,1372;39;M
7361;1362,1269,1279,1395,384;37;M
7401;1304,644,1391,1418,1052,1048,575,1294,1102,1385,856,1645,1040,1504,384;31;F
7459;1043,1372,1367,384,1040,1279,1102,1645;38;F
7475;1045,1077,1645,856,1361,1046,1042,1522,1052,644,1391,1504,1395,1418,1369;43;F
7480;1279,1627,1077,248,1418,384,856,1102,1385,1345,251,977,571,1367,1372;45;M
7517;1386,1040,1504,1045,1367,1392,1391,251,384;27;F
7519;1645,575,914,1418,856,1102,1613,1345,977,1279,1040,248,1367,1372,393;34;M
7521;1179,914,938,1613,1403,1404,688,1539,855,715,856,1385,1182,1392,1345;44;F
7542;1380,1294,856,1350,1042,634,575,644,251,1040,1077,1418,384,1362,916;45;M
7568;1403,1386,1043,1345,1102,855,1539,1048,977,1077,1395,248,1367,1372,644;51;F
7611;856,1102,1385,1294,1042,634,1345,1504,384,1367,1372,1645,644,1391,977;33;F
7624;1052,715,1102,1269,1380,634,1304,1522,644,1391,1040,1504,1418,1367,1362;36;F
7631;856,1102,1361,977,1386,1279,1040,248,983,1285,957,1077,1613,1345,276;36;M
7654;1504,186,1627,248,1184,1418,1367,977,571,1077,575,1345,1279,1043,1372;37;M
7690;914,1279,1040,1504,251,1391,644,1345,1285,1645,575,384,1367,1372,1362;26;F
7721;1362,186,1040,1279,1294,1102,1385,1345,251,977,384,1367,856,1391,1372;42;F
7833;1304,1522,1052,1040,1627,1077,1395,1418,1350,1046,914,1045,1036,1043,916;37;F
7862;1522,1539,1380,1042,634,1404,1403,251,248,1367,1372;34;F
7920;1404,1386,248;51;F
7923;1504,575,384;63;F
7925;1385,715,1269,1380,1048,1345,1391,1279,1040,1504,186,571,384,1367,1036;18;F
7944;983,957;17;F
7952;1504,1627,1395,1367,1285,575,634,856,1645,1391,251,384;38;F
7960;715,1285,1179,248,1372;35;F
8020;1627,1392,1391,248;33;F
8101;276;39;M
8155;1392,571,1385,1294,1285,1345,1279,1179,248,1362,856,1627;32;M
8163;1392,644,1613,1077,1418,1522,1504,1350,1046,914,1045,1036,1043,916;38;M
8183;688,1345,977,1367,1372,1645,1392,1539,1404,1403,1179;38;M
8197;1285,1539,1404,1403,1613,977,1279,1040,1504,571,248,1184,1418,1367,1372;28;M
8225;634,1269,1345,644,251,977,1279,1504,186,1627,1077,248,1418,1367,1362;32;F
8256;276,1403,1504,571,1362,1279,1102,1645,1285,1345,1404,1391,251,1613,856;31;M
8275;1522,1385,1345,1404,1613,251,977,1627,384,856,1102,1285,1367,1392,1279;47;M
8276;1345,644,1391,1613,1279,1367,1418,1504,1350,1046,914,1045,1036,1043,916;7;M
8284;856,1385,1350,1645,938;40;M
8312;1645,1285,715,1345,977,1504,1102,1392,1404,1391,186,1627,384,1367,1372;46;F
8313;1040,977,251,1391,1392,575,1645,1380,715,856,248,384,1367,1372;33;F
8342;1179,1504,1418,1367,1036,1372,1362,1376,1042,1294,1102,634,251,644,715;37;F
8361;186,248,1184,1367,1372,856,1285,1345,977,1279,1627,571,1269,1391,384;28;F
8451;1385,1294,856,1102,1269,1285,1345,1391,977,1279,1504,1627,384,1367,1372;41;M
8509;938,977,1040,1077,1418,1367,1102,1350,1522,644,1391,914,1045,1043,916;38;F
8511;1042,634,1052,1391,1395,384;31;F
8532;1345,1040,1395,384,856,1385,715,1392,1391,186,571,1367,1372,393,1362;47;F
8541;1361,1102,1385,715,1042,1418,856,1380,575,1048,1345,251,977,1367,1376;25;F
8566;1294,856,1361,575,1285,938,634,1645,1304,977,1040,384,1367,1369,1372;22;F
8569;1385,1304,1040,1036,1182,1380,1392,1386,1376;63;F
8609;1391,977,1040,384,1367,1372,1645,1269,715,1102,1380,1504,1522,1392,644;50;F
8653;1380,1102,634,1645,575,1391,1040,1036,1362;46;M
8655;1040,186,1627,571,1102,1645,1279,1077,1504,1367,856,251,1345,1372,1285;44;M
8705;1048,644,1504,571,1102,1645,1285,1522,1345,1391,1279,1627,1392,1613,384;29;F
8748;957,1404,1040,1077,1184;36;F
8770;1042,1645,1048,644,1077,1418,1350,1046,1613,914,1045,916,1043;41;M
8775;1179,1392,1285,1052,688,983,855,1645,1294,1385,1102,856,1404,276,1403;26;M
8822;575;79;M
8831;914,251,1613,1522,575,1269,1042,715,856,977,644,1418,1372,1043,916;35;F
8875;1102,1182,1048,1345,644,1391,1504,571,384;36;F
8887;938,977,914,1386,1279,1040,1179,1504,1184,1418,1367,1372,393,1376,186;25;F
8903;186;56;M
8914;1285,1403,1077,1392,1539,1404;37;M
8927;186,1040,1102,715,1380,1285,1052,1345,644,1613,1279,1077,1392,1391,251;49;M
8982;186;76;F
8988;1627,571,248,1418,1367,1372,856,1102,1522,688,1345,251,957,983,1184;33;F
8993;1392,1042,1048,1279,1522,1345,1391,977,186,1627,1367,1372,1043,1285,1504;26;F
9005;1042,1269,1048,1052,1345,644,251,977,1040,1418,1367,1036,1369,1372,393;34;F
9007;1403,1522,1504,1361,914,1045,1036,1350,248,1386,1391,1042,1052,1404,1043;26;F
9013;977,856,1042,1539,1052,1345,1404,251,1504,1627,248,1418,1367,1372,1043;28;M
9031;1269,1279;37;F
9050;1376,1304,186,1391,938,1504,1627,1036,575;37;F
9093;1045,1418,393,1361,1380,1404,1403,1391,251,977,1386,1369,1372,1376,1036;33;F
9109;644;52;F
9118;571,977,644,1345,957,1304,1392,983,1645,634,1380,1269,1294,715,1385;31;F
9151;856,1184,1391,957,983;28;M
9166;1350,1385,856,1102,715,1645,1345,1391,977,1040,1504,1627,384,1367,1372;25;M
9217;1350,715,1391,1045,384,1361,1380,1279,1077,1372,1362;31;M
9241;1645,1361,856,644,977,914,1386,1279,186,1627,571,1077,1418,384,1372;31;F
9245;571,1504,1391,1404,1345,688,1392,1285,1645,1380,1269,715,1385,1102,856;23;F
9299;1392,1404;27;M
9300;715,1042,1645,1539,1404,977,1504,186,571,248,1184,384,1367,1372;24;F
9323;186,856,1102,1385,1294,1645,1392,1345,1391,251,977,1504,571,1367,1372;34;F
9362;1391,1294,1627,1077,248,856,1102,634,1645,855,1345,644,186,1418,1367;37;F
9370;276,1391;29;M
9380;1040,1361,914,916,1046,1350,644,1045,1418,1367,393,1043;45;F
9411;856,983,957,1345,644,1367;27;F
9431;1040,1403,1404,1392,575;58;F
9439;1385,715,855,1392,276,1345,1404,1403,1613,1279,186,571,1077,248,1367;34;M
9443;393,1362,1376,688,1539,1102,856,1392,855,1345,977,1504,186,1077,1367;43;F
9448;1269,1285,1304,1367,856,1392,1522,1345,644,1391,977,914,1279,1040,1376;34;F
9463;983;40;M
9468;1102,856,1345,1613,251,977,1040,186,1504,1367,1372;29;M
9481;1269,1042,1294,715,1385,856,1345,938,977,1279,571,1418,1367,1036,1372;29;F
9491;384,1362,856,1102,1380,855,1345,1404,1391,977,1040,186,571,1367,1372;41;M
9565;1385,715,855,1392,276,1345,1404,1403,1613,1279,186,571,1077,248,1367;23;M
9590;1403,1404,1345,1539,1285,1294,1385,1102,856,1269,251,1279,1040,384,1372;48;F
9602;856,1385,1042,1380,1048,251,938,1040,1627,1043,186,1367,1036,634,1392;35;F
9620;1380,634,1645,575,1304,1052,1345,644,1404,1403,1504,384,1369,393,938;29;F
9623;1345,1392,855,575,1361,1102,1042,1380,1285,1391,1279,1040,1504,384;21;F
9654;1367,1385,1040,1279,977,938,1345,1522,1539,1392,1285,575,1645,1269,856;34;F
9661;186;70;F
9664;251;27;F
9703;1627,1522,1042,1102,856,1376,1077,1367,916,1391,251,1040,1418,1372,1362;37;F
9795;977,1391,634,1392,1504,1372,856,1102,1385,1345,1294,1645,251,571,1367;36;M
9796;1367,1627,1404,1285,1182,715,856,1385,1294,1645,1392,251,977,186,571;39;M
9803;856,1350,1046,1294,644,1285,1279,1040,1045,1367,1043,916;7;M
9817;634,688,1043,1372,1367,571,1040,977,644,1345,1048,1645,1294,1102,1385;25;F
9826;715;4;F
9845;634,1645,575,688,1404,1403,977,1279,1179,1504,186,1627,384,1367,1372;28;F
9854;1385,1392,856,1102,1269,1380,1645,1391,251,977,1040,1627,384,1367,1372;29;F
9866;1285,1418,1350,1294,1269,644,1046,914,1045,393,1043,916;7;F
9871;1522,1392,575,1102,251,977,634,644,856,571,1385,1645,393,1372,1367;31;F
9905;1367,1392,644,1182,1385,1294,856,571,1345;39;M
9924;1391,977,914,1504,384,1372,1645,1380,856,1102,715,1285,251,1040,1367;30;F
9937;1613,688,1269,1350,1046,1285,1522,644,1040,1045,1418,1043,916;11;F
9947;1279,1369,856,1391,977,1627,384,251,1504,1345,1048,1372,1392,1367,1613;28;F
9961;715,1380,1391,1279,1040,1077,1367;30;F
9978;715,1345,1372,1367,1418,571,1279,1539,1269,856,1385,1285,1392,977;35;F
9986;1504,1077,1391,1403,1404,1345,276,1539,1392,1285,1182,1385,983,957,1184;32;M
10006;1304,1522,1391,1077,1418,1042,1269,1285,1345,644,251,1279,1040,1367;40;F
10008;715;41;M
10009;983,957;31;F
10010;1052,634,276,1386,1395,1372,1376,1043,1345,938,1048,644,1391,1627,248;40;F
10011;1042,1380,1285,1040,1418,384,1367,1372;29;F
10022;715;7;F
10034;856,1645,1304,1367,384,571;26;F
10036;186,571,1418,384,1367,1372,856,1102,1380,1645,1345,1391,1040,1077,1362;42;M
10052;715;39;M
10062;715,1294,634,1285,251,914,1279,1040,186,1627,571,248,384,1372,1367;27;F
10074;1386,1504,186,1102,1380,1285,1304,1391,251,938,1040,1367,1036,393,1376;62;F
10078;644,1522,1380,1102,1385,1350,1046,1042,1392,1304,1391,914,1043,916,1376;54;F
10079;1048,1376,688;47;M
10082;248,715;69;F
10122;715;62;F
10128;1367,1036,1362,276,957,1392,983,1645,1042,1361,1102,1391,1040,1048,384;31;F
10134;856,1522,251,1627,1418,1369;28;F
10179;1048,644,186,1372,1102,715,1269,1380,1391,977,1040,1504,384,1367;31;M
10197;1042,1522;29;F
10253;1392,1645,1102,856,1385,1522,1403,1404,715,1345,1285,1279,1504,1269,1372;39;F
10263;1345,1391,1279,1376,856,715,644,251,977,1504,1627,248,384,1367,1372;36;F
10266;688,1403,1504,186,248,1184,1367,1294,1345,1418,1385,1182,977,571,1372;46;M
10305;251,1040,384,1367,393,1043,1369;31;F
10325;1539,1392,1042,1645,1345,644,1404,1403,1391,977,1179,1077,248,384,1372;30;F
10342;1285,1345,977,571,1418,1372,1077,856,1040,251,1522,644,1613,1279,1269;43;M
10363;856,1102,1385,1294,1042,251,1645,1391,571,384,1367;34;M
10378;856,1385,1285,1392,1539,1404,1403,1372,1179;28;F
10385;1040,1279,977,1391,1345,1052,1048,1522,1285,1269,1042,856,634,644,1395;36;F
10404;1345,856,1269,575,1285,1391,251,977,1279,1504,186,571,1627,384,1367;32;M
10410;1040,1627,1418,1362,856,715,634,957,644,1404,1403,1391,1504,186,1367;23;M
10426;715,1294,1392,977,1627,1367,1372,1102,856,634,1048,1345,644,1391,571;37;F
10447;856,1385,715,1042,634,1285,1522,186,1391,977,1077,1418,384,1367,1372;38;F
10450;276,1345,1404,1403,251,977,1279,248,1367,1372;38;F
10457;983,957,1184;31;M
10465;914,1504,1418,1376,856,1385,1046,1269,1304,1040,1627,1077,384,1367,1372;32;F
10480;1372,384,1418,1504,276,688,575,1522;40;F
10486;384,1627,977,251,1392,856,1522,1345,1391,914,1504,571,1418,1372,1362;35;F
10491;634,1182,1042,1294,1046,1385,856,715,1304,1522,1403,1404,251,186,1418;41;F
10517;1184,983,957;42;M
10522;1182,1285,1345,1391,251,1279,1627,1418,1367,856,715,1269,1522,1040,1077;39;F
10542;1304,1392,634,1361,1345,1048,1376,916,1372,1367,1418,1627,1522,856,1102;35;M
10556;1522,977,1380,1376;38;F
10565;1403,1391,1345,1048,688,1539,1285,634,1380,1269,1042,1294,1102,1385,715;10;F
10569;1345,251,1386,1040,384,1372,856,1385,571,1077,1367,1362,1294,1645,715;45;M
10577;957,983;35;F
10585;1392,1645,1391,1077,1376,1362,1372,1367,1418,1627,1504,1404,1345,644,1522;28;F
10590;1040,1350,1046,914,1045,1036,1043,916;6;F
10594;1404,1403,1077,1372,715,856,1367,1036,1362,644,977,688,1391,1345,248;29;M
10619;575,1392,1539,1345,1404,1403,977,1627,1372;35;F
10638;1304,1539,1391,1395,248,1367,1036,393,1376,1102,1392,1345,644,1404,1077;51;M
10660;856,1392,1539,1404,1040,393,916;35;F
10666;977,688;30;M
10688;1404,1403,1613,1279,1179,1184,1102,1380,1285,1345,1391,977,1504,1367,1372;28;F
10704;1350,1046,914,1045,1036,1043,916;8;M
10720;1042,1645,575,1285,384,393;53;F
10725;1042,1102,856,1361,715,916,1645,1285,977,1077,248,1418,1367,1036,1372;38;F
10736;1285,983,1645,1269,1102,575,938,977,1279,1504,1418,384,1367,1036,1372;32;F
10759;384,1040,1404,856,1042,1645,1627,248,1367,1372,1043,1376;27;F
10764;1179,977,1345,276,1052,688,1522,1539,983,1102,186,1627,1418,1372;37;M
10814;1404,1403,384,1367,1372,1179;25;M
10821;1627,248,1184,1418,384,1367,1372,1043,916,688,251,938,977,1279,1040;26;F
10843;1279,977,251,1404,1345,688,1539,1285,855,1645,1269,1294,1385,856,1367;35;M
10858;856,1046,1285,1304,1391,914,1279,1504,1077,1367,1369,1269,644,1040,1418;30;F
10861;1182,1285,1345,1391,251,1279,1627,1418,856,715,1269,1522,1040,1077,1367;42;M
10880;1404;26;M
10902;1294,1345,644,571,1077,1367,1372;35;M
10903;1184,384,1048,957;32;M
10909;715,1269,1645,1285,1392,1404,1391,977,1279,384,1367,1372;35;F
10923;856,1385,715,1042,1269,1645,1392,644,938,914,1279,1040,1418,384,1367;32;M
10932;1077,1040,1522,1269,715,856,1367,1418,1627,1279,251,1391,1345,1285,1182;11;M
10961;1345,977,1504,186,1367,1376,1385,1645,1392,251,1386,1040,571,1372,393;43;F
10965;688,1539,1392,983,1269,1294,715,1385,856,1102,1380,1285,977,248,1367;25;M
10976;1392,1361,1350,1182,1391,1279,1040,1395,1367,856,1269,1380,1048,251,644;38;F
10986;1077,1040,1522,1269,715,856,1367,1418,1627,1279,251,1391,1345,1285,1182;4;M
11042;1391,251,1380,1279,1269;40;M
11088;1380,1048,1345,1386,1627,1367,1369,1376,688;41;F
11132;1102,983,957,1184;41;M
11173;1042,1380,1345,1391,1040,571,1045,856,1182,251,1386,1077,1369,393;31;F
11193;855,1367,1036,1372,1362;32;M
11212;393,715;36;F
11227;1391,1404,644,1345,1522,856,1380,1102,1285,1040,186,1077,1418,384,1367;34;F
11283;1285,1392,1404,1102,1645,575,1504,186,384,1367,1362;34;M
11389;1182,1345,1404,1403,1418,634,1613,186,1184,938;29;F
11393;276,1403,1613,715,1182,1269,1539,957,1042,1645,1345,1077,384,1285;28;M
11404;575;36;M
11422;1386,977,855,634,1042,1304,957,1372,1391,1040,644,1522;40;F
11435;1182,1385,1102,1627,1077,1045,1372,1362,1269,957,276,251,1040;21;F
11452;1304,1102,1042,1645,1392,393,1350,1385,856,1182,1522,1391,1613,571,1418;38;F
11453;1361,276,1345,977,1045,1392,856,1102,1042,1182,1391,571,1418,393,1043;92;F
11484;644;56;M
11493;1361,384,1627,1040,1645,856;23;F
11539;1036,1372,393,1043,1361,715,856,1102,1645,1285,1522,977,1279,1040,1418;8;F
11572;856,1385,1182,1392,1391;39;M
11618;1279,186,1627,1077,1043,1385,1645,1392,977,571,248,1418,1367,1372;34;M
11636;1102,983,1392,1522,1345,1403,1404,1391,1279,1504,186,571,1077,1418,1367;41;M
11697;1269,715,856,1522,1345,1391,977,1077,1418,1367;39;M
11723;1369,914,251,715,1522,1048,1040,1627,1367,393,1391,644,1285,1269,1042;37;F
11758;983,1285,957,251,1040,916;37;M
11787;1361,1367,1376,1362,1369,384,1184,248,571,186,1040,1645,1102,957,983;29;F
11798;688,1539,1392,855,715,1102,1522,1403,1404;28;F
11812;251,1040,186,1627,571,384,1391,1392,1285,1102,856,1269,1279,1418,1367;33;F
11815;856,1102,1380,1392,1285,1404,1403,251,977,914,1279,1040,571,1367,1362;28;F
11825;1385,715,1294,1269,855,1285,1522,688,1345,1404,1391,977,1418,1367,1372;39;F
11851;1504,1627,1372,715,856,1102,1285,1392,1539,688,957,1404,1391,251,1036;32;M
11858;688,276,1345,1391,1077,1418,1367,1372;37;F
11921;1077,1539,688,1179,1392,1403,1404;36;M
11971;856,1269,251,914,1040,1367;24;F
12010;1294,1182,276,1345,1391,977,1040,1627,571,1077,1367,1372,715,1645,1048;38;M
12034;715,1269,1522,1391,1392,1345,251,1279,1040,1504,186,1627,1418,1367,1372;30;F
12062;575,855,1645,1380,1294,1385,715,1539,1345,977,186,248,384,1367,1372;44;F
12072;983,957;30;F
12096;1504,186,1627,1372,1048,1345;28;F
12103;1042,855,1304,977,1522,1345,1279,1040,1627,1077,1418,1367,1376,1392,1404;66;M
12116;1294,1385,1102,856,276,644,1404,1403,1391,977,1279,1179,1504,186,248;51;F
12128;1362,1269,1042,1046,1522,644,938,914,1279,1040,384,1036,1372,393,1043;40;F
12137;856,1613;24;F
12174;856,1385,1269,575,1392,251,1279,1040,1418,916;32;M
12197;1294,575,1285,1304,1048,1345,1391,251,1040,1627,1367,1372,856;28;F
12203;1345,1372,248,1391,1269,1386,644,1362,1279;36;M
12205;1362,856,1102,1304,1048,1345,1391,251,1040,186,1077,1367,1036,1369,393;33;F
12218;1522,1304,1376,856,1385,1380,855,644,251,1504,1627,1395,1369,1040,393;47;F
12224;1645,1504,1372,977,1040,1627,1077,856,1385,715,1392,644,1279,571,1367;62;M
12237;1367,186,1304,1285,715,1102,856,1269,1380,1522,1345,1391,251,1279,1077;43;M
12239;1294,1385,856,1102,715,1269,1285,1345,977,1279,186,1077,1418,1367;37;F
12243;1361,1645,1522,1345,251,571,1376,1372,1362,856,1294,1380,1304,644,1040;33;F
12260;1645,1269,1385,1102,856,1361,575,1391,251,1040,1504,1627,1367,384,393;34;F
12292;384,1372,1380,1040,1077;42;F
12307;957,983;36;F
12359;1392,1294,571,1372,1367,1285,1345,856,1627,1040,1279,1269;26;M
12361;1102,1285,251,1386,1279,1040,1304,1380,1269,1372;35;F
12367;1391,1182,276,957,1539,1077,1279,1613,1403,1404,1345,1392,1285,983,1385;31;M
12395;983,957;42;M
12404;644,1102,1380,634,251;41;F
12457;1539,1522,688,1048,1403,914,1386,1418,1369,1345,1395,1367,1184,983,957;37;M
12462;1403,1404,571,1362,715,1385,856,1269,1285,1345,977,186,1077,1418,1367;37;M
12505;1102,715,1285,1392,1522,1539,1345,644,1404,1403,1179,1504,1627,248,1367;40;M
12511;1613,1403,1404,276,957,1052,1539,1285,575,1182,1294,1102,1645,1391,384;25;F
12556;1042,1522,715;43;F
12559;1404,1403,251,977,1040,1504,186,248,1184,1367,1036,1372;28;M
12583;1269;39;F
12588;715,1042,1380,634,1285,1345,644,1040,1279,938,1269,1077,1395,1036,916;40;F
12599;1380,1304,1391,251,914,393,1269,1279,1040,1077;39;F
12602;715;44;M
12604;1042,715,1385,856,1391,571,1418,384,1367,1036,1376,1102,1645,1345,251;33;F
12625;251,977,1279,1040,186,1372,1367,1418,1345,1285,1645,1385,856,1294,571;44;F
12629;1385,715,1042,634,575,1522,644,1504,1045,384,1372,1043,1367,1036,1376;50;F
12648;1269;43;F
12651;384,393,1350,1042,1391,1279,1040,1269,1645,1504,571,1077,1367;48;M
12683;571;63;F
12694;571;65;M
12696;1077,1036,1043,1504,856,1362,251,1102,855,644,1040,1395,1372,393,916;38;F
12705;1040,1380,251,1269;38;M
12709;1046,983,957;42;F
12737;715,644,251,1279,1077,916,1367,1395,1040,1391,1345,1304,1380,1269,1042;35;F
12759;1102,1380,644,1386,1279,1040,916,1418,1395,1077,1269,1522;42;F
12766;715;8;M
12780;983;27;F
12815;1504,1627,1077,251,1391,644,1048,1285,1269,1042,715,856,1367,1369,393;6;M
12826;1392,1539,276,644,1404,1403,1179;47;F
12845;1345,914,1040,1279,186,1077,1372,977,644,856,1522,1627,248,1418,1367;39;F
12915;1102,1380,1285,1048,1052,644,1391,251,977,1040,186,1045,1367,1036,1372;20;F
13007;1380,1285,1345,1404,1391,251,1040;24;M
13021;1040,914,1042,1102,384,715,856,1361,1285,1522,1345,977,1627,1077,1367;29;F
13050;644,1645,1522,1345,1404,1077,1372,856,1385,571,1504,1367,1182;36;M
13052;1045,1645,1102,248,1391,1285,1294,1392,1504,571,575,856,384,1367,1372;30;M
13094;688;68;F
13104;715,1269,1285,1304,644,1391,251,914,1386,1279,1040,1627,1077,1367,393;5;M
13146;715;38;F
13174;1077,1045,1367,1362,856,1385,715,1269,1522,1345,977,1504,1627,1418,1372;33;F
13196;715;9;M
13230;1345,977,914,248,1404,1403,393,1362;37;M
13232;1362,856,1102,715,575,1285,1345,251,977,1279,1504,1627,384,1367,1372;28;M
13259;1385,575,1391,977,1504,1392;34;M
13261;1285,1036,1043,916,1350,1046,1045,914;41;F
13279;856,1269,1285,1392,1345,1404,1403,1391,251,977,1279,571,248,1367,1372;43;M
13283;688,1361,1345,1052,1539,1392,1285,634,1042,1102,1350,1045,1036,1043,916;37;F
13346;251,1345,1048,1285,575,634,715,1361,1042,1645,1392,1404,1391,977,1372;31;F
13349;1040,1395,1418,1367,1046,1102,1350,644,914,1504,1077,1045,384,1043,916;32;F
13371;1182;37;F
13409;1345,644,1279,1627,384,856,1269,1380,1304,1391,1613,1040,1504,571,1367;48;F
13412;644,1077,715;34;F
13497;1102,1269,1391,1279,1040,1184,1418,384,1367,1372;35;F
13501;1391,1040,571,916,1376,1077,1395,384,1367,1613,644,1522,1042,1102,856;40;F
13532;1345,1285,1043,1304,1392,1380,1361,1102,715,1042,1269,384,1367,1372,1376;24;F
13534;1392,856,384,251,1404,644,983,1645,1102,1504,186,1418,1367,393,1376;37;M
13548;1645,575,983,688,957,1184;23;F
13589;1042,1404,977,1040,916,856,715,1522,1345,1504,1627,1077,384,1367,1372;21;M
13601;248;63;F
13614;1376,1369,1367,384,1395,1040,977,1391,1345,1048,1304,1380,1042,1102,1361;18;F
13616;1367,1043,1376,1361,856,1102,1645,1304,688,1391,1504,1627,571,1372;34;F
13624;251,1304,715,1392,1539,1345,1404,1403,1613,977,1179,1504,1418,1367,1372;54;F
13626;715,644,1077;34;M
13633;856,1285,1279,1040,1367;42;F
13657;1040,186,248,855,983,1052,1613,1362,1345,1279,1627,571,1367,251,1077;38;M
13677;384,251,276,1645,1385,856,1392,571;29;M
13679;1404,977,1040,1504,186,1627,384,1372,1102,1345,1391,251,248,1367,393;33;F
13680;715,644,1077;7;M
13681;186;31;F
13701;1403,1404,856,1645,1504,186,1627,1362,248,1395,1269,1285,1279,1367,1372;51;M
13714;1385,575,688,1403,977,1627,571,248,1372,1102,983,957,1345,1184,1367;40;F
13720;1522,1504,1627,1392,856;27;M
13761;715,644,1077;5;M
13801;1285,1380,1102,1522,1345,644,1391,251,1279,1040,1077,1367,1372,393,1362;36;F
13807;688,1385,856,1102,634,248,1372,1418,1367,1404,1345,977,644;51;F
13830;715,644,1077;2;F
13868;571,1504,186,1362,1040,1350,856,1102,1042,575,1391,1418,384,1372,983;40;F
13904;1042,856,1385,715,1269,1285,1522,688,1403,977,1279,1504,1418,1367,1362;71;F
13922;977,688;51;M
13978;575,1645,1269,1102,856,1392;42;M
14025;1350,1046,1304,1522,644,251,914,1040,1077,1045,1395,1036,1369,1043,916;14;F
14040;1269,1285,1522,1048,644,251,938,977,1040,1504,186,1627,1077,1418,1372;37;F
14111;1386,251,1391,1279,186,1418,384,1367,856,1102,1285,1182,1269,1345,1077;34;M
14158;1182;39;M
14204;1102,715,1645,1539,1404,251,914,1504,248,1367,1372,1362;36;M
14206;1285,575,1345,1391,1627,384,1367;44;M
14218;1418,1627,1404,688,1522,715,1102,1350,634,276,1345,1391,977,1386,916;34;F
14235;856,1380,1304,1392,644,1391,914,1040,1367;50;F
14241;1304,855,856,1042,1380,575,688,251,1040,1504,248,384,1367,1369,1372;22;F
14275;1403,1345,1285,1380,1404,251;40;M
14280;1613;55;M
14284;983,957;41;M
14290;856,1645,1391,186,1367,1372,1102,634,575,644,251,1040,1504,571,384;41;F
14306;634,1345,1404,1627,1184,1367,1418,1372;39;M
14326;856,1102,715,1285,1391,1372;37;M
14405;248,1367,688,1372;48;F
14421;384,1418,248,571,1504,1179,1613,1391,856,1385,1392,688,251,1040,186;27;F
14424;1367,1269,251,1040;15;F
14426;251,384;47;F
14434;1504,1077,1367,1376,856,1102,634,1392,1304,1052,1345,644,1391,251,1040;31;F
14466;856,644,384,1404,688,1504,1361,1042,855,1345,977,248,1102,276,1391;40;F
14471;1304,644,856,1345,251,977,1279,1040,186,248,1367,1369,1372,1362,1376;25;M
14544;1522,1504,1627,1418,916,977,1279,1395,1362,957,1345,1391,1077,1367,1184;46;F
14553;855,1504,1345,644,276,1391,856,688,1052,977,1077,1045,248,1367,393;30;F
14556;1040,1077,393,1372,856,1392,688,1052,276,1345,977,1627,571,248,1367;29;M
14560;715,1539,1045,248,1367,1036,1369,393,1361,634;52;F
14567;575,1102,1361,855,856,1380;31;F
14589;1269;38;M
14599;1042,1385,1102,715,1269,1285,1522,1404,977,186,1367,384,1418,1372,1362;71;M
14620;1418,384,1367,1403,957,1539,575,1645,1269,1385,715,186,571,1372;32;F
14665;1367,1045,1504,977,938,1403,1404,1304,1285,1042,1046,1385,1372,1043,1376;24;M
14678;571,575,856,1385,1182,1645,1392,1345,1404,1403,1179,384,1367,393,1362;42;F
14679;957,1386,1361,1504,1645,1179,1102,1052,1048,856,644,248,1395,1369,1613;18;M
14685;1269,1404,1403,977,1279,1504,186,571,1184,248,1418,384,1367,1036,1372;26;M
14697;856,1385,715,1391,977,1279,1504,1627,1367,1372,1362,1345;33;M
14700;983,957;33;M
14711;571,1645,1294,575,1285,1539;47;F
14746;1042,1040,644;36;F
14754;1392,1048,1404,938,1504,186,571,248,1418,1367,1369,1372,393,1362,1376;22;F
14761;938,1345,1392,1385,715,634,1645,575,644,977,1040,1504,186,571,1367;24;F
14781;571,855,983,1391,1627,1362,1102,856,1376,248,1345,1522,1392,1504,1367;20;M
14795;1367,571,1279,977,1403,1404,688,1285,855,1269,715,1385,856,1345,1372;30;F
14801;977,1403,1345,688,1392,1285,1645,1269,1294,1385,1404,1418,384,1367,1372;28;M
14807;715,1392,1345,977,1504,186,1036,1367,938,1391,1304,1285,1380,914,1040;35;F
14820;856,1042,1269,1304,1522,644,1391,1279,1040,1504,1627,571,248,1418,1369;34;M
14825;1048,575,571,1285,1182,1403,1395,1362,384,1418,1077,1645,715;31;F
14830;715,1042,1345,1522,1304,575,1645,634,1380,1294,1385,856,644,251,571;66;F
14845;1504,634,977,186,1404,1179,1279,1372,1376,1367,914,1285,1102,856,1269;20;M
14914;715,1345,1404,251,977,1179,1504,186,571,248,384,1367,1372,1362,916;24;F
14925;856,1385,1042,1182,1040,1367,1036,1372;36;F
14933;1385,1285,1404,1279,1504,1627,1372,1376,1367;24;F
14958;1182,1285,644,1391,977,1279,1040,384,1367,1372;34;M
15009;983,575,855,1042,1294,715,856,1385,1102,1391,251,1504,384,1367,1372;24;F
15015;914,186,1627,1042,1504,1102,1385,1392,1391,977,1179,571,384,1367,1372;87;M
15050;1385,1294,1285,1392,688,1345,1404,1403,1279,1179,1504,186,571,1367,1372;31;M
15076;715,1294,1345,1403,1404,977,571,248,1367,1372,1279,1285,1269;39;M
15167;1269,248,1077;45;F
15197;1102,575,644,251,1369,393,384,1418,1367,1077,1391,1345,1522,1269,856;32;F
15230;1418,384,1362,856,1385,715,1285,1403,977,1279,1504,186,1627,1367,1372;48;F
15241;248,634,1385,1040,186,644,571;28;M
15252;1522,1539,1403,1404,1077,1418,1372,1269,644,1345,1392,248,1376,977,688;34;F
15299;1040,914,1269,1046,1350;46;F
15325;1385,1294,1645,1285,1404,1403,1279,571,1367;41;F
15346;715;40;F
15351;248,384,1362,1077,1179,977,1391,1403,1404,1345,688,1539,1182,1367,1372;24;F
15364;715,1345,1391,251,977,1040,1627,1077,1367,1369,1372;25;M
15408;855,977,1040,1418,384,1367,1372,1362;25;F
15419;384,1182,1645,1345,1404,1613,1077;38;M
15451;1504,1077,1036,1372,1362,856,1645,1304,1522,644,1391,251,1040,1418,1367;39;F
15502;1539,1285,1345,1403,571,1418,1362,856,1102,1645,1404,977,1279,1367,1372;56;M
15516;634,1042,1102,1385,715,1392,251,1279,1627,856,1345,1504,1367,1372,1362;29;M
15525;251,186,1367,634,715,1522,1345,1077,1392,1048,1042,1040,393,644;50;M
15539;1376,384,855,393,248,1369,1645,1345,1404,1391,977,1367,1102,856,1048;58;F
15558;1269;33;M
15582;1372;43;F
15598;1392,856,1102,1269,1522,1391,251,1279,1040,1627,1077,1395,1418,1367,1036;37;F
15617;634,1042,856,1367,1043,688,1404,384,916,1184;23;F
15648;276,1345,1418,715,1522,1404,1391,251,1627,977,1077,248,1367,1372,1362;68;F
15666;1627,1077,1036,1362,1385,856,1102,715,977,644,1391,1504,384,1367,1372;48;F
15673;1102,856,1645,1392,186,1376,1040,1627,1048,251,634,644,1386,1504,575;23;F
15696;186,1045,384,1294,1042,1645,1285,1522,1362,856,1102,1269,1040,1077,1418;43;F
15700;1522,1539,983,1418,393,1043,1350,1046,1102,1042,1269,1040,1077;40;F
15795;248,1385,1102,856,1269,1380,1392,1345,1613,251,1279,1040,1504,571,1372;34;M
15798;1269,1391,251,1279,1040,1077,384;37;M
15880;1304,1345,1404,1403,1504,1102,634,644,1391,938,1179,1627,571,1367,1372;22;F
15888;575;45;M
15900;1385,856,715,1042,1269,634,1285,1345,1404,1403,977,1279,186,1077,1418;36;M
15906;1361,1102,715,1645,983,1522,688,1048,276,1345,644,1404,1391,251,384;71;F
15909;977,1404,644,1052,1539,186,1367,1369,1376,1391,1345,1048,1285,715,1362;40;F
16006;1385,1367,1285,856,1391,977,1504,1418,1345,1392,1522;34;M
16023;575,1285,1345,1404,1403,1391,251,977,1279,1504,1627,571,384,1367,1372;32;F
16029;1385,856,1345,251,1040,1367,1269;43;M
16032;1385,1046,1042,1380,1285,1369,856,1269,1304,1522,644,251,914,1279,1040;36;F
16084;1077,634,983,1522,644,1040,1184,715;50;M
16106;1380,1391,251;50;F
16138;1045,1418,1077,644,276,1645,1042,856,1102,1380,914,1040,1627,384,1367;40;M
16145;1269,1645,1627,1395,384,1102,1285,1522,1040,1362,856,1385,715,1380;38;F
16146;1376,977,1385,1102,1294,1042,1645,644,1504,571,384,1367,1372;49;F
16159;1367,1036,1504,1627,251,1391,1048,575,1645,1294,1385,1102;59;F
16172;977,1179,1627,715,1294,1345,1391,1403,1404,1372,248,571,186,1367,1504;36;M
16224;1645,1345,1392,1385,856,1294,1285,1522,977,1504,186,571,1376,1367,1372;40;F
16369;1391,1182,977,1392,1522,1048,1345,914,1279,1627,1418,1367,1372,1043,1269;43;F
16389;914,1045,1372,1367,1376,1102,1350,1392,1539,688,276,644,1404,1403,186;34;F
16410;1404,1279;51;F
16476;1304,1285,1380,634,1042,856,1048,1052,1345,1279,1040,1367,1372,1043,1362;19;M
16500;1385,1294,1539,688,1052,1345,1404,1403,977,1279,1504,571,248,1367,1376;29;F
16514;1102,1380,1645,575,1418,384,916;36;F
16527;977,1372,1042,634,644,1627,1077,1102,1522,1345,1279,1395,1269,1418,1367;38;F
16558;1345,688,1392,1645,1102,644,1404,1367,384,1372;39;F
16578;1372,1362,644,1404,1345,1052,634,1042,1102,856,1392,1522,1613,1040,1418;39;M
16608;856,1042,634,1645,1522,644,1391,251,914,1040,571,384;43;F
16618;644,688,1539,1392,634,1042,1102,1361,856,1380,1304,1522,1048,1040,384;42;F
16648;1391,1077,1361,634,644,1613,393,1043;43;M
16651;977,186,1504,1627,1372,1269,1102,856,1385,1645,914,1279,571,384,1367;46;F
16691;688;29;F
16721;1052,1404,1391,251,977,186,1627,1077,571,1045,1418,384,1367,1372,1043;25;M
16735;856,1285,251,1040;34;M
16738;715,1285,688,1345,1404,251,977,1279,1504,571,248,384,1367,1036,1372;27;M
16748;575,1285,1345,1404,251,914,1279,1040,1504,186,571,248,384,1367,1372;29;M
16759;1380,1391,251,977,186,1627,1372,856,1102,1645,1345,1040,1504,384,1367;45;F
16760;1627,1345,1522,1102,1042,1645,1052,644,251,1045,1395,384,1362;72;F
16788;1385,1102,1294,1645,1285,1345,1404,1403,977,1279,186,571,384,1367,1372;14;M
16797;1345,1391,1504,1102,1269,1285,251,384,1367;37;F
16864;186;45;M
16865;914,977,1102,1645,1285,1504,1367;39;M
16941;251,1504,1385,1102,186,1077,715,856,1304,1522,1040,1627,1369,916;36;F
16943;1304,1048,1052,1345,644,1391,251,1279,1504,186,571,1418,1367,1372,1362;14;F
17008;1102,1361,1042,634,1304,1539,1048,644,1403,1040,1045,384,1369,1372,393;21;F
17015;1645,1345,977,251,1504,571,1367,1372;26;F
17044;1179,1539,1269,393,1403,384,1385,1645,1392,977,1504,186,1418,1367,1372;35;F
17071;856,1102,1269,1285,1392,1613,977,1279,248,384,1367,1372;36;M
17081;1372,977,1345,856,1385,715,1294,1645,1391,1040,1504,186,571,384,1367;23;M
17082;1304,1367,1036,1372,1418,1345,1380,856,1040,1627,644,393,634,715,1522;33;F
17172;1362,1391,1613,1392,634,1294,1385,1102,856,1645,575,644,1504,1627,384;44;M
17174;575,1102,1380,715,1522,1048,1036,1362,916;10;F
17183;957,983;34;M
17192;276,1077,1372,688;62;M
17200;634,1048,1345,644,251,977,1040,1504,186,1627,571,384,1367,1036,1372;24;M
17244;715,1042,1182,983,1404,1403,1613,1386,186,1395,248,1418,1367;35;F
17248;856,1645,571,384,1367,1036,1376,1345,1391,1504,1418,1380,1304,1522,644;36;F
17256;1522,977,1418,1372;36;M
17282;1504,1077,1182,1645,1052,1345,1627,571,1045,1418,1367,1372,393,856,1613;42;F
17289;1046,1380,634,1522,1048,644,251,914,1040,384,1036,1369,393,1043,916;9;M
17303;1040,977,1345,1269,1042,1294,715,1102,856,634,1645,1522,1048,644,251;36;F
17319;384,1372,571,186,1279,1392,1102,1345,1391,977,1367,1539,1404,1403,1179;48;F
17348;715,1102,1645,977,1627,1372,1362,384,186,1504,1391,1345,688,575,856;23;F
17378;644,575,855,1645,1269,1294,856,1285,1345,1279,1504,1627,571,248,1367;36;M
17402;1376,1304,1102,1391,251,977,1627,1345,856,715,688,1504,384,1367,1372;54;F
17408;856,1613,914,1040,1367,1362,251,1392,1269,1285,1522,1345,1279,1077;30;F
17424;1645,856,1385,1294,1269,1345,1391,977,1279,1504,1627,186,571,384,1367;40;F
17465;186,251,575,634,644,855,1285,1279,1345,1367,1645;45;F
17519;1418,1367,1362,1345,1048,1042,856,571,1045,1077,1504,1391,1182,1385,1392;43;F
17532;1042,1350,1102,1269,1380,1304,1048,644,251,1040,1077,1418,1362,916,1376;35;M
17565;916,1362,1372,1418,1279,977,1391,1403,1345,1522,1304,1285,1645,1269,715;36;F
17590;644,634,856,715,1269,1380,1345,1391,251,977,1279,1040,1077,1367,1372;39;F
17606;276,1391,1367,384,688;41;M
17623;1285,1380,715,856,1102,1046,1269,251,1040,1077,1418,1367,1372,1043,916;42;F
17631;1269,1285,1392,1404,1403,1179,1385,1294,571,1367;27;F
17640;1102,856,1036,1048,248,977,983,957,1504,1391,1345,1042,1184,1367,186;37;F
17683;1294,1345,1404,977,1367,1372;34;M
17699;916,1043,1036,1367,1418,1077,1040,938,1404,1522,855,1042,1046;34;F
17713;856,1380,1304,1040,1627;30;F
17726;1285,1361,1385,644,1386,571,1539,1392,856,855,1345,977,1279,1367,1372;33;M
17728;644,1645,1522,688,1040;35;F
17731;1042,1294,1046,715,1350,1385,1361,856,1102,688,1345,644,1391,977,1504;59;F
17758;186;34;M
17760;186;35;F
17771;1048,1361,571,1279,1403,1404,688,1392,1385,715,856,634,384,1367,1372;44;M
17822;715,1385,856,1102,1294,1285,1522,1391,977,1279,1040,1077,1367,1372,1362;42;M
17835;1285,1385,644,1627,1077,571,186,1040,1279,914,1380,1269,1367,715,856;34;F
17851;1391,1040,1504,186,1392,1285,1102,1269,634,644,1279,1627,384,1367,1372;63;F
17899;384,957,1645,1294,1385,1042,575,251,977,1040,1504,1367,1372,393,1102;28;F
17905;1102,575,983,1285,1392,1539,1404,1367,856;27;M
17907;1345,575,1102,1645;49;M
17932;1391,251,938,384,1036,1376;32;F
17935;1269,251,856,1040;33;M
17961;1048,1391,251,977,914,1386,1279,1040,1504,384,1367,1036,1369,1372,393;38;F
17973;276,384,575,688,977;27;F
18112;957,1279,1504,571,1045,1042,983,276,1345,1403,1404,1179,384,1367,1372;35;F
18164;1372,1361,1294,1042,1285,1392,1279,1269,1645,644,251,1418,384,1367,393;33;F
18181;1504,1345,1418,1367,1304,634,1269,1042,1385,1102,856,1285,1391,251,1040;39;F
18190;1385,634,1522,644,1372,1077,384,1367;41;F
18265;186;25;F
18307;983,957;45;F
18353;983,957;47;M
18388;571,1372,1385,1042,1645,1522,251,977,186,384,1369,1376,1182,1304,1418;32;F
18398;977,251,1345,1522,856,1042,1269,634,1279,1367,1285,1645,1102,715,644;39;F
18410;1392,715,1102,856,1522,914,1040,1367,1362,1269,1285,1391,1279,1077,1418;39;M
18420;1077,1269;37;F
18439;1048,1392,1285,855,1380,1182,1294,1046,856,1102,715,1042,983,1522,1045;32;F
18448;1048,1391,977,1045,1367,1036,856,1102,1294,1042,644,1040,571,384,1372;26;M
18449;1350,644,1045,1304,251,977,914,1040,1418,1367,1036,1369,1372,916,1376;44;F
18451;1522,688,1404,251,977,1040,856,1385,1269,1345,1504,1627,248,1367,1372;49;F
18515;1613,1391,1345,1285,1380,1361,1102,1385,1350,575,1304,251,1279,1040,1504;32;F
18519;1522,1345,1077,393,1042,1380,644,1391,251,938,1279,1040,1504,1418,1367;32;F
18544;1350,1304,644,251,977,914,1040,1045,1418,1367,1036,1369,1372,916,1376;10;M
18549;186;49;F
18559;1350,1304,644,251,977,914,1040,1045,1418,1367,1036,1369,1372,916,1376;10;M
18576;1350,1304,644,251,977,914,1040,1045,1418,1367,1036,1369,1372,916,1376;7;F
18589;1102,1269,634,1279,1040,1077,1367;31;F
18598;1350,1304,644,251,977,914,1040,1045,1418,1367,1036,1369,1372,916,1376;45;M
18625;1522,1345,1504,186,1418,1392,1362,1645,1279,1077,1367;45;M
18639;1179,384,1102,1392,1539,1404,1403;49;F
18640;1391,186,1627,1367,1036,856,1042,1269,1048,1052,1404,251,977,1040,1372;22;M
18680;1367,1036,1372,916,634,856,1102,715,1042,1380,1285,644,251,1040,1077;43;F
18682;1048,1345,1391,1504,384,1372,1102,1392,1539,1404,1403,1179;16;F
18686;1392,1391,384,1102,1539,1404,1403,1179;53;M
18729;1522,914,575,1048,1052,1345,644,1391,1279,1040,1077,1042,1269,1285;38;F
18746;1102,1385,1304,1392,1522,644,914,1613,251,1279,1040,1504,1418,1372,1376;35;F
18787;1522,251,1279,1040,1504,1627,384;29;F
18804;1385,715,1042,1269,1380,1304,1522,1345,1391,251,977,1040,1504,1627,1367;37;F
18841;856,1102,1385,1645,575,1392,1285,1345,1391,1279,1504,1627,384,1367;29;F
18847;1380,1269,1285,1304,1522,644,1391,251,914,1279,1040,1504,186,1627,1418;38;F
18854;1269,1285,1040,1279,1077,1418,384,1367;43;M
18864;1042,715,856,1385,1386,977,1391,1304,1285,1102,1404,251,1040,1367,1372;47;F
18869;914,1040,1627,1077,916,856,1285,1522,644,251;62;F
18873;1418,1392,1182,644,1613,1279;42;M
18894;1361,634,855,644,1391,1386,186,1395,248,384;52;M
18900;856,575,1404,977,1504,186,1627,1367,1372;29;F
18903;1048,1052,644;30;F
18910;856,914,1386,1279,1367,1372,1376,977,251,1613,1391,644,1345,1304,1392;42;F
18922;1279,1040,1418,1367,1362,1627,571,1345,1504,1392,1645,1182,1294,1385,856;40;M
18928;1367,1369,1376,1361,856,1102,1269,1380,1285,1304,1048,644,251,1040,1077;30;F
18930;715,1350,1361,1042,634,575,1304,688,1048,1052,644,251,1504,1395,384;46;F
18955;715;32;F
18966;575,251,1504,1367;35;F
19012;1391,1052,575,1645,856,1380,1304,251,1040,1418,384;40;F
19095;1042,1285,1392,644,251,1077,856,1269,1522,1345,1279,1627,1418,1367,715;41;F
19149;1395,1627,1504,1404,1345,688,575,1645,715,1102,1042,1391,977,1367,1372;40;F
19192;1539,1404,1403,1391,977,1418,1367,1372;27;F
19210;1391,1372,571,1404,1294,1385,186,1367,1279,977,1392,1285,715,856,1269;37;F
19234;251;38;F
19238;1279,1395,1369,1042,1269,1285,393;35;F
19263;715,1042,1380,1645,688;63;F
19264;688;69;M
19267;1102,1269;38;F
19269;251;10;F
19271;384,856,1102,1269,1380,634,1645,575,1285,251,1279,1040,1504,1627,1367;33;M
19277;1102,1269,1285,1345,1391,1279,1077,916;40;F
19292;251;5;F
19308;1294,1385,856,1269,1285,1345,1404,1403,977,1279,1627,571,248,1367,1372;35;F
19316;1269;36;F
19323;1522,644,914,1279,1418,1395,1077,1048,1304,1040,1627,384,1367,1036,1372;38;F
19329;1294,1369,1269,1285,644,1279,1395,1367,393;7;F
19365;1380,1345,1046,634,1645,1285,1040,856,1294,1304,1048,644,571,1367,1376;35;F
19386;1345,644,1391,856,1269,1380,1304,251,914,1279,1040,1077,1418,1367,1372;33;M
19401;1372,1279,1391,1102,1285,1040,1269;35;M
19425;1418,1372,1391,1285,1380,1385,1102,856,855,1304,644,251,186,571;70;M
19465;1522,1077,634,1269,856,1392,644,251,914,1279,186,1627,571,1418,1367;33;F
19511;1392,1539,688,1418,1367,1345,1285,1385,715,977,856,1269,1522,644,1372;40;M
19534;856,644,1367;48;F
19545;1522,1418,916,1362,1043,914,1269,634,251,938,1386,1040,1036,1372;36;F
19607;1385,856,715,1285,1391,1040,1613,1627,1372,1504,1522,644,1362,1269,1279;36;M
19610;634,1285,251,977,1386,1279,1040,1395,384,1367,1036,1369,1372,1043,1376;56;F
19634;186,1504,1279,1391,1345,1285,644;52;F
19649;1294,1385,575,1539,1345,1404,1391,977,1504,1627,248,1418,384,1367,1372;25;F
19674;1362,1372,1367,384,1279,977,251,1391,1403,1345,1539,1350,1392,1404,1627;26;M
19685;1052,644,1279,384;33;F
19689;1418,1372,251,1345,1102,1269,1285,644,977,1040,1504,1627,571,248,1367;44;M
19755;1392,575,1042,1385,1350,856,1102,1285,1522,1048,644,1279,1077,1418,384;37;F
19783;1304,1285,1269,251,977,914,1279,1040,1367;21;F
19794;1046,1102,1361,1350,715,1380,1304,1391,914,1386,1040,1395,1376,1077,644;42;M
19813;1376,1395,1040,634,644;52;F
19863;1102,575,1304,1345,1391,1613,251,977,1279,1040,1504,1627,384,1367,1372;47;F
19869;688;40;M
19879;856,1102,1294,1380,1285,1392,1522,644,977,1279,1504,571,1367,1036,1372;32;F
19903;1269;34;F
19942;1367,1102,1285,1376,1362;26;M
19957;1376,1395,644,634;76;F
19958;856,1392,1404,1391,1613,251,977,1279,1504,1627,571,248,384,1367,1372;42;F
19983;644,1391,571;69;F
20033;1269,1645,575,1392,1304,1048,644,1391,251,977,1279,1040,1504,1367,1372;32;F
20066;977,1040,1367,384,1372;31;M
20091;1269,1376;37;M
20119;1395,1367,1102,1285,1391,251,575,1392,644,1613,977,1279,1627,384,1372;60;F
20128;1522;36;F
20133;1539,1046,1102,1042,571,1392,856,1304,977,914,1279,1040,1627,1367,1372;33;F
20161;1269,575,251,1040,1504;26;F
20162;1504,186,1367,384,571,1627,977,251,1613,1391,644,1522,1645,634,575;46;F
20236;914,1391,1345,1269,1102,856,251,1418,916,634,1522,644,1504,1077,1367;31;F
20256;1040,1386,938,1391,644,688,1522,1304,1285,1645,634,1380,1102,1361,715;35;F
20257;983,1345,688,977,1418;37;F
20275;1380,575,1522,1052,644,1279,1040,1395,1042,1077,384;45;F
20321;856,1385,1294,1645,1392,1304,1345,1391,977,1504,186,571,384,1367,1372;35;F
20353;1645,575,384;43;M
20358;1418,1036,1369,1279,644,1048,634,1361,1269,1380,251,938,1040,916;38;F
20395;575,1048,1345,1504,1627,1395,1418,1367,1369;33;F
20398;1102,1182,1645,251,1279,1369,856,1345,1391,571,1418,1367,1372,393;39;F
20417;1361,856,1380,1285,1304,644,1040,1504,1077,1395;24;M
20421;1522,1345,1404,977,1504,384,1372,856,1380,1285,644,1279,1040,1627,1367;41;F
20438;1391,1418,1102,1304,1042,1269,1392,1048,251,1040,384,1367,1036,1372,1043;24;M
20463;1345,1404,1403,1372,1392;26;M
20484;688,1613,1504,983,1077,1645,1385,571,1367,1392,1345;34;M
20546;571,1294,856,1285,1048,1345,1404,1391,977,1279,1504,1627,384,1367,1372;45;F
20547;1182,1392,1345,1504,1372,856,1385,1645,855,1391,186,1627,571,1418,1367;41;M
20570;1345,1645,715,1385,1102,856,1269,1285,1522,644,251,1279,1367;43;M
20578;1385,1269,1645,1285,1279,1052,1345,1404,1403,977,248,1418,384,1367,1372;13;F
20584;1385,715,1269,575,1539,688,644,1404,1403,977,1279,1504,384,1367,1372;10;F
20613;1043,688,1403,251,977,571,248,384,1367,1372,1392,1404,1539;25;M
20627;856,1102,1380,575,1285,1345,1279,1040,1504,1418,1391,977,384,1362,1372;24;F
20629;1385,1102,856,715,1269,1645,1391,251,977,1418,1367,1372;42;F
20640;1052,977,1372,1385,856,571;60;F
20658;1372,1362,1102,1042,1645,1279,1504,1627,571,384,1367,1043;21;M
20684;856,1380,1645,977,1279,1040,1504,384,1036,1372,1269,1285,1345,1391,1367;43;M
20686;1504,1627,1040,251,1380,1102;29;M
20700;856,571;61;M
20780;644,1345,1285,634,1380,1350,1385,1361,1102,1294,1304,251,1040,1036;27;F
20792;1372,1362,1102,856,715;66;F
20796;1613;25;M
20862;1385,715,1345,251,977,914,1504,1367,1372,1102,1269,1040,186;30;F
20872;1285,1380,856,1522,1345,644,1391,977,914,1279,1077,1418,1367,1372,1269;43;F
20880;1048,1304,1380,1385,856,393,1043,715,1645,575,1040,1504,384,1367,1376;48;F
20902;251,914,186,1627,571,248,1367,1372,715,1385,856,1380,1645,1304,1040;39;F
20917;977,1345,575,688,644,1504,1372,1367;26;F
20955;575;43;M
21038;1504,856,1102,1042,1269,1345,1391,251,1279;31;F
21106;1042,856,1361,634,983,1048,644,977,571,1045,1367,248,1372,393,1043;31;F
21149;715,1645,1285,856,1385,1269,251,1040,1279,1504,1627,571,1418,1367,1372;27;F
21166;1285,1269,856,1391,251,1386,1367,1372,1362;21;M
21185;1391,938,977,1279,1504,1418,1036,1372,1522;36;M
21261;1395,1048,1304,855,1042,1102,1380,644,1386,1367,1036,1369,1372,393,1376;57;F
21302;1367,856,957,983;32;M
21371;1645,575,1048,1391,1077,1367,1392,1350,1304,1369,1613,914,1040,384;50;F
21453;856,1269,1380,634,1645,1392,1522,688,1391,186,1418,384,1367,1036,1372;29;M
21485;1613;21;F
21500;855,1345,1369,1043,393,1367,1627,914,1613,251,1403,856;39;F
21503;1380,1304,251,938,1279,1040,384,1367;22;F
21515;715,1361,1102,1042,634,1645,575,1048,914,1504,1077,384,1036,1372,688;27;F
21533;1102,856,1269,575,1285,1304,1404,251,977,1279,1040,1627,1367,1372,1504;34;F
21536;1102,688,1345,1404,1613,251,914,856,575,1040,1504,571,384,1367,1372;17;F
21620;1392,575,1102,856,1345,1613,251,977,914,1040,1504,571,384,1367,1372;51;F
21704;1361,1042,1045,1418,1367,1372,983,393,1345,1285,1392,644,977,688,248;29;F
21705;1043,1036,1367,1418,914,1391,1345,1048,1285,1102,1522,251,1279,1040,1269;35;F
21740;1179,1391,1403,634,1645,575,644,977,1077,384,1372;37;F
21749;1391,977,1045,1367,1362,715,856,1102,1269,1285,644,251,1279,1040,1077;35;M
21796;1391,1077,1269,1380,1645,251,1040,1418,1367;41;F
21812;977,688,634,1042,1102,1539,1522,644,1404,1403,1391,1179,1418,1372,1376;40;F
21820;1345,1403,1391,1040,1362,1361,634,644,251,1279,186,571,384,1367,1036;31;M
21821;1294,1392,571,1043,1385,634,1372,1645,1345,938,977,248,384,1036,1367;32;F
21829;1522,688,1404,1391,1279,1040,1504,571,1077,1418,384,1367,1036,1372,1362;41;M
21885;1504,1391,1404,1345,276,983,957;55;F
21893;1403,715,1182,983,1367,1418,1395,1404,571,248,1345,1392,855,1042,1385;59;M
21913;1645,1392,1304,1048,1052,644,251,1386,1279,1040,1504,384,1036,1043,1376;37;F
21935;1361,1391,251,1040,1504,634,384,1036,1372;23;F
21939;1040,856,1380,1392,1522,1504,644;36;M
21972;1372;28;F
22020;1042,977,1367,1361,1102,715,1380,575,1391,251,1040,1504,186,1627;27;F
22022;1042,1269,1285,1048,938,1279,1372,1304,1345,251,1040,571,384;23;F
22033;1350,715,634,1391,251,938,977,1040,1367,393,1042,384,1036,1372,1362;32;F
22058;1361,856,1102,1380,1304,251,914,1279,1040,1504,384;36;F
22065;1627,1504,1279,251,1391,1345,1285,856,1269,1522,1418,715,1367;35;F
22069;1504,571,1077,1395,1376,1361,856,1102,1269,634,914,1279,1627,384,1367;42;F
22074;1504,1040,1279,977,1345,1522,1392,1042,1385,1102,856,575,1304,1391,251;32;F
22082;1046,715,1042,1522,1403,251,977,914,1179,1504,1418,1367,1372,1043,1376;32;F
22126;856,384,1627,1048,186,571,575,1522,977,1367,1345,1385,1645,1392,1504;25;F
22145;1522,856,1385,1042,1182,634,1645,1392,1345,644,1391,251,1040,571,384;38;F
22160;715,1042,1380,1304,1052,1345,251,977,1040,1627,1418,1367,1036,1369,1372;28;F
22178;856,1048,1042,384;31;F
22188;1504,1042,1361,1376,1372,1418,1395,1386,1391,1403,1404,1345,1522,1539,1392;33;F
22192;983;37;F
22224;1372,1522,1391,1040,1102,856,1269,1380,1392,1345,644,1279,1627,571,1367;67;F
22253;1182,1042,856,1385,1294,1048,644,251,977,186,571,1367,1036,1372,393;30;F
22262;1418,1372,393,1380,1269;32;F
22273;1392,1285,575,1294,1385,856,1418,1522,1391,977,1279,1395,248,1367,1372;55;M
22277;1504,1539,957,276,1102,634,983,1345,644,1404,1391,1386,1040,1045,393;28;F
22294;715,1285,1522,1627,1077,1418;37;F
22370;1269,1182,715,1102,856,1385,1042,977,1040,1627,571,1367,1036,1372,1043;32;M
22450;1418,1504,1279,914,251,1613,1522,1392,1285,1380,634,1102,644,1367,393;42;F
22471;1361,1380,855,1392,276,1404,1403,251,1040,1367,393,1362;42;F
22476;1269,1279,1040,1367;41;M
22477;1385,688,186,1042,1048,1052,856,634,276,248,1372,384,1645,1345,977;31;F
22514;634,715,1042,1380,1304,276,1345,644,384,1367;26;F
22534;856,1102,1380,634,1392,1522,1345,644,1613,251,977,914,1279,1367,393;42;M
22537;1046,1042,1380,1645,1522,1052,644,1613,914,1040,1627,1418,1369,1372,1043;44;F
22540;1504,1279,1042,1046,1350,1385,856,1304,1522,644,251,1040,1627,1077,1418;40;F
22546;1361,1182,1392,1345,1404,1403,1391,251,1386,1179,1077,1367,1372,1627,1376;31;F
22553;856,1046,1048,1391,251,1040,1504,571,1077,248,1418,393;26;F
22556;1362,1046,1350,1102,856,1361,1269,1380,1304,1522,1391,251,938,1418,384;30;F
22564;1350,856,1385,1102,1361,1046,1380,1285,1304,1522,1048,251,938,1386,1418;31;F
22574;1380,856,634,1391,251,977,1040,1504,1627,571,1077,1418,1367,1372,1043;46;F
22786;1522,977,914,856,1385,1042,634,1645,1304,1048,1345,644,251,1040,1504;34;F
22793;977,914,1386,186,1627,1395,1367,1036,1043,916,856,1380,1048,1052,644;42;F
22794;1046,634,1285,644,977,914,1279,571,384,1367,1372;27;M
22811;1042,1182,1269,1645,1285,1522,1403,1376,856,1304,1048,1052,1345,1040,1372;29;F
22812;1102,1269,1285,1392,1522,1048,644,251,914,1279,1504,1627,1036,393,1362;33;F
22818;1042,1046,1350,1385,856,1362,914,644,1522,1285,1269,1102,1418,1367,393;37;F
22841;1042,1385,575,1392,1040,1504,384;29;F
22849;1418,1367,1372;64;F
22850;1362,1102,1269,1285,1304,1522,957,1345,1391,251,1279,1040,1504,1627,1036;34;F
22858;1269,1380,1285,1304,1345,251,938,977,1279,1040,1504,1077,1418,1367,1372;24;F
22875;1392,251;33;F
22920;1404,856,1385,715,1294,1182,1645,1285,1345,977,1040,571,248,1367,1372;46;F
22934;1345,1522,856,715,1392,1391,571,1367;47;M
22950;634,1042,856,1269,644,251,1040,1418,384,1367,1372,1043,916,1376;29;F
22967;914,1077,856,1042,1182,575,1304,1522,1052,1372;31;F
23118;715,1645,1392,688,1522,1179,1504,1367,1372,856,1385,1285,1345,251,1040;36;F
23140;1522,1052,1345,1404,1391,977,1279,1504,186,1627,571,248,1418,1367,1372;40;F
23204;1042,1391,1279,1077,1395,916,1362,1285,856;36;M
23206;977,1279,1040,1504,1627,571,1077,1395,1372,856,1392,1522,1418,1367,393;30;F
23207;1361,856,1102,644,1404,1367,1036,1372,1369,393;24;F
23302;251,1077,1395,1418,1036,1376,715,1522,1048,1391,977,1386,186,1372,384;44;F
23342;1522,644,1404,1077,1418;39;M
23350;1385,1102,1361,856,1042,1269,1392,1522,1048,644,914,1077,1418,1043;34;F
23354;983,1102,1042,1645,688,1345,1404,1403,1504,1077,384,1367,1362;39;M
23411;1285,1539,688,1345,1404,1403,977,1279,186,1627,571,248,384,1367,1372;50;F
23413;977,1504,571,384,1367,1036,1372;28;F
23443;1645,644,1391,571;65;M
23459;1269,1285,1391,251,977,1279,1372,1367;35;M
23465;1361,856,1504,1269,634,1645,575,1304,644,1367;50;F
23480;1367,571,1279,1391,1403,688,1042,1392,1539,1522,1404,977,1179,1418,1372;28;F
23497;1304,1522,251,1040,1418,1369;33;F
23557;644,957,1522,1285,634,1102,1042,1048,1345,1391,251,977,1418,1367,1372;36;F
23581;983,1345,1404,1403,1613,1279,1504,957;35;F
23608;1386,1369,1043,1345,1627,248,856,1367,977,1372,1376,1504,1279,1350,1042;38;F
23610;1269,1285,251,1279,1040,384,1367,1376;30;F
23649;688,1522,1102,251,1367,1372,856,1385,1294,1645,1392,1345,644,1504,571;10;F
23727;957,1361,1102,1042,1645,575,1403,1391,914,1040,1504,1418,384,1367,1372;33;F
23796;1269,1645,575,1404,1403,914,1077,1362;31;M
23824;1385,715,1645,1392,1522,1048,977,914,1279,1627,571,248,1367,1372,1376;41;F
23826;1279,1613,1040,644,1504,1392,856,1391,251;37;F
23907;1404,1345,1392,1077,1418,1362;35;M
23946;1367,1627,186,1504,1279,977,1403,1404,1345,276,1052,1522,1285,1645,1269;37;M
23956;1042,1048,977,1045,1367,384,1504,1279,251,1391,1345,1285,1645,1269,1385;38;F
23997;856,1645,1040,1627,384;24;M
24089;1522,1345,1391,977,1504,1418,1367,1372;32;F
24101;186;75;M
24127;1285,1040,715;41;M
24139;1539,1042,1350,1102,1645,855,1285,1504,1627,1045,248,1418,384,1367,1372;24;F
24157;1043,1036,916,1045,1350,1046,914;48;F
24165;248,1392,715,688,1404,1504,1367,1372;39;M
24215;1504,1045,1367,1362,856,1102,1385,575,1522,1391,251,977,571,1418,1372;34;M
24218;1350,1046,914,1045,1036,1043,916;7;M
24236;1350,1046,914,1045,1036,1043,916;20;F
24237;186;73;F
24248;1350,1046,1045,914,1036,1043,916;49;M
24250;1392,1645,1285,1048,1345,1404,1391,251,977,634,1294,715,1102,1372,1376;39;F
24298;1392,571;51;F
24358;1350,1380,856,1392,1522,644,1040,1504;36;F
24456;715,1269,1285,977,186,1367,1372;38;F
24502;855,1285,1645,1102,644,1279,571,248,384,251,1613,1345,1392,856,1372;35;F
24510;384,1418,1504,977,1345,1522,1380,856,1391,251,938,1040,1367,1372,916;42;F
24513;1102,1304,855,1376;42;F
24515;644,1504,1395,1367,1376;88;F
24538;276,977,688;33;M
24545;251,914,1279;37;M
24577;1048,1345,575,1042,384;28;M
24599;384,1372,393,1043,715,1350,1042,1645,575,1404,1403,251,977,1369,1385;20;F
24603;1350,1645,575,1304,1404,1403,251,977,1386,1040,1179,1367,1369,393,916;19;F
24618;977,688;34;F
24625;1077,248,1184,1418,1367,1372,1362,1102,983,1285,1539,1345,644,1404,977;31;M
24677;186,856,715,1042,1269,1285,1077,384,1385,1294,1645,1279,571,1367,1372;32;M
24694;1294,1102,634,1645,276,644,575,1304,1048,1345,251,1040,384,393,1391;41;F
24725;1345,1372,1522,1504,1613;42;M
24763;1042,1048,1418,384,1367,1372,1645,1392,1522,688,1052,1404,1403,1391,1040;55;M
24776;1385,715,1645,1504,1627,1077,1102,634,1285,644,1279,186,571,248,1367;71;M
24842;856,1304,1345,977,914,1040,1367,1269,1285,1522,251,1418;35;F
24848;644,1285,1645,1350,1376,1077,1040,1522,1304,1380,1046,715,1269;36;F
24868;1045,1504,1279,1386,1345,1102,1269,983,1391,977,1040,248,1418,1367,1372;35;F
24917;977;49;F
24942;1391,1036,575,1385,1361,1102,855,1392,384,1403,1042,1539,1404,1179,1504;22;F
24944;1369,1367,384,251,1102,1391,571;37;M
24958;1404,977,1285,1345,1504,571,248,1418,1367,1385,1392,1279,856,1294,1522;36;M
24994;855,1404,1391,977,1279,186,1367,1372,1362,1504,1052,1285,1102,1345,248;23;M
25017;1367,1522,1042,1350,1102,856,1052,644,977,1627,186,1418,384,1372,916;33;F
25027;1269,1285,688,276,1345,1391,251,914,1279,1040,1504,1627,1367,1372,1376;35;F
25060;571,1403,1539,1269,1294,856,1385,715,1285,1345,1404,977,1279,248,1367;46;M
25087;1042,1522,688,1048,1052,1345,644,977,1040,186,1627,1418,384,1372,916;43;M
25160;1046,914,571,1077,1418,856,1385,1392,1522,1391,1627;37;F
25166;1367,1404,1403,977;39;M
25186;1613;60;M
25188;1372,1361,856,715,575,1285,1048,1345,977,1279,1504,1627,384,1367,393;34;F
25198;1269,1645,1052,1345,977,1372,1285,1048,644,1391,1627,384,1036,856,1040;26;F
25208;186;46;M
25214;1613;49;F
25224;575,1285,1392,1539,688,1345,1404,1403,1391,977,1504,1184,1367,1372,1362;23;M
25247;1645,1294,715,1385,1386,1504,977,644,251,1048,1045,248,1367,688,384;35;F
25285;1385,1102,1042,855,575,1345,1404,251,186,1627,384,1367,1372,1391,248;34;M
25308;1102,715,1350,634,644,1391,1040,1077,1184;76;F
25334;1385,856,1102,715,634,1345,1404,977,1504,1418,1367;61;M
25357;1345,1279,393,715;47;F
25396;1613,1102,856,1269,1392,1522,1345,914,1279,1040,1504,1627,1077,571,1362;41;F
25398;1036,393,715;48;M
25415;1345,1048,1539,1645,1042,1350,1102,688,1404,1391,1504,393,977,1392,248;29;F
25454;1403,1285,1294,715,1385,1645,1539,688,1404,977,571,248,1184,384,1367;32;F
25481;1345,1504,1285,1372,856,1627,1367;39;F
25510;393,916;50;M
25523;1102,715,1182,1285,688,1404,1403,251,248;58;M
25608;856,1269,575,1392,1304,276,1404,1403,977;33;M
25616;1385,1345,1391,1040,1627,186,571,1418,384,856,575,1504,1367,1645,644;43;M
25640;856,1269,1279;42;M
25686;715;68;F
25703;1404,1345,1539,1304,1645,1361,1042,634,251,1386,1504,186,1627,1395,1372;24;F
25716;977,1279,1040,186,1627,571,248,1418,1367,1372,1376,1042,1269,1391,251;35;F
25740;1361,856,1102,1645,1285,1304,1522,1052,644,251,1279,1040,1418,1036,1369;41;F
25759;983,1045,856,1102,1385,1294,1645,575,1392,1345,644,1613,1279,571,1367;46;F
25814;1539,1392,1404;44;F
25892;1102,1392,1345,1040,1367,575,276,1404,977,248,1504,1627,384,1372,1376;59;F
25935;1392,1285,1294,1385,715,1269,1345,1391,1613,1279,1504,186,571,1367,1362;46;F
25953;1285,1645,1392,1613,1418,644,1279,186,571,1372;39;F
26042;856,1102,1042,1380,1392,1048,1404,251,1040,1504,186,1361,1385,575,1304;42;F
26060;938,1386,575,855,1182,1042,715,1350,1102,1361,251,1052,1048,688,1372;29;F
26080;1294,575,1345,914,1504,186,1627,856,1385,1304,977,1040,571,1367,1372;48;M
26109;1645,1345,1391,1613,1627,571,1418,1362,634,644,251,1040,1367,1369,393;53;F
26127;1048,1522,1294,715,1385,1102,856,1042,1380,1645,1285,1304,251,1040,1367;24;F
26186;1504,251,1418,1345,856,1392,1522,644,1613,1279,1040,1077,1395,1367,916;35;F
26235;1048,1279,1040,1369,1362,1522,1345,1391,251,186,571,1395,248,1418,1367;38;F
26236;1345,1380,855,1304,1522,1048,644,1391,251,977,1040,186,1395,1418,1372;45;F
26240;1269;40;F
26242;1385,856,1350,1042,1645,1345,1404,977,1040,186,571,384,1367,1372,1043;30;M
26245;1077,856,1385,1294,1645,1345,1391,977,1040,186,1504,571,384,1367,1372;26;F
26270;251,977,186,1077,384,1372,1362,1361,856,1102,1294,1345,1404,1040,1367;42;M
26288;1380,1345,1182,634,1304,1391,1040,384,1376;24;F
26317;1304,855,1048,1404,1391,251,914,1418,1372,856,977,688,1345,1392,248;39;F
26348;1184,957,983;32;F
26368;957,1184,983;32;M
26388;1285,1345,1391,977,1040,1627,1102,1361,1269,1645,575,251,1504,1367,384;31;F
26417;1102,634,855,1392,1522,276,644,1404,251,1395,916,1362,1391,1345,1367;45;M
26418;1102,575,1304,1391,1040,384,1504,1376,1613;41;F
26430;856,1385,715,1392,1345,977,1627,1367;24;M
26450;1367,571,186,977,1345,1042,1645,1522,1391,1418,1376;42;M
26513;1362,384,856,1361,1350,1042,1380,634,1304,1048,1052,644,251,1040,1036;34;F
26518;1362,571,1627,186,856,1102,575,1522,1048,977,1077,1418,384,1367,1372;36;M
26522;1048,1182,1385,1522,1418,1036,1372,186,1504,688,1042,644,977,1045,1376;38;F
26547;1279,248,1418,1367,1645,1285,1539,1403,688,1345,1404,1391,977,1036,1372;54;F
26549;1404,1613;44;M
26610;1404,1613;41;M
26659;1392,1522,251,1418,1372,1362;37;F
26711;186,715,1102,856,1385,1294,1645,575,1048,1391,251,1504,571,384,1367;36;M
26736;1380,634,1391,1613,251,1040;36;M
26756;384,1362,856,1102,1269,1345,1279;36;M
26759;1048,1404,1184,1102,1385,715,1294,1645,1345,1391,1040,1504,186,571,1367;41;F
26787;914,1279,1040,1179,1504,186,1627,571,384,688,251,977,1367,1372,1362;20;M
26800;1361,1046,1269,1380,1304,1522,644,1391,251,1040,1077;43;F
26812;384,1372,1385,1392,1627,1367,856,715,1042,1269,1285,1345,1279,1504,1045;32;F
26848;1042,1102,1380,1269,1279,1367,1036,1362;35;M
26866;1042,1385,856,1522,1391,1613,1504,1077,916,1380,1304,644,251,914,1040;38;F
26871;1285,1304,1522,1345,644,1391,251,938,977,914,1040,1627,1077,1418,1367;8;F
26880;1418,1269,1042,1102,1040,384,1367,1369,916,634,644,251,1279,1077,1395;39;F
26914;1385,1182,1522,1279,1627,1077,856,1102,1380,1645,1304,644,977,571,1367;39;F
26919;856,634,1285,1052,1345,1627,1367,393,715,1645,644,1279,1077,1418,1372;42;M
26960;1380,1269,1294,856,1102,1385,1645,575,1391,251,977,1040,1504,1367,1372;37;M
26964;1522,1627,1418,1391,1372,1345,1285,1102,1077,856,575;31;M
27005;856,1102,1645,1304,1391,1040,571,1077,1367,1043,916,1285,1345,1269,1279;42;M
27036;1522,688,1345,1391,251,1418,1367,1372,977;44;M
27037;251,1048,1040;46;F
27108;393,1077,1504,644,715,1350,1522,1045,1043,916;38;F
27112;251,1645,1042,856,1102,1285,1304,1345,1391,1279,1040,1077,1367,916,1269;6;M
27156;1285,1392,1304,1391,251,914,1040,1504,1627,1077,1367,1369,916,1279,1269;9;F
27173;1182,1504,1613;49;M
27204;1522,1345,644,1391,251,977,1504,1627,1077,1418,1392,575,1269,1182,1042;47;F
27217;571,248,1367,1372,1362,1040,1279,1345,1285,1645,1269,1294,715,1102,856;29;M
27228;276,384,856,1102,1372,1504,1040,1391,575,855,688;32;F
27250;856,1385,715,1539,1372,1367,571,186,977,1404,855;23;M
27287;1040;21;F
27308;1367,983,1179,1285,1392,1077,248,1362,1539,715,1504,1345;28;M
27309;1376,916,571,1391,1522,1645,856,1102,1350,1040,384,1036;67;F
27314;1179;46;F
27352;856,1102,1385,575,1048,1504,571,384,1367;35;F
27363;1391,688,1386,1372,977;33;M
27533;1392,1385,856,1345,1391,1613,977,1279,1040,1504,248,384,1367,1372,1362;26;M
27536;1036,938,1403,1052,1046,856,1627,571,1367,1372,1539,1404,251,1040,1392;24;M
27555;1372,186,1040,1279,914,977,938,1392,1285,1269,1102,1385,715,856,1391;30;M
27594;856,1102,1380,1304,1345,1391,1040,1627,384;41;M
27637;1392,1404,1403,977,1279,1040,186,1627,571,1042,1102,1391,384,1613,1372;25;F
27643;634,1042,1048,1052,644,1404,251,977,1504,186,1077,1418,1372,393,1043;33;F
27662;1048,644,1369,856,1385,1645,1304,1345,1279,1627,1418,1376,1285,1040,1367;43;M
27672;1285,251,1279,1040,571,1367;38;M
27675;715,1522,644,1279,1504,1627,1077,1418,1367,1362,1269,1285,251,977,1372;43;M
27742;1385,715,571,1285,1372,1392,1345,1040,1627,1504,856,1645,1522,1279,1269;37;M
27750;1392,1367,384,393,1042,634,1345,644,938,1077,1045,1376,1043,1418,1385;22;F
27832;715;49;M
27881;1043,571,248,384,1372,393,856,1042;44;M
27943;1042,1392,1369,393,1380,644,251,1040;42;F
27961;1504,384,1372,393,1376,1539,1392,1294,1645,688,1404,1403,977,1179,1036;44;F
27968;1504,856,1102,1645,575,1627,248,571,384,1367;56;F
27973;715,1285,1345,914,1040,1367;32;M
27986;1102,575,1048,1504,186,1627,384;37;F
28010;1522,715,856,1361,634,983,957,644,251,977,1184,1418,1367,1369,1372;34;F
28031;1040,571,1048,1645,1042,1361,1385,634,1052,644,251,1395,393;46;F
28039;856,575,1048,251,914,1040,1504,186,1045,1395,1418,384,1367,1036,1372;63;F
28052;248,1367,1372;40;M
28053;1285,1279,384,1645,634,1613;41;F
28057;938,688,1539,715,856,1645,1372,1385,251,1040,1367;28;F
28091;1102,715,1380,1645,1304,251,856,1385,575,1040,1504,571,384,1367,1372;45;F
28121;1645,977,1040,384,1385,1504,571,1372,1362;27;F
28124;186,1077,1045,1395,1418,1102,715,1042,1285,1052,977,384,1367,1362,1372;54;F
28127;1269,1645,1522,644,914,1279,571,1077,384,1043;43;F
28130;1294,1392,1345,1404,1403,1269,1279,1367,856,1645,1285;52;M
28152;916,1036,1367,715,1042,1102,634,1522,644,1404,1391,977,1179,1627,1077;36;F
28210;1645,634,1294,1102,856,1285,1345,977,1279,1040,1504,1627,571,1367,1372;47;M
28242;1042,1048,1052,1613;41;M
28246;1345,1040,1376,1362,856,1385,1294,1645,1285,1404,1403,251,1627,1367,1418;36;M
28251;571;41;F
28258;1269,1285,251,1367,1372;35;M
28285;1345,1392,575,634,1380,1269,715,1385,856,1285,977,1040,1279,1367,1372;28;M
28286;1404,1403,1391,251,977,1504,186,571,248,1418,1367,1372,1362,1345,1279;21;M
28318;571;20;F
28356;571;11;F
28374;1285,1404,251,1395,1367,856;38;F
28376;1179;35;F
28377;393,384,1395,1040,1386,1404,1403,1645,1102,1361,634,977,1304,644,688;34;F
28380;1077,1522,1539,1042,1102,856,1504,1404,1403,1179;40;F
28389;571;65;F
28407;688,575,1380,1042,715,856,1102,634,855,644,1391,251,977,1184,384;46;F
28424;571;68;M
28458;1269,855,1285,276,1345,1403,1279,1179,1627,571,1077,1367,1392,1522,1404;36;F
28468;1179;46;F
28537;1279,1504,1102,1040,384,1367;23;F
28567;575,983,957,977,1504,1184,1367,1036,1372;21;F
28580;1404,1403,1179;39;M
28638;575,1269,1385,1102,856,1279,1504,1077,1372,1345,1539,1285,1645,1294,384;35;F
28655;983,957;39;F
28673;1380,1285,634,644;60;M
28675;1361,1042,634,1048,1386,1627,1102,1294,575,1522,977,1504,1418,1372,186;30;F
28754;1269,1294,1102,856,1385,1042,1645,1285,1522,1345,1404,977,1279,1418,1367;39;F
28758;1102,1269,1522,1345,644,1391,1279,1040,1077,1418,1043;34;F
28770;1362,916,1077,571,1627,186,1040,1304,1380,856,1392,1522,1345,1391,251;36;F
28785;1040,977,1391,1345,1522,1304,1392,575,715,1102,1418,1077,186,1042,1182;32;F
28794;1042,1304,1391,914,1077,1045,1043,1627,1380,1040,856,251,1504,1367,715;38;F
28815;1367,1418,1627,1040,1345,1269,1285,1304,1279;32;M
28860;1042,855,1345,186,571,1418,1367;38;M
28869;1361,856,1380,1645,1304,1345,251,1040,384,1376;64;F
28884;1179;;F
28939;1613,1040,1045,1184,1385,1182,634,1052,855,276,977,1102,1645,1392,1345;32;M
29002;644;53;M
29104;1522,1345,644,1404,1391,1386,1040,1504,856,634,251,914,186,1627,1367;34;F
29132;575,1376;45;M
29136;1361,1385,1042,983,688,1391,977,1504,1627,571,1418,384,1367,1372,1043;21;F
29161;1418,384,1372,1504,1391,1077,1392,1362,1376,1102,1042,1539,688,1403,1404;27;F
29170;1369,856,1102,1380,634,1645,1345,644,1404,1403,251,977,1040,1179,1376;50;M
29199;634,1645,384,1102,1269,575,1285,1404,1403,1279,1077;34;M
29254;1418,1345,983,688,977;1;M
29309;1380,634,1522,1345,644,1391,251,977,914,1279,1040,1504,1627,1418,1367;38;F
29389;1404,1403,571,1386,914,977,276,983,855,1042,1102,575,1522,1077,688;38;F
29415;1345,856,1042,1391,251,977,1040,186,571,1077,1395,384,1367,1372,393;29;M
29456;575,855,1345,1184,248,571,977,1403,1539,1392,1404,251,384,1367,1372;24;F
29461;1613,1179,1102,575,1285,1404,1362,393,384,1040,938,1403,1048,644,1345;43;F
29495;1040,186,1036,1385,1361,1102,575,644,1391,977,1367;24;M
29509;1184,571,1392,856,983,644,1403,957,1345,1391,1179,186,1077,1045,1362;40;F
29525;688;59;F
29530;715;55;F
29540;1294,1269,1285,688,276,644,1404,1403,1279,186,248,1367;29;M
29544;1179,1077,1045,1418,1376,688,1404,977,186,1627,571,1367,384,1372,248;55;F
29582;384,1367,1369,1376,251,1040;39;M
29587;1627,1367,248,1184,1350,1380,575,1285,1304,644,1391,1279,1040,1504,384;31;F
29676;1179,715,1645,1403,251,1077,1395,1367,688,276,1404,977,248,1372,1362;32;M
29683;1369,393,1404,1403,251,1040,1179;33;F
29707;688;59;M
29753;1418,856,1269,634,1285,1304,1345,914,1279,1504,186,571,248,1367,1372;28;F
29758;1052,1045,1418,1362,1077,1504,1040,914,1345,1392,1645,1042,1102,1350,251;31;M
29760;1392,634,1042,715,1102,1385,1645,1285,1304,1404,1279,571,1367,1372,1376;42;F
29842;1102,856,1404,1403;50;M
29967;977,914,1040,1627,571,1418,1350,1046,1036,1043,916;41;F
29987;1042,1404,1391,977,1627,571,1418,1367,1372,1362,1376;34;F
30027;1102,276,1391,688,977;46;M
30111;186,1627,1504,977,1391,1345,1522,575,1385,1102,856,384,1418,1372,1376;27;F
30142;1369,1403,644,688,1539,983,634,1182,1042,1102,1392,186,571,1367,1362;20;M
30184;1102,715,1042,1269,1380,1304,1522,1345,644,1391,251,1040,1077,1367,1418;40;F
30190;1077,1036,1362,1102,856,715,634,1392,1345,1404,1403,1391,977,1367,1372;46;M
30197;251,248,1367,1036,393,1362;40;F
30198;1362,855,1345,248,571,1627,1504,1040,251,1391,575,1294,1385,856,1372;27;M
30211;715,1385,856,1392,1285,1539,688,1048,1052,1391,1418,1367;16;M
30236;688,1376;69;F
30249;1418,1102,1645,1392,644,977,186,571,248,1367,1372,1345,1504,1385,251;50;F
30253;634,644,251,977,1043,1367;14;F
30269;1392,1522,688,957,1052,276,1345,644,1404,1403,251,1077,1418,1367,1372;46;F
30270;957;48;F
30279;644,1345,1040,186,1627,1418,384,1367,1372,916,1504,1522,715,1042,276;41;F
30294;1367,634,856,1102,1645,1392,688,1345,1391,1504,186,1627,248,977,384;37;M
30316;1350,1504,1179,977,1403,1345,688,715,1102,1539,1522,1372,1404,1627,1418;33;F
30332;1627,1269,715,575,977,1504,1367,248,571,186,1279,1613,1392,1385,856;48;F
30339;983,1294,856,1504,186,1367,1372,715,1269,1285;37;M
30374;1385,856,1102,1380,575,1304,1345,251,977,1040,1504,1627,1418,1367,1372;34;F
30423;1367,1036,393,1285,914,1403,1345,983,1361,1404,1102,1042,688,644,384;33;F
30441;1385,715,1645,575,938,977,186,571,1279,1613,1392,1285,1269,384,1504;44;F
30517;1043,1386,914,1404,1304,1042,856,1380,1645,1392,1391,251,1040,1279,1077;35;M
30572;1279,1367,715,575,1304,1048,644,938,914,1040,1504,1627,384,1036,1182;26;F
30586;957,1269,856,1182,1285,1613,1279,1077;47;M
30596;1539,276,1386,186,1627,384,1367,1369,1372,1418,1504,977,251,688,1522;29;F
30676;1372,977,571,1391,1345,1522,1285,1294,715,856,1269,1392,1613,1279,1367;46;M
30692;856,1645,1391,1077,248;34;F
30752;1042,1645,1392,688,1345,1404,1391,251,977,1504,571,248,384,1367,1372;32;F
30776;914,1279,186,1077,1418,1184,248,1367,571,1504,1369,1372,1613,1385,1345;22;M
30788;1539,1182,1042,575,983,957,276,1345,644,977,571,1077,248,384,1372;37;F
30814;248,186,1372,856;34;M
30839;1539,1522,688,1048,1052,644,1404,1391,977,1386,1395,1418,1367,1372,393;42;F
30900;1102,1042,1645,1052,644,1404,1403,1179,384;31;F
30913;186,644,1386,1077,1362,977,1042,1040,571,384,393,1345,1285,1269,1102;34;M
30942;1102,1350,575,644,1391,251,1040,1504,1418,384,1367,1372;28;M
31034;1042,1645,1392,1052,1345,1404,1391,1179,1504,1627,1077,1367,1372,916,1376;31;M
31080;1380,634,575,1048,1345,644,1391,251,1040,384,1036,1043;39;F
31083;1179;64;M
31092;856,1645,1391,977,1279,384,1367,1372;38;M
31106;1380,1345,977,186,856,1385,1645,644,1391,1040,571,1045,1367,1372,916;51;F
31108;1304,1539,688,1052,1404,914,1279,248,1184,384,1372,938;26;F
31112;384,1362,856,1294,1269,634,1645,688,977,914,1279,1627,1367,1372,1285;41;M
31117;1385,856,715,1380,1404,1345,1403,1391,1285,914,1279,186,1184,571,1367;34;F
31142;1361,856,715,1294,1391,1036,1304,1048,644,1040,393,916;39;F
31149;1036,1376,1102,575,1522,1048,1052,1345,1391,977,1504,384,1367,1372,1042;52;F
31257;1403,571,1077,1372,1279,1391,1345,688,1392,855,1645,1404,977,248,1367;40;F
31304;186,1504,1279,1345,855,634,1102,1645,1392,1391,251,914,571,384,1367;38;M
31316;644,856,1380,1102,1350,1046,1042,1269,1392,1345,914,1279,1045,1043,1376;41;F
31416;248,1372,1294,1269,1539,977,1627,1385,1285,688,1279,1367,1392,1504,1645;42;M
31450;1345,715,1285,1077;37;F
31453;715,1269,1040,186,1367,1042,1645,1345,977,856,575,1504,1627,384,1372;22;F
31472;1042,1522,1404,1391,186,248,1345,1367,634,644,916;42;F
31500;384,251,856,1269,1380,644,1040;49;F
31517;1385,248,186,1345;31;M
31527;1392,1645,1042,1102,856,1522,688,1345,1404,977,186,571,1418,1367,1372;27;F
31550;575,1361,1042,1645,1048,1304,1403,276,1345,644,1404,1613,1372,1043,1376;54;F
31566;1392,1385,856,1102,1285,1522,688,1052,1391,251,1077,1395,1367,1372,1362;14;M
31581;856,1269,1052,251,1279,1077,1362,1350,1046,914,1045,1036,1043,916;37;F
31582;1404,1102,715,1046,1380,1304,1522,1345,251,914,1040,1504,1418,1367,1369;27;F
31609;1102,1385,715,1182,1645,634,1285,1345,644,1391,1279,1504,571,1418,1367;40;M
31622;1504,1279,914,977,688,1522,856,1385,715,1269,1392,644,1613,1040,1367;44;M
31632;938,1036,1372,715,1285,1522,1345,1391,251,977,1279,1504,1418,384,1367;59;F
31633;1386,1361,1102,688,1048,1345,1404,1391,977,1279,1040,571,1077,1367,1372;51;F
31645;856,276,644,1391,1627,1367;51;F
31647;1048,1361,1042,1645,1040,1376,1179,977,1539,1392,1372,1102,1403,1404,1367;25;F
31674;571,1367,1279,1294,1645,977,248,384,1372;28;F
31708;983,957;39;M
31728;914,1385,1345,1627,1418,856,715,1285,1522,977,1279,1504,384,1367,1372;63;M
31795;715,1392,1522,1052,571,1077,384,1385,1102,1645,644,1627,1395,1418,1369;63;F
31824;983,1392,1102,715,1522,1345,1403,1404,1391,977,1504,186,1418,1367,856;33;F
31833;1345,1418,1367,1372,1376,384,1040,914,977,1404,644,1645,1269,1385,856;42;F
31863;1645,856,1345,644,1504,186,1367;42;F
31883;1042,1285,1522,644,1345,1404,1391,977,1077,1395,1418,1367,1036,1372,1043;38;F
31898;1504,1279,1345,856,1102,983,1522,1404,1403,1391,571,1418,1362;37;M
31913;1102,1645,575,1285,384;75;F
32038;1385,1269,1645,575,983,1539,688,1404,1403,251,977,1040,1179,1504,1627;42;F
32040;855,1294,1285,1077,856,1102,1372;35;M
32071;1627,1040,251,1345,855,715,856,1179,977,1522,1392,1285,1102,1404,1403;68;F
32078;1385,1361,715,1645,1048,1345,1391,251,977,186,571,1418,384,1367,1376;40;F
32086;1345,644,1418,1522,1045,715,977,1627,1367,1372,1392,1386,1369,1048,1395;83;M
32098;1645,1285,1392,1404,1403,251,1627,384,856,1269,1345,1279,1504,1367,1362;36;M
32119;1102,575,1345,977,1627,1077,1367,1372;25;F
32135;1627,1504,186,1645;46;M
32249;384,1418,1077,1040,1391,1380,715,1522;34;F
32263;1102,1404,1403,1179;26;M
32270;977,1504,1304,1285,1380,1269,1102,856,715,1345,1391,251,1279,1367,1372;35;F
32278;1385,1345,1404,1403,1077,983,957;40;F
32310;644,1627,1077,1045,1395,1294,1385,1102,856,1645,1504,571,1418,384,1372;28;F
32318;575,1345,1504,384,1367;40;F
32336;1048,1345,644,1040,1367,1404,1613,1627,1077,688,575,1182,1042,1102,276;46;M
32338;251,1504,1367,1391,1613,1372;25;F
32375;1386,977,1391,1404,1345,688,1539,1392,1645,1102,644,1504,1367,1036,1372;31;F
32389;1522,1391,251,186,1395,1380,856,1613,1040,1504,1627,384,916;42;F
32539;1372,856,1102,1392,1522,1345,644,1391,1279,1504,186,1627,1077,1418,1367;40;F
32563;715;40;F
32573;856,1392,186,571,1395,575,251,977,1504,1627,1362;22;M
32574;1627,1367,393,1380,1102,1048,634,1345,1040,856,1645,1392,644,251,571;39;F
32591;715;7;F
32611;856,1645,983,957;52;M
32613;715;1;M
32616;1522,1613,1627,1404,1367,1391,1345,1285,1279,1102,856,1077,715,571,276;34;M
32625;715;42;M
32643;1380,575,1285,1539,1048,1052,644,251,1504,1045,1418,384,1367,1036,1372;22;M
32656;1102,715,1042,1645,1345,1404,571,248,1367,1362;45;M
32665;1294,1385,856,1645,1345,977,1040,1504,186,571,248,1418,1367,1372,1043;43;F
32697;914,1418,1376,916,1036,1627,1504,1040,1345,1052,1522,575,1380,1182,1042;28;F
32743;1367,1392;20;M
32744;1036,1045,1279,914,1522,1285,1042,1046,1102,634,1645,644,1077;37;M
32746;644,1391,914,1279,1045,1395,384,1372,1376,1362,1369,1361,1645,1304,1052;34;M
32747;715;39;M
32748;1102,1269,1645,384;22;F
32755;1048,1386,1395,1367,1361,856,1285,1304,1392,644,1613,251,914,1279,393;47;F
32809;1385,715,634,1380,575,1285,1304,251,977,1040,1504,186,1418,1367,1372;29;F
32847;1285,1539,1052,1403,251,1279,1040,1627,571,1045,384,1367,1372,1362,1376;49;M
32887;1613;73;M
32964;1345,1391,251,977,1367,248,1372;37;M
32986;1627,1418,1361,856,715,1042,1182,1392,1522,1048,644,1391,977,1367,1372;38;F
33009;856,1182,1613;40;F
33017;1269,1102,1385,855,186,248,856,1392,1522,393,1418,571,1040,251,1182;35;F
33038;1182,1285,1279,715,1345,384,1385,1294,634,1645,1392,644,1391,1504,571;41;F
33044;1361,715,1102,1350,1042,1304,1522,1052,1391,1279,1045,1362,916;33;F
33071;856,1269,1392,1522,1048,1345,644,1613,251,914,1279,1040,1504,1418,1372;40;M
33094;938,1504,1627,1376,1362,1043,1372,1367,1077,186,1040,1391,1380,715,856;42;M
33111;1504,1627,384,1380,1042,1385,1269,1285,1048,644,251,1279,1040,1367,1372;36;F
33116;1418,1372,715;46;F
33117;856,1102,1539,688,1345,1391,977,1279,571,1077,248,1418,384,1367,1372;20;M
33121;1645,1042,384,1367,1372;73;F
33158;1392,1048,644,1040,1361,856,1042,1645,1052,251,914,1077,1418,1372,393;27;F
33172;1392,1522,644,1391,1627,1304,276,1403,251,1279,1040,1077,1418,1367,1372;34;M
33215;571,384,1345,1504,856,1367,575,1362;45;M
33227;1269,575,1522,1279,1504,1627;24;F
33267;575,1285,1392,1539,1522,1345,1404,977,1279,1504,186,1627,571,1367,1372;28;F
33319;186;43;F
33381;1077,1645,1102,856,1269,1285,1345,644,977,1279,1040,571,248,1369,1372;56;M
33398;1345,1404,1403,384;35;M
33424;715,1285,1077;4;M
33454;1279,1391,1403,1345,1645,1269,856,1385,186,1367;42;M
33456;1040,1279,1048,1380,1269,644,1613,1627,1077,248;31;M
33466;1046,575,1304,1077,1372,393,1043,1040,1102,1042,644;47;M
33492;1304,1036,1504,1522,1392,1102,1048,1613,1391,251,914,1040,1418,1372,393;56;F
33517;715,1102,856,1367;24;F
33536;1304,983,634,1645,1048,1052,856,1102,1380,855,1522,1391,1627,1045,384;50;M
33546;856,715,1294,1042,1285,1391,1040,1077,1367;40;F
33556;1304,856,1269,1285,1522,1077,1362;42;M
33619;1269,1645,575,1285,1345,1391,977,1279,1040,1504,186,1627,384,1367,1372;23;M
33624;688,1345,276,1418,1362;29;M
33630;715,634,644,1362;36;F
33649;1294,715,1102,1395,186,1042,1385,856,977,1386,1279,1418,1367,1372,1376;43;F
33653;1269,1048,1345,1504,393,1046,1304,1522,1040,1627,1077,1418,1367,1036,916;33;F
33661;855,1285,1522,1052,1345,644,1613,251,977,1279,1040,1418,1367,1372,1391;41;F
33678;1102,856,715,688,977,1372,1627,1391,1345,1539,1645,1294,1392,571,1385;34;M
33679;856,1385,1294,1042,1182,276,1345,977,1627,1077,1395;38;M
33733;856,1046,1042,983,248,916,1362,1043,393,1036,1367,1077,644,1392,634;39;F
33737;1367,575,1392,1539,1042,634,276,1362,644,248,384,688,1052,1404,977;36;M
33750;384,1395,1077,977,644,1052,575,1380,1042,1102,1645,1522,1613,1367,1372;43;F
33754;1294,977,251,1345,1522,1285,1102,856,1279,1040,186,1077,1418,1367,1372;33;M
33759;1077,571,1627,186,1504,1279,977,1403,1404,1345,1392,575,855;33;M
33772;1102,1522,644,1627,1077,1184,1418,1367;32;F
33812;384;51;M
33818;1539,688,977,1372,634,1391,1504,186,1077,1367,1392,1345,856,1645,571;42;M
33835;634,1042,1369,1367,644,1613,914,1040,1077;40;F
33846;1386,1077,1418,916,856,1102,634,1048,644,251,393;33;M
33859;1645,1285,1279,1392;36;F
33869;1361,1102,1522,1043,916,1345,1048,1285,634,1046,1380,644,393;32;F
33875;575,1645,715,1102,1304,856,1269,1345,1391,1279,1040,1627,1367;30;M
33905;1418,1362,1504,186,384,856,1285,1345,977,1102,1392,1279,1040,1367,1372;31;F
33925;1046,1048,644,1391,938,977,1279,1504,571,1077,1367,1036,1372,1392;35;F
33937;1045,1418,1362,1376,1042,1380,1304,1522,1052,1345,571,1077,1395,856,393;47;F
33940;1102,1367,1362,1418,1285,1385,1613,856,1269,251,1627,1345,1522,1392,1504;30;F
33941;1380,251,1040,393,1269,384,1645;36;F
33944;1645,1345,856,1304,1040,186,1627,1367,393,1285,1392,251,1279,571,1372;33;M
34012;634,1182,1102,1042,1380,1052,644,1391,251,977,1045,1395,1367,1036,1372;31;F
34018;715;49;F
34074;1392,1504,1645;37;F
34095;1102,983,1392,276,1404,1279,1372,1391,248;49;M
34107;186;50;M
34124;1046,1042,1269,1040,1386,1045,1036,1350,914,1043,916;39;F
34131;575,688,977,1504,384,276;33;F
34144;1613,251,1504,1372,1362,1285,1522,1052,1345,644,1279,1040,1395,1269,1392;42;M
34157;1385,1361,1042,1645,1504,1269,1380,1392,1048,1613,251,1627,571,384,1369;44;F
34194;1102,856,1361,1380,1304,1522,1048,1395,916,1376,251,1040,1418,1367,1036;41;F
34224;1392,1504;39;M
34236;1102,1285,1304,1522,1345,1391,1613,977,1077,1418,1367,1372;39;F
34246;1042,1645,1392,1522,957,186,1077,634,1345,644,1391,251,977,1367,1372;53;F
34247;1504,186,1077,1627,571,1184,384,1367,1372,856,1102,1645,634,575,644;37;F
34248;1345,1391,1613;26;F
34263;856,1102,1380,1304,1040,1077;31;M
34275;1613,1504,1627,1077,384,1376,1102,1304,1522,1391,1395,1418,1367,1372,1362;43;F
34321;1376,393,384,1627,1504,1040,914,251,1391,644,1048,1392,575,634,1042;30;F
34322;1350,1045,1036,1043,916;62;F
34330;1391,1279,1362;31;M
34332;715,1285,1179;3;F
34342;916,1350,1046,914,1045,1043;46;F
34344;856,1385,1042,1269,983,1392,1279,1040;28;M
34377;856,1385,1285,1345,1404,1403,1613,1279;39;M
34402;1350,914,1040,1045,1043;52;F
34410;1102,856,715,1645,1392,1345,1404,1403,977,914,1279,571,1367,1372,575;47;M
34421;715;8;F
34425;1361,1350,1042,1645,855,575,1285,1048,1345,1391,251,938,384,1367,393;23;F
34430;1345,977,1279,186,571,248,1367,644,634;53;F
34432;715,1294,1182,1645,855,1392,1539,688,1404,1403,1391,977,571,1367,1372;49;F
34437;1102,1418,1367,1362,856,1182,1269,634,1285,644,1391,251,1040,1179,186;37;F
34481;1279,1403,1404,688,1539,715,1385,856,1285,977,1372;33;M
34533;715;39;F
34536;251,1042,856,1102,1269,855,1285,1392,1522,1345,1613,977,1279,1372,1362;38;M
34556;1522,1304,1361,1380,938,914,1279,1040,1395,1418,384,393;65;F
34559;1269,644,1418;34;M
34561;644,1392,1285,1304,1645,1380,1179,1504,1627,1395,1372,1367,1376,1269,1279;36;F
34589;1369,1372,393,1362,938,1391,1404,1345,1042,1361,1269,1380,1285,1040,251;27;F
34590;1385,715,248,384,1036,1376,1042,1539,1522,688,1345,644,1404,1418,1372;37;F
34610;1345,186,571,1645,1392,1048,1102,575,1391,1504,384;48;F
34619;856,715,1285,1522,1345,1391,1418,1367,1102,1269,1279,1077,1362,1376;38;M
34628;1102,856,1345,1391,977,914,1386,1279,1504,571,1077,1045,1367,1372,1362;57;M
34634;1613;54;M
34649;634,715,1372,1418,1184,977,1403,1404,1345,1052,1522,1102,957,1645,983;38;M
34658;644,1418,1367,1036,1369,1182;32;F
34705;938,384;38;M
34711;856,1182,1522,1418,1362;40;F
34733;1046,1345,1522,1304,1350,251,914,1040,1504,1045,1418,1367,1372,1043,916;39;F
34755;644,1048,1380,715,575,1392,1404,251,1627,384;48;F
34827;1294,715,1385,634,644,1404,977,1279,1504,186,1627,571,384,1367,1372;33;F
34874;856,1385,1645,1285,186,1418,1367;37;M
34903;186,1376;23;F
34911;1294,1539,688,1404,1403,977,1279,571,1395,1184,1367,1372;24;F
34915;1372,856,1385,1294,1304,644,1040,571,1376,1367;42;F
34919;1386,1504,384,1367,1036,1043,393,1369,1627,1040,914,938,251,1345,1361;27;F
34967;1504,1372,977,1279,1627,571,1367,856,1042,575,248,1345,1403,1404,1645;56;F
34999;688,1345,1403,977,1504,1627,1179,251,1404,1102,1392,715,384,1367,1372;40;F
35017;1645,1345,1404,1279,1504,1627,571,1376,856,855,1391,977,1386,1367,1372;40;M
35028;1279,977,1367,1372,916;39;M
35106;1269,1380,1285,1304,644,1391,251,1279,1040,186,1077,1418,1367,1372,393;39;M
35164;1269,1380,1304,1345,977,1040,1418,1367;46;M
35172;1522,1048,1345,1040,1077,384,856,977,1504,1372,1645,575,644,1613,1367;55;F
35197;715,1285,1391,938,1279,186,1367,1102,856,1380,1304,1386,1040,1392,251;41;F
35202;856,916,1350,1046,1522,1045,1036,1043;34;F
35256;1102,1385,1042,1269,1522,938,1040,1418,1367,856,1392;38;F
35261;1385,1294,1392,1372,571;32;F
35273;1043,1045,1350,1522;35;F
35305;1522,688,644,248,1418,1627;39;F
35326;983,1392,1539,957,276,248,1372,1362,856,1102,1182,575,1345,1391,1504;30;M
35334;856,1345,644,1613,914,1386,1279,1036,715,1046,1042,1380,1392,251,1040;34;F
35340;251,977,914,1279,1040,1045,1418,1367,1036,1043,1350,1046,1372,916;48;F
35357;715,855,1392,1304,1539,688,1404,251,1504,186,571,1184,1367,1372,1362;28;F
35402;186;26;F
35411;384,1367,856,1102,1385,1269,1285,1392,1345,1404,1403,251,914,571,1372;29;F
35482;1645,1504,1627,251,1040,384;26;M
35487;1269,1385,1404,251,1102,856,1380,1645,1522,1052,1345,644,1613,1504,384;41;F
35500;856,1102,1269,1285,1048,1052,644,251,1279,1040,1367,1372;30;F
35524;1304,634,1385,856,1102,1380,855,1392,1345,977,1279,1040,1367,1369,1372;46;M
35535;1645,251,977,1627,571,248,916,1102,634,1404,1504,186,384,1367,1372;33;F
35592;1182;35;F
35667;1392,715,1279,1504,1418,1645,575,1285,1404,1403,251,1179,384,1367,1372;66;M
35730;1362,1376,1285,1392,1345,1391,1077,916,1102,1269,983,644,1403,1367,1372;64;F
35733;1102,1345,1404,1391,1179,186,1372,1362;31;M
35742;1269,1380,634,1102,715,1285,1522,1345,644,1391,251,977,1418,1372,1362;31;F
35786;1627,384,1367,1372,856,1102,1269,1380,634,1285,251,1279,1040,1077,1362;32;M
35809;1304,1043,1367,1077,1042,1040,856,186,1522,251;36;F
35865;1367,1036,1102,1645,938,1279,186,571;32;F
35875;1345,634,1392,644,1613,251,1279;64;F
35877;1522,1052,1403,977,1040,1077,1285,1380,1042,1294,1376,248,1367,1372,916;46;F
35890;1345,957,688,1539,1285,1269,1294,715,1385,856,855,1522,977,1367,1372;5;M
35901;1372,1040,914,1613,644,1345,1048,1522,1304,1645,1380,1385,1102,1361,1367;44;F
35958;855,1392,1522,688,1345,977,1279,1179,186,571,1077,1418,1367,1372,1376;5;M
35961;1385,1046,1042,1522,1048,1345,644,914,1279,1040,1418,393;38;F
35962;938,1372,634,715,1645,575,1285,1345,644,1391,977,1279,1504,384,1367;59;F
35967;634,1285,1392,1345,644,938,977,1279,1367,1372,1376,384,1391,575,1645;38;F
36003;1102,914,186,1627,1040,938,251,644,1048,1522,1285,1380,715,1367,1036;30;F
36038;1627,1376,1043,1369,1036,1367,1418,1045,571,1386,938,644,1052,1304,1042;38;F
36080;1385,1269,1522,1345,977,1504,186,571,1418,715,1367,1372,251;30;F
36086;1522,251,938,1040,1504,186,1627,571,1418,384,1367,1036,1369,1372,1043;37;F
36125;1077,1627,1279,1522,1269;44;M
36131;1418,1367,1372,1043,571,1627,715,1380,983,1392,1522,688,276,1345,644;74;F
36155;1380,1645,1304,977,1627,1367,393,1362,1376,1102,855,1404,251,1040,384;45;F
36184;1350,1042,1304,1522,1048,1345,1391,914,1040,1627,571,1045,384,1043,916;11;M
36229;1102,644,276,1345,1404,1391,251,977,1077,1395,1418,1369,1372,393,1362;43;F
36233;1042,1613,251,914,1040,1395,1043,916;46;F
36244;1279,1386,1304,644,1077,1395,248;39;F
36276;1345,1182,1385,715,1042,1269,688,977,1077,1184,248,1418,384,1367,1372;31;F
36278;1040,1048,957,856,1345,1391,1279,1102,1042,1269,575,251,1504,384,1367;26;F
36301;1362,1391,977,688;36;M
36323;571,1367,1372,856,688,1404,1362,1048,251,1040,1392,1391,1279,634,644;35;F
36325;1345,634,1645,715,1391,251,977,1036,384,1367,1376,1372;48;M
36361;1269,1645,1372,1627,1391,1345,1392,1380,1522,251,1418,1367,1036,1369,393;36;F
36387;1304,1040,571,1395,384,1367,1372,1036,856,644,634,575,251;31;F
36420;1380,1345,251,1386,1040,1077,384,1367,1372;42;F
36488;575,1102,1285,1345,1391,1504,1077,914,1376,1380,1372,644,1386,1279,1269;44;M
36493;1627,1385,1042,575,1285,1345,1403,977,1504,571,384,1404,1367,1372,186;52;M
36509;1345,688,855,715,856,1269,1285,1539,1404,977,186,1627,1367,1372,1362;25;M
36518;1539,1392,1385,856,1645,1269,1294,575,1285,1613,977,1279,1040,1367,1372;43;F
36590;1627,1045,1418,384,1362,957,1522,983,1269,1182,715,856,1613,1391,1102;39;F
36625;1522,856,715,1285,1392,1304,1345,1391,251,1184,1367,1372,1043,1362;45;F
36633;1345,1613,1372,248,977,1391,1539,855,1269,856;13;M
36648;1362,856,1102,1042,1645,575,1392,1304,1052,1391,977,1040,1504,1627,1077;39;F
36684;856,644,1045,1372,1077,186,1391,1345,688,1522,1392,1418;62;F
36712;1048,688,1522,1539,1304,1392,1285,983,575,634,1042,1102,1404,384,1372;47;F
36740;1042,1182,855,1539,1522,688,644,1404,1613,977,1040,1627,1077,1418,1392;39;M
36773;1539,186,1395,1522,1036,1645,1048,571,384,1367;49;F
36783;1391,715,1385,1102,856,1645,1392,1404,977,1279,186,571,384,1367,1372;63;M
36804;1345,644,688,1539,1285,855,1269,1294,1385,856,977,1279,248,1367,1392;37;M
36812;644,1369;38;F
36821;1042,575,1392,1304,1522,1052,1345,1391,914,1040,1504,1627,1077,1367,1362;13;M
36847;855,1285,688,1345,1404,1403,977,1279,1179,1504,1627,571,248,384,1372;31;F
36853;1048,1042,715,1385,1102,251,914,1040,571,1367,393,1418,644,1522,1645;43;F
36854;1645,1182,1385,1380,855,1522,1345,251,1504,715,856,977,1627,1367,1372;41;M
36900;571,1418,977,1184,1367,1372;37;M
36915;715,1350,1102,276,1345,1391,1077;45;M
36983;1350,856,575,957,977,1040,1077,384,1372;20;M
37000;715,1294,575,1285,1539,688,1345,1404,1403,977,1504,1627,248,1367,1645;55;M
37001;1042,977,1504,1077,715,1285,1179;39;F
37014;186;51;F
37025;856,983,1403,1404,1391,1386,1040,1184,1376,575,1304,1048;40;F
37037;1392,1385,1367,1345,1285,1279,1269,1048,856,644,248,1645;19;F
37047;1385,1294,983,1279,384,1345,644,248,1367;43;M
37092;634,1040,644;52;F
37108;1645,248,644,856,1048,1269,1279,1285,1345,1367,1385,1392;55;F
37128;1345,1385,856,1361,1391,977,1040,186,1367,1372,393,1362,855,251,938;35;F
37139;1345,1418,1048,715,1102,1269,634,644,1040,1077,384;44;F
37146;914,977,1522,1380,1102,1361,856,1269,634,1285,1304,1345,644,1040,1279;49;F
37151;1392,1385,1367,1345,1285,1279,1269,1048,856,644,248,1645;48;M
37238;186,977,1403,1404,1385,1102,1392,571,1418,856,634,1645,1345,644,1367;40;M
37248;856,1077,571,1391,1404,1385,1627,1504,251,1392,1372,1279,1269,1522,1367;27;M
37253;575,856,644,1391,1040,1367,571;45;F
37288;1391,1052,251,914,393,1048,1269,1279;39;F
37289;856,1385,1645,644,1391,571,1367;65;F
37374;856,1645,1048,1040,1504,1627,571,1367,393;34;F
37492;1385,1362,384,248,1040,1404,644,1048,1539,1304,1392,1645,634,1380,1361;41;F
37501;1385,856,1645,1522,1345,977,1504,1627,1077,1418,1367,1372,1102,644,634;37;F
37508;1504,251,1385,856,1294,1392,1627,571,1367,1372;44;M
37537;1645,186,1077,248,393,856,1042,251,938,1040,1418,384,1372,1043,1376;34;F
37559;715,1042,1269,575,1285,1392,856,688,644,186,1418,384,1367;39;M
37583;688;27;M
37587;1369,1362,1102,1418,1361,634,251,186,1539,688,1403,1404,977,248,1372;60;F
37594;575,1504,1045,384,1043;41;F
37598;1504,1385,715,1269,1645,1285,251,1279,384,1367,1372;32;M
37603;977,1504,1627,571,1395,1367,1036,1522,644,186,1418,1372,393,1043,916;42;F
37611;1380,575,1052,977,1040,1627,571,856,634,644,1504,1418,384,1367,1372;64;F
37641;1386,1040,1418,1102,1269,1345,1279,1372,1350,1046,914,1045,1036,1043,916;38;M
37648;1418,571,1043,1102,856,1380,1048,1613,977,1367,1036,1372,644,251,1040;40;F
37677;1042,1285,1345,1391,1613,1418,384,1369,1269,251,1040;31;F
37689;1350,1046,914,1045,1036,1043,916;42;F
37749;715,1345,1403,977,1279,1504,186,571,1372,1392,1522,1404,1179,1418,1367;36;F
37762;393,1369,1367,914,938,1345,1522,251,1392,1418;37;F
37781;1102,1385,1645,1380,1304,1285,1345,1040,1504,1418,1367,1372,1376,251,1391;20;F
37821;1392,1539,688,1345,1404,977,1279,1504,1627,571,248,1184,1418,1367,1372;34;M
37862;1361,1645,575,644,1391,251,1279,1372,1362,1385,1102,1294,571,1380,1040;29;M
37871;1367,571,1361,1380,575,251,1040,1504,384,1036,1372,1043;33;F
37891;1367,1376,1304,644;54;F
37921;1350,1182,1645,1285,1391,938,914,1040,1077,1045,1395,1036,393,1043,916;46;M
37936;1522,251,1404,1040,1504,1418,1367,1362,1102,1042,634,1645,1345,977,1372;34;F
37960;393,1376,1369,251,856,1102,634,1645,575,1392,644,1504,1627,571,384;30;F
37982;1392,1385,1042,1345,977,1361,1269,1380,634,1285,644,251,1040,393;27;F
38002;251,1040,1627,1367,1102,715,1392,1404,1362;67;F
38029;1350,634,1304,1522,1052,644,1391,1386,1627,1077,1418,1369,393,1362,1376;27;F
38049;1386,1040,1504,186,1376,856,1102,634,575,1392,644,1391,251,1627,571;83;F
38057;1613;52;F
38094;1279,1522,715,1102,856,634,644,1345,1404,1403,977,1179,1418,1367,1372;54;F
38097;1386,1376,1369,1345,1052,1361,1645,1392,1391,1179,1372,1102,1285,1539,1404;54;F
38102;1369,393,1043,1304,1269,856,1385,1042,1392,1522,644,1613,251,1040,1418;33;F
38104;1042,1392,1304,644,251,977,914,1279,1040,1504,1418,1367,1369,1372,393;40;F
38108;1345,1404,1403,1391,251,977,914,1040,1036,938;27;F
38131;715;35;F
38143;914,1077,1367,715,856,1269,575,1052,644,1040,1504,186,1372,1042,1613;42;F
38149;1304,1391,1367,1376,1179,1386,938,251,1403,856,575,1504,1404,384,1036;40;F
38152;715;41;M
38153;1404,1403,1391,1279,1504,1102,1269,983,1345,977,186,571,1077,1367,1372;33;M
38158;1102,1380,1645,1345,575,1285,1304,1048,644,1391,251,1040,384,1367,1362;33;F
38168;1102,1042,1269,1392,1304,1522,644,251,914,1279,1040,1418,1367,1369,1372;42;M
38197;1077,1385,1042,1269,1645,1504,1627,1418,1367;13;F
38274;1345,977,248,1367,1376,1269,1294,1385,1392,1404,1403,1279,1504,571,1372;39;M
38288;715,1392,1539,1345,644,1404,1403,977,1179,1372;37;F
38294;1040,1504,1392,856;41;M
38297;1279,1391,644,1345,1048,1645,1392,1285,1380,1294,575,856,1385,977,1367;28;F
38300;1627,393,1376,856,1294,1182,1645,1304,1048,644,571,1045,384,1367,1372;27;F
38349;575,855,715,1539,1102,1645,688,276,1345,1404,1391,977,248,1367,1372;65;F
38357;1345,571,1369,1372,393,1362,1045,1040,938,251,1613,644,1392,1645,1042;33;F
38359;1052,644,1391,1372,1367,248;29;F
38364;715;48;F
38365;715;47;F
38371;856,715,1046,1269,1380,634,1285,1522,1345,644,914,1040,1504;45;M
38372;575,1392,1504,571,1418;24;F
38379;855,186,1367,715,856,1385,1392,977,1504,571,1372;46;F
38386;715,1376;32;M
38402;715,575,384;40;F
38410;1392,1048,644,251,1279,1367,856,1042,1285,1304,1522,1040,1395,1077,715;37;F
38411;1367,1077,977,1522,1285,715;42;M
38425;1345,1392,575,1361,1645,1285,1040,384,856,1102,1048,977,571,1367,1372;31;M
38430;1391,1522,1304,634,1042,1361,1380,1645,575,1285,1345,1418,384,1102,1269;34;M
38431;1395,1627,977,1048,1522,1645,1042,856,1102,1345,1391,251,1040,1367,715;41;F
38438;715,251;48;M
38449;1040,251,1304,1285,1380,1269,1046,715,856;38;M
38481;715;40;F
38531;1345,1522,1285,1627,1077,1418,1367,1385,1102,1645,575,1613,1504,384,1372;29;F
38534;1645,1102,1385,715,1042,1380,1304,1345,1391,1040,1418,1367,1036,1613;43;F
38543;957,983;35;M
38556;688,1184,957,983;28;M
38574;1404,1391,1613,977,1392,1522,1376;39;M
38631;1367,1040,1279,1269,856,715,1285,1345,1391,251;45;F
38637;186,1077,1418,1102,856,1504,1042,1522,1279,384,1367,1372,1043,393,1376;27;F
38694;575,1645,1102,688,1404,248,1418,384,1367;46;F
38705;1385,1391,1613;52;F
38708;715;37;F
38709;1345,1391,644,1102,1048,1395,248;54;F
38736;856,634,251,1036,916,1645,1304,1048,644,1613,1040,1077,1395,1369,1362;44;F
38759;1269,1294,1645,1285;59;M
38814;1102,634,1285,1304,1539,1403,1391,1040,1504,186,1627,1395,1367,1036,1372;64;F
38871;1279,571,1077,1418,1372,1362,855,634,856,276,644,1404,1627,248,1367;36;F
38878;1385,1042,1269,1380,855,1285,1392,1522,1391,1040,1367,1645,1294,1350,715;37;F
38881;856,1385,1345,977,1279,1040,186,571,1367,1372,1362,855,575,1504,384;43;F
38893;856,1042,634,1522,1048,1345,644,1391,977,1627,571,1395,1418;29;F
38900;1385,715,1269,1345,644,977,1279,1367,1372;40;F
38970;1385,856,1102,1042,1504,571,384,1036,1380,575,1392,1048,1345,1391,1040;31;F
38987;856,634,251,977,1040;23;M
38994;1361,856,1304,1404,1040,1395,1376,1102,575,1345,1391,251,1627,384,1367;41;M
39049;1077,1045,1418,384,1367,1372,393,1362,916,856,715,1042,1182,251,1391;45;F
39053;1380,1645,1522,1391,1627,1395,1376,1269,1042,575,1040,1504,1367,384,1372;28;F
39055;1269,855,1285,1539,1345,1404,1391,1279,186,1627,248,1372,977,1395,1367;57;F
39098;1102,1380,1345,1391,1613,1376;41;M
39135;1404,977,1361,1042,1052,1391,251,1386,1040,1627,571,1077,1367,1372,1376;28;F
39189;1395,1184,1362,1385,1269,1392,1404,1391,251,977,914,1504,571,248,1367;28;M
39207;1380,575,1504,1627,1367,856,1385,1294,634,1645,1392,644,1391,251,571;49;F
39215;1404,1392,1285,1645,1294,1385,856,1102,855,1345,644,186,248,384,1367;47;F
39251;1367,393,1043,856,1350,1042,1269,1048,1052,1345,1279,571,1036,1392,384;34;F
39257;1404,1102,186,1367,1372,856,1294,634,1645,1285,1345,644,251,1279,248;47;F
39265;1522,644,914,1504,916,1102,1046,251,938,1040,1077,1418,384,393,1043;37;F
39297;1040,1627,1372,715,688,1269,977;27;F
39300;856,1102,1385,1380,575,1392,1304,977,251,1040;29;M
39312;644,1279,1040,1043,393,1376,1361,856,1102,715,1042,1285,1048,916,1077;40;F
39322;1367,856,1102,977,1645,983,1285,1522,634,575,1345,644,1279,384,1372;75;F
39342;248;28;F
39365;715;41;M
39413;715,1102,856,938,914,571,384;28;M
39432;1345,1036,1376,1361,1102,1042,634,855,688,276,644,1391,1372,1043,1362;42;F
39434;1392,1539,1404,248;39;M
39443;1367,856,1385,1645,1392;49;F
39452;1269,1040,715;40;F
39475;1367;25;M
39541;856,1522,1345,1391,1077,715;42;F
39549;1385,1361,856,1042,1269,1380,1304,251,914,1040,1504,1627,384,1369,393;58;F
39583;1522,1345,1404,1403,977,186,571,1077,248,1418,384,1367,1372,1043,916;38;F
39599;1294,1385,977,1539,1048,1391,384,1367,1036,1372;29;F
39602;1350,1269,1285,1522,1391,251,938,977,914,1279,1040,1077,1045,1418,1372;35;F
39646;1645,1036,715,856,1380,634,1304,251,977,1040,1504,186,1367,1369,1372;35;F
39647;1285,1380,575,1404,977,855,1504,186,1627,1395,248,1418,1367,1372,1362;22;F
39659;1269,1404,251,1040,1077,916,715;37;F
39703;1376,938,1048,1367,186,1040,251,1285,856,1269,575,1304,644,1279,1036;30;F
39707;1504,1077,1627,1040,1304,575,1269;46;F
39716;186,1504,1627,1385,1392,1345,571,248,1367,1372,856,1285,1522,1418,715;40;F
39720;1385,1539,1391,856,715,855,1392,688,1345,977,1627,1077,248,1367,1372;31;M
39725;1102,1522,1345,1613,977,856,1077,1367,715;15;F
39749;251,977,248,1367,1372;71;M
39755;1102,856,1294,1380,1645,1392,1522,1048,644,1391,1627,1367,1372,1036;35;M
39779;1372,1418,1184,571,186,1504,1279,977,1345,1522,1645,1367,1285,856,715;41;M
39782;856,1380,1285,644,1404,1403,251,1179,1040,1627,1372,715;40;F
39783;1285,1052,1345,251,1395,1367,1372,1362;50;F
39795;1380,575,1392,251,1077,384,856,1102,1042,1304,1048,1345,1613,977,1040;33;F
39825;1385,715,1380,1285,1392,1345,1404,1403,977,1279,186,1627,248,1418,1367;30;M
39842;1613,1184,248,1372,977,1392,1285,1350,1385,1294,1345,1279,571,1367,1036;48;F
39848;1385,715,1182,1304,1048,914,1040,571;62;F
39938;1345,1391,977,1367,1372,248;55;M
39974;634,251,914,1040,1077,1395,1504,1345,1279,644,1362,1269;37;F
39976;186,251,1391,1304,1102,856,1380,634,575,644,1613,914,1040,1504,1627;34;F
39984;914,384,856,1042,1380,1522,644,1077,1418,1367,1362,1040,1269,1285;42;F
39985;1102,634,1269,1279,1040,1077,1395,1367,1362;37;M
40004;856,1385,715,1182,1504,1627,1418,575,1404,1376;17;F
40035;1404,1380,634,855,1345,644;51;F
40040;1391,1613,1627,1077,1045,1036,1294,1102,1385,1285,1392,977,914,186,1418;23;F
40065;1627,983,1182,1385,1102,1345,644,1392,856;45;M
40078;1385,1182,688,1345,1504,977,1391,1184,957,983;60;M
40085;571,248,1418,856,1102,1285,1404,1391,251,1279,1077,1367,1369,1372,1362;30;M
40131;1361,856,1042,1522,1040,715,1077,393;43;F
40143;634,644,715;38;F
40174;1042,715;9;M
40248;1367,983,688,977,248;20;M
40255;1385,1380,1645,1391,251,1504,571,384,1367;29;M
40286;715,634,644;11;M
40289;1345,1504,1102,1279,384,715,1285,1522,644,1077,1418,1367;40;F
40305;1269,1285,1391,1040,715;36;F
40307;1040,1504,1627,1052,1345,855,1367,384,1369,644,634,1042,1102,856,1361;28;F
40319;1380,248,575,1539,688,1404,1403,251,977,1040,1504,186,571,384,1372;26;F
40333;384,1372,393,1043,1361,856,1385,1380,1522,644,186,1627,1369;36;F
40338;1391,186,1369,1376,1285,1404,1403,977,1279,1179,571,248,384,1367,1372;35;F
40381;1539,688,1403,1613,186,571,1077,1102,276,1345,1404,977,248;41;F
40391;1418,251,983,855,1294,856,1102,1285,1391,977,1279,1179,1367,1372;47;M
40425;1052,575,1048,1345,1504,1102,1042,634,688,276,644,1391,977,248,384;30;F
40431;251,914,1077,393,1042,1182,1380,634,1645,1392,1048,1345,644,938,571;42;F
40479;1077,1385,251,914,1040,1627;30;M
40486;856,1385,715,1285,1392,1522,1345,1504,186,1627,571,248,1418,1367,1372;40;M
40506;856,1385,715,1285,1392,1522,1345,1504,186,1627,571,248,1418,1367,1372;3;F
40514;1040,1285,634,1294,1385,1361,1048,644,251,384,1367,1372;28;F
40524;1367,1042,1645,1048,1376,384,1036,1403,1179,1372,1392,1539,1404;31;M
40575;1345,1391,977,1369,644,688,1645,1042,1380,276,1404,251,938,1077,384;34;F
40583;1385,1345,1285,856,1367;32;M
40616;1102,1385,715,1539,688,1048,1391,914,186,1367,855,1404,977,248,1372;45;F
40619;1362,1369,1036,1504,1391,1380,1042,856,1385,1182,1522,1627;48;F
40637;1285,1645,1385,1102,856,1269,1522,1048,1345,186,571,1367,1036,393,1362;39;M
40672;856,1102,1269,1392,1345,1404,1391,977,914,1040,1504,1627,1077,248,1418;38;M
40690;186;77;M
40696;1645,856,1102,1350,571,1294,983,1392,1345,914,1269,644,1391,1077,1418;33;F
40699;1042,1627,1403,1052,1645,1077,1372,977,688,1345,1392,1539,1404,248,1367;32;M
40709;715,1362;42;M
40747;856,1102,1042,634,855,1392,1522,1048,1345,644,1391,251,571,1372,1362;51;F
40748;1613,1367,856;45;M
40753;644,1182,1102,856,1385,1645,1392,1345,1391,1504,186,1077,1367,571,384;41;F
40757;1077,248,1367,1376,1372,1504,1345,1522,1645,1102,575,688,977,384,276;33;M
40759;1391,1367,1285,856,715;39;M
40776;1504,571,1627,1645,1385,1102,1522,1345,251,977,186,1418,384,1367,1372;41;M
40780;1391,1345,1048,1392,575,1645,715,1102,856,1504,1627,384,1367,1613;43;F
40830;1102,1269,1522,1345,1391,1279,1504,1418;36;F
40831;1391,1345,1522,715,1385,1102,856,1294,1285,977,1279,186,1418,1372,1269;35;M
40834;1042,575,1048,1345,1391,977,1040,1504,186,1418,1367,1369,393,1522;48;F
40852;688,1345,1391,1418,1042,1645,251,1040,571,1077,1367,1036,1372,1043,1362;29;F
40885;1522,1391,1613,1418,1036,916;36;F
40899;856,1102,1385,1294,1182,1392,1345,644,1391,251,977,186,571,1418,1367;6;F
40907;1048,276,1404,1391,914,1504,1077,1395,1367,1043,856,1102,1040,186,248;21;M
40919;856,715,1385,1392,1403,1404,977,1504,571,1184,248,1367,1372;33;M
40923;1345,644,1404,1403,251,384,1367,1036,1376,688,977,1504,571,248,1372;31;F
40925;1392,1404,1403,914,1279,1504,1269,855,1522,1418,1627,571,644,1285,1294;39;M
40932;856,1385,715,1285,1392,1522,1345,1504,186,1627,571,248,1418,1367,1372;8;M
40936;1102,715,1539,1345,1372,1367,1418,1627,186,1504,1040,977,1403,1404,1179;69;F
40944;938,1036,1369,1043,1376,715,1645,575,1285,251,1040,1504,1367,1372,393;25;F
40958;856,1613,1279,1504;50;M
40989;1504,1627,1269,977,1367,186,1392,1285,856,715,1391,938,914,1040,1036;36;M
41002;983,957;53;M
41017;575,1645,856,1102,1350,1392,1285,1539,1391,1179,1372,1403;32;M
41025;856,715,1269,1380,1285,251,977,1279,1040,1504,186,1367,1036,1372,1362;26;F
41039;1077,1345,1285,1613,1279,1362,1392;38;M
41045;1102,1285,1392,1345,1404,1403,1391,1613,1279,1504,1077;43;M
41061;1613;56;M
41121;856,1392,1613;43;M
41130;1294,1102,856,634,251,1040,571,1367,1372;25;M
41152;1361,634,1645,1392,644,1391,251,1504,571,384,1367,1036;50;F
41154;644,186,1077,393,1385,1645,634,1392,1285,1345,276,1048,1391,1279,1179;17;M
41180;1522,715;36;F
41212;1102,1613,571,1627,1294,1285,1403,1279,186,1345,1395,1522,1504,1392,644;33;M
41233;1036,1645,977,1043,1361,634,1048,384,1042,688;32;F
41246;856,1102,1350,1380,634,1392,914,1386,1040,1395,1367,393,1361;33;M
41275;1613,1040,1077,1045,1395,1036,1102,1042,634,1645,1285,1279,384,1367,1376;21;F
41277;856,1102,575,1345,1077,1522,571,1372,393,1040,1504,186,1418,384,1367;41;M
41281;1077,1613;42;F
41287;1102,715,634,644,1522,276,1345,1404,1391,251,977,1040,248,1367,1372;29;M
41292;186,914,393,1367,1077,1102,1345,644,251,1040,1395;43;F
41313;1380,634,983,1304,688,1404,1391,1040,644,1077,1369,393,251,1392,1042;48;M
41315;1285,1504,1043,1385,1386,1380,856,1522;33;M
41325;1040,384,1367,1372,1304,1522,1391,977,1504,186,1627,571,1077,1045,1418;44;F
41337;1372,186,1361,856,1285,1404,1403,938,977,1279,248,393,1369,688,644;36;F
41389;856,1102,1380,1645,634,575,1048,1345,644,1391,251,1040,1627,1077,1367;25;F
41411;1361,856,1102,1385,715,1294,1522,1345,644,938,977,571,1077,1418,1367;37;F
41429;1380,1372,1367,1040,856,715,1042,1285,1392,1345,251,977,914,1279,1418;44;F
41474;1269,575,1391,1040,1627,384,1372;33;M
41477;1036,1627,644,575,1645,634,1042,1048,1391,1504,384;21;F
41495;1367,384,1040,1279,251,1391,1345,1392,1285,1645,1380,1269,715,1102,856;32;M
41518;977,1279,571,1077,1367,1372,1362,856,1102,1645,855,983,957,276,1391;26;M
41530;186;53;M
41537;1391,977,1279,1040,1077,1045,1418,1036,393,248,1362,634,644,1386,1395;50;M
41572;1522,688,1345,251,977,1418,1367,1036,1372;31;F
41574;1645,1042,1367,1372,393,1043,384,1504,1391,855,1380,251,1345,856,1361;29;F
41584;186,248,571,1077,384,1367,1362,1279,1403,1404,1345,575,1285,1294,1385;35;M
41613;1539,688,276,251,1386,1077,248,1418,1367,1372,1392,977,1395;63;F
41614;856,1539,977,1372,248,1179,276,1182,1102,1285,1345,1392,1404,1403;39;M
41674;957,977,276,1077,715,1367,1279,186,1404,384,983,1350,1048,1285,1391;36;M
41683;1361,856,1102,977,1040,1367,1036,1372;29;F
41685;1294,715,1048,855,1645,634,1042,1361,1385,1539,688,914,1367,1376,1372;29;F
41689;1294,1269,855,1403,938,977,914,571,248,1392,1504,1404,1345,856,1285;33;F
41744;1042,1046,1350,1361,1385,856,1362,715,634,1345,644,1627,248,1036,1043;39;M
41758;688,715,1077,1404,1504,1392;26;F
41769;1391,914,1077,1372,1179,1404,1345,1645,1285,1279,1504,1627,571,384,1367;65;F
41771;1376,1102,715,1522,1052,1048,186,1077,1345,1285,977,1627,1418,1367,1372;31;F
41781;1645,1304,914,1504,1042,1102,856,1269,1380,1285,1048,251,1279,1040,1627;37;F
41808;575,1645,634,1269,715,1102,1042,1418,384,1367,1372,1539,1404,1403,1179;65;F
41815;571,1367,1627,1504,1345,957,1285,856,1102,1385,1294,1182,1269,1645,983;36;M
41822;977,248,1372,1645,644,384;45;M
41838;1372,1367,1386,914,1048,1522,1304,1182,1361,1102,1345,1403,977,1040,1179;36;F
41924;1504,1279,384,916,856,1046,1294,575,1522,1048,1613,251,1367,1036,1362;31;F
41947;1269,1385,715,1285,1539,1345,1404,1403,977,1279,1179,1627,571,1184,1367;25;F
41952;1404,1403,1392,1345,1285,1102,1182,276,1179,248,1372,977,1539,856;68;F
41959;856,715,1182,1645,855,1392,1404,1391,977,186,571,1077,248,1367,1362;65;F
41971;1392,1304,1539,1040,1184,1372,1376;35;M
41982;571,1184,1403,1294,1539,688,276,1404,977,186,248;46;F
41990;856,1042,1380,1304,1048,251,938,1386,1040,186,1395,1418,1367,1372,1376;35;F
42001;1627,248,384,1367,575,1392,1539,1404;36;F
42006;251,1391,1345,276,688,1539,1304,1380,715,1361,1102,1645,575,983,957;47;F
42013;248,1367,1362,1102,715,575,983,1539,1404,1403,1391,977,914,1504,384;36;M
42021;1052,575,1345,914,1102,1042,1380,1269,1285,1304,1392,1522,1048,1279,1040;38;F
42025;1539,1404,1403,1392,1345,1285,1102,1182,276,1179,248,1372,977,856;;F
42033;571,1385,1294,575,856,1269,1285,688,1279,1372,1367,1613,1392,1504,1522;32;F
42060;1362,384,1395,1077,1179,1403,1048,957,575,1645,1182,715;3;F
42067;634,1380,1645,251,1362,856,1102,575,1040,186,384;36;M
42068;856,1102,634,1645,1285,1345,644,251,1040,1367;35;M
42091;1385,1294,575,1285,1404,1403,977,1279,1372,1392,1345,1391,571,384,1367;32;F
42116;1182,186,856,715,1645,855,1392,1345,1404,1627,571,1077,248,1367,1362;72;M
42151;1385,1294,1645,571,384;59;F
42153;715,1285,1403,1179;37;M
42160;1077,1418,1362,856,1294,1285,688,1403,1404,977,1279,571,248,1367,1372;38;M
42174;715;14;F
42182;715,1645,1392,1304,1522,1077,1367,1372,1362,1345,977;43;M
42193;1345,1385,856,1269,1040,1504,1391,1392,1285,1102,1418,384,1367,1372,1362;28;M
42196;977,1269,1385,856,1102,1380,1645,1304,688,644,1613,251,1040,384,393;50;F
42209;715,1350,1361,248,1504,1102,1042,688,644,384,1367,1372,393;39;F
42245;1522,1392,1645,1182,1042,1385,856,1345,1376;45;M
42259;1285,1345,977,1504,1627,571,1102,856,1269,1645,644,251,1279,384,1367;32;F
42266;1504;33;M
42279;1362,856,1350,1042,1380,634,1285,1052,1345,644,1040,1077,1045,1395,384;51;F
42333;1392,634,1182,715,1385,644,1040,1077,1367,916,1345,1391,251,571,1395;46;F
42407;186,1279,688,1392,1645,1345,1404,251,977,1504,248,1418,384,1367,1372;52;F
42420;715,251,1040,1077,1036,1369;35;F
42422;1380,1392,644,251,186,1627,1077,1418,1367,1372;34;F
42428;715,1350,938,1036,1043,916;37;F
42430;1627,186,1504,1040,251,1392,1042,1046,1102,1304,1522,1404,1418;35;F
42442;1361,856,1046,1269,1285,1304,1522,1345,644,1279,1040,1627,1418,1367,1036;33;F
42450;393,1361,1385,1645,1392,1048,1391,251,938,1040,1627,571,1367,1036,1372;34;F
42458;1350,1404,1403,977,1385,1294,1285,1345,1391,1613,1279,571,1367,1036,1372;14;M
42496;1380,715,1040,1077,1036;9;F
42498;1380,1102,1042,1269,1345,1391,251,977,914,1279,1040,1504,571,384,1372;30;F
42500;1522,1385,1294,1645,634,1392,1345,1391,977,1504,1077,1418,384,1367,1372;39;F
42520;715;44;F
42527;1102,1042,856,1294,1285,1613,977,1279,186,571,1045,248,1367,1036,1372;25;M
42686;1403,1539,688,1395,856,1102,1385,1645,1285,251,977,1279,186,1367,1372;40;M
42691;715,1539,688,1395,856,1102,1385,1645,1285,251,977,1279,186,1367,1372;37;F
42695;1403,1404,938,914,1386,1040,1627,393,856,634,1048,644,1391,1376;34;F
42704;634,384,1048,938,1504,1395,1184,1391,983,957,1036;25;M
42741;1539,1522,1418,977,1404,1392;19;F
42754;1392,571;47;M
42776;715,1391,1403,1345,1645;33;F
42780;1102,1361,1285,1304,1345,644,1386,1376;41;M
42788;1042,1539,1052,1362,1372,1102,1404,1403,1179;31;F
42801;1345,644,1504,186,571,715,575,1391,977,1279,1077,1418,384,1367,393;51;M
42850;983,1391,1403,1404,1345,575,1645,1294,1385,1279,1504,1077,1367,1285,715;49;M
42856;715,575,983,1392,1539,1522,1345,1404,1403,1391,1179,571,1077,1418,1362;38;M
42858;644,1391,251,1040,1077,1418,1369;36;F
42880;1269,1285,1046,1645,1404,1403,186,571,1367,384,1043;42;F
42894;715,1102,186,1504,1418,1042,1269,1285,1345,1404,977,856,1077,1367,1372;29;F
42910;1102,715,575,983,1392,1539,1522,1345,1404,1391,1179,571,1077,1418,1362;13;F
42940;1102,715,575,983,1392,1539,1522,1345,1404,1391,1179,571,1077,1418,1362;2;F
42959;1102,856,1345,644,977,186,571,1418,1367,1372;30;F
42963;715;40;F
42970;1102,248,1404,1367,1372;17;F
42980;1522,1391,1279,186,1627,571,1045,1362,1385,1418,856,855,1367,251,384;53;M
42998;248,1372;71;F
43005;856,1380,1345,1294,1522,571;41;M
43022;856,1385,1350,1380,1522,1052,1345,644,251,1040,571,1045,1418,1367,1372;32;F
43034;1385,856,1361,1102,1046,1380,575,1304,251,914,1279,1040,1418,384,1367;37;M
43035;856,1269,1285,1522,1391,251,1279,1040,1418,1367,1372,1362,916;36;F
43039;856,715,1294,1269,1285,1345,1279,571,248,1418,1184,1367,1372;41;M
43070;1627,634,856,1046,1294,1269,1380,1645,1392,1522,1391,1613,251,938,1040;65;M
43102;186;30;M
43110;1350,1046,914,1045,1043,916;50;F
43121;1042,1350,856,1385,1046,1294,251,914,1627,571,1418,393,1043,1362,916;38;F
43123;977,914,1504,1627,1077,1036,1372,1385,715,1042,1285,1522,644,1418,1367;41;F
43135;1052,1040,634,983,1048,957,1391,938,251,1504,1045,1184,384,1367,1036;25;F
43185;1418,1504,1040,914,276,1522,715,1102,856,1380,1392,1345,1391,1613,1077;45;M
43190;1395,1269,634,1613,1077,1392,644;44;F
43208;688,1539,856,715,1367,1372,1385,1042,634,1392,1522,644,1627,1077,1418;39;F
43225;1645,575,1304,644,977,1040,1504,186,1285,1380,634,715,251,1367,1372;30;F
43229;715;39;F
43247;186;39;M
43271;715;40;M
43273;1392;34;M
43284;715;9;F
43295;715;4;M
43311;1391,1613,715,1285,1367,1077,1504,1279,1385,1294,1645,575,1345,1404,1403;42;F
43331;575,644,384;24;F
43339;1539,688,1404,1504,186,1102,1645,644,1391,251,977,248,384,1367,1372;31;F
43344;1077,1043,1294,1345,1269,1285,251,644,1279,1040,1418;46;M
43352;1042,688;90;F
43355;855,1385,983,1613,1645,856,715,575,1285,1345,1391,1279,1504,1077,1367;11;F
43374;856,715,1645,1392,1404,251,1504,1627,384,1367,1376;45;F
43383;916,1046,856,1102,1042,1392,1522,1345,644,1391,251,1045,1418,1367,1036;38;F
43384;575,1522,1279,1504,1627,571,384,715,856,1102,634,1285,1345,251,1040;43;F
43420;1102,1385,1294,1645,186,571,1367;44;F
43425;1345,644,248,1367,1372,1376;72;F
43437;1042,1345,644,1504,1367,1369,1361,856,1102,1304,1391,1040;30;F
43439;1504,251,1042,1269,1285,1522,1345,644,1391,977,1279,1040,1418,1367,1372;32;F
43440;1372,1367,384,575;35;F
43447;1285,1269,715;49;F
43449;715;51;F
43452;1304,1376,1362,1372,1036,384;17;F
43481;1369,1077,1279,914,251,1391,644,856,715,1269,1380,1285,1304,1040,1395;39;F
43497;715,1269,1285;10;M
43550;855,1042,1102,856,715,1269,1285,1522,1345,644,1391,251,571,248,1367;35;F
43564;1285,575,1102,715,1345,1279,1504,1077,384,1367,856,1380,1269,1627,1418;37;F
43568;1043,1403,1345,1404;41;F
43577;715,1269,1285;9;F
43595;1304,644,1391,251,1627,856,186,1102,1380,1645,575,384,1040;30;F
43596;1522,1391,571,1367,644,856,186,855,1345,1392,977,688,1627,248,1418;39;F
43624;384,1036,1372,1361,856,1102,1052,938,1040,1376,1042,575,251,1418,1043;34;F
43636;1403,1404,1391,1040,1345,715,1504,1367,1372;58;F
43672;1042,575,1304,688;22;M
43697;1367,1077,1627,977,1269,1504,1052,644,1392,634,1385,1645,186,571,384;23;F
43710;186,571,248,1372,1385,715,1294,1645,855,1285,1392,1627,856,1367,384;43;M
43727;1045,1350;43;F
43757;1269,1102,1392,644,251;34;F
43773;1392,1372,1179,1285,1345,1404,1403,1279,1504,571,248,1418,384,1367,1362;41;M
43786;1385,393,1367,1522,1304,715,1361,1380,644,251,938,1504,856,1345,1392;52;F
43796;1102,1645,575,1345,1404,1391,384,1367;68;M
43809;1294,1380,575,1285,1391,1613,977,1367,1372,1362,1645,384;44;F
43823;1285,1522,644,1279,384,1036;37;M
43827;1304,1504,1627,856,1102,1380,1269,634,1345,644,1391,251,1279,1040,1036;49;F
43884;977,248,1367,856,1392,1539,1404,1403,1179;39;F
43894;1294,1285,688,1345,1404,1403,1279,248,1372,1367,571,1504,977,1645,1385;46;F
43905;1385,715,1042,1645,1392,1052,1345,571,384,1367;34;M
43907;715,1042,1645,1627,1539,688,1345,644,1404,977,1504,571,1367,1372,393;33;F
43909;1279,186,571,1418,1102,1367,1040,1627,1645,856;38;M
43952;1645,384,1362,251,1391,1404,1539,856,1052,1048,1504,186,1367;46;F
43954;1627,1504,1391,1345,1052,1048,1522,634,1350,1418,1613,1392,1042,1102,1362;28;F
43968;1042,634,1522,1504,1395;37;F
43973;384,1367,1102,1361,856,634,575,1345,644,1391,1040,1504,186,571,1372;49;F
43989;1279,1404,1285,1294,856,1380,1645,1392,1345,1391,251,977,1040,1367,1372;43;M
43991;1361,1048,1391,251,1386,1040,571;51;M
43995;1380,634,1304,644,251,938,1036,1369,1362;39;F
44034;1285,1522,644,914,1279,1077,1367,715;41;M
44038;1395,1279,856,1040,1304,1102,1269,1077;33;M
44051;1285,715;37;M
44137;1385,1042,1645,1392,1048,644,1404,977,1386,186,1627,248,384,1367,1372;52;F
44170;1182,1042,1392,1539,1048,644,1404,1403,1391,1040,1179,384,1367,1036,1372;43;F
44183;1362,384,571,1345,1522,1645,1042,1102,1285,1304,1386,1040,1077,1367,715;37;F
44193;856,1269,977,186,1372,1367,1504,644,715;41;F
44195;1102,1645,1285,1279,1077,715,634,644;36;M
44205;1102,1182,1392,644,251,1040;44;F
44229;1391,1345,1285,1645,1042,1279,1040,1077,1418,1367,1372,715;52;F
44259;1522,644,938,977,1361,1042,634,575,1539,688,1404,1403,1045,1372,1367;21;M
44264;1345,977,1040,1367,1380,1048,1539,1392,575,1403,1404,1504,1627,384,1372;38;F
44285;1102,571,1040,1391,1392,1645,186,1367,856,1380;39;F
44292;1369,1269,1380,1304,644,1391,1279,1040,1627;35;F
44302;1522,1304,856,1042,1269,1285,1345,1391,977,1279,1627,1077,1418,1367,1372;29;F
44313;1385,977,186,384,1367,1372;25;F
44332;1052,251,1372,1102,1392,688,1040,1395,1036,1043,916,1048,634,644,248;34;M
44364;1102,1350,1391,251,1040,384,1372,1362;37;M
44406;1613;21;M
44416;634,644,251,1386,1040,1372;19;F
44427;1522,1285,1645,1102,856,1042,1380,855,1304,1404,1391,1040,248,1367,1362;24;M
44440;1404,1403;37;F
44456;856,715,634,855,644,251,977,1386,1040,1504,1627,571,384,1367,1372;43;F
44486;1279,1504,186,571,1184,248,1367,1372,393,1385,1102,1645,1345,1386,384;30;F
44495;1645,1539,688,644,1345,1403,938,393,1372,977,1102,276,1404,248;36;M
44553;1404,1391,1386,248;46;M
44562;1645,1539,688,1279,1504,384,1367,1372,634,1285,1403,1404,1627,571,248;42;F
44590;1391,1403,1404,1627,186,1102,1385,715,1645,1285,1345,571,1367,1269,1279;47;M
44601;715,1522;43;F
44606;1269,1645,1285,1522,1345,1613,977,1279,1040,1627,1045,1418,1367,1036,1372;26;F
44613;1372,1045,1345,1645,715,1385,1040,1102,1403,1279,856,384,1539,644,1077;27;M
44614;1042,1385,1392,1522,1052,644,251,977,914,1279,1504,186,1627,1418,856;30;F
44622;1279,1391,634,1269,715,1102,1046,1522,1345,644,251,1040,1418,1043,916;38;F
44648;1404,977,1040,1627,1372,856,1102,1385,1380,1645,251,938,1504,571,1367;24;F
44655;384,1372,1043;55;F
44658;715,644,186,1627,1539,1285,1102,856,1345,977,571,248,1418,1367,1372;20;F
44660;1043,1367,575,1645,1102,1052,1345,384;32;F
44663;1102,715,634,575,393,1367,1077,1504,914,251,1391,644,1345,1048,1042;42;F
44665;1391,251,1279,1040,1077,1418,1367,1372,1522,1285,634,1380,1269,1042,715;6;M
44682;1102,856,1392,1539,1345,688,1269,1285,251,977,1279,1504,1627,1367,1372;30;M
44724;1386,1404,248;39;M
44736;856,1367,715,1042,1269,1380,634,1285,1522,1391,251,1279,1040,1077,1418;8;M
44798;1040,1504;40;F
44817;938,1048,1361,575,1385,1102,856,1367;32;F
44829;1285,1392,1345,977,914,1279,1040,1504,186,571,1627,1418,384,1367,1372;23;F
44902;1627,251,186,575;41;F
44920;1052,688,1539,1285,1645,1385,977,1367;28;M
44958;248;43;M
44969;186,1376,571,251,1391,1048,1304,1285,1042,1102;40;F
44978;1367;30;M
44995;1304,1522,1052,384,1369,1043,856,1102,1645,1048,644,251,186,248,1418;40;F
45019;715,1048,1376;45;F
45026;856,1385,1380,1345,1391,251,1504,1362,1367,1372,1048;31;F
45038;1361,634;28;F
45043;186,571,1392,575,855,1042,1385,1102,856,384,1367,1369,1372,393,1043;27;F
45047;1361,1102,1350,1042,1380,1052,251,1040,1504,1627,1418,384,1372,1043,916;31;F
45053;1372,1380,634,983,1048,1404,251,384,1102,575,688,977,1504,1627,248;48;F
45058;1102,1269,977,1040,186,1627,1367,1372;33;M
45093;1350,1042,1645,1522,1048,1345,1391,251,938,914,1040,1045,1418,384,1367;26;F
45111;1294,1361,1539,977,1367,393,571,1386,1304,688,1404,1403,248,1372,1376;32;F
45152;715;29;F
45154;856,1102,1350,1294,1380,1522,251,977,1040,1077,1418;36;F
45172;715,1345,1077,1418,1372,856,1102,1385,1645,575,1504,1627,571,384,1367;48;F
45174;715,1380,575,1048,1052,1345,251,1386,1504,186,1418,1367,1036,393,1362;35;F
45186;644,1269,715;36;M
45210;914,251,644,1345,855,1042,1102,856,1392,1522,1391,186,384,1367,1372;31;F
45254;1304,575,1376;68;F
45267;1304,575,1182,715,1294,856,1385,1048,251,1040,571,1395,1367,1372,1362;43;M
45276;1269,1077,1285,1345,1391,1279;30;F
45296;1504,1403,1539,1645,715,575,688,1404,977,1627,571,248,384,1367,1372;51;F
45329;1102,1645,1048,1404,384,1372;39;F
45371;1042,1350,1385,856,1279,1040,186,1627,571,248,1184,1418,1367,1372,1043;24;M
45372;1361,1102,715,1376;48;F
45385;1645,644;30;F
45393;1304,1345,1403,1391,251,938,977,1040,186,1627,571,384,1367,1036,1372;25;F
45404;855,688;47;F
45411;855,1645,1385,1102,1345,1391,251,977,1504,186,571,1418,1367,1372,393;34;F
45416;1385,983,644,384,1372,248,1392,1403,1404,1367,1077,186,1345,855,1504;31;M
45446;1102,1042,855,1345,977,1504,1627,384,1367,1372,1391;48;F
45487;1627,1077,1418,1372,186,1048,688,1522,575,855,1042,1361,856,251;29;F
45491;575,1385,634,1048,644,251,977,1386,1504,186,571,384,1367,1372,1376;36;F
45494;1040,1504,1627,571,1036,1361,1042,634,688,1048,1345,977,384,1372;24;F
45541;1395,571,1040,977,1613,1391,644,1522,1304,634,1042,1372,1362;49;F
45557;914,186,1627,571,1418,384,1367,1376,856,1385,715,1042,1380,1285,251;37;F
45564;644,1077,715;4;M
45572;575,251,384;26;F
45578;715;9;F
45617;1285,1645,1269,1385,1102,856,1380,634,644,251,1040,1077,1369,1372,715;36;F
45621;1380,1392,1304,1048,644,1404,1391,1040,1418,1362;40;F
45629;977,914,1627,1385,1102,634,575,644,251,938,1040,1504,384,1367,1372;27;F
45717;856,1385,1294,1392,571,393;46;F
45736;1048,1040,1367,1372,1362,1376;43;F
45758;977,1418,1269,1367,1372,1279,1376;40;F
45760;571,1184,1403,1404,688,1539,1645,715,248,1279,1285,1385,856,1367,1372;32;F
45784;1042,1392,1304,251,914,1040,1372,1362;42;F
45787;914,571,1285,1345,1404,1403,1418,384,1279,1040,1372,1504,1362,1269,1392;30;F
45809;644,914,384,1369,393,1362,1376,1294,1385,1380,1392,1304,1613,251,1040;29;F
45861;1539,856,1294,688,1345,1403,1404,977,571,186,1184,1367,1372;32;F
45864;1048,977,186,1350,1285,1613,1040,1645,1404,1279,571,248,384;49;F
45875;1048,1504,571,1362,1077,1418,1372,1627,1040,1279,1613,1345,1522,856,1367;69;M
45880;1372,1367,384,1418,1627,1279,1345,1522,1285,1269,1042;39;M
45884;715,1048,1391;40;F
45894;1522,1304,1042,1369,1367,1418,644,1102,856,1380,575,1392,1504,1627,571;33;F
45896;916,384,1077,1040,251,1285,1645,1269,856,715;36;F
45898;1404,1613,977,1279,1040,1179,1504,186,1627,571,248,1395,384,1367,1372;67;F
45940;1345,1392,1042,1403,1179,1504,1627,571,1539,688,1404,977,248,1367,1372;34;M
45945;914,1362,384,1391,1052,276,1102,1042,1048,1345;17;M
45954;1042,1385,1345,1613,1504,384,1372,1102,1052,644,1386,1040,1369,1304,1392;30;M
46008;571,1345,1052,688,1539,1294,1645,1522,1404,1403,977,1179,1418,384,1372;31;F
46011;1350,1048,393,1376,1036,1613,1395,384;39;F
46016;1361,1102,1380,1285,1304,251,938,1040,1367,1369;33;F
46034;1627,1294,1385,1504,571,977,1391,1345,384,715,957,983,1367;32;M
46075;644;65;F
46108;644,1392,855,186,1040,1279,1391,1404,1345,276,575,1645,1102,1367,384;54;F
46119;1279,1627,248,1418,1362,1376,1380,1285,1391,977,1040,1504,571,1367,1372;28;F
46120;1040,1077,1367,1362,1269,1345,856,1627,1279,1380,1418,1372,1392,1522,1504;32;M
46123;1380,575,1392,1539,1404,1367,1362;38;M
46153;1052,856,1385,983,1404,1403,571,248;25;M
46201;384,1043,1504,1040,938,251,1345,1052,1048,1645,575,1042,1350,1102,1361;23;F
46205;715,1042,1269,1285,1522,1345,644,1391,251,977,1279,1077,1418,1367,1372;42;F
46227;1391,1345,1522,855,1645,1042,1350,1367,1102,856,1304,644,251,1040,1077;38;F
46234;1645,1361,1102,1350,634,575,983,1304,1539,1404,251,938,1386,1040,1504;28;F
46249;1539,1392,1179,1404,1403;28;M
46272;1102,634,644,384,393,1645,856,1077,1504,1367;37;F
46288;186,1077,1369,1350,1042,1269,1380,1285,1522,644,1279,1040,1418,1367,1372;35;F
46311;715;42;F
46370;1385,1294,1645,1392,1040,571;63;F
46407;393,1361,1376,1367,1418,1627,977,1539,1304,1285,688,1404,914,384,1372;29;F
46409;1102,856,1052,1395,384,1345,1404,1504,1285,251,1522,1279,1362,644,1269;40;M
46436;1269,384,1372,1376,393,186,1361,715,1042,1391,251,914,1040,1362,1367;27;F
46467;856,1285,1392,1504,1627,1372,384,1279,251,1345,1539,1294,1385;39;M
46469;856,1042,1285,1304,1522,1345,644,1391,1279,1040,1376,1504;33;M
46474;856,1380,1386,1036,1361,1269,1304,251,1040,1369,393;35;F
46480;1539,1392,688,276,1404,248;38;M
46494;938,251,1645,1042,1102,856,1613,384,1372;27;F
46506;856,1385,1380,1392,1304,1522,1345,644,977,186,1627,571,1418,1367,1372;60;F
46525;1627,384,1362,856,1391,1504,1077,1395,1418,393,1372,1102,715,1285,1367;46;M
46547;1285,1504,1077,1418,1367,1102,715;37;F
46565;571,1376,1102,1042,983,957,276,1391,1613,977,1184,384,1367,1036,1372;17;M
46582;856,1404,914,1179,571,1367;29;M
46600;1102,1645,1304,1522,1048,1345,644,1391,1613,1376;74;F
46604;1279,1392,1285,856,1350,715,1046,1042,1345,644,1077,1045,1367,1043,916;5;F
46627;1645,1285,1304,1539,1522,1345,1404,1613,1279,1504,1040,1077,1418,1367,1372;21;M
46692;1345,1522,1392,1269,1042,1385,1627,571,856,1294,644,1391,1077,1362;45;M
46706;1048,644,1404,1403,1179;47;F
46745;1385,1102,856,1285,1304,1345,644,938,1040,1077,1418,1367,1036,1369,1372;30;F
46750;1077,1385,634,1285,644,1613;41;M
46756;1042,1048,856,1102,1385,1294,1645,1345,644,1391,977,571,384,1367,393;29;F
46761;1362,856,1048,1102,855,1042,1052,1504,634,1345,644,1040,1395,384,1369;65;F
46765;1279,914,688,1539,856,1385,1294,1042,1380,1304,1052,251,571,384;36;F
46783;1345,644,1391,251,977,1279,1040,1077,1395,1418,1367,1372,1102,715,1285;37;F
46791;856,1042,1645,1304,644,1613;56;F
46801;856,715,1269,1304,1522,644,251,977,1040,1627,1077,1395,1418,1372,1036;36;M
46803;855,1294,1182,634,575,1285,1539,1345,644,1367,1403,1372,1404,1179,1504;27;F
46806;1361,856,1102,1269,634,1285,1345,251,1279,1040,1504,186,1627,1418,1367;32;M
46811;1042,1645,1392,1522,1345,1391,1613,977,1040,1504,1418,384,1367,1372,1043;25;F
46825;1613,644,1285,634,1385,1077,1376;10;M
46838;251,1345,1380,1102,856,715,1285,1522,644,1418,393,1362,916;8;M
46850;856,186,571,1367;36;M
46860;1539,1279,1285,1294,1404,977,1345,1403,1645,571,248,1184,1418,384,1372;42;F
46863;384,571,977,1403,1361,634,1367,1042,1645,1048,1052,644,1404,186,393;36;F
46865;1613,644,1279,634,1385,1077;13;M
46868;634,644,1613,1279,571,1077;40;F
46875;1367,1391,1404,1539,634,1350,1385,1102,856,1294,1380,1645,1345,251,571;36;M
46886;1294,1539,1522,688,1404,977,571,248,1372,856,1385,1645,1392,1345,1367;45;F
46908;1367,1077,1522,715;43;F
46910;1391,1645,1269,1102,644,1613,1279,1504;50;F
46913;1345,1391,1418,1367,1504,1077,1522,715;42;M
46941;1077,1040,977,1522,1613;50;F
46959;1046,856,575,1285,1052,251,1040,1036,1372,384,1645,1392,1304,1369,393;44;F
46968;1391,186,1627,1102,1645,1404,1403,251,977,1279,1504,571,384,1367,1372;63;F
46970;1362,1367,384,1418,1077,1504,977,1380,1294,1385,1522,1345,1391;42;M
46980;914,1386,1367,1372,571;66;F
46998;1036,1372,248,1376;60;M
47033;983,688,644,1386,1367,1372,393,1345,384,1102,977,1392,1391,248,276;31;F
47046;1279,938,1539,856,1179,186,1367,1285,1522,1404,1403,251,1418;31;F
47054;1350,1042,1380,634,276,1345,1404,1403,251,1279,186,1367,1372,1645,1285;43;F
47105;1539,1269,1385,715,1294,1285,1403,688,1279,977,1504,186,248,1367,1372;29;M
47126;1391,1345,1052,1048,1522,1304,1285,1380,1046,715,1350,1385,1102,1392,1040;40;F
47138;1362;58;M
47146;1392,855,1269,1522,688,276,1404,1391,1418,1367,1372;35;F
47153;1279,1392,575,1294,1627,1045,384,1372,856,1385,1645,644,1504,571,1367;41;F
47218;856,1380,1392,1345,251,914,1040,186,571,248,1367,1036,1372;68;F
47225;1504,1077,1613;49;M
47228;1627,571,1077,384,1036,1372,1043,1362,1385,715,1645,1391,1504,186,1367;32;F
47239;1046,1522,1048,644,251,1040,1395;30;M
47242;644;67;F
47253;1102,1385,715,1294,1380,855,1285,1392,1304,1345,1404,1391,251,1040,571;15;M
47276;856,1042,644,1404,1403,1391,1613,977,914,1279,1504,1627,1367,1418,1372;44;F
47287;276,1285,575,1269,715,1102,1385,1294,634,1392,1345,644,571,1077,1367;84;F
47309;1404,1403,1391,1179,571,1367,1376;46;F
47310;186,1627,1040,977,251,1304,575,1102,856,1380,1391;52;F
47313;977,1345,1052,1304,1042,1380,1522,1391,1418,916;47;F
47322;715,1042,1380,1645,1522,1391,977,1279,1040,1504,1418,384,1367,1372,1043;53;F
47346;1418,571,1504,1279,914,977,1613,1403,1391,1404,644,1042,1385,1102,1372;11;M
47350;1184,1645,1102,856,1403,1279,1504,1376,1367,384,1404,1380,715,1285,1304;20;F
47354;1418,1367,1372,1376,1385,1182,983,1285,1539,957,1404,1391,1077,1345,1279;33;F
47400;1504,1345,688,1539,1392,634,1102,856,977,1404,644,575,1645,384,248;45;F
47447;1395,1036,1043,1350,1522,644,916,1376;38;F
47487;1645;60;M
47495;1380,251;31;F
47520;1279,634,856,1385,1645,575,1285,938,977,1040,1504,248,384,1367,1372;27;F
47529;1404,251,186,1627,1395,384,1376,1418,1077,1504,977,1391,644,1522,715;35;F
47531;1385,1102,1645,1345,1391,186,1627,384,1367,634,688,644,251,248,1372;63;F
47532;1613,1522;46;F
47542;1102,1077,1042,856,1182,1539,1522,276,1391,251,977,1418,384,1372,1613;40;M
47544;1504,1385,715,1391,1043,1350,1052,1048,1042,1404,856,855,1392,1372,1367;30;F
47558;715,1040,1627,248,1367,1294,1285,856,1392,1345,1613,1279,571,1077,1372;51;M
47563;1385,644,977,1504,571,1418,1367,1372,393,1294,1042,1522,1048,1345,1036;34;F
47564;1102,1345,1391,1279,1504,1627,1294,856,1385,1645,571,1367;68;M
47569;1613,251,1418,1350,1036,916,1102,1046,1042,1645,644,914,1040,1045,1043;64;F
47584;1403,1404;36;M
47600;1102,1380,1392,1345,644,1404,1391,1386,1504,1395,1367;36;M
47638;715;34;M
47665;715,1376;8;F
47683;715;5;M
47695;1102,634,644,1345,186,856,1385,715,1294,1645,1285,1279,1627,571,1367;68;F
47697;715;43;F
47707;1404,1403,1613,977,914,1279,1504,1627,571,1367,1372,1102,1345,186,1391;44;M
47710;1380,715;44;M
47711;1362,1367,1077,1182,1385,856,1391;41;M
47730;1345,1418,1391,1522,1361,1645,1042,715,1048,1504,1045,384,1367,1372,1043;24;F
47775;856,1102,1385,1040,1362,1367,914,251,1391,1392;40;F
47787;1048,1077,1376,1102,1380,1304,1345,644,1391,1504,384,1367,1036;39;F
47799;1345,1613,1372,1392,1279;10;M
47800;1102,251,1395;47;F
47815;1385,715,1380,634,1645,855,1285,1345,251,977,1040,1627,384,1367,1504;34;F
47828;1361,1304,1386,384;44;F
47832;1504,977,1304,575,1645,1294,856,1385,1345,1391,251,938,1040,571,1367;37;F
47836;1392,1345,1504,248,1385,1294,1285,1304,1404,977,1279,571,1367,1036,1372;37;F
47841;1285,1392,1539,1345,1404,1403,977,1179,1504,384,1367,1372,1362;43;F
47842;1539,977,1040,1367,1350,856,983,1285,1052,276,1391,186,1045,916,1362;15;M
47874;1380,1294,715,1385,856,1102,1522,1345,1391,977,571,1418,1367,1372;37;F
47875;1102,715,1285,1539,688,1279,1179,1504,186,1627,571,1184,248,1367,1372;44;F
47885;1285,1279,1504,186,1367,1385,248,1627,571,1042,1392,1539,1404,1403,1179;29;M
47898;1613,715;47;M
47917;856,715,1385,575,1403,1404,1367,384;31;M
47924;1362,1043,1042,575,1404,916,393,1418,715,634,1285,644,251,1045;40;F
47927;1285,715,1362;6;M
47950;715,1285;9;F
47971;914,1279,1040,1627,1395,1285,1380,1269,1042,1361,1345,644,1077,1418,1367;37;F
47975;575,977,186,384,1367,1372,957,1345,1391,251,1504,1184,983;35;M
47985;251,186;42;F
47990;977,1613,1403,1048,1285,1380,715,1269,644,1404,1391,251,1279,1077,1367;35;F
48020;983,957;34;F
48030;1392,856,1522,1391,1613,571,1418,1367;47;M
48034;634,1380,1269,1361,856,1102,1385,1645,1304,1403,1404,251,186,571,1367;50;F
48040;1386,1391,1345,1522,1304,1392,1042,1385,1102,856,1645,575,914,1418,384;42;F
48047;1046,1380,634,644,1391,251,938,914,1040,1077,1395,1418,384;41;F
48060;1102,1350,1042,1645,634,1522,1345,1391,1077,644,1279,1269,1386,1362,916;37;M
48061;983,957;34;M
48109;1391,977,914,186,1077,248,1367,1372,1102,1042,1269,1285,1345,1279,1395;45;F
48114;1269,1285,1539,688,1345,251,938,977,1040,186,1627,571,384,1367,1372;25;F
48189;1179,1279,977,1345,1403,1404,1539,1392,1285,983,1645,1269,1294,715,1367;50;F
48206;1046,575,983,1279,1362,856,1102,1350,1042,1182,1645,1052,1391,571,384;20;F
48228;1627,914,251,1345,1304,1392,634,1372,1380,1042,856,1269,1522,644,1613;41;F
48263;248,571,186,1504,1279,251,1403,1404,1392,1285,1645,1294,856,1385,1367;31;M
48279;186;64;F
48353;1279;39;M
48369;1391,1403,1404,1102,856,715,1285,1522,1345,644,1077,1418,1367,1362,1372;40;M
48384;715,1380,1285,1522,1345,1391,251,977,914,1040,1077,1418,1367,1372,1362;8;M
48397;715,1350,856,1042,855,983,1392,1522,1391,977,1418,1369,1372,1362,916;41;F
48403;1102,715,1380,1285,1345,644,1391,251,977,1040,1077,1418,1367,1372,1362;7;M
48460;1627,914,1345,1102,856,1269,1392,1304,1522,1048,251,977,1040,1077,1367;34;F
48465;1102,715,1380,1285,1522,1345,644,1391,251,977,1077,1418,1367,1372,1362;38;F
48467;1367,1372,1613;47;F
48470;1304,1285,1645,1269,1042,1294,715,1350,1385,856,384,1040,977,251,1380;22;F
48477;1285,248,856,1102,1269,1392,1345,1404,1391,251,977,1504,1367,1372,384;27;F
48518;1392,571,1372,715,1645,1522,1048,1345,644,914,1627,856,1077,1367,1362;38;F
48544;856,1376,1040,1395,1380;46;F
48551;977,1386,1418,1372,1376,1380,1285,1048,276,1345,644,1391,251,1040,384;32;F
48576;634,1539,1345,1404,1391,251,977,1279,1504,186,1627,571,384,1367,1372;30;F
48591;1522,1304,575,1645,1102,1052,914,1040,1504,1077,393,1362;34;M
48615;856,1102,1645,1304,1345,644,1391,1504,571,1376;69;F
48668;856,1102,1645,1304,1345,644,1391,1504,571,1376;71;M
48685;1613,186,571,1361,1385,1042,575,1052,1040,1504,1367,856,1645,1627,384;28;F
48686;644,856,1048,1391,938,1372,1504,1367;22;F
48693;856,1102,1294,1645,1048,644,1391,571,1367,1376;73;F
48702;1046,1380,644,1386,1040,1395;73;F
48716;856,1102,1294,1645,1048,644,1391,571,1367,1376;71;M
48776;1279,571,1367,1285,1294,1395;52;M
48800;856,1269,1522,1345,644,251,1040,1418,393,1372;33;F
48824;715,1350,1522,1077,855;50;M
48839;1385,1380,856,1304,251,1040;42;F
48850;977,1345,1539,1285,1380,856,1392,1304,1522,1404,914,1279,186,1367,1077;67;F
48857;1367,1350,1294,1077,1362,1102,634,575,571,644,1385,1504,1627,1645,856;36;M
49017;1418,1184,1294,1269,1285,1404,688,186,571,1504,1372,248,1627,1179,977;19;F
49024;688,251,977,1179,1504,571,248,1418,384,1367,1036,1372,393,1043,1362;27;F
49031;1627,1418,1361,1522,644,1504,1102,1380,1645,1048,1345,1391,251,1279,1040;27;F
49055;1369,1077,1391,856,1102,1645,1522,251;38;M
49063;1102,715,276,1077,1367,1279,914,977,1345,1522,1285,1182,1350,1372,1269;36;M
49082;1345,1102,1385,1042,1380,855,1392,1048,1052,644,1404,251,1504,571,1367;28;M
49143;186,1285,1345,1391,1102;42;F
49153;1367,1376,1385,1522,1504,1627,1361,856,1102,1380,1645,1304,1048,1040,1395;51;F
49222;1179;54;F
49233;1645,1367,1285,1279,1294,1040,977,856,644,634,575,571,393,384,186;37;F
49269;186,1040,977,251,938,1391,1345,575,634,1380,715,1385,1102,856,1372;34;M
49298;1386,1077,1395,1367,1036,393,1522,644,1040;36;F
49313;715,1504;34;M
49318;1392,977,1504,384,856,1102,1385,1350,1294,1645,1345,1391,571,1362,1036;26;F
49421;1269;38;M
49441;1294,1042,1645,1392,1304,1052,1372,1367,384,571,186,914,977,1345,644;86;F
49504;855,1385,1279,1372,1362,715;55;F
49536;1102,856,715,1269,1645,1304,1391,251,977,1279,1040,1504,1627,1367,1372;34;F
49552;1372,1367,384,1395,1504,1386,977,251,644,1345,1392,634,856,1645,1304;44;F
49577;1385,1350,1294,1392,251,977,1179,1627,1372,715,634,1345,644,571,1367;43;F
49579;715,1042,1269,393,856,1361,1102,251,914,1279,1627,384;30;F
49594;1102,856,1645,251;58;F
49630;1102,1269,1345,1391;25;F
49644;575,914,1045,1279,1367,1102,1269,1285,1304,251,938,1040,1504,384,1036;47;F
49657;1304,571,1367,1362,1376;28;F
49666;1350,1380,1645,1304,1391,251,1040,1077,1372,393,1376;42;F
49693;1179;28;F
49695;1504,1285,1077,977,1345,1645,644,1404,1403,1391,186,1418,384,1367,1372;65;F
49710;1102,634,575,1404,1391,251;32;F
49715;1372,1522,1645,1380,715,1043,916,1345,1045,1418,393;34;F
49781;1504,1627,1077,384,1376,1369,1404,1403,1179,1418,1367,1036,1372,393,1043;30;F
49822;1040;22;M
49876;1361,856,855,1040,248,1367;41;F
49877;1048,715,1645,1627,571,1077,1395,1367,1362,1380,1294,1345,644,1392,1391;47;M
49906;1418,977,688;36;F
49945;856,1102,1042,634,855,575,1304,1522,1048,1345,1391,977,1040,1504;46;F
50001;1418,384,186,856,1350,571,1045,1036,1372,916,1043;17;M
50029;1613;40;F
50048;1380,715,1102,856,983,1539,688,276,1345,1404,1391,251,977,1077,248;72;F
50116;715,1046,1102,1361,1042,634,1645,575,1048,1052,644,251,571,1367;33;F
50125;1036,1361,688,977,1392,1294,1403,1285,1404,1269,1539,715,1179,1367,1372;29;M
50131;1048,1391,384,916,1036;30;F
50134;251,1279,1040,1179,1627,571,1077,1045,248,1395,1184,1367,1036,1362,916;48;F
50137;1102,1645,856,384,1367,1345,251;42;F
50140;644;51;M
50172;1380,575,1279,1376;34;M
50179;1504,1285,715;40;F
50204;575,1522,1052,1504,1627,186,1369,393;39;F
50216;1392,1385,1361,856,1102,1042,1380,1645,855,1048,1391,251,1040,571,384;51;F
50227;856,1269,1285,1392,1304,1522,1345,1391,914,1279,1040,1504,571,1077,1418;36;M
50234;715;42;F
50265;715;13;M
50281;688,1345,1404,977,1279,1179,1504,186,1627,571,248,1184,1418,1367,1372;30;F
50286;715;10;M
50303;856,1102,1285,1345,1404,1391,251,571,1077,1184,1367,1372;53;M
50317;1102,1645,575,1345,1391,384,1504,1367;35;M
50331;1645,1345,1077,1367,1102,715;45;M
50352;1613,977,914,393,1102,634,1285,1539,1404,1040,1627,571,248,1184,1367;23;F
50399;1102,1372,384,977,1391,1345,1048,1285,1367,1504,644,1362,856,1645,575;36;M
50400;1285,1345,1391,1279,1269,715;45;M
50408;715,1376;41;F
50409;715,644,1391,1372,1376;68;F
50448;855,1645,634,1385,1627,1395,384,1367,856,1380,1392,1404,1403;33;M
50460;634,1102,856,1522,1345,644,1045,1077,1391,1627,1504,1279,1285,1645,1269;44;M
50488;1362,186,1179,1369,1372,1367,977,1380,1392,1304,1539,688,1345,1404,1403;39;M
50494;715;46;F
50515;1369,393,1362,1102,1285,1392,1539,1522,1077,248,1404,977,1418,1367,1372;48;M
50526;1040,1042,1367,1036,1184,186,1504,251,938,1403,1404,1345,1392,1102,1361;24;F
50530;1403,1404,1391,251,1077;50;M
50538;1361,1077,1294,1182,856,1385,715,1042,1269,1392,1345,914,1279,1627,1367;36;F
50679;1539,1404,1403,644,634,688,384;47;M
50689;1391,1392,1404;49;F
50703;856,1102,1042,575,1285,1391,1386,1279,1504,1627,384;33;M
50815;914,186,1627,1036,1372,1345,1539,1392,575,1380,715,1102,856,1367,1404;48;M
50886;1522,1391,251,1504,1627,1395,384,1380,634,1367,1372,1040,1077,644,1392;45;M
51104;186,248,856,1102,855,1392,1345,1403,1404,977,1279,1040,1504,1367,1372;17;M
51129;1042,575,186,248;58;F
51133;914,1040,571,1077,1418,1036,856,1102,1385,644,1391,634,1645,384,1367;16;F
51144;715;6;F
51165;715;39;M
51178;916,1369,1036,384,1048,1102,1042,688,1052,276,1345,1391,977,1504,248;32;M
51185;977,186,1077,1045,1627,571,248,1372,1046,1385,856,1645,1504,384,1367;49;F
51199;856,1102,575,1304,1522,1048,1391,1040;40;F
51202;1627,634,1380,1182,1102,1077,384,1362,856,715,855,688,276,1345,186;23;M
51257;1361,393,856,1042,1304,1048,251;43;F
51259;856,1102,1182,1645,1392,1522,977,1279,1504,571,1077,1372,186,1418,1367;41;M
51343;1182,1052,1048,1392,1645,1269,1102,1504,1279,644,251,1077,248,1367,1372;34;F
51350;248,384,1102,575,1179,1367,1362,1392,856,715,1539,1345,1404,977,1504;32;M
51396;1182,634,1645,644,1403,1386,1279,571,1077,1045,1395;41;F
51409;1367,186,856,1613,1504,1627,1418,1372;29;F
51429;634,1645,1304,1048,644,1391,251,977,914,1040,1627,1077,1367,1036,1372;35;F
51432;1285,855,856,1361,1102,715,1380,634,1304,938,977,1040,575,251,1504;47;F
51436;1102,1645,1350,1042,634,1052,644,1391,1077,384,1036,1613;22;F
51460;856,1102,1350,1269,1380,634,1522,1345,644,1391,251,1040,1418,1367,393;30;F
51484;1404,1403,938,1369,856,1294,1304,644,1613,251,1040,1372,1376;50;F
51489;571,1627,186,1504,977,1345,1522,1539,856,1385,715,1367,1372;37;F
51490;856,1102,1385,1294,1645,644,977,1040,1504,1627,571,248,384,1367,1372;63;M
51492;715;61;F
51561;1269,634,1285,1404,1613,977,1367,1372,856,1345,644,1391,251,1279,1040;39;F
51578;715;67;M
51587;575,1386,1372,1504,1285,977,957,1184,1376;33;F
51607;1361,1042,634,1052,1345,644,1613,977,1077,384,1036;53;F
51610;715,1285,1392,1345,644,1404,1403,977,1040,1179,186,1077,1418,1367,1372;29;M
51625;1294,855,1391,977,1279,1539,1285,1645,1102,1404,688,276,1627,248,1372;66;F
51635;1380,1627,1367,1040,856,1269,1285,1392,1539,1404,1403,1279,1179,248,1372;31;F
51640;856,251,1040,384;31;M
51664;1380,1645,1052,1345,251,914,1279,1040,1627,1395,1418,384,1367,1372,1376;29;F
51681;1102,1042,1645,1285,1522,977,1279,1077,1418,1367,1372,644,1350,1269,384;40;F
51697;983,688,1184;42;F
51705;1380,644,1391,1504,1367,1372,186;56;F
51735;1279,1269;38;F
51771;715,1269,251,1279,1285;43;F
51772;1102,855,575,1522,688,977,1367,1504,1362,1418,1372;34;M
51795;1285,1269,715;6;F
51803;1362,1391,1048,1645,856,1361,1102,1380,1392,1052,1345,644,1613,251,1504;47;F
51807;1418,384,1369,393,1362,1376,856,1102,1385,1294,1645,575,1392,251,1367;45;F
51810;715,1385,1102,856,1380,575,1285,1304,251,1627,1279,1040,1504,1367,1372;34;M
51832;248,1367,1372,1362,1077,977,1613;21;M
51836;1077,1040,1279,251,644,1522,1392,1285,1645,715;3;F
51842;1048,938,571,1077,916,1361,1294,634,1645,1304,1522,644,1369,393,1043;45;F
51858;856,1392,1391,1040,571,644;65;M
51865;1392,1285,1102,856,1048,1404,1279,1077,1367,1372;39;M
51866;1376,1504,1042,1102,715,1392,1539,644,1345,1403,1404,977,384,1367,1372;22;F
51869;1386,1279,571,1077,1418,1367,1376,634,1048,1391,251,1036,644,1522,1269;32;F
51874;1380,1285,1392,977,1362,1042,1269,1522,644,1391,1077,1395,1367,1372;46;F
51879;1269,1345,644,1391,1040,1279;50;M
51895;1385,634,1645,644,251,977,571,1367,1372,393;38;F
51897;384,1372,856,1385,1285,251,977,1504,1367;31;F
51898;856,1385,1645,1285,1392,1345,1391,977,1279,1040,1627,571,248,1367,1372;36;M
51912;1279,1040,1045,393,1043,1362,1376,1350,1042,1645,1048,1052,1391,251,384;36;F
51923;1269,1182,715,1361,856,1102,1294,1042,1391,251,914,1040,571,393,186;36;F
51925;1294,1645,575,1539,1404,1403,1627,1077,384,1504,1367,1372,856,1285,1391;30;M
51946;715,1380,634,1418,1367,916,983,1522,688,957,644,1391,251,1627,1184;40;F
51959;715,1376;19;M
51997;1052,393,1367,1184,571,1627,914,1048,1385,1102,1042,644,251;41;F
52009;715;39;M
52015;1627,571,1077,248,1184,1367,1036,1362,1376,856,1645,855,1504,1418,1372;24;M
52024;1052,251,1386,1361,1385,1294,634,1645,1376;65;F
52037;1385,634,1392,1048,251,1040,1369,1052,644,1613;40;M
52067;1385,1102,715,1042,1269,1380,1285,1392,644,251,914,1279,1040,1077,1367;37;F
52073;248,186,977,855,715,856,1285,1345,1404,1403,571,1367,1392,1269,1279;39;M
52094;1645,1285,251,384,1372;27;F
52103;715,1042,1385,1102,856,1361,1522,1391,1418,1367,1369,1304,251,1386,1040;33;F
52123;856,1102,1269,1380,634,575,1285,1504,1367,1376,644,251,914,1361,1040;25;F
52132;856,1269,1285,1522,1345,644,1404,1391,1279,1040,1627,571,1077,384,1367;38;M
52138;1294,1645,855,1285,957,644,977,251,1367,384,1043,393,1102,634,1372;32;F
52150;1102;36;F
52178;1392,715,1385,1102,856,1269,1285,1391,1279,1040,1504,186,1627,384,1367;34;M
52217;856,1042,634,575,1345,644,1504,1102,1380,1645,1048,1391,1040,1627,384;60;F
52240;1285,1269,1522,977,1279,186,1077,1418,1367,1372;38;F
52269;1385,856,1645,1285,1392,1539,688,938,977,1504,186,1627,571,248,1372;29;F
52324;1367,1279,1285,855,1269,1102,1504,715,1345,856,634,575,1522,1613,1627;33;M
52325;916,1043,1369,1045,1077,571,251,1048,1645,634,1294,1046,1304,644,1040;45;F
52335;1391,1404,1285,1042,1645,575,1418,384,1367;62;F
52359;715;10;F
52370;1046,1294,634,1645,1304,1048,644,1040,251,571,1077,1045,1369,1043,916;14;F
52372;1102,1645,575,1285,688,977,1504,1372,384,1367;41;F
52384;1046,1294,634,1645,1304,1048,644,251,571,1077,1040,1045,1369,1043,916;10;F
52397;1102,715,1042,1391,1279,1367,856,1269;32;M
52398;856,715,1042,1380,1645,1285,1304,1539,977,914,1040,186,571,1367,1372;60;F
52404;1391,1102,1522,186,1367,856,1385,715,1285,1345,251,1279,1504,1627,384;38;F
52433;938,644,575,1102,856,1361,1269,634,1304,1048,1040,251,1380,393,1369;32;F
52459;1392,1539,1403,1404;29;F
52466;856,1645,1285,1345,1391,977,1279,1504,1418,1367,1372;32;F
52467;856,1294,644,251,1040,571;34;M
52485;1392,1539,688,1345,1404,1403,251,977,1279,1179,1418,1367,1372,1362,186;35;M
52496;1380,1404,1627,248,1376,1102,1392,1304,1391,251,1040,1362;26;M
52500;1345,1391,251,1386,1395,384,1367,1372,916,1042,688,276,977,1627,248;38;F
52508;1036,1385,1102,914,1279,1040,186,384,1367,1369,1376,856,1380,1391,251;40;F
52545;276,1345,644,1391,251,1386,384,1372,916,977,248,688,1645,1042,1102;10;F
52568;1386,384,1372,977,688,276,1345,644,1391,251,1627,1395,248,1367,916;6;M
52570;251,1367,1392,1040,1385,1269,1645,1285,1345,644,1279,1504,1627;39;F
52583;855,1645,634,1042,1361,1102,1380,1392,1345,644,1391,251,1040,571,1367;41;F
52597;1392,1367,856,1385,1294;46;F
52601;1102,715,1042,1645,983,1304,1522,957,1077,248,1184,1418,384,1367,1372;40;F
52609;1613,575,1380,1040;50;F
52614;575,1304,688,1048,1345,1391,977,186,1367,1369,1361,983,957,251,1184;24;F
52697;1403,977,248,393,1362,1042,1361,1345,1391,1077,1392,1404,1627,1367,1372;47;F
52745;715;41;M
52767;1345,914,1395,1418,856,1102,1294,1380,1522,644,1040,1036,393,1362,916;47;M
52799;715,186,1391,914,1367,1362,1380,251,1386,1040,1395,1350,1522,644,916;39;F
52809;1613;71;F
52810;186,856;43;M
52855;715,1376;27;M
52859;1042,1385,856,1380,644,384,1040,914,1391,1345,1102,1269,1285,251,1279;37;F
52865;248,1372,1362,855,856,715,1645,1285,1392,1345,1404,1403,1391,1179,1367;60;M
52889;1179;32;F
52901;1269,1048,644,1391,251,1279,1077,1045,1367;35;M
52906;914,1385,715,251,1372,856,1102,1404,1403,1391,977,186,384,1367,1179;37;M
52944;1294,1645,1052,644,251,856,1102,1345,1391,1613,1077,384,1367,1372,1362;34;M
52981;957,983;37;M
52996;1269,1285,1345,1391,1279,1077,1418,384,1367;38;F
52997;1040,1279,1386,914,977,251,1345,1391,1522,1392,1285,1645,1350,1102,715;41;F
53011;856,1052,251,571,1418,1369,1372,1043,916,1522,1645,1380,1350,1042;40;M
53016;1304,1048,1040,1077,1395,1036,393;33;M
53022;1404,1391,1504,186,1627,571,1367,1372;51;F
53034;1391,1386,186,571,1418,384,1036,393,1376,1362,1372,1045,1077,1539,575;54;M
53061;634,1645,1385,855,1539,688,1345,1391,977,571,1077,384,1367,1372,1362;19;M
53082;715;40;F
53144;634,1285,251,977,1627,1372,1362,856,575,1345,1391,1279,1040,384,1367;29;M
53148;1376,1304,644,1391,251,914,1386,1040,1036,393,1043;37;F
53170;1036,1372,1285,1362,856,1102,1385,1294,634,1645,855,1392,688,1345,1613;38;M
53250;571,384,644,856,1294,1369,1385,1645;48;M
53300;571,384,644,856,1294,1369,1385,1645;40;F
53315;1645,1102,1042,855,688,1052,276,644,977,186,1045,248,1367,1036,393;55;F
53319;1046,715,1385,1102,1361,856,1392,1391,977,1040,1077,1418,1367,1372,1362;54;M
53330;1048,1645,1042,1102,856,1385,715,1269,1380,1285,1522,251,1279,1040,1367;34;F
53338;1350,1385,856,1102,1048,1391,977,1279,1269,1522,644,1077,1418,1367,1372;36;F
53349;1269;42;M
53362;1403,938,1386,1627,1102,1361,1645,575,1304,1404,1504,1367,715,1269,1285;41;M
53426;644,251,1269,715;36;F
53459;1269,1285,1391,251,1418,384,1367,1372;39;M
53475;1102,575,1522,957,1391,1386,1040,1504,1184,1367,1376;66;F
53488;644,1269,715,251;8;M
53498;251,644,1269,715;4;F
53512;1036,1367,384,1184;39;F
53513;186,1367,856,1391,1386,1036,1361,1380,634,1048,251,938,1040,1369,393;27;F
53517;715,856,1350,1042,1380,1304,1391,251,914,1040,1504,1627,1077,1045,1043;7;F
53522;715;37;F
53532;1367,248,1045,571,186,1504,644,1539,634,1350,1522,1036,1077,715,1376;61;F
53539;688;34;M
53544;1102,1345,1077,1367,1269,1645,1279,384;65;F
53547;1042,251,856,1350,715,1304,1391,914,1040,1504,1627,1045,1077,1367,1043;3;F
53548;856,634,1380,1385,1391,251,977,1376,1627,1040,644,1279,1269,1367,1372;29;F
53550;1102,251,1372;45;M
53551;1539,1391,251,1418,384,1367,1372,1362;44;M
53569;1392,1539,1345,1404,1403,977,1279,571,248,1269,1645,644,384,1367,1372;38;F
53580;856,1179,1404,688,1539,1392,1285,855;31;M
53587;393,916,1376,1102,1522,644,251,571,1504,186,384,1362;36;F
53598;1391,1504,1369,1350,1380,1522,1048,938,1040,186,1077,1036,916,1362,1376;22;F
53600;914,938,251,1391,1380,1269,1042,1279,1040,1077,1367,1036,1372,1043,916;40;F
53619;957,983;30;M
53629;856,1380,1391,251,914,1040;30;F
53632;1361,856,1102,1385,1294,634,1645,855,1392;49;F
53653;644;43;M
53674;1182,1304,1522,977,1504,186,1627,1077,1367,1102,1269,644,251,1040,1418;32;F
53686;1391,1040,1077,1418,1372,1504,856,1385,1645,1392,251,186,571,1367,1362;34;M
53721;1391,1504,384,1376,1645,1285,1522,1345,644,1627,1367,1369,1372,393,916;68;F
53726;1386,1040,1376,1077,1395,393,1369,1367,384,1504,1391,644,1345,1285,1645;42;F
53753;977,251,1391,688,1304,1539,575,1645,1102,1367,1345,644,384,1372,1376;56;F
53763;715,1345,248,1367,1372;30;M
53794;715;40;M
53804;715;7;F
53806;916,1362,384,1184;68;F
53812;715;6;F
53817;715;35;M
53835;248;58;M
53836;688,1345,1404,1403,251,977,1279,1179,1504,186,1627,571,248,1367,1372;41;F
53845;1645,1345,644,251,1077,1367;43;M
53851;1645,1269,856,1102,1380,575,983,1048,957,1184,384;39;F
53887;856,1102,715;37;F
53904;1385,1392,1613,1504,1367,1269,1279,1285,1294,1345,1403,1404,1645,248,571;29;M
53918;1418,1372,1362,1404,1403,977,1179;35;F
53929;855,634,1042,715,1385,856,1102,1645,1392,1391,1504,1627,571,1077,1367;29;M
53953;248;52;M
53963;977,276,1504,1040,1395,248,1539,1404,1627,571,1367,1392,1052,644,384;35;F
53969;1102,1042,1645,1304,1040,1504,1627,1045,384;24;F
53970;715,1385,1294,1285,1392,1304,1404,977,1279,1504,571,248,1367,1036,1372;37;M
53975;1372,384,1102,1345,276;34;F
53976;1418,1367,1372;31;M
54029;1391,1385,856,1645,644,571,1627;40;M
54053;1403,1048,276,1539,977,571,1045,1077,1613,1392,1404,1294,1345,1372,1391;26;M
54062;251,1627,1362,384,1077,938,856,1285,1391,1040,248,1367,1345,1279,1269;29;F
54072;1362,1385,1522,1391,1040,1077,1395,1036,856,1102,1380,1345,644,1613,1376;42;F
54092;1361,715,1380,1304,914,1386,1395,1077,186,856,1102,855,575,1040,1376;36;F
54097;715;63;F
54099;1385,1392;63;F
54109;1404,384,1362,856,1102,634,1645,575,1522,644,1391,1040,1504,1418,1613;39;F
54148;571,1627,186,1504,914,977,251,1391,1522,856,1102,1385,1182,1645,575;42;F
54159;1102,1269,1285,251,1504,571,1418,1645,575,1404,977,1040,384,1367,1372;18;F
54165;1350,1380,1048,914,1040,186,571,1367;48;F
54179;1522,1380,1042,1102,856,1350,1046,644,914,1504,1045,1418,1036,1043,916;39;F
54203;1042,715,1102,856,1392,1345,977,1504,571,1418,1367,1372;37;M
54219;571,1040,856,1385,1380,1294;42;M
54231;1392,1102,1269,575,856,1285,1304,1345,251,1279,1040,1627,571,384,1367;42;F
54241;1627,856,575,1077,1385;18;M
54252;276,1392,1285,983,575,855,1645,634,1269,1182,1294,715,1385,1102,856;26;M
54295;384,1294;42;F
54314;1042,1285,1304,1045,384,1376,856,1392,1279;48;M
54358;1522,1392,575,1380,634,1182,1361,1102,1269,1391,251,914,1040;26;F
54361;1102,575,1040,1504;39;F
54364;1385,1042,575,1048;19;F
54409;977,1345,1285,855,1269,715,1102,1362,856,1391,1040,1367,1372;43;M
54428;1040,1627,384,856,1042,1522,1345,644,1391,1504,1045,1418,1367,1036,1372;42;F
54447;1285,1345,1404,1403,977,1279,1504,186,1627,571,248,1418,384,1367,1269;31;M
54457;1345,1522,1392,1285,1350,856,1372,1367,1418,1077,1279,977,251,1304,1269;34;M
54465;575,1345,1404,1403,1391,1627,384,1367,1372,1376;28;F
54467;1361,1102,1645,1380,1285,1304,644,251,1386,938,1040,1504,1627,384,1036;31;F
54494;1385,1042,575,1522,1345,977,1504,1627,1367,1102,1391,186,1077,384,1372;37;F
54503;1391,1040,1627,1045,1418,384,1036,1042,1392,1522,1613,914,1279,1077,1043;35;F
54505;1179,1504,571,1045,1418,393,1279,1391,1403,1345,1522,1046,1042,1269,938;32;F
54532;186,1627,1418,856,1385,1294,1645,1048,1052,1345,1391,251,571,1077,1367;43;F
54545;715,1385,1102,1294,1285,1392,1345,644,1391,914,1279,571,1077,1418,1367;36;F
54549;1345,688,1304,1392,1285,634,715,1269,1380,1522,251,977,1279,1627,1418;33;F
54558;644,914,186;69;F
54578;856,1102,855,251,977,186,1367,1372,1362;40;M
54585;856,644,1040,1418,1372;37;M
54606;1522,1345,644,1404,1403,186,1418,1645,575,1304,1386,1040,1504,571,1367;32;F
54650;248,856,715,1269,1345,977,1279,1627,571,1285,1376,1367,644,1522,1046;37;F
54677;384,575,1395,1386,634,1102,1645,1048,1052,644,1504,1036;39;F
54704;977,914,186,1077,1395,1367,1269,1522,1279,1045,248,1418,1043,1362,916;36;F
54713;186,1077,1367,1362,856,1102,1645,1345,644,1418,1504,1040,1627,571,384;41;F
54749;644,977,1279,1627,1361,1392,1539,1404,1403,1504,1395,248,384,1372,393;27;M
54750;1504,1627,1376,1304,1392,1380,1269,644,251,1386,1279,1040,1077,1418,1367;41;F
54777;1046,1304,1522,1077,1418,1367,1372;25;F
54781;715,1645,384,856,1522,251,977,1040,186,1627,571,1418,1367,1372;27;F
54782;1042,1380,1392,1522,644,251,938,1040,186,1627,571,1418,1036,393,1043;35;F
54788;571,1418,1385,1046,1269,1645,384,1285,1040,186,1367,1372,644,1279,916;38;F
54796;856,1294,1645,1285,1392,1345,1391,977,1279,571,1418,384,1367,1372,1362;15;M
54809;1403,1645,393,384,1395,1179,1279,1404,644,1539,1392,1285,575,634,1361;52;F
54817;977,186,1418,1367,1285,1385,1522,1362,1504,644,957,1279,1392,1345,251;34;M
54834;1404,1392;57;M
54859;715,1048,644,1391,1040,1077;37;F
54873;1627,1294,1040,186,571,1367,1395,1077,1279,251,1613,1285,1380,1269,1362;41;F
54875;856,1102,1522,251,977,914,1040,186,1627,1418,1367,1372;33;F
54889;715,1048,644,1391,1040,1077;39;M
54890;855,715,1385,856,1042,1269,1645,1392,644,1391,1627,1418,384,1367,1372;34;F
54891;1040,1102,1385,1345,977,1627,571,856,1269,1285,1279,1418,384,1367,1372;56;M
54902;1294,1102,1285,1392,1404,1403,1179,186,248;35;F
54904;715,1048,644,1391,1040,1077;10;F
54908;1404,1345,1285,1645,1294,856,1385,715,1279,1504,571,1077,1418,1367,1372;6;M
54914;715,1048,644,1391,1040,1077;8;F
54921;1522,1279,1040,1367,1369,1043,393,1350,1046,1042,644,1391,914,1418,916;41;F
54998;1372,1369,1102,715,1304,575,1285,1627,1367,1504;26;F
55014;644,634,856,1102,1350,1046,1391,1040,571,1279,1380,1269,1392,1504,1522;37;M
55089;1504,1404,1102,856,938,1279,1367,1391,1645,1361,248,1376,1345,1285,644;35;M
55091;1285;32;M
55139;1627,1504,1279,1269,1042,1294,1102,1645,1403,1404,1077,1184,1367,1362,1376;42;M
55167;1380,1376,916,1372,1036,1367,1418,1040,977,1345,1042,1102,1522;54;F
55175;856,1102,1385,1042,1380,634,1285,1048,1361,1645,1304,644,1504,384,1367;24;F
55180;1391,1372,1285,1539,977,1279,248;39;M
55184;1404,1345,688,1304,1380,1102,1522,276,1391,251,977,1386,1627,1367,1372;45;M
55210;715,1361,856,1042,1380,575,1048,1052,1404,1403,1386,1040,1179,1395,384;41;M
55225;1522,914,1045,1418,1367,1404,1392,1645,715,1385,634,1285,1345,1391,1279;38;F
55249;1522,1345,1391,1045,1418,1367;39;F
55289;715;40;F
55321;715;10;M
55331;715;52;M
55373;856,1102,634,1285,1048,1345,1391,251,1504,1627,571,1077,384,1367,1036;45;F
55449;1367;30;F
55464;1102,1385,634,1645,644,1391,251,1279,1367,856,715,1269,1345,1504,1392;31;F
55501;715,575,1392,1345,644,1404,1391,977,1279,1504,186,1627,571,384,1367;44;M
55504;1102,575,1504,1418,384;32;M
55518;715;37;F
55561;1403,1613,977,1279,1179,1504,186,1627,571,1372,856,1385,1285,248,1367;40;M
55579;1102,1182,1645,1345,1504;33;F
55638;1613;80;F
55685;1285,1294,715,1392,1048,1391,977,983,1345,644,1404,1403,1504;61;F
55762;1376,1102,575,1285,1504,384;27;F
55797;1040,1385,634,1645,855,575,1345,1391,251,977,1504,186,1627,384,1367;32;F
55822;1345,1285,575,1102,856,186,1367,1372;47;F
55842;1102,1645,575,983,688,276,384;38;F
55920;983,914,1045,1376,1385,1269,1645,1345,1391,1613,1504,1418,1362,977,1367;44;M
55928;1522,276,1345,1404,1391,1077,1418;33;F
55958;251,1392,186,1372,1385,715,1645,1345,1391,1504,1627,384,855;58;F
55967;1404,1279,1522,983,1539,1052,1182,186,1184,1418,1372,1077,1392,1345,1613;39;F
55985;1385,856,1345,1391,1279,1627,1367,1522,1285,1392,1645,384;41;F
56026;1043,916,977,938,251,1304,634,1042,856,1522,1048,644,1418,1367,1372;36;F
56048;977,688;46;F
56060;1102,856,1392,1522,1345,644,1391,1613,1279,1504,1627,1077,1418,1372,1362;10;F
56072;1645,1285,1403,1279,571,248,1184,1367,1372;45;F
56088;1645,1539,1372,715,1627,1392,688,1504,1184,957,983;35;M
56095;715,1042,1269,575,1285,977,186,251;39;F
56126;1392,384,1403,1627,1372,1385,1294,1269,977,1504,186,571,1077,1367,1345;41;F
56138;1048,1052,1042,1269,1279,1504,1627,715,1385,1294,1645,1285,186,384,1367;54;F
56140;1102,1345,1391,251,1040,1627,571,1077,1372,393,1362,856,1294,914,1418;36;F
56169;856,1392,1627,571,1418,1367,1372;54;F
56189;1045,938,1077,634,644,571,1043,1042,1052;22;M
56203;1395,1367,384,856,1391,251;34;M
56221;688,1404,1391,1040,1627,384,1285,1345,977,1279,1504,186,571,1184,248;25;M
56225;1522,1304,1392,575,1380,1269,1042,715,1102,1285,1613,977,384,1367,1372;32;F
56241;1042,1279,1504,1627,571,1077,1045,248,1184,1418,384,1367,1036,1369,1372;18;M
56270;1380,634,1645,983,1304,1627,571,1367,1184,1391,957,856,1361;66;F
56284;644,1613;53;F
56303;856,1042,1645,1304,1391,251,1040,571,1077,1418,384,1367,1372,1043,1182;40;F
56353;1361,1042,1504,938,1345,1522,1645,1269,1385,856,715,1285,977,1367,1372;48;F
56358;1077,1403,1345,1285,1102,1392,1391,977,571,1418,1367,1372;43;F
56388;1184,571,276,1294,1645,1539,688,1404,1403,977,186,248,384,1367,1372;29;M
56412;644,1269,1279,1613,1285,1522,1392,1504;32;F
56441;1361,1042,1645,1392,384,1385,1052,1345,644,1404,1391,251,1504,571,1043;36;M
56445;1391,983,1385,856,1042,1380,1645,575,251,384;54;F
56452;1627,251,1391,644,1345,688,634,1645,1392,957,1404,1403,384;25;F
56489;715,1504,1367;41;M
56492;1645,1345,644,1404,251,977,1040,186,1627,571,1077,248,384,1367,1372;57;M
56500;1380,856,251,1269,1522,1613,1279,1504;32;M
56506;1304,634,1048,856,1102,1269,1380,1645,1285,1391,251,1040,1395,1367,1376;52;F
56513;1285,1367,1361,1269,1372,856,983,1385,1345,1279,1040,1380,1504,1392,1613;35;F
56536;1102,1391,251,1077,1367,1036,1376;47;F
56555;715,1042,644,1367;45;F
56556;1392,977,251,575,855,1102,856,715,1042,1285,1522,1345,1404,1627,1367;75;M
56562;1380,634,1645,1048,644,1279,384,856,1385,1504,186,1627,1362,571,1367;47;F
56570;1042,1304,251,1040,384,1367,1369,1372,1043,916;46;F
56574;1392,1539,1522,1048,644,1404,1403,1179,1077,384,1367,1036,1372,1043,1376;44;F
56580;715,644;10;F
56587;1304,1403,1385,1102,688,1404,977,1367,1376,1345,251,1040,1184,983,957;39;F
56598;1304,575,1269,1294,1385,1361,856,715,1645,1285,1403,251,1279,571,1367;43;F
56600;715,644;17;F
56604;856,1294,1285,1539,688,1345,1404,977,186,1627,571,248,384,1367,1372;50;M
56610;715;47;M
56613;1102,1361,1392,1304,1391,251,938,1040,186,571,1367,1036,1369,393,1043;43;F
56628;1392,1539,1404,1403,977,1179,1504,1627,186,1045,248,1418,1367,1372,1362;45;F
56642;575,1345,1404,1403,977,1279,1040,1504,571,248,1418,1367,856;33;M
56672;1385,1380,634,1645,1522,1052,1345,644,251,1040,571,1077,1395,1367,1372;35;F
56700;1504,384;27;M
56713;1372,1043,916,1522,1345,1391,977,1279,1627,1077,1367,1362,856,1102,1285;41;M
56724;1367,1372,1362,1376,856,1385,1294,1269,1285,1304,1403,251,914,1279,1040;48;M
56738;1361,856,1042,1392,977,384,1367,1372,1385,1294,634,1345,644,571,393;45;F
56744;186,938,856,1385,634,1345,644,571,1367,393;44;F
56745;1391,1077,1367,1418,715,1376;41;F
56750;1380,1182,1367,1369,1361,856,575,1391,571,1077,1418,1362,384,393,1395;60;M
56755;1645,1285,1522,1345,1404,1403,1279,1040,1627,1077,1418,393,856,1102,1367;48;M
56758;1102,856,1361,1380,575,1392,1304,251,938,1040,1504;33;F
56781;1391,634,1048,1182,571,1392,1345,1052,1627,644,856,1645,1504,1367,1385;28;M
56807;1179;21;F
56825;1403,1613,977,1279,1385,1269,715,1182,1404,1386,1627,1392,688,1361,1345;25;M
56831;1102,1361,856,715,1042,1269,1392,1345,1404,977,1040,1418,1367,1372,393;23;M
56842;1285,1367,856,1385,1294,1645,1392,1522,1345,1391,1613,1279,571,1372,384;30;M
56876;1345,251,186,1367,1372,393,1376,575,1304,688,276,1404,644,977,248;52;F
56882;1304,1504;63;F
56953;1645,1522,1048,1345,186,1418,384,1362,1392,856,1367,1372,1391,1613,1504;13;F
56961;1102,1269,575,1392,1522,644,1403,1279,1367,1372,1362;40;M
56993;1522,1279,1372,1345,1367,856,1385,1294,1645,1285,1392,1391,1613,571,384;57;M
57029;1504,1077,1418,1372,983,688,977,856,1645,1392,276,1404,1627,248,1367;57;M
57055;575,1645,1042,1102,1391,977,1040,1504,1627,571,1077,1418,384,1367,1372;27;M
57117;1380,1040,1367,1372,1362,856,1102,1269,1522,1345,1391,251,1279,1077,1418;35;M
57123;856,1269,1380,1285,1304,1522,1048,1345,644,1391,1279,1040,1627,1077,1418;34;F
57126;1645,1613,914,1367;49;M
57137;1279,1040,186,1627,571,248,1418,1184,1367,1372,856,1645,1304,938,384;47;F
57174;1380,634,644,1036,856,1391,1077,1418;36;F
57190;1418,1386,251,1361,1385,1645,1304,1285,1048,644,1391,1040,571,384,1367;61;F
57193;1279,1385,1294,1645,1285,1539,1403,977,1179,1504,186,1627,248,384,1367;47;F
57198;1391,1345,1304,1285,634,1380,1102,1392,977,914,1367,1372;46;M
57216;1042,1380,1279;25;M
57220;1522,856,1385,1294,1645,1285,1392,1345,1391,1613,1279,571,384,1367,1372;53;F
57230;1279,1040,384,1102,1645,1285,1392,1613;43;F
57258;856,1385,1294,1645,1285,1392,1522,1345,1391,1613,1279,571,384,1367,1372;32;F
57279;186,571,248,1184,575,1392,1539,688,1345,1404,1403,977,384,1367,1372;27;F
57287;1392,1418,1036,1043,1102,856,715,1294,1042,1645,1279,1627,571,1367,1372;30;M
57338;1040,1391;32;M
57348;1392,914,1279,186,1627,1077,248,1372,977,688,1539,276,1403,1404,1613;29;M
57349;855,1539,688,1048,276,1345,644,1404,1391,1627,1369,1372,393,977,248;33;F
57350;634,1052,856,1404,384,977,1539,1392,248,1372;34;F
57367;1392,1040;33;M
57435;1392,1345,1404,1391,251,1367;52;M
57447;1418,1539,688,1345,977,1504,571,1372,1367,1285,1102,634,1404,1403,1179;20;M
57457;914,1627,1367,1369,1043,1376,1285,1042,1102,1361,856,1380,251,938,1040;32;F
57464;1048,575,1645,1046,856,1102,1350,1042,1522,1391,914,1045,1418,384,1372;31;F
57505;384;74;M
57542;1304,251,1036;48;M
57561;644,977,914,1504,1627,384,1367,1372,393,1418,1392,1102,856,1613,251;42;F
57580;1404,1403,571,384,1367,856,715,1645,1345,1102,1048,644,1391,1279,1077;40;M
57589;1052,1048,1361,251,1345,1504,1036,575,856,1040,1102,384,1367,1392,1645;30;F
57601;1372,856,1102,1403,1404,1392,1367,1077,251,1269;28;F
57606;1645;61;M
57611;644,1048,1304,1042,1102,1285,977,1367,1376,1043,1361,1380,1345,1391,1040;33;F
57638;634,1304,856,1102,1645,1285,644,251,1279,1040,1367,1036,393,1372;40;F
57641;1403,1404,1345,1048,688,1522,1539,1380,715,1372,1367;28;F
57654;1522,1539,1269,1042,1102,1361,1645,634,575,644,1403,1404,1504,384,1372;35;F
57661;1184,1418,855,1504,715,1345,1385,1285,1404,1403,977,384,1367,1372,1376;35;F
57670;1385,715,1645,1522,1345,977,1504,1372,1269,1285,1391,914,1279,1418,1367;27;M
57678;1403,1391,251,977,1279,1504,186,1627,571,248,1184,384,1367,1372,1404;27;F
57687;1294,688,1404,1403,977,1367,1372;32;M
57707;575,688,1052,977,1179,384,1372;32;F
57715;856,1042,1182,1645,1304,1345,251,1040,571,1077,1418,1367,384,1372,1043;36;M
57763;1285,1392,634,1380,1269,1042,1350,1385,856,1539,644,1404,1179,1367,1372;48;F
57769;916,1362,1043,1418,1077,1040,977,938,251,1304,1042,856,1350,634,644;36;M
57796;1504,1418,384,1036,1372,715,856,1102,1042,1392,688,1404,1403,977,1179;30;M
57798;1361,1645,1279,1504,1627,1045,248,1385,715,1269,1345,644,1404,1403;39;F
57853;1392,1522,1627;37;F
57866;1418,1613,1392,1042,1052,644,251;43;F
57881;1539,1345,977,1279,571,1367,1036,1372,1645,644,1404,1403,1391,1627,1269;38;F
57926;248,1395,914,384,1367,1036,856,634,1285,1304,1279,1380,1345,1391,644;54;F
57951;1385,1102,1036,1392,856,715,1380,1645,1304,1345,977,1040,1504,571,1367;37;F
57968;1045,1504,1040,1522,1392,575,1645,644,1386,186,856,1042,1048,384,1367;33;F
57996;715,1042,983,1392,688,1345,1404,251,1179,1077,248,1418,384,1367,1372;30;M
58006;1504,186,571,1418,715,1645,1285,644,1613,856,1279,1627,1367,1372;32;M
58046;571,1627,186,1040,1279,1345,957,1052,1304,1285,1645,634,715,856,1048;33;M
58047;1645,1380,1042,715,1102,1361,644,1404,1391,938,1395,384,1367,1372,1362;46;F
58082;634,1645,983,1304,644,1404,1179,1395;43;F
58109;1102,1645,575,1345,1391,251,977,1279,1040,1504,384,1367,1372;27;M
58120;1627,571,1418,1367,1372,916,856,634,1048,644,1077,1304,1285,1504,715;39;M
58144;1645,1345,1404,1403,977,1077,1367,1362;42;M
58155;715,1539,688,1345,1404,1403,1279,1179,1504,186,571,248,1184,1367,1372;30;M
58211;644,957,688,1539,1392,1285,983,855,1645,1042,1294,715,1102,856,634;43;F
58253;634,1102,856,644,1391,251,977,1279,1040,186,1627,248,1418,1367,1372;33;F
58269;634,1269,1385,856,1361,715,1380,1304,251,977,1040,1504,1367,1036,1372;31;F
58274;1042,644,251,1376,1345,1404,1391;38;M
58288;1046,1350,914,1418,1045,1036,1043,916;41;F
58311;977,251,1391,1392,1285,1182,1385,856,914,1279,571,1372;27;M
58314;938,1386,1504,186,1395,393,1361,1350,1042,1304,1403,251,1040;27;F
58340;856,1102,1385,715,1645,1285,1345,1391,977,1279,1040,1504,1627,1367,1372;29;M
58352;1392,1048,1404,1391,1179;36;M
58357;644;71;F
58365;1369,1040,1386,1391,644,1048,1304,1380,1182,1042,1361,856,1385,1645,251;27;F
58368;715,1392,1627,856,855,1522,1345,251,977,186,571,1418,1367,1372;36;M
58420;1369,393,1385,1285,977,914,1279,1040,1367,1372,1042,1380,1392,644,1613;31;F
58490;1269,1042,1046,1350,1385,1102,1380,634,575,1285,1345,1391,856,715,1504;40;F
58500;856,715,1380,1285,644,914,1279,1418;49;F
58508;1385,715,1380,1392,1345,644,1391,1376,186,1627,571,1395,1367;76;F
58513;634,644,1613;32;M
58583;856,1361,1385,1269,1645,575,1285,644,251,977,1279,1040,1504,1627,1367;40;F
58584;1385,856,1102,715,1269,1380,1645,575,1285,1345,1279,1040,1504,1367,384;24;M
58607;1367,1362,1372,856,1380,634,575,1392,1345,977,1040,1279,251,1102,644;44;F
58631;715,1269,1645,1285,1345,977,1279,384,1367,1372;32;F
58656;1269,1385,1372,1367,248,571,977,1403,1404,688,1539,1294;28;M
58666;856,1385,715,1380,634,1645,855,1522,1345,644,1391,977,186,1367,1372;42;M
58692;1645,855,1392,1522,688,1345,1404,1403,1391,977,1504,186,1627,1367,1372;41;F
58694;1345,977,1504,1627,1418,1372,1367,571,688,575,855,1385,715,856,186;12;F
58696;1392,1048,688,1345,1627,186,1504,977,1522,855,1645,634,715,1418,1367;15;F
58756;1522,1285,634,1380,1102,1391,1040,1395,1418,384,1367,1036,1372,1362;30;M
58785;1102,1350,715,1522,688,1391,251,1040,1627,571,1077,1418,1367,1372,1362;30;M
58823;1102,276,1345,1504,1367;18;M
58887;251,1391,1345,1522,1392,1285,1645,1380,1042,715,1102,1269,914,1040,1279;42;F
58909;1040,1077,1367,1372,1043,916,1380,1627,1269,1362,251;35;M
58911;1369,186,1040,644,1522,1285,1380,1102,1304,1345,1391,1613,914;45;F
58953;1102,1042,1645,575,1040,1504,571,1627,384,977;24;F
58959;1504,856,1102,1269,1522,644,1391,251,1279,1040,1627,571,1077,1367,1376;43;M
58995;251,1386,1627,1504,1367,1036;39;M
59000;384,914,644,634,1380,1269,1102,856,1285,1304,1345,1391,1279,1376,251;54;F
59005;248;66;M
59050;575,1362,856,1361,1385,1392,1345,1391,251,1504,1367,1036,1376;37;M
59060;1269,1294,1102,1385,1392,1539,688,1345,1404,977,1179,186,571,1077,248;42;M
59063;276;41;M
59090;1279,1391,1269;40;M
59092;1522,1279,1077,1294,1613;38;F
59112;1385,1102,1042,575,1048,1052;24;F
59117;1380,1391,1040,393,1361,1048;31;F
59124;715,1048,977,1040,1627,384;28;F
59165;1102,1369,856,1645,1345,1391,1627,1077,1036,251,1392,938,1040,571,1367;41;F
59175;715,1380,1522,1391,1613,1279,1077;37;M
59236;1627,1040,251,1380,1504,384;27;F
59275;384;46;F
59291;1294,1645,1522,1345,1391,977,914,571,1418,384,1367,1369,1372,1362,1376;42;F
59302;856,1380,1645,1285,644,1279,1040,1627,571,1367,1372;43;F
59317;1367,1362,1285,1304,1539,1404,1040,1504,1627,384,1269,1345,1391,251,1279;38;F
59329;1361,1077,1380,634,1645,1522,1392,1304,644,1613,938,251,1504,1627,1043;52;F
59343;1294,1385,1102,856,715,1380,1645,1285,644,1279,1040,1627,571,1367,1372;13;M
59350;571;63;F
59351;1182,634,1392,644,1391;46;M
59368;856,1042,1380,1645,575,1285,644,914,1279,1040,1504,1627,571,1367,1372;20;F
59446;1102,1380,575,1391,186;60;F
59502;1345,1391;26;M
59526;1042,1522,1404,1391,1627,1077,1418,1102,715,1345,644,1403,1179;40;F
59535;571,1418,1372,1392,977,186,1077,1367,1036,1102,856,1350,1645,1304,1522;66;M
59544;1645,1367,856,1102,1392,1345,1613,977,1279,1372,1522,1048,571,1418,1043;32;M
59572;1345,1045,1367,1036,1350,1645,1392,688,384,1372;40;F
59585;1627,715,575;24;F
59617;384,1404,1102,1645,1048,1504,1036;50;F
59618;1345,855,1404,1385,1367,1539,248,1403,1392,644,1077,977,688,276;44;M
59648;715,1403,1362,1077,1040,644,1522,1042;45;M
59703;1102,1042,1269,575,1285,977,914,1386,1279,1040,1504,1367,1372,1043,1376;28;F
59730;1403,1504,186,571,1418,1372,856,1042,1645,855,1392,1404,248,384,1367;37;M
59772;1042,634,688,644,1391,977,384;24;F
59805;1102,1345,1403,1391,1404;28;M
59836;1613;54;M
59851;1285,1102,1304,1403,1040,1504,1385,1392,1179,1539,1404,1613,1372,384,1418;31;F
59867;856,1385,1269,1285,1367;26;F
59915;1102,575,983,688,1404,1391,977,1504,1077,248,1418,384,1367;48;M
59932;251,1077,1367,1372,1279,1285,715;44;F
59940;1042,1269,1380,1345,1391,1279,1040,186,1077,1418,1367;36;F
59949;1102,1380,1345,1391,251,1040,384,1362,1372,1367,571,1392,575,1645,1504;27;M
59965;1376,1102,855,1386,186,384,1367,856,1645,1285,1048,644,251,571,1372;46;M
59967;248,1418,1367,1372,1304,1522,1404,1040,1627;16;M
60005;1279,571,1367,1376,1613,1040,977,251,644,634,1102,856,1042,1372,1504;47;F
60014;1367,1279,1645,634,1380,1294,1385,1102,856,715,1345,644,1391,1040,1077;14;M
60058;1304,1048,644,251,914,1040,571,1077,1418,1367,1376,856,634,938,1627;33;F
60066;715;58;F
60170;1504,186,1627,571,1184,977,983,1539,688,276,1404,248,1418,1367,1372;33;F
60194;1043,1418,1395,251,1391,1380,1042,1522,1077;39;F
60211;1380,1042,1385,1361,1102,634,1369,1372,1304,1539,688,1345,1404,251;19;F
60212;1102,575,1391,1504,1627,1376;66;M
60257;1345,644,977,1040,186,1627,1369,856,1269,1391,251,1522,1418,1367,1372;37;F
60280;1102,1385,856,1269,1645,1345,1404,1403,1391,977,1279,1504,571,1367,1372;33;M
60287;251,1391,1403,1345,1645,1380,1385,856,1392,1404,186,1045,384,1367,1362;29;M
60315;914,1627,1077,1395,1045,856,575,1345,1391,251,1040,1504,384,1367,1362;41;M
60321;251,977,1279,1367,1369,1376,856,1304,1391,1386,1040,1269,1380,914,384;34;F
60361;634,1380,1102,644,977,1040,1504,1395;14;M
60383;1048,1042,251,1504,634,1361,571,1385,715,977,186,384,688,644,1036;24;M
60389;715,1285,1418;59;M
60396;248,186,1627,1418,1372,1350,1042,1645,914,1504,1367,1036,856,1380,1304;55;F
60440;1367,957,983;40;M
60506;1052,1102,1269,1048;44;F
60605;1392,1040,186,1367,1036,393;43;F
60635;856,1102,1046,1294,1042,1392,1522,1052,1048,1613,251,977,1279,1504,571;32;F
60656;1645,856,571,1627,1504,977,1391,1522,575,1102,1077,1418;46;F
60661;1372,1077,1279,251,1613,1345,1052,1522,1350,1046,914,1045,1036,916,1043;41;F
60665;1294,916,393,384,571,1040,1404,1345,575,1645,856,1385;41;M
60726;1345,856,1102,1385,1042,1294,1182,1645,1392,644,571,384,1367,1362,1040;44;F
60748;856,1385,1294,1042,1645,1539,688,1345,1404,977,1279,186,571,1367,1372;24;M
60785;1345,1522,1385,856,1391,251,1279,1040,1504,1627,571,1418,384,1367,1372;26;F
60853;1269,1522,644,1613,251,1279,1077,1367,1372;65;F
60909;856,575,957,1345,1404,1403,251,977,1040,1504,1627,1077,1367,1184,1372;42;F
60917;1048,1380,1304,1345,1391,251,938,977,914,1386,1040,1036,1369,1372,393;42;F
60926;1285,1345,977,1367;71;M
60929;1102,1392,1391,977,1040,1504,1367;48;F
60935;1345,1522,1285,1102,1645,575,983,688,1279,1504,1627,384,1367,1372;46;F
60954;644;27;M
60973;1367,1391,1269,1285,251,977,1627,1372;28;M
61035;1367,1372,856,1102,1385,1294,1403,1404,1269,1285,1279;44;M
61039;977,251,1279,1040,1504,186,571,1077,1184,248,384,1367,1036,1372,1376;29;M
61043;1418,1385,977,1040,1504,1367,1372,393,1102,856,1392,1522,1613,916,1362;43;F
61047;856,715,1345,186,1627,1367,1372,1102,575,1391,1613,977,1040,1504,384;47;M
61053;575;42;F
61075;1627,186,1504,1279,914,251,1403,1404,688,1522,1392,1285,575,1645,1269;27;M
61084;1385,715,1645,1285,1392,251,977,1279,1040,1504,186,1627,571,248,1367;41;F
61100;1182,1279,1376,856,1385,1294,1645,1392,977,1372,571;38;M
61133;1102,1627,1077,1395,1042,1645,575,1048,1052,1391,1045,384,1367,1372,1043;30;F
61134;1345,1391,977,1179,1418,248,1627,1504,856,1102,1380,575,384,1367,1372;39;F
61173;1042,1392,1285,1345,1404,251,1279,1040,1179,1504,571,248,384,1372,1043;30;F
61230;575,251,1279;34;M
61239;1392,715,1385,1294,1269,1645,1285,1403,1404,1279,1504,186,571,384,1367;35;F
61241;1077,1418,384,1367,1372,916,1504,1627,1395,1391,575,1645,1102,1380,644;81;F
61242;855,983,957,1391,1184;50;F
61263;856,1392,1522,1345,977,1504,571,1418,1372,1367;36;F
61272;1362,1102,856,1269,575,977,914,1504,1627,571,248,1418,384,1367,1372;25;M
61274;1045,644,1269,1376;39;M
61287;1385,856,1102,715,1645,1522,1345,644,977,571,1395,1418,1367,1036,916;70;F
61293;977,1404,688,1294,1645,1285,1539,856,1385,715,1345,1391,571,1367,1372;23;M
61301;938,1361,1102,1269,1645,1391,1369,393,856,644,251,1040,1077,1036,1043;28;F
61323;715,1345,644,977,914,1367,856,1269,575,1304,1391,251,1040,1395,384;28;F
61324;1043,1102,1504,1042,977,1367,1539,1645,1392,688,1279,1372,384,644,1040;21;F
61377;1361,856,1042,1048,644,251,186,1627,571,384,1367,1036,1369,393;28;F
61388;715,1380,1285,1522,1345,1077,1504,977,1391,1269,251,1040,1367;28;F
61407;1345,1645,1361,856,1102,1042,1285,1048,1391,1613,1279,384,1367,1372,1043;39;F
61412;715,1391,1052,1350,384,914,1522,1361,1345,1418,1367,1036,1369,1372,916;38;F
61438;571,1279,1391,1285,715,1042,186,1362,856,575,1304,1040,1418,384,1367;43;F
61445;248,1036,1043,1361,1102,1042,1380,634,1285,1304,1404,251,938,1040,1372;25;F
61450;1102,1385,1645,1285,1304,644,1386,1040,186,571,1077,1418,384,1372,1376;32;F
61452;251,938,1386,1504,1627,571,1395,1418,1372,393,916,1376,1102,1645,384;62;F
61475;715,1304,1522,1369,1367,1627,1504,1279,251,1391,1345,1285,1380,1269,1040;30;M
61510;1522,644,1504,1045,393,1036,1385,856,1102,1645,1304,251,1077,1367,1372;50;F
61581;1102,1350,1269,1645,1048,1504,1077,1362,1376,1042,1304,1613,251,1040,384;32;F
61584;1294,571,1367,1362,1522,1403,1613,251,1385,1102,856,1179,1627,1418,1372;32;M
61707;1627,1077,248,1418,1369,1372,1043,1362,856,715,1269,1391,251,1040,1367;44;M
61725;715;41;M
61814;186,1627,1077,1367,1372,1043,1362,1048,1304,1269,1046,856,1522,1040,1418;38;F
61818;856,1385,1269,938,977,1627,1367,1372,1380,1645,575,1392,251,1040,1504;28;M
61822;1040,938,1361,1522,644,1418,1372;40;F
61879;715;10;F
61906;1269,1645,575,983,1392,1404,1403,977,1279,1179,1077,248,384,1367,1372;25;M
61918;1269,1102,856;33;M
61943;1392,1539,1404,1627;32;M
61946;715,1269,1285,1522,644,977,914,1279,1040,1179,1627,1077,1367,1372,1362;40;M
61975;1294,1077,938,688,1285,575,855,1645,1269,1182,1102,856,1361,1392,1345;33;F
62055;1102,634,1645,1372,1391;55;F
62062;251,1645,1294,1102,856,1385,1304,1345,977,1040,186,571,1367,1372,1043;25;M
62090;1102,634,1645,575,644,1391,1504,1627,1077,1395,1418,384,1367,1372,916;83;M
62102;715;6;M
62127;1294,1269,1645,1285,1392,1345,1404,1403,977,1279,571,248,384,1367,1372;30;F
62185;1362,1040,914,715,1645,1304;37;F
62190;715;46;F
62203;1391,1404,251,1077,1362,1285,1102,856,1040,1392,1279,384,1372,1504,1613;41;M
62235;977,1279,186,1627,1045,384,1036,1372,1269,634,1304,251,1386,1040,1376;36;F
62238;1385,916,1380,251,1522,856,1504,1627,1040,1362,914,1043,1392,1279,1269;36;M
62357;1042,1404,251,1386,1040,1504,1367,1369,1372;21;M
62382;1052,1395,1361,1350,1046,1042,1380,1304,1048,1036,1369,393,1043,916,1376;40;F
62411;1392;75;F
62426;1269;43;F
62444;186,1504,977,644,1385,715,1645,1392,1522,1345,1391,571,1367;33;F
62472;1367,1042,1304,1048,1052,1345,644,977,1386,1504,1627,1077,384,1372,393;35;F
62473;1504,1040,1522,1102,1367,1077,1279,914,251,1391,644,1345,1285,1380,1269;36;M
62489;856,1285,1345,1279,384,1102,1385,1269,575,977,1504,1627,571,1372,1367;32;M
62506;1102;44;M
62565;1279,1042,634,1102,1404;30;F
62624;1269,1645,688,1404,1403,977,1179,1372,1367,248,1345,1285,1294,1385,856;26;F
62628;1042,1182,1645,634,575,1304,688,957,1052,644,1504,571,384,1367,1376;41;F
62646;1345,1645,1392,1391,1279;33;M
62653;1385,1392,1345,1391,571,1372;39;F
62674;1040,1042,1380,1392,1522,1279,1369,1376,1043,916;38;M
62714;1361,1350,1042,1376,1102,1645,1052,1345,644,571,1045,1395,384,1369,1372;46;M
62724;1645,977,575,384,1048,248,1077,1042,856,1361,1403,1179,1504,634,644;32;M
62756;914,1386,1627,571,1367,1102,1380,1392,1304,1048,1391,1040,1036,856,384;27;F
62775;1040,977,251,1613,1345,276,634,1102,1392,644,1391,914,1418,384,1367;42;F
62777;1372,1367,1395,571,1627,186,644,1380,1102,856,715,634,688,251,977;38;M
62812;1645,1285,1304,276,644,1403,1391,1279,393,1376,1361,634,1048,1052,1386;44;F
62815;1102,634,1304,1040,1504,186,1627,384,1367,1372;25;F
62835;1367,1372,1179;59;M
62847;856,1294,1304,251,1040,571;13;F
62923;644,1269;48;M
62943;1345,1040,1362,571,1077,1350,856,1392,1613,977,1279,1504,1395,1367,1372;19;M
63035;186,571,1036,1102,1645,575,688,251,977,1040,1504,1627,1367,384,1372;25;F
63040;1102;49;M
63064;186,571,1077,384,393,1043,1362,856,1385,715,1182,1045,1367,1392,644;42;F
63074;1045,1367,1269,1102,1285,1179,1077,1395,248,1372,715,1392,1539,1404,1403;61;M
63131;644,251,1048,1345,1391,914,1040,1077,1418,1036,1372;34;F
63137;1350,1042,1269,1392,1539,688,1048,1052,1345,644,1404,977,248,1367,1372;29;M
63144;1369,1376,856,1102,1345,1279,1504,1367,1372,1269,1380,1285,1304,251,1040;31;F
63164;571,856,1102,1385,1269,1380,1392,1048,644,1627,1395,1418,1367,1036,1372;30;F
63183;1102,575,1522,644,977,1504,186,1627,571,1077,248,1418,1367,1372,1613;36;M
63227;856,1102,251,1040,571;39;F
63234;914,1294,1042,1269,251,977,1504,248,1102,1645,575,644,1418,1367,384;50;F
63253;1102,1391,1627,856,1046,1522,1048,1345,644,1613,251,1040,1395,1418,1043;72;M
63260;1345,977,1504,186,856,1102,1385,1403,1613,251,1179,1627,1418,1367,1372;31;F
63271;715,1102,856,1285,1522,1040,634,1645,575,1048,1504,1627,384,1367,1372;22;F
63313;1179;36;F
63354;644,1391,1504,1522,1392,1304,1040;42;M
63360;1627,856,1345,644,1040,571,384;37;M
63421;1179;65;F
63440;634,1042,1385,856,1102,1380,1345,251,1279,1040,384,1367;31;M
63453;251,1613,1391,1404,644,1345,1052,1048,1522,1304,1392,1042,1385,856,1367;44;F
63480;914,1102,1385,634,1645,1345,644,977,1504,1627,384,1367,1369,1372,1376;47;F
63519;1304,1522,1345,1391,1613,977,1279,1077,1367,1369,1372,1269,251,1040,1418;39;F
63542;715;69;M
63552;1042,855,983,1522,276,1345,977,1627,248,1418,384,1367,1369,1372,393;36;M
63556;1102,1385,715,1042,1285,1345,1504,384,1392,1179,1645,1539,1403,1372,1404;70;F
63608;1392,276,186,1040,1046,1345,644,1269,1279,571,1285;26;F
63638;855,1613,1046,856,1102,1042,1380,1522,644,1391,251;71;F
63656;715;61;F
63682;1539,1404,1403,977,1179,1372;32;M
63846;1294,1269,715,688,977,1279,1627,856,1522,1504,571,1418,1367,1372;31;M
63871;1046,856,1350,1294,1042,1522,644,251,914,1045,1418,1369,393,1043,916;6;M
63905;575,1182,856,1102,1385,1294,1042,634,1645,644,251,571,384,1367,1372;44;F
63926;1385;22;F
63935;856,1350,1294,1042,1522,644,251,914,571,1045,1418,1369,393,1043,916;2;F
63986;1392;30;M
63989;1385,1392,1279,1627,1367;23;M
64038;1102,1042,1269,1304,644,1391,1040;35;M
64040;977,938,1345,1392,1042,1294,1361,1102,575,1048,251,1504,384,1372,393;33;F
64048;1627,186,977,1048,856,1042,1269,634,1522,644,1391,914,1504,1077,1036;40;F
64059;856,1392,1279,1367,575,186,1539,644,1404,1403,1179,1504,384,977,1102;31;F
64079;1645,1279,1077,715,856,1627;41;F
64088;251,186;43;M
64150;1392,983,855,1645,856,1102,1539,977,644,1404,1403,1395,248,1367,1372;60;F
64153;856,1380,1285,1304,1345,1279,1504,186,1367,1372;36;M
64157;644,1392,855,1645,856,1102,983,1539,1404,1403,977,1395,248,1367,1372;55;M
64215;644,1627,855,1285,1392,688,1345,1404,977,1279,186,571,248,1367,1372;37;F
64217;634,1385,856,1102,715,1042,1285,1522,1345,1391,1279,1040,1077,1395,1269;38;F
64220;575;44;M
64226;1048,1304,1350,715,1285,251,1040,186;36;M
64248;1391,1404,1345,1522,1380,1182,856,1385,1392,251,186,571,1418,1036,1372;39;M
64257;1048,715,1102,1361,856,1380,1269,644,251,1040,1504,1627,1367;43;F
64258;856,1102,1645,575,914,1279,1040,1372,1285;28;M
64267;1350,1385,856,1102,1269,1645,1285,1345,251,977,1279,186,1077,1367,1372;35;F
64271;1345,1036,1369,1372,1362,1042,1102,1522,276,1077,393;45;F
64300;1102,1042,1645,1304,1522,1345,1404,1391,977,1040,186,1627,1418,384,1367;64;F
64314;1285,1279,1040,1627,248,1418,1367;38;F
64316;1042,1269,1522,1048,1345,1391,977,1504,186,1077,1418,1367,393,916,1376;44;F
64353;1046,1042,1645,1522,1345,644,1077,1418;36;F
64367;1045,1304,914,1627,571,1077,1372,856,634,1380,1042,1046,644,251,1279;39;M
64391;1345,1418,248,1403,1404,1285,1182,1294,1385,715,1645,977,1279,571;38;F
64461;1179,186,1380,715,1385,856,1376,1361,1046,1042,855,1304,251,1367,1372;35;F
64463;1418,1372,856,1385,715,1380,1279,1040,1504,1627,571,1077,1184,248,1367;38;F
64488;977,1504,1627,384,1367,1372,856,1294,1645,855,1285,251,1040,186,571;34;F
64499;571,1504,1279,977,1613,1048,855,715,1350,1645,1522,1404,1386,1077,1036;47;M
64512;1372,1627,1504,1179,1040,1386,977,1391,1404,1403,1345,1522,1392,855,1042;26;M
64528;977,914,1040,186,1077,1418,1367,1372,1362,1345,1522,1392,856,1391,1613;37;F
64529;1627,571,1279,983,1294,1285,1403,1404,251,1418,1077,1645,856,1269,1362;37;F
64548;248;59;M
64564;1392,1345,1613,1504,186,571,1077,856,1269,1380,1285,251,1279,1627,1418;39;M
64575;248,1184,1367,1372,1376,384,1403,1404,1345,688,1539,1285,1269,1294,644;33;F
64581;1285,634,1182,1102,715,1042,1269,1645,1040,1077,1418,384;8;F
64597;715,1404,914,1504,186,1627,571,1372,856,1391,251,1279,1040,1367,393;29;F
64618;1285,715;9;F
64678;715,1285;6;F
64683;856,1345,1404,251,1386,1040,186,571,1418,1391;44;F
64751;1376,248;75;M
64764;1504,248,384,1372,1385,634,1392,251;38;F
64770;1304,1345,644,251,914,1040,1627,1077,1367,856,1350,1392,1522,916,1376;42;F
64777;1385,1304,644,1391,977,1279,1380,1269,1645,384,1362,1376;33;F
64782;571,1285,1380,1046,715,856,1269,1304,1522,1279,1040,1627,1418,384,1367;36;F
64804;1361,1285,1040,1504,1627,186,715,575,1304,1391,251,977,1367,1369,1372;30;F
64826;977,914,1504,571,1077,1362,715,1522,1418,1345,983,957,1184,1367,1372;41;F
64875;1627,186,1504,1040,251,1391,644,1645,1042,715,1102,856,1380,1613,384;23;F
64879;856,1102,1385,715,1182,1645,1285,1392,1345,1391,251,1040,571,1077,1367;30;F
64882;1362,1367,1504,914,1345,1645,1269,856,1102,1279,1391,1522,1285;42;M
64890;571,1361,1269,1285,1345,644,251,977,914,1279,1040,1367,1369,1372,393;30;F
64926;856,1269,1380,1304,1613,1040,1077;34;M
64947;1645,575,1613,251,914,1386,1279,186,571,1184,1361;33;F
64965;575,1304,1539,1345,1404,1403,977,1179,1504,186,1627,384,1372,1367,1376;32;M
64983;251;29;M
65009;1403,644,688,1539,1345,1385,1294,1392,1404,977,1279,571,248,1367,1372;43;F
65027;1102,1042,634,1645,575,644,977,1040,186,1077,1367,1036,384,1372,1043;28;F
65101;1048,1345,644,1404,1391,977,186,1627,1395,1418,384,1367,1046,1042,1522;39;F
65130;1385,1042,1392,1345,251,186,384,1362,1522;33;M
65139;1182,1042,1285,1392,1539,688,1404,1403,251,1279,1179,571,1184,1372,248;42;M
65146;1042,1645,1345,186,1418,384,1367;42;M
65172;1613,251,1279,1040;33;F
65226;856,1385,1380,1269,575,1522,1391,251,977,1504,186,1627,1418,1367,1372;36;F
65261;1627,1385,1285,1345,1404,1403,977,1040,186,571,248,1184,384,1367,1372;36;M
65266;1392,855,1645,1042,1350,856,1046,1613,644,1279,1040,384,1369,1372,916;33;F
65335;1376,1391,1404,1345,1269,856,1380,983,855,1304,1522,644,1627,1418,1036;55;F
65359;644,856,1269,1285,1362;29;M
65442;1392,1391,1386,1279,1040,384,1367,1036,1369,1376,1102,715;43;F
65444;1184,957,983;37;M
65450;1048,1040,715,1269,1380,1285,1418,1367,1036,1369,1372,393,1043,916,1376;39;F
65463;1102,1042,1269,1522,1052,1077,1418,1372,1043;37;F
65476;1042,1345,1404,1279,1102,575,1392,1391,1504,571,1367,1385,1294,1645,384;26;F
65485;1102,1182,1269,1645,957,977,1040,1279,1045,384,1304,644,1395,1372,1376;36;F
65528;1627,1077,1184,1362,571,1504,575,1102,1269,1285,1392,977,914,1279,1040;30;M
65612;688,1403,1391,977,1279,1040,1077,1372,856,1285,1392,1345,1404,571,1367;32;M
65657;1504,1627,384,1367,1362,1361,1380,634,1048,644,251,938,914,1040,393;41;F
65686;688,1404,977,571,1045,248,1372,186,1385,1627,856,1345,1362,1504,1367;30;M
65745;715,855,1294,1269,856,1385,575,1285,1403,977,1279,1627,571,1372,1367;40;M
65804;1392,1304,1102,856,1042,1380,1645,575,1345,1404,1040,186,571,384,1036;25;M
65904;1385,1042,1269,938,1040,1395,1418,1367,1372;36;F
65941;1102,1645,983,1522,1052,1345,977,1627,571,1367,1392,1285,855,1385,856;42;M
65951;1372,1391,575;37;M
65955;1418,1372,856,644,914,1040;64;F
65965;1269,1345,977,914,1279,1504,571,1372,856,1392,644,251,1613,1627,1367;35;F
65982;983,1372,1362,644,634,571,1036,715,1040,1077,384,1380;74;F
65993;1369,393,1362,1385,856,1046,1294,634,1522,644,251,914,1040,571,1077;35;F
65994;393,248,715,634,916,1036,1042,644,186,1045,1367,1539,1522,1504,1077;41;F
66039;1367,1627,1522,957,1392,1372,856,1376,571,715,1042,276,977,1391,186;32;F
66050;575,186,938,1372,393;46;M
66051;1613,1392,1380;64;F
66057;1040,1418,1372,1376,1385,1042,575,1345,977,1367,1294,1645,384;36;F
66066;1627,1539,644,1645,1077,393,186;44;M
66070;384,248,186,977,1404,1403,1345,276,1522,575,634,1042,1294,1102,1372;41;F
66084;1504,1418,1182,1362,916,1045,1036,715,1040,384,977,251,393;10;M
66088;1040,1279,1391,1403,1404,1539,1645,1380,1385,856,575,251,1627,571,1504;31;F
66095;977,186,1627,1369,1372,856,1102,1285,251,1279,1040,1504,384,1367,1376;37;F
66096;1046,1372,856,1279,1285,916,1043,1077,1102,1380,1391,1395,688,186;45;F
66147;1042,393,1269,1350,1102,856,1645,1392,1052,1391,1279,1040,571,1395,1367;33;F
66148;1380,575,1304,1345,251,1077,856,1102,1645,1048,1391,1504,571,1367;27;F
66157;571;39;M
66160;1367,1627,1504,1418,1372,1369,1362,1036,1077,384;14;F
66177;1627,856,1369,644,634,575,1036,977,1380,1391;55;F
66212;1627,1376,1036;62;F
66232;1645,251,1040,1367,1372;35;M
66235;1404,1367,1392,1361,634,1036,1040,1102,1380,688,186;31;F
66240;977,1279,248,1367,1372;35;M
66251;1294,1385,688,977,571,1418,384,1369,186,1391,644,1345,1285,1269,856;50;M
66252;1404,1367,1369,634,1345,715,1040,276,1102;33;M
66270;1367,1522,1269,856,1369,1376,1345,715,1052,1077,384,977,1102,251,1391;28;F
66291;1367,1627,1269,856,1369,634,571,715,1042,1052,384,977,1102,393,186;38;M
66310;1182,1385,1645,1048,856,1102,1042,1269,1285,1052,1345,644,1279,1045,384;33;F
66328;1294,715,1385,1102,856,1182,1380,1645,1392,1040,1627,571,384,393,1362;25;F
66341;248;21;F
66346;1367,248;30;F
66350;856,1294,1645,1304,1048,251,571,384,1367,1369,1362,1376;52;F
66352;644,1036,1385;48;F
66373;1367,1504,1304,1372,856,1362,1376,977;63;F
66375;1077,1036,1386,1361,1627,1645,983,1345,1372,1367,715,644,1184,634,1102;49;F
66384;1403,1392,1404,1052,276,1345;22;M
66393;1367,1504,1372,856,1345,1645,575,571,1385,384,977,1102,251,186;43;F
66408;1367,1504,1418,1372,1345,1645,575,571,1036,1042,938,1043,384,1391;32;F
66421;1367,1504,983,1418,1304,1372,856,1345,1645,575,571,1042,1040,1385,977;43;F
66422;1040,1418,384,1367,1372,1043,916,1362,856,1385,1294,1645,644,571,1077;46;F
66427;1392;33;M
66441;1613,1504,856,1376,916,1042,1040,1077,1380,393;44;F
66462;186,1385,1269,1645,1285,1391,1279,1367,644;45;F
66463;1627,1392;3;M
66467;1304,856,634,1048,644,1040,571;21;F
66468;1504,571,1045,856,1102,1392,1391,1613;38;M
66475;1380,1042,715,1539,1404,977,1367,1043,1376,1361,856,1102,1391,251,938;29;F
66480;1522,1269,1418,1304,856,1369,1345,1036,715,1048,1040,1102,251,1380,1391;32;F
66499;856,1269,1285,1040;33;M
66512;1522,1269,1418,1304,856,1369,1345,1036,715,1048,1040,1102,1380,1391;33;M
66542;1361,1042,1380,1048,1391,1040,571,384,1367,1372,393;53;F
66546;1367,1418,1372,855,856,1362,1345,916,715,1077,1385,1102,1391,393;51;M
66552;1361,1645,644,1391,1077,1418,384,1369,393;40;F
66573;1367,1522,1504,1269,1539,1294,855,1645,575,1048,384,1102,1391,688,186;45;F
66585;634,1304,644,938,914,1040,186,571,1077,1418,384,1367,1036,1369,1372;19;F
66591;1613,1627,1372,644,1645,1385,1395;71;F
66596;1367,1418,1645,1048,384,1102,1395;70;F
66597;1045,1077,977,1404,1345,1385,856,1269,1285,1279,1504,1367,1372;25;F
66628;1522,1304,1361,856,1369,1376,644,1102,1380,1391,393;69;F
66678;856,1102,1385,1645,1392,644,251,1040,1504,1627,571,248,384,1367,1372;28;M
66689;1403,1367,1372,384,571,1504,1040,1279,977,1404,1345,1048,1285,575,1269;28;F
66724;644,634;46;F
66772;248;59;F
66849;856,1385,575,1285,1539,688,1345,977,1504,571,384,1367,1372,1376,248;69;F
66856;1645,575,1386,1040,1077,1395,384,1362,1045,1350,1046,914,1036,1043,916;63;F
66873;1179,1627,1077,1184,384,1372,393,1376,1350,1294,644,1279,571,248,1367;44;F
66892;1102,1385,634,855,1539,688,644,977,1504,186,1645,1391,248,384,1362;45;F
66901;1350,1046,914,1045,1036,1043,916;53;F
66940;1046,855,983,1048,644,1391,914,1418,393,1042,1522,276,1345,1404,1395;40;F
66955;1392,1345,855,856,1361,983,1304,1048,1404,1391,251,1040,1395,248;34;M
67025;1269,1294,1385,856,1102,1539,688,1345,1404,1391,977,248,1418,1367,1372;37;F
67049;384,1418,1627,983,1361,575,688,1279,1040,1504,248,1367,1372;30;F
67087;186;65;M
67092;1350,1045,1036,1043,916;33;M
67130;1350,916;66;F
67132;1350,957,1386,1395,1376,1042,1285,1052,1404,1403,1613,914,384,1036,393;33;F
67134;938;33;F
67162;1345,1279,977,1372,1367;47;M
67167;1048,1042,1040,1350,1046,914,1045,1036,1043,916;45;F
67174;914,1052,856,575,251,1304,1380,1040,393,1367,1627,644,1184,983,957;26;F
67200;1385,1294,1645,575,1304,644,1391,977,1279,1627,571,384,1367,1372,1376;50;F
67208;1077,1279,977,251,1613,914,1040,1367,1372,1376;45;F
67231;1367,1372,1102,1361,977;27;M
67239;1385,1380,856,571,1294,1645,983,1285,1392,1404,1403,1613,1279,1179,248;30;M
67244;856,715;36;F
67305;1184,1418,1036,1369,983,957,251;30;F
67332;644;31;F
67337;1372,983,688,957,1391,251,977,1184,1367;41;M
67341;1627,1179,1345,1285,1182,715,856,1269,1040,571,1367,1376;33;M
67345;856,1102,1645,575,1392,1391,1613,251,977,1040,1504,384,1367,1372;52;F
67347;575,1627,1385,1645,1392,1613,1040,384,1036,856,1048,1367,634,644,571;43;F
67371;1372,916,1285,1504,715;36;F
67390;1367,1385,715,1102,856,1042,634,1522,1391,251,977,186,1418,1372,393;41;F
67404;1052,1042,634,1539,688,1404,1386,1045,248;38;F
67430;1376,393,1036,1040,1048,1304,856,938;30;F
67441;1361,1269,1285,644,938,914,1386,1040,1627,571,384,1367,1036,1372,393;40;F
67445;1392,1380,855,1345,251;36;M
67460;1391,1077,384,1504,938,1380,1269,1361,1613,251,1279,1040,1036,1369,393;50;F
67492;1345,1522,1539,1392,1285,1645,1042,1102,1385,384,1418,393,1372,688,977;40;F
67493;856,1048,644,251,977,1279,1040,186,1077,1395,248,1367,1036,1372,1102;38;F
67496;1052,1345,1404,1403,977,1045,1372,1376,1102,1504,384,1367,1645,575,276;31;F
67517;856,1102,1269,1380,634,1392,1304,1345,644,1613,977,1040,1077,1395,393;41;F
67539;1102,1627,1372,1367,1645,575,1279,384,856,1392;48;M
67542;1392,1539,1403,571,1367;33;M
67569;715;36;F
67570;688,1539,1304,1285,575,1645,1042,715,1102,856,1361,957,983,1367,1391;29;F
67581;1395,384,1362,856,1102,855,1522,1404,1403,977,1504,571,1418,1367,1372;30;M
67609;575,186,1391,1404,856,1345,1504;37;M
67628;575,1539,1404,1403,977,1179,1367,1372;28;M
67629;1042,1404,1372;43;M
67638;1418,1367,1391,251,186;37;F
67680;571,1627,1504,1179,977,251,1404,688,1539,1392,715,1385,856,1367,1372;47;F
67715;1522,644,1504,1627;69;M
67721;1304,1345,1504,1627,1077,1418,1367,1372;42;F
67733;856,1294,983,1392,1539,688,276,1345,1403,1404,1391,1613,977,1367,248;22;F
67737;1279,1627,393,856,1385,1418,1367,1036,1369,1372,644,1345,1522,1285,1269;41;F
67739;1613,575,1345,1404,1504,715,1627,1367,1372,1285,1052,856,1102,644,1077;16;M
67744;1522,1504,1627;63;F
67759;1392,1182,1391,1504,1376;53;M
67771;977,1045,1362,1345,688,575,1102,855,1522,1048,1391,1504,186,1367,1372;34;F
67795;1269,1294,715,1385,856,1285,1345,1404,1403,1279,1367,1504;42;M
67847;1048,1645,715,1102,1294,634,575,1392,644,251,1279,1504,1627,571,384;60;F
67851;983,957;34;F
67858;1367,1418,1304,856,1613;44;F
67875;248,634,1539,644,1395;49;F
67876;1392,1418,1504,1522,1345,977,1367,1372,1385,856,1269,1380,251,1627,1279;41;M
67885;977,1279,1504,186,1077,571,1376,856,1102,1645,1040,384,1367,1372,393;40;F
67888;1522,1376,856,1345,1304,1380,938,251,1627,1040,1279,1269,1386,1362,644;34;M
67911;276,575,1361,1380,251,644,977,1504,186,1627,1045,248,1367,1369,1372;68;M
67916;1279,186,856,1269,575,1285,251,1040,1504,1627,1418,384,1367,1372,393;34;F
67917;914,1504,1627,571,1372,856,1269,1285,1345,1077,1418,1367,393,1304,251;49;F
67970;1279,938,1404,1539,575,1645,1294,715,1102,1285,1304,1391,251,1179,571;49;F
67998;1279,251,1345,575,1269;40;M
68043;1372,644,1042,1102,1184,1418,1367,1645,1522,688,276,1345,1391,977,248;39;F
68062;644;21;F
68089;634,715,856,1102,1269,1285,1522,1345,1391,977,1279,1504,384,1367,1372;36;F
68138;1392,644,1404,1627,1395,384;44;F
68150;1102,1042,1404,1077,1367,1372;32;F
68158;1361,856,1102,1380,1304,1391,251,977,914,1040,1367,1369,1372;29;F
68177;1392,855,1645,1102,1361,1046,1042,1522,1048,644,1404,1391,1386,1395,248;43;F
68194;644,1391,1040,1504,1372,1362,1369,1367,1385,1395,1627,186,251,1345,1102;31;F
68207;1386,644,914,1077,1350,1046,1380,1048,1036,1369,393,1042,1304,251,938;27;F
68278;1102,384,1395,1627,1404,644,1392;12;M
68284;1395,1182,1391,1040,251,644,1645,1269,1102,856,1077,384,1367,1372,916;42;F
68293;1102,715,983,1392,1539,688,276,1367,1345,1404,1391,977,1504,248,1372;42;M
68294;384,1362,186,1040,1380,1385,1102,856,575,1345,977,1504,1627,1367,1372;29;M
68297;1350,1046,914,1045,1036,1043,916;45;F
68366;856,644,1627,1367;41;F
68374;186,1362,715,1294,1042,1052,1345,276,977,1279,571,1077,1418,1367,1372;38;M
68382;251,1385,856,1269,1285,1345,1391,1040,1627,571,1077,248,1418,1367,1372;31;M
68387;1385,1345,1391,1613,251,1504,1627,1045,977,1392,1645,856,1367,384,1372;35;F
68407;1285,1345,571,1367,1372;37;M
68419;957,983;40;M
68444;1404,1403;25;F
68475;1522,1627,1386,571,1077,1395,856,1391,1613,1369,1392,1279,1040,1504,1418;34;F
68492;644,1418,1385,1645,1392,1539,1345,1404,1403,977,1279,571,248,1367,1372;26;M
68502;634,644,688,977;33;M
68566;1184,1102,856,1404,1403,977,1279,384,1367,1372,1385,1294,575,1504,571;52;F
68567;1367,1036,1369,393,1362,1361,1046,1350,1042,1539,251,1504,186,1418,1372;30;F
68576;1077,571,1386,977,251,1391,1404,1304,1046,1385,1522,1040,1504,384,1372;43;F
68605;1385,856,1380,571,855,1345,1391,977,186,1627,1077,1418,1367,1372,1362;44;M
68619;251;37;F
68644;1269,1285,1522,1391,1279,1040,1627,1077,1367,1372,1362;38;F
68645;1361,856,634,1392,1522,644,251,1386,1040,1627,248,1418,384,1372,393;28;F
68648;977,916,1376,1361,1042,1380,634,1522,688,1386,1418;33;F
68677;1042,1294,715,1350,1385,1361,856,1380,1404,251,1040,384;27;F
68687;1040,1045,1043,1362,1369,916,1361,1046,1042,1645,1304,957,1386,393,1376;32;F
68802;916,1362,186,1040,251,644,1345,1285,634,715;37;M
68810;1350,1046,1269,914,1045,1036,1043,916;37;F
68877;1504,1627,1367,856,1269,1645,575,384;41;F
68878;1269,1350,1046,914,1045,1036,1043,916;7;M
68904;1269,1350,1046,914,1045,1036,1043,916;4;F
68928;715,1102,856,1361,1380,1392,1522,1048,644,1391,1613,251,1279,1077,1376;38;F
68930;1269,1350,1046,914,1045,1036,1043,916;36;M
68935;1391,1367,1372;55;M
68968;1294,856,1385,715,1645,1539,688,1345,1404,977,571,1627,248,1367,1372;39;M
69001;1285,644,1404,1391,251,977,914,1279,1040,1504,186,1627,571,248,1367;34;M
69021;715,1391,1367,1269,1279,1392,1504;37;M
69205;1392,1279,384,575;36;M
69328;1361,1102,1385,856,1380,1645,1392,1304,1391,251,1040,1627,571,248,1367;28;M
69387;1369,251,1345,634,1404,1036,1372,1361,1645,1392,1304,644,248,1367,1376;57;F
69390;1539,1504,1372,248,1392,1404,1403,1179;32;M
69406;715,856,1522,1504,1392,1345,644,1391,251,977,1040,1418,1367,1372,1362;34;F
69423;1285,1522,644,1627,715;3;F
69459;977,1345,1102,856,1380,634,1304,644,1391,1613,1040,1395,1036,1372,1362;29;M
69469;1042,1269,1380,634,1304,644,251,938,1040,1627,1045,1418,1369,1043,393;41;F
69529;1345,1403,1404,1391,1279,1504,186,1627,571,248,1184,1418,1367,1372,977;40;M
69533;1362,1367,1077,571,186,1504,1040,1279,914,856,1102,1522,977,1418,1372;45;M
69574;186,1504,276,1645,856,1102,855,1285,1345,1279,248;43;F
69624;1294,384,1372,1504,1279,977,1391,1403,1404,1285,1385,1645,1392,571,1367;51;M
69639;1404,1403,1418,1372,644,856,1285,1179,914,1345,1269,1279,1504,1627,1376;27;M
69642;186,1504,1279,977,1403,1345,688,1522,1392,1285,856,1294,1404,914,571;18;M
69671;1391,1304,1285,575,1042,715,251,977,1367,1372,1043;48;F
69691;1040,1367,1369,856,1385,1294,1391,251;34;M
69734;1350,1380,1304,914,1040,916;40;M
69736;1045,1395,248,1184,1418,384,1367,1036,1369,1372,393,1043,1362,916,1376;38;F
69764;914,1376,1043,1367,1077,1040,977,251,1391,1345,575,1269,1042,715;51;M
69797;634,1645,644,1367,1372;48;F
69802;1048,276,644,1391,1036,856,938,1077,248,1418;32;F
69803;688,1645,1269,977,1040,1504,186,571,1077,248,1184,1418,1367,1372,1376;24;M
69819;1285,1279,1040,1504,186,1627,384,1367,393,1376,856,1102,1645,251,1372;39;F
69848;1380,1304,1345,644,1391,914,1279,1040,1504,1627,1077,1367,384,1372,1376;56;F
69849;1392,571,1102,856,1645,575,983,1304,1391,1504,384,1367;47;M
69850;1645,1269,1285,1391,1279,1367;43;M
69882;1345,251,1179,1392,644,1403,1404,977,1077,384,1372,1627,1102,248,1362;35;M
69898;575,983;21;M
69911;715,1102,1361,634,644,914,1279,1504,1627,1418,384,1367,1043;43;M
69921;957,688,1042,575,983;22;F
69940;1269;30;M
69952;1404,248;50;F
69957;1385,715,1539,688,977,1279,1179,1504,186,248,1627,1418,1367,1372,1269;35;F
69969;1042,1345,1627,384,393,1102,1380,1522,688,251,977,1418,1367,1036,1372;36;F
70045;1350,1102,715,1042,1285,1304,1048,644,938,1504,571,1077,384,1367,1372;26;F
70057;715,1294,1285,1345,1403,1404,977,914,1279,1504,571,248,1367,1362,1269;37;F
70062;1345,644,251,1386,1418,384,1367,1036,393,1361,1102,688,1404,1391,977;31;F
70101;634,1052,1504,384,1361,1380,1304,1345,644,251,914,938,1040,1367,1036;27;F
70128;1269;28;M
70161;1040,1395,1036,715,1042,1645,1285,1304,1345,1045,1418,384,1367,1362,1376;12;M
70171;1036,384,1367,186,914,644,1380,1361,856,1294,634,1304,938,1040,571;23;F
70185;1279,1045,1418,1376,384,1077,1504,1522,715,1042,1285,1304,1345,1367,1362;38;M
70241;1403,1392,855,634,1294,1102,1285,1345,571,248,1367,1372,688,1404,977;33;M
70263;1102,856,251,1042,1304,644,1404,1386,571,1045,1367,1362;43;F
70264;1391,644,856,1269,1285,1304,1345,977,914,1279,1040,1372,1362,1077,1395;32;M
70292;856,1350,1294,1042,1522,644,251,914,1045,1418,1369,393,1362,1043,916;86;F
70302;1418,1367,1372;42;M
70332;1350,1294,1042,1522,644,251,914,1045,1418,1369,393,1043,1362,916;38;M
70351;1043,1102,856,1042,1645,1345,644,1391,1504,186,1627,248,384,1367,1372;59;F
70381;1380,1304,1077,1350,1182,938,1040,1036,1345,856,1522,1627,393,1418,186;37;F
70386;856,1350,1046,1294,1522,644,251,914,1045,1418,1369,393,1043,1362,916;60;F
70418;1386,1367,856,644;37;M
70421;983,957,1184;30;M
70424;856,1350,1046,1042,1294,1522,644,251,914,1045,1418,393,1043,1362,916;62;M
70445;856,1269,1645,1522,1052,1345,644,1504,1279,1613;45;M
70464;957,983;18;F
70491;1042,1052,1345,1362,1385,1102,856,1391,977,186,1627,1418,1367,1372,1376;50;M
70499;1418,1042,856,1350,1046,1294,644,251,914,1045,1369,393,1043,1362,916;64;M
70538;856,1350,1294,1042,1522,644,251,914,1045,1418,1369,393,1043,1362,916;62;F
70564;1040,1367,856,1385,1182,1418,1372,1361,634,1645,644,251,1045,1395,393;29;F
70569;856,1294,1613,977,1367,1372,983,1392,276,1345,1403,1404,1391,571,248;48;F
70579;856,644,1403,251,977,1504,1627,571,1418,1367,1372,1345,1404,1077,384;33;F
70609;1372,186,1404,1385,1042,1345,1045,1367,1043,856,1102,1350,1522,571,1418;39;M
70620;856,715,1522,571;9;M
70634;1627,1043,1645,1285,1048,1040,384,856,1102,1042,1269,251,1279;38;F
70650;1102,715,634,575,1304,251,914,1040,1504,186,1627,1077,384,393,1362;11;F
70678;1350,1294,1042,1182,1539,644,914,1077,1043,571,977,1403,1048,1376;35;F
70707;186,571,248,1385,688,715,1361,983,1304,957,1345,1504,1184,1367,1372;27;F
70721;1102,983,1285,1391,1403,977,1279,186,571,248,1184,1367,1372,957,1345;28;M
70724;248;64;F
70754;715,1385,856,186,1627,384,1362,1376,1392,1345,1404,1403,938,571,1367;36;F
70761;575,1645,1380,1102,1042,634,1539,644,1404,1403,1391,1504,1372,1362,1376;34;F
70779;644,1386,1376,1345,1391,856,715,1269,1285,977,1279,186,1627,1367,1372;35;F
70792;1385,1102,1269,1645,1285,1392,1048,1345,1404,1391,1279;47;M
70816;1645,1046,1350,715,1077,1367,1043,1285,1269,1395,384,1376,1361,1102,1042;30;F
70817;1045,1367,1372,393,1504,1042,856,1269,1285,1522,644,251,938,1418,1376;34;F
70821;1269,634,1539,688,1345,1404,1403,977,1367,571,1052,1392,1645,1385,1372;29;M
70833;856,1269,1279,1627;40;M
70838;251,1380,1042,856,1645,634,1522,644,1040,571,1077,1395,1184,983,957;37;F
70857;856,1385,1294,1645,1392,1345,1391,1613,1279,571,1045,1418,384,1367,1372;23;F
70864;856,1102,1285,1522,1345,1279,1077,1418,1367;31;M
70885;856,914,1036,1392,644,251,1386,1040,1504,186,1627,1395,384,1367,1372;29;F
70897;1345,1102,1627,1362,1392,1504,1613,251,977,1395,248,384,1367,1372,1043;32;F
70900;1350,1046,1269,914,1045,1036,1043,916;38;F
70923;856,1269,1279,1627;37;F
70925;1404,1403,248;64;M
70987;983,957;29;M
70992;1350,1046,644,914,1077,1045,1036,1369,1043,916;35;F
70995;1385,715,1294,1269,634,1392,1285,1522,1345,644,977,186,1627,1372,1362;;M
71038;1350,1269,1046,914,1045,1036,1043,916;11;M
71054;1285,1269,1345,1391,1279,1045,1418,1367;42;F
71058;1404,1403,938,1386,1279,248;59;F
71073;1350,1046,1269,914,1045,1036,1043,916;13;F
71117;1102,1372,1043,1362,1077,1627,1040,977,251,1345,575,1042,856;28;M
71135;186,571,384,1367;45;F
71141;855,1392,1403,1645,1522,644,1404,938,1386,1179,1627,1418,1043,393;36;F
71146;1036,1102,1361,1046,983,1392,1052,1504,384,644,1043,1376,1042,1048,1404;25;F
71166;856,715,1385,1345,1367,1372;44;M
71172;384,644,1040,1385,1285,914,1279,1269;34;F
71203;856,1392,644,1372,1504,251,1040,1627,1645,384;35;M
71265;977,715,856,1385,1367;40;F
71293;1361,1385,715,1294,1380,634,1645,1285,644,251,1504,1627,571,1367,393;23;F
71296;1279,1392,393,1385,715,1294,1380,1645,1285,644,251,1504,1627,571,1367;60;F
71322;1645,575,1285,1403,977,1504,856,1269,1392,1345,1404,1279,1367;35;M
71325;856,1385,715,977,1367;10;M
71334;1392,186,1367,1040,1294,1385,571,1077,856;40;M
71342;1042,1645,1304,1052,1504,1385,1294,1345,977,1040,571,1045,1367,1372,1376;27;M
71354;1522,688,1645,715,856,1285,1304,1048,1345,644,977,1279,1395,1367,1372;40;F
71356;1372,1362,916,1361,1042,575,1304,1613,1040,384;20;F
71369;715;74;M
71383;1350,1046,644,914,1077,1045,1036,1369,1043,916;8;M
71388;715,1042,1645,1522,977,1367;7;M
71395;1645,384;45;F
71398;1391,1048,634,1046,1102,1042,186,1345,1386,1040,1645;30;F
71402;1350,1046,644,914,1077,1045,1036,1369,1043,916;5;F
71417;1350,1046,644,914,1077,1045,1036,1369,1043,916;1;M
71425;715;72;F
71478;1279,186,1036,1369,856,1102,1269,1380,634,1304,644,1391,251,1040,1372;37;M
71488;1395,1376,1102,1385,1294,1042,1645,1285,1345,1391,1279,1504,384,1367,1372;23;F
71530;1269,1380,251,1279;36;F
71548;856,1040,1418,983,1645,1077,1362,1385,1367,384,251,644,1285,1269,1102;24;M
71566;1372,916,1045,914,977,251,1404,644,1345,1048,1522,1539,634,1042,1046;42;F
71576;186;70;F
71632;1380,1304,1522,644,1391,251,977,1040,1504,186,1077,248,1418,1367,1372;30;F
71711;1345,1045,186,1367,1504,1372;46;F
71712;1380,634,1285,644,251,384;31;F
71726;634,644,186,1045,393,1522;36;F
71786;186,1077,384,1369,393,1361,1645,575,1522,251,1395,1418,1376,634,644;47;F
71787;715;46;M
71845;715;39;F
71886;715;10;M
71896;1269,575,384,393,1376;33;F
71898;1369,1385,1504,1522,1269,1077,1367,571,1645,644,856,1040,1182,1279,1613;42;M
71899;715;8;M
71913;715;42;M
71973;1350,1046,914,1045,1036,1043,916;10;F
71979;983,1345,1404,1403,977,186,248,1184,1367,1372,1418;36;M
72042;856,1182,644,1048,276,1345,1391,384;53;M
72044;715;69;M
72047;1048,1052,644,1040,1418,1036,1372,715,1285,1504,1395,384,1367,1362,1376;7;M
72055;1345,1403,251,1279,1040,1504,186,1627,571,1077,248,384,1418,1372,1367;28;F
72060;276,1345,384,1362,856,1102,634,1304,1391,251,1040,1504,393,575;32;F
72081;644,1627,1367,1376,1043,1040,251,1391,957,1380,575,1048,1504,384;28;F
72086;251;31;F
72101;1279,1040,571,1395,715,1269;40;F
72129;1042,1345,1391,251,1504,1040,186,1627,571,1045,248,384,1367,1372,1043;30;F
72134;1345,1391,1102,1504,384,856,634,1645,1392,644,1613,1627,1077,1367,1372;61;F
72144;1391,1504,856,1345,644,1367,1372;34;M
72169;1392;46;F
72182;715,1392,1539,1522,1404,1391,977,1627,1418;44;F
72192;644,1645,1522,1345,1077,1182,1367,1504,571,1385,856;35;F
72215;384;25;F
72235;1279,1345,1522,1285,1269,856,1102,1385,715,1404,1077,1391,977,571,1372;40;F
72236;1367,1418,186,1279,1345,1522,634,1285,644,1077,1269;34;F
72244;1362,1418,938,251,1522,1042,856,715,634,1285,644,1040,1077;38;F
72271;248,644,1418,1367,1392,1404;41;M
72305;575,855,1645,715,1385,1102,1184,1367,634,644,1345,1504,1391,384,1372;45;F
72310;1350,1042,1269,1380,634,1522,1048,1052,251,1386,1040,1045,1404,1395,1403;28;M
72311;1380,1367,634,1645,575,1522,644,1391,977,1504,186,1627,384,1372,1362;57;F
72321;1294,1042,983,1392,1048,276,1345,1504,1418,634,644,571,248,384,1367;45;M
72324;938,186,1395,1418,1367,384,1369,715,634,1285,644,251,1040,1077,1362;10;F
72334;1645,1042,856,634,575,644,1040,1504,1395,248,384,1367,1036,1372,1362;32;F
72358;1040,1285,1380,1361;31;F
72364;715,634,1285,1522,644,251,938,1040,1077,1418,384,1367,1369,1043,1362;6;F
72372;856,393,1102,571,1048,1627,1613,1504,644;55;M
72378;856,1046,1042,1269,1279,938;33;F
72384;1404,977,1627,1362,856,1385,1392,1504,571,1269,1285,1279,384,1367,1372;34;M
72388;1102,1391,186,856,715,1645,1285,1279,977,1504,1627,384,1367,1372,1269;31;F
72411;1385,1294,251;33;M
72462;1269;34;F
72495;1304,1645,1380,1269,1042,1385,856,1285,977,1279,1040,1418,1367,1372,393;33;F
72498;916,1043,1367,1418,571,938,1404,1392,1522,634,1182,1102,856,1042,644;40;F
72533;276,1345,1613,1077,957,1285,983,248,1279,1386,977,1361,1102,856,1040;30;M
72554;1269,1386;37;F
72558;644,856,1385,715,1294,1042,1380,575,1304,1048,1345,1372,1504,1040,251;23;F
72565;248,1036,1385,1042,1285,977,1504,571,715,1645,1304,251,1627,384,1367;27;F
72568;1380,856,634,1392,644,1042,1269,1048,1391,251,1279,1040,1045,1395,1372;31;M
72574;1294,1361,1077,384,856,1102,634,1645,1285,1522,644,1279,1504,1627,1367;39;F
72577;575,1040,1077,1036,938,1369,1613,715,1361,634,1304,1048,1391,251,1386;57;F
72580;1102,251,914,1040,1613;67;F
72583;1385,983,276,1372,1376,634,688,1345,644,1404,977,571,1045,248,1367;62;F
72588;855,856,1645,575,1285,1391,251,1279,1040,1504,186,1627,571,384,1367;36;F
72597;1504,1269,1279,977,1403,1404,1345,1285,856,1040,186,1627,571,1372,1367;28;M
72614;856,715,1285,1392,1504,1522,1279;31;M
72624;1627,1395,1269,1304,1522,644,1391,251,1077,1418,1367,1369,1372,393,1362;34;F
72663;1645,856,1385,1294,1285,644,251,1279,1040,186,571,248,1367,1372,1362;28;F
72664;1645,1345,1404,914,1269,1285,1522,1391,1279,1418,384;38;F
72688;1361,1042,1380,1048,1052,1391,977,1040,1627,1395,248,1369,393,1362,916;42;F
72695;855,1102,856,1385,1294,1182,1645,575,1392,1522,1345,1391,1040,1504,571;46;F
72713;251,1403,276,688,1522,1539,715,634,1345,644,1404,977,1418,1372,393;35;F
72716;634,1361,1102,1392,1048,644,1404,1613,251,938,1279,1040,1627,1369;32;F
72729;983,1369,1362;41;M
72730;1102,1418,1036,1362,916,856,1345,1376,1627,1040,1372,644,1504,1522,1269;34;F
72777;1367,1627,1392,1304,1372,1361,856,1182,1376,571,1385,977,1380,1386,186;74;F
72783;715;4;F
72788;1102,1539,1345,1404,1403,1077,1367;38;M
72793;715;7;F
72804;715;41;M
72812;715;11;M
72821;575,1102,1392,1522,957,1052,276,1345,644,1040,1504,1627,571,1077,1367;38;M
72840;575,1285,1522,1391,1040,1504,186,1627,571,1077,1395,1418,384,1367,1376;73;F
72841;688,1345,1404,1403,977,1386,1279,1040,1504,186,1627,571,248,1367,1372;27;M
72858;1361,856,1102,1294,634,1645,1285,1522,644,1279,1504,1627,1077,384,1367;7;F
72862;1403,977,914,1504,186,571,248,1036,1645,1522,688,1418,384,1367,1372;45;F
72876;1048,1391,977,1367,1372,1052,1294,1613,1504,1045,384,575,1645,1042,1102;20;F
72892;1361,856,1102,1294,634,1645,1285,1522,644,1279,1504,1627,1077,384,1367;4;M
72909;1285,1042,1294,1046,1350,1372,1077,1040,1279,1386,914,644,1345,1522,1269;35;F
72919;1380,1361,856,1102,1294,634,1645,1285,1522,644,1279,1627,1504,384,1367;40;M
72932;1184,983;24;M
72957;1350,1645,1285,251,977,1279,186,1367,1036,1372,856,1102,1385,1269;42;M
72971;575,1345,977,571,393,1372,1367,1285,1269,1294,1385,1102,1645,1279,384;31;M
72980;251,1102,715,1285,384,1367;67;F
73020;1645,575,1504,248,1372;45;F
73034;1362,644,1392,1102,1269,634,1645,575,1345,1391,1279,1040,1504,1367,1627;38;F
73040;1043,1380,1285,1522,1404,1395,248,384,1042,644,251,938,1279,1102,1269;41;F
73072;1304,1285,1645,715,1385,1046,1042,1182,1522,1345,571,1418,384,1367,1372;39;F
73145;186,571,248,1036,1372,1376,1345,644,1391,251,1279,1367,1385,1102,384;42;F
73152;1418,1367,1369,856,1304,1522,644,1504,1627,1362,1376,1102,1269,251,1279;35;M
73208;575,1350,715,1269,1285,1522,1345,1391,914,1279,1077,1418,1372,393;35;F
73219;957,1504,1184,384,983;36;F
73233;977;30;M
73243;575,856,1102,1645,1285,1392,1052,1404,644,1391,1613,1504,571,1367,384;19;M
73290;977,1279,571,248,1184,1367,1372,957,1403,1404,1345,1391,251,1040,983;37;F
73312;1367,1504,1040,1285,1269,1102;44;M
73318;571,1077,1404,644,1345,855,575,634,1294,715,1102,856,1372,393,1362;25;M
73337;251,1645,1372,1367,1102,856,1285,1418,1345,1627,1504,1522,1279,1269,644;38;M
73347;1077,1184,1372,1376,856,1042,634,1304,1539,1522,644,1386,1040,1395,248;40;M
73350;1345,1645,1372,1367,1102,856,1285,1418,1627,1504,1522,1279,1269,644;35;F
73374;1102,575,1522,276,1345,977,1279,1418,1391;66;F
73381;1376,1372,1367,384,186,1040,1279,977,251,1345,1285,1645,856,1385,1102;32;F
73383;1403,1294,1182,634,1391,251,914,1040,1184,1367,1372,1102,1504,983,1376;26;F
73391;644,1418,1372,1102,856,1385,1294,1182,1380,1645,1345,251,571,1367,1369;47;F
73524;715;44;F
73537;1385,1269,1645,1285,1345,1404,1403,1279,248,1418,856,1392,251,1367,393;38;F
73547;248,715,1279,186,1627,1077,1645,1285,1345,1391,1522,644,1418,384,1367;41;F
73555;1102,1269,1380,1285,644,251,1279,1627,1376;37;F
73565;1362,1077,1504,1279,571,1613,1392,1418,914,1376,1380,1040,1627,856,644;55;M
73597;1048,1372,1376,575;23;M
73604;688,1392,1042,1645,1385,856,575,1522,1345,644,1404,1391,1613,977,384;33;F
73606;1102,1269;33;F
73627;1285,1392,1269,1385,856,1645,1345,977,1613,571,248,1418,384,1367,1372;34;M
73629;1361,1504,1372,1627,251,1403,1404,1345,1522,1392,855,1645,715,1350,1102;31;F
73683;1361,1042,1645,688,1404,977,1040,248,1418,1367,1372,393;49;M
73707;1046,644,914,1077,916,1285,856,1102,1042,1269,251,1391,1279,1040,1362;36;F
73709;1285,1042,715,1403,688,1385,1269,1645,1392,977,1504,186,1627,1418,1367;35;M
73740;1392,1539,1627;26;M
73748;856,1052,251,938,1040,1418,384,1367,393;19;F
73812;186,1627,571,1395,1184,393,1376,1285,1392,644,1504,1279;41;M
73853;1539,1627,1367,1279,1403,1345,1613,1385,856,1048,251,938,248,1043,1372;25;F
73906;1077,1045,938,1403,1392,1361,1042,1182,1269,644,1404,571,384,1367,1372;39;F
73917;1645,688,1372,393,1539,1392,855,1385,856,977,1294,1380,644,571,248;53;F
73926;1645,1403,1404,248,384,1395,1102,1350,1269,1380,634,1367,393,715,644;41;F
73954;1385,1345,1367,1403,1404,1392,1040,1380,856,1269,1279,1504,1627,251,1522;32;M
73960;856,1392,1304,1522,1345,644,251,977,1040,571,1077,1418,384,1367,1372;32;F
74018;393,1304,1380,1042,1294,1285,1040,1362,1102,856,1645,1522,1391,571;33;F
74040;1102,1042,1645,1522,575,1627,384;25;F
74064;575,1048,644,688,1522,1182,1046,1385,1040,1077,1418,1367,1036,1043,916;33;F
74082;1627,1504,1285,1645,575,644,1391,384;52;F
74101;1182,1385,1179,855,248,1285,856,1102,1392,1345,983,957,1184,1367,1372;28;M
74144;1102,1645,856,1385,715,1285,1345,644,1391,251,938,977,186,571,1367;43;F
74149;1418,1184,248,1386,1369,1043,393,1350,1102,1404,1403,1077;25;M
74159;1294,855,1285,1279,186,571,1077,1367,1385,856;38;M
74163;1645,1380,1269,1042,1294,1350,1385,1102,856,571,1418,1367,1182,1522,1040;39;F
74183;914,1613,1385,1269,1391,856,1102,1645,575,1285,1345,1279,1504,1627;27;F
74184;571,384,1043,1184,1045,1040,1522,575,1380,1042,1350,1102,1391,957,983;31;F
74196;715,1645,1345,251,1040,1504,186,384,1367;29;F
74209;248,688,1345,1404,977,1504,186,1522,1392,856,1627,571,1418,1367,1372;29;F
74212;1391,571,248,856,1385,855,1345,251,977,1627,1362,1372,1367,1077,715;53;F
74224;1102,1077,1367,1362,715;47;M
74226;977,1345,1404,1403,251,1627,186,571,1077,248,1372,1350,856,1504,1367;32;M
74241;1102,715,1042,1285,1522,1052,1391,251,1279,1040,1077,1418,1367,1372,1269;38;M
74263;1042,983,1404,1362,1504,1179,1645,1345,384,1539,688,977,248,1372,1391;25;F
74288;688,571,1367,1372,983;37;F
74312;1269,1285,1403,1386,1279,186,571;33;M
74334;1048,644,1391,251,938,1036,1376;31;F
74338;977,1304,1380,1046,715,1102,1269,1285,1345,251,914,1040,1418,1367,1372;36;F
74360;1376,1367,1418,1077,1627,186,1040,1279,914,1391,644,1645,1350,856,1269;36;F
74391;957,575,983;42;M
74402;1613,1279,1040,1627,393,1362,634,1269,1504,1036;47;F
74455;1269,1182,1294,715,1385,1102,856,855,1392,1404,1391,186,1077,1418,1367;23;M
74465;1385,1392,856,1391,251,1279,571;48;F
74500;715,1350,1269,1645,644,977,1279,1504,1395,248,1418,384,1367,393,916;10;M
74549;1645,1077,186,1279,1613,276,1042,1269,1052,1345,1040,1627,571,384,1036;14;F
74581;1102,1350,715,1269,1380,634,1645,644,1404,1403,1395,248,1367,393,916;8;F
74591;1361,571,1102,1042,634,1048,644,1367,1369,393,1043,1645,575,384;36;F
74598;1269;27;M
74622;1380,1361,856,1102,1385,1042,1269,1285,1522,644,384,1362,1304,251,1040;29;F
74629;384,251,1380,1269,1350,715,1102,634,1645,644,1040,1395,1367,393,916;6;F
74637;1269,1380,1304,1048,1040,1036;28;F
74649;1361,1042,1380,634,1285,644,977,1367,1372;24;F
74685;1385,1294,1645,1539,688,1279,1403,977,248,1367,1372;41;F
74689;856,1392,251,186,571,1418,1367,1372;34;F
74703;1385,1294,1645,575,1285;51;F
74718;1380,688,1404,251,1040,571,248,384,1367,1036,1372;34;F
74724;186,248,1367,1048,1392,1539,1345,1279,1372,1042,1403,1376,1404,251,384;32;F
74742;1380,1269,1102,1361,715,1042,1304,1345,1404,1403,1613,251,1040,1367,1036;26;F
74753;1361,1102,1269,1645,393,384,1367,1182,1279,186,1077,1045,1418,1036,1372;38;F
74776;1386,1279,1395,1367,1369,1376,1043,1040,251,644,1048,1645,1380,856,1372;46;F
74785;856,1102,1046,1042,1380,575,1048,1391,251,914,1040,1504,1418,1367,1043;29;F
74818;1391,977,1279,1504,571,1077,1367,1372,1042,1269,634,1285,644,251,1418;35;F
74821;957,276,1048,1269,1102,856,1361,1042,983,644,1391,251,1372,688,977;23;F
74827;856,251,1040;30;M
74844;856,1385,1294,1645,1052,251,977,1040,1627,571,384,1367,1372,393,1043;28;F
74846;571,1392,1627,856,1345,1504,1385;42;M
74847;1522,251;35;M
74856;1361,634,251,914,1040;40;F
74858;1362,1077,1345,1380,575,1392,1179,1504,1403,1404,1372;27;M
74862;1404,1403,1504,1627,571,248,715,1345,977,1367,1372;33;M
74905;856,715,1042,1269,1304,1522,1052,938,1386,1040,1418,1043,1376;40;F
75035;1285,1304,1345,1279,856,715,1403,1404,251,1040,1367;25;M
75037;1350,575,1403,1404,856,644,186;38;F
75039;1645,977,248,384,1367,1372;29;F
75064;938,186,384,1279,1392,575,1385,856,1269,1285,1504,1627,571,248,1613;37;F
75073;1645,1539,688,571,1184,1285,1403,1404,977,1279,186,248,1367,1372,1362;59;M
75079;1182,1045;27;F
75110;1269,1613,186,1345,977,938,1279,1040,1504,571,1184,248,384,1367,1372;24;F
75112;1042,1052,1395,1367,1522,186,1077,715;19;F
75132;1304,575,1048,1345,1403,1504,384,1372,1392,1613,251,1040,1045,1418,1043;44;F
75137;186,1627,1367,856,1269,1077;42;M
75141;856,1385,1392,1345,1404,1391,977,1279,1504,186,1627,571,248,1367,1372;35;F
75142;1613;39;M
75152;1392,983,855,1404;27;F
75165;983;38;M
75192;1391,1102,856,644,1345,1522,1613,1392,1627,1040,1504,251,1269,1279,1362;35;M
75210;644,248,1367,1040,977,1404,1539,688,1285,1380,1182,715,1385,856,1372;56;F
75228;856,1294,1269,855,1522,1404,1403,938,1376,384,1418,1077,251,644,1367;30;F
75253;384,1179,1040,1279,977,1392,1285,1372,1376;63;F
75262;856,1042,634,575,1404,251,977,1040,1504,1372;27;F
75270;1645,1285,644,1403,1404,1279,384,1367;40;F
75274;1042,1361,856,1102,983,1304,1522,1391,251,1386,1040,1627,1395,248,1372;49;F
75279;186,571,248,1184,1504,1179,1279,977,688,1645,1367,1392,1539,1404,1372;20;M
75283;644,1345,1380,1042,715,856,1102,1269,1285,1391,1279,1040,1077,1418,1367;37;M
75286;1345,856,1102,1392,1539,688,1404,1403,251,977,957,1184,1418,1367,1372;31;M
75299;1102,634,1392,1539,1522,1404,1504,186,1627,571,248,1367,1372,916,1376;20;F
75311;856,1102,1385,1294,1345,1404,1391,977,1504,384,1367,1372;23;F
75324;1645,1392,1345,1279,1040,384,1372,1504,1367,856,1102,957,1391,983,1184;38;M
75337;1040,1045,1077,384,1350,1046,1042,1380,1645,1304,1522,1048,644,251,1395;58;F
75340;1392,1539,688,977,1279,1179,571,1184,1403,1404,1345,248,1367,1372,1362;21;M
75395;1304,1345,251,914,1386,1040,384,1372,1043;40;F
75398;1102,856,1040,1504,186,1627,914,938,251,1613,1372,1345,1285,1269,1376;32;F
75399;251,938,1179,186,1627,571,1418,384,1367,1369,393,1403,1392,1345,248;28;F
75411;1613,575,1380,1645,1285,1392,1304,644,938,977,1040,1077,1372,393,1043;40;F
75416;1345,251;25;M
75423;1627,1362,715,1392,1294,1385,856,251,977,1040,1504,571,384,1367,1372;24;F
75467;1102,715,1285,1392,1539,1345,1404,1403,1391,571,1367,384,1372;25;M
75498;1522,688,1403,1404,977,186,1627,1294,1391,571,1102,1645,1285,1279,384;36;M
75502;571,1367,856,1102,1385,1645,1285,1403,1404,1391,1279;29;M
75516;248,1184,1285,715,1385,1102,856,1345,977,1504,1627;24;M
75601;1040,977,938,251,1345,1522,1380,1385,856,571;29;F
75669;983,1042,1046,1350,1627,571,1045,384,1418,1367,1036,1372,393,1043,1376;42;F
75685;1385,1294,1645,855,575,1285,1539,688,1345,1404,1403,977,1504,1627,1367;37;M
75705;1269,1102,856,1285,1304,1522,1345,977,1279,1040,571,248,1418,1367,1372;31;F
75707;1043,644,1504,1392;37;M
75789;1522,644;36;F
75797;1042,856,688,276,1345,644,1404,1391,251,977,186,1077,1418,1367,1372;41;F
75822;1285,1404,1403,251,977,1279,1040,186,571,248,1184,1418,1367,1036,1372;25;M
75825;1269,1385,1372,1367,575,1285,1539,1404,1403,251,914,1040,1179,1504,1627;44;F
75840;1645,1392,1539,977,248,384;29;F
75882;1392,983,855,1294,715,856,1269,1285,1345,977,1040,571,384,1367,1372;28;F
75896;186,1504,914,977,1345,715,1385,1279,1627,1367,1372,1269,856,1102,1391;36;F
75923;1102,856,1380,1645,855,1048,1345,938,977,1504,186,1627,571,1367,1372;22;F
75925;983;33;F
75931;575,1345,1404,1403,1391,251,977,1372;21;M
75932;1102,1385,715,1380,1392,1052,1404,1403,1279,384,1042,1345,1367,1372,1376;23;F
75941;715,1345,1391,977,186,571,1077,248,1184,1367,1269,1040,1504,384,1372;27;M
75950;186,1077,1362,1372,1367,1102,855;33;F
75959;856,1102,1269,1279,1040,1184,1367,1036,1372;40;M
75981;1504,1372,1367,571,186,1279,1403,1404,1392,575,1645,1269,1294,1385,856;31;F
76020;1385,1345,977,1042,855,575,688,276,644,1404,1627,1372;31;F
76053;1367,1369,1403,977,1279,1627,384,1372,1043,575,983,957,938,1077,1184;30;F
76056;1042,1269,1285,1304,1522,644,1391,251,1040,1077,1418,1367,1372,1036,1376;37;F
76059;1285,1418,1367,1372,1043,1504,1279,914,977,1522,856,575,1345,251,393;42;F
76110;1613;85;F
76112;983,957,1345,1184,1372;32;F
76133;715,1042,1269,1380,1304,1048,1345,644,1391,977,1040,384,1372,1376,251;28;F
76153;1350,1269,1380,1304,644,1391,251,1040,1504,1077,1367,1036,1369,393,1285;35;F
76163;715,1645,1285,1036,1102,1392,1403,1404,251,1367,1372;26;F
76164;1269,856,1045,248,384,1380,855,1392,1285,644,251,1279,1040,1627,1372;31;M
76179;938,1391,1403,1404,1345,957,1522,1285,855,1294,715,1385,1102,1269;32;M
76230;856,1042,1285,1048,1391,1040,1395;45;F
76248;251,1045,634,855,1391,1627,1345,977,1504,571,1367,1392,715,1385,856;50;M
76267;1367,384,1269,1294,715,1385,1102,856,1361,914,1345,1040,1372;38;M
76279;248,251,1362;43;F
76289;715;61;F
76295;1361,715,1269,1376;59;M
76317;1345,1362,1077,1279,1285,1042,1102,1361,856,1269,1048,644,251,1040,1367;35;F
76329;1269;31;M
76349;1361,1102,856,1304,1048,1077,1418,1369,977,251,1285,644,384,1367,1372;22;F
76352;1345,1391,251,1279,1040,1077,1418,384,1367,393,1043,1046,1269,1522,1048;38;F
76358;251,938,1279,1040,1627,248,856,1102,644,1304,1345,1418,1367,1376;46;F
76359;1418,1036,384,571,1042,1294,1367,1645;40;F
76370;251,1627,644;33;M
76418;634,855,715,1385,856,1279,1504,186,1627,571,248,1418,1184,1372,1367;20;F
76419;1269;30;F
76442;1279,1627,571,1345,1285,1645,1102,856,1269,251,914,1040,186,384,1367;34;F
76443;1361,1395,1304,1539,251,1386,1040,248,1376;29;F
76458;1102,1350,715,1046,1042,1269,1285,644,914,1279,571,1077,1045,1367,1043;9;M
76481;1645,186,1504,1179,1279,977,1403,688,1539,715,1385,248,384,1367,1372;32;F
76487;688,276,1345,1403,1391,977,1040,248,1367,1372,1380,1102,1504,1627,384;19;F
76494;1294,1380,1048,1345,1391,251,977,1386,1040,1504,1627,571,1418,1367,1372;36;F
76502;1391,1285,1645,715,575,1345,1627,384,1367,1372;32;F
76505;1504,1367,634,644;55;F
76519;1077,1285,856,1102,1350,715,1046,1042,1269,1345,644,914,1279,1045,1043;40;M
76550;1350,1046,1269,1380,634,644,1391,1040,1077,1395,916;35;F
76555;1385,856,1102,715,575,644,1391,251,977,1279,1504,1077,1418,1367,1372;33;F
76577;856,1102,575,1285,1345,1391,977,1279,1040,1504,1627,571,384,1367,1372;34;M
76581;688,1048,1391,251,938,977,1040,186,1077,1418,384,1372,1367,1036,1522;25;F
76597;1380,1304,1279,1040,251,938,186,1627,248,1418,1372,1522,856,1285,1362;30;F
76615;1418,1504,977,1391,575,1380,856,1102,1285,1522,1345,1040,1367;25;M
76616;1269,1380,1522,1345,251,977,1418,1367,1372;38;F
76650;1392,1391,1504,1367;45;M
76665;1345,644,1418,1279,1040,1504,1627,1380,1385,1645,715,856,1285,1367,393;45;F
76670;1102,688,1040,1386,1361,983,1304,957,251,938,1184,1036,1372;28;F
76672;1367,1184,248,1403,1404,1345,957,1294,983;41;F
76675;1269;33;F
76678;856,1304,1522,1391,1627,248,1269,1285,251,1040,1376;30;F
76690;983;28;M
76703;644,1269;46;M
76708;1036,1391,1392,644,1362,1269,1279,1102;33;M
76719;1285,1522,1345,644,251,977,1279,1627,571,1077,1045,1418,1367,1372,1043;30;F
76730;1345,688,571,1367;41;F
76754;1376,571,1077,1372,1627,1504,644,1362,1367,914,1385,1392,856,1279,1269;29;M
76768;1042,634,1522,1048,644,1269,1376;35;F
76789;1369,1102,1385,1042,1269,1645,1522,1391,251,1279,1045,1395,1418,393,1043;37;F
76791;1269,1285,251,1040,186,1367,1372,1376;29;F
76793;1036,1380,1102,1361,715,634,983,1285,957,1345,251,977,1040,1184,1367;46;F
76835;575,1361,1102,1385,1042,634,1345,644,1372,1043,1645,688,1418,1036,1362;26;M
76846;715,1269,1285,251,1279,1040;44;M
76852;384;70;M
76858;1391,688,1522,1285,855,1294,1385,856,715,1392,1345,1504,1627,571,1367;44;F
76871;1522,1404,1504,1077,1418,1367,1372;40;M
76880;251;65;M
76883;1367,384,575,1627,1504,1179,1279,1345,1391,1285,1645,1269;34;F
76905;1269,1285,1279,186,384,1367;40;F
76908;1367,1391,251;39;F
76927;575,1048,1345,977,1504,1627,248,1372,856,1269,1645,1391,1279,1367,384;37;F
76954;575;62;F
76968;1385,715,1392,1345,1404,1403,1391,977,1279,1504,186,571,248,1367,1372;41;M
76995;856,1385,715,1380,1645,1285,1345,644,1279,1040,1504,1627,1418,1367,393;49;M
77016;251,1345,1042,1418,715;37;F
77021;856,1385,715,1380,1645,1285,1345,644,1279,1040,1504,1627,1418,1367,393;13;F
77051;856,1385,715,1380,1645,1285,1345,644,1279,1040,1504,1627,1418,1367,393;11;M
77056;251,688,1522,1539,634,715,1361,1304,1345,1504,1627,248,1418,1367,1372;34;F
77105;1418,1361,1042,634,1522,1048,251,393,384;35;F
77163;1285,1392,1345,1404,1403,251;39;M
77169;1627,571,248,384,1367,1362,957,1404;48;F
77176;1345,1279,1179,1504,1627,384,1367,856,1269,1645,575,1285,1391,251,571;35;M
77179;856,1294,571,1367;21;F
77186;1504,1376,1627,1040,977,1294,856,1102,571,1362,1385,1269,1285,1279,1367;30;F
77201;856,1385,634,1645,855,688,644,1391,977,1279,1040,571,248,384,1362;50;M
77203;1269;32;F
77218;1294,1385,1269,1645,1285,688,977,1504,248,1279,571,384,1367,1036,1372;39;F
77223;688,1048,1345,914;34;F
77239;957,644,251,384,1036,983;66;F
77256;1385,1522,1345,644,1045,384,571,1645,1504,1367,1042,1391;23;F
77277;715,1350,1385,1392,1042,1294,856,1102,1645,1048,1052,1345,644,384,1376;45;F
77281;856,186,1367;42;F
77283;856,1380,575,1304,1040,384,1036;24;F
77284;1040,1279,914,1392,1380,856,1042,1522,1345,644,251,1077,384,1269,1367;36;M
77323;575,1285,1522,1345,914,1279,1504,856,1269,1380,644,1391,251,1367;36;F
77331;1304,715,1269;42;F
77349;384,1043,1376,1627,251,914,1504,248,1418,634,1345,644,977,1385,1645;44;M
77354;644,575,1182,1042,1102,856,1645,1304,1391,977,384,1367,1372,393,1376;39;F
77356;1294,688,1403,1404,186,571,1184,1372,1367,1645,1285,1362;38;M
77377;1048,1345,1404,914,1504,1036,634,1645,644,1391,251,977,384,1367,1372;55;F
77430;715;35;F
77433;1345,1285,1380,715,1385,856,1102,1350,1269,575,251,914,1391,1279,1504;35;M
77438;1367;43;M
77444;855,856,1102,1285,715;67;F
77457;1269,1279,186,1077,1367;28;M
77480;855,1285,1048,1404,248,1367,1036,856,1102,1522,688,977,1627,1418,1372;57;M
77481;1522,1294,1269,1627,1372,1645,1539,1404,1403,1613,1504,1392,1385,1345,1367;41;M
77519;1345,1404,1403,1504,1627,1418;25;M
77553;856,1385,715,983,957,1345,1404,1403,571,248,1184,1418,1367,1372,1376;36;F
77554;1367;43;M
77581;856,1645,1304,1391,384;35;F
77594;1350,1048,1036,393,916,1077,1369,1395,1361,251,1040,856,1279,644,1269;34;M
77603;1367,856,1040,571;44;M
77616;644;59;F
77633;1418,1372,856,1385,1294,1182,1269,1392,1522,1613,251,977,914,1040,571;29;F
77635;1627,1279,644,1269;38;F
77654;715;43;F
77667;1404,251,938,914,186,571,248,1418,384,393,634,983,957,644,1184;15;M
77678;1102,715,1046,1269,1285,644,251,977,914,1279,1504,1077,1418,1367,1362;32;F
77682;1404,644,1345,688,1539,1269,856,1042,634,855,983,248,1418,1367,1372;17;F
77703;1645,715,1385,1102,856,1380,186,1367,1036,1391,251,938,1279,1040,1627;37;F
77716;715;7;F
77741;856,1102,1380,1304,1048,251,977,1040,1367,1369,1372;23;M
77754;1367;41;F
77776;856,1385,977,1362,1367,248,1627,186,644,634,1522,1392,1269,715,1361;35;M
77789;1385,856,1361,644,1404,251,977,1040,1627,571,248,384,1362,1372,1367;37;M
77805;248;67;F
77806;1645,393,1404,1403;38;F
77842;1102,1645,1048,1403,914,1395,1418,1043,856,1042,634,1392,1539,1404,384;30;F
77879;1102,715,1285,1539,688,276,1345,1403,977,571,248,1367,1372;49;M
77880;1285,1102,1392,1539,688,1345,1627,1052,1504,248,1367,575,1385,1645,384;35;F
77892;1627,1504,1345,1645,1269,1294,1385,856,1285,1392,1522,1613,251,1279,1367;34;F
77893;1102,1504,186,856,715,634,1345,644,1391,248,571,1184,384,1367,1372;86;M
77896;251,1391,1403,1404,1345,276,688,1539,1392,1285,1645,248,1367,1372,1362;46;F
77958;575;26;F
77968;575,1522,1345,644,1391,938,1386,1504,571,1077,1367,1376,1046,1304,1040;38;F
77978;1345,1391,938,1040,1386,1077,1395,393,644,251,1045,384,1504,1376,575;30;F
77990;1418,856,1102,634,1345,1391,1077,1404,957,983,1645,715,1385,1184,1367;56;M
78009;1522,1385,1345,1391,1613,977,1279,1040,1627,1077,1045,248,1367,1372,1043;60;F
78031;1613;52;M
78047;1042,1380,644,251,914,1386,1040,384,1036;25;F
78054;715,1380,186,1372,1361,1391,1279,1504,1362,856,1269,1285,1627,1367,1376;48;M
78056;983;36;F
78066;1386,1077,1395,1418,1036,1372,1376,1102,1350,1522,644,1391,977,571,1367;42;F
78069;1102,1392,1345,1613,251,977,1040,1504,1077,1395,1418,1367,1036,1372,393;30;M
78080;1046,1042,1182,1522,644,251,1077,1418,1367;39;F
78093;1369,1043,1376,1042,1285,1304,1048,251,1040,1418,916,1380,1522,1269,1279;45;F
78110;1392,1048,977,1504,856,1042,1404,1391,251,1627,1395,384,1367,1043,916;26;F
78121;1645,634,715,1350,384,1361,1048,251,977,914,1367,1369,1036,1372,1376;26;F
78129;856,1395;49;M
78139;1345,1403,1404,1391,1627,1367,1369,1372;49;M
78161;1048,1279,1045,1367,1372;35;F
78175;1350,1046,1269,914,1045,1036,1043,916;40;M
78184;1304,1048,977,914,1386,1504,384,1367,1372,856,1102,1392,1391,1040,1613;42;F
78199;856,1102,1380,1392,1304,1522,644,1391,977,1040,1627,571,1418,1372,1362;37;F
78209;983;18;M
78214;977,1285,1392,1345,1404,1403,1391,1179,384;41;M
78215;1102,1385,983,1392,1539,688,1345,644,1404,1391,977,1279,1418,1367,1372;40;F
78221;1645,715,248,1385,1285,1392,1539,688,1403,977,1179,1294,1279,1372,1367;42;M
78228;715,634,575,1345,1279,1504,571,1077,384,1367;38;F
78241;1269,1285,688,1345,1403,977,1279,1504,186,1627,571,1418,1367,1372,393;35;F
78246;957;44;M
78249;1372,1418,1102,1385,715,1380,1522,1391,251,1279,1040,1627,1367,856,1269;35;M
78265;1269,1391,1418,1376;37;F
78269;1077,957,983;41;F
78273;1380,1645,1048,644,251,1040,186,1627,1045,248,1369,1376,393,1367,1372;41;F
78278;856,1269,634,1522,1048,1345,644,1391,251,977,914,1077;40;F
78282;1036,1395,1350,856;23;M
78301;856,1385,715,1294,1645,855,1392,1539,1522,1345,644,1627,248,1367,1372;56;M
78304;1522,1345,977,1077,1395,715,1048,1040,1418,1367,1372;41;F
78319;393,1376,1102,1042,855,1392,1539,276,644,1404,1391,1179,1627,1418,384;30;F
78330;1380,251,1369,1361,1304,1077,856,1048,1042,1040,1036,644,634,393,1613;45;F
78333;1361,1376,1040,1613;48;M
78378;384,983;39;M
78387;1345,715,856,571,1367;31;M
78404;1077,1279,1040,914,644,634,1350,1102,1285,1522,1045,1418,1043,916,1269;36;F
78408;1285,1391,251,1279,1040,384,1367,1036;29;F
78493;644,1391,977,1504,571,1077,1418,384,1362,1102,856,1645,251,186,1367;34;F
78502;856,1102,575,1285,1345,1613,1404,1403,1504;33;M
78515;1294,634,1048,644,1391,251,1040,1418,1369,916;42;F
78518;715,1285,1522,1048,1345,977,1040,186,1077,1395,1418,1367,1372;9;M
78520;856,575,1040,384,1367,1372,1362,1376;43;F
78541;1102,634,1645,983,1345,1404,1391,977,1040,186,571,1367,1372,1043,916;29;M
78568;276,1380,715,1645,575,688,251,977,914,1040,1504,571,384,1367,1372;38;F
78578;1645,1040,384,1372,251,186;40;F
78584;1350,1522,251,1184,1418,384,715,1345,977,1367;24;M
78595;1504,1304,1392,575,1645,1102,856,1385,1380,1048,1391,1613,1040,384,1362;44;F
78615;1102,1345,1046,856,1380,634,1392,644,1404,251,1504,1627,1369,1362;42;F
78621;983;22;F
78657;957,1184,983;51;M
78660;1522,1385,1345,251,977,186,1627,571,1367,1376,384,1040,644,1269,856;35;F
78665;715,1285,1522,977,1040,186,1077,1395,1418,1367,1372;7;F
78666;634,855,1285,1539,1048,276,1404,1403,977,1040,1504,186,571,1372,1367;23;M
78668;1367,1645,856,1345,1392,1504,1522,1372,1380,1304,251,1040,1627,1269,644;39;M
78670;1367;37;M
78673;186;35;M
78678;1391,1040,1345,914,575,1042,1362,1418,1645,1380,1385,1102,856,1504,1613;42;M
78694;977;56;M
78701;1269,1285,1279;35;M
78731;715,1285,1522,1048,1345,977,1040,186,1077,1395,1418,1367,1372;5;M
78742;575,384,1184,957,983,1504;29;M
78743;1367;37;F
78776;1036,384,1184,1522,1539,1645,575,1285,1345,1404,1391,1279,1102,855,1392;27;F
78778;1361,856,1269,1380,938,914,1367,1036;55;F
78803;1279,1040,1367,1102,1269;37;M
78834;1077,1361,856,1385,715,1294,1380,1645,1391,251,1040,1627,571,384,1367;45;M
78835;644,1285,1645,634,1380,715,1361,1504,1627,1395,248,1367,1369,1372,1376;78;F
78850;1269,1279;35;M
78854;1645,1285,1522,1048,1345,644,1391,1279,1627,1077,1418,1367,1362,856,1269;37;M
78859;384,1418,1522,1392,983,1645,1182,1042,856,1345,1391,1045,1367,1372,1376;24;F
78860;1367,384,1294,715,1385,1361,856,1102,1645,1392,1345,251,1504,1627,571;38;M
78866;186,1367,1385,1042,1269,1404,1403,251,1279,1376,715,1645,575,1285,1504;31;F
78885;384,186,1040,1279,977,914,938,1403,1404,856,1304,251,1418,1367,1362;36;F
78890;1385,1182,983,1539,957,276,1404,1391,1613,1279,1077,1392,1403,1504;30;M
78899;1376,1040,251,1380,634,1362;49;M
78921;1350,1042,1182,1385,1102,1269,1285,1345,644,251,914,1279,1045,1372,1376;49;F
78925;1391,1345,1048,688,1522,1304,1285,1645,1380,1042,1385,1102,856,1279,1376;31;M
78949;1367,1372,977,1391,1345,1304,1380,634,856,1361,1294,1042,1418,1036,393;32;F
78971;983,957;35;F
78972;384,1395,1077,1279,1285,1269,1504,1418,1367;33;F
78980;957,983;41;M
78989;1077,248,1418,1367,1036,1376,1361,1269,1285,1304,1522,977,1279,1045,1372;31;F
78992;1269,1380,634,575,1285,1345,1613,1279,1040,1504,1627,1362,1367,1036,393;48;M
78995;1269,938,715,1046,1285,1522,1279,1045,248,1418,1367,1036,1372,393,1043;28;M
79023;1645,644,384;65;F
79030;1392,1404;53;F
79032;248,983,957,1391,634,1184;34;M
79037;1392,1285,1040,1504,856,1404,1279;31;M
79045;1304,1391,1504,1627,856,1385,1042,1380,1392,1345,1404,251,186,571,384;31;F
79047;1385,1645,1285,1392,251,938,1627,571,1362,856,1269,1345,1279,1040,1367;34;M
79058;1385,634,644,1404,1077,983;50;F
79075;571,1040,1294,715,1385;29;F
79093;575,1048,644,1391,251,977,1386,1504,1045,1036,1372,393,1269,856,384;29;M
79113;1362,977,186,1392,1385,856,1345,1404,1403,251,1279,1040,571,1367,1372;32;M
79114;916,384,248,1077,1040,1345,1048,1522,1392,1285,634,1269,1182,1102;32;F
79115;575,1376,1369,393,856,1042,1269,1304,1345,644,1391,1613,1040,384,1036;24;F
79120;1345,1385,715,644,914,1627,1367,1279,1269,856,1102,1380,1613,1040,1395;45;M
79122;1376,1285,1304,1345,1391,251,977,571,1627,1367,1372;33;M
79139;1404,1391,186,571,248,1184,1418,384,1367,1036,1369,1372,393,1043,916;32;F
79150;1391,644,1522,1102,856,1350,1380,1285,1392,1304,1613,251,1279,1040,571;40;M
79151;1102,983;26;M
79188;1042,688,1403,1404,251,1504,571,1184,634,1645,983,575,957,1391,384;27;F
79203;1385,856,1269,1380,1285,1391,251,938,914,1040,1504,186,1627,1367,1372;28;F
79210;1102,1345,856,1645,1392,1522,644,1613,914,1040,1418,384,1504,1395,1362;37;F
79225;1391,1367,1372,1043;50;F
79226;1522,1269,644,251,1279,1040;39;F
79253;1048,644;32;F
79271;983,1392,1539,1345,1404,1403,1367,856,1102,1391,251,977,248,384,1372;40;M
79317;1040,977,251,1345,1042,1102,856,1279,1269,186;34;M
79319;1504,1102,856,1361,251,977,1386,1279,1627,393,1391,1367,1372,1043,1376;30;M
79365;1361,644,977,1077,1045,1418,384,1367,393,1043,916,1269,1052,248,1372;28;F
79404;715,1285,1504,1391,1404,1345,1522,1645,1380,1042,251,1386,1279,1418,1372;38;F
79424;1048,856,644,1345,1269,1285,1279,571,1077,1367,1376;41;F
79435;1392,1385,1294,1645,1345,644,1391,914,1504,571,1077,384,1367,1372,1376;45;F
79441;1048,276,644,1404,251,914,1386,1040,1077,384,1036,1372,1043,916,1376;27;F
79465;856,1042,575,1392,1404,251;24;M
79503;983,957;27;M
79504;1504,715,1102,1294,1048,1391,1627,571,1367,1385;45;F
79515;977,1077,248,1418,384,1367,1372;40;M
79519;575,1504;27;F
79523;856,1269,1285,1304,251,1279,1040,1367,1372;29;F
79526;1645,575,1285,688,1345,1404,977,1279,1504,1367,384,644;26;F
79556;1645,1294,575,1345,1391,977,1279,1504,186,571,248,1418,384,1367,1372;27;M
79593;1385,1269,186,856,1102,1184,957,983;46;M
79621;856,1102,1645,1345,1627,384,1372;38;M
79644;1522,1372,1345,1391;41;F
79652;856,1385,1102,715,1269,1380,1345,644,1613,914,1279,1040,1627,1395,1367;41;F
79656;1362,1385,1645,1285,1392,1304,1539,688,276,1345,1391,251,914,1504,1627;24;F
79665;856,1385,715,1294,1645,575,1285,1539,1345,1391,977,1279,571,384,1367;21;M
79677;856,1269,1380,634,1645,1285,1040,1627,1367,1036;48;F
79725;1269,1645,1539,688,644,1404,251,977,1386,1279,1367,575,914,1040,1504;30;F
79726;575,1539,1404,1403,1627,384,248;27;F
79727;983,1391;27;M
79729;1102,715,1269,688,276,1404,1403,1391,1613,1179,186,1627,571,1367,1372;38;M
79772;384,1372,1376;61;F
79782;1504,571,1395,1418,1367,1350,1304,1522,1048,1052;47;F
79786;715,1102,1385,1294,1645,1285,1392,1404,1403,1279,1504,571,1077,1367,1362;40;M
79802;1102,1042,634,855,1522,644,1391,977,1504,571,1077,1418,1367,1372,393;35;F
79815;1385,1350,715,1046,855,1522,644,393,251,1391,575,1645,1380,1042,1504;36;M
79822;1048,1036,1376,1043,1042,1645,1392,1304,644,1404,1613,1386,1040,571,384;23;F
79852;1361,1042,575,983,957,1052,1391,1613,1040,1418,384,1372,1043;25;F
79862;1040,1391,715,855,251,1627,1372,1362,856,1048,1345,644;41;F
79873;983,957,1184,1418,1372,916;32;F
79925;1361,1645,856,1102,715,1522,1304,1380,1269,644,1391,251,977,1040,1367;40;F
79927;1385,1645,977,1504,571,384,1367,1372;23;F
79936;248,1372,856,1294,1269,1645,1285,1345,1391,977,1279,1040,571,384,1367;35;M
79974;1042,1269,1645,1285,1522,1345,644,1391,1040,1627,1077,1418,1367,1043,1362;34;F
79981;1102,856,1392,977,1279,571,1367;32;M
80023;1391,644,688,1539,1304,1392,1285,575,1645,634,1380,1385,856,1361,251;30;F
80043;715,575,1048,1040;27;M
80076;1539,855,1042,1361,1367,393,688,1048,1404,276,1391,248;39;F
80077;1102,1184,251,384,983,957;35;F
80096;1102,1350,1042,1269,1645,1304,1522,1048,1391,251,938,1040,1418,1372,916;30;F
80098;1102,983,957,251;38;M
80104;1102,1269,1285,1279,1043;45;F
80147;1395,1418,1367,1372,1362,1613,1380,1042,1350,1046,914,1045,1036,1043,916;10;F
80254;1361,1042,855,1539,688,1048,276,1404,1391,1045,248,393;3;F
80278;644,856,1645,1285,957,1404,1391,251,977,571,1045,384,1367,1372,1362;32;M
80296;856,1380,1645,1048,1613,1040;40;F
80299;1294,1385,1645,1285,1392,1345,1403,1404,186,571,1395,248,384,1367,1372;27;F
80301;977,938,251,1380,1046,856,644,1040,1627,916,1269,1522;43;F
80315;1380,384,1504,938,1391,1345,1048,1102,1304,634,1361,644,977,1386,1036;29;F
80337;1077,1627,1504,1040,1345,1522,1042,1285,1380,1102,1269,1391,251,1279,715;38;F
80342;1404,1403,1504,571,1077,384,1362,856,1102,1350,1042,1052,1391,251,1040;27;M
80352;1369,1048,1285,1269,1042,856,1367,251,1613,644,1522,1102,1077,1418,1372;32;F
80380;1613;44;M
80400;1385,855,1361,1042,1645,1539,688,276,1404,1391,1045,248,393;1;M
80401;1367,856,1102,186,1077,1362;40;F
80418;1077,1404,276,1522,1285,715;40;M
80421;856,1404,1627,1294,1504,1372,1385,1102,1645,1392,1048,1345,977,571,1367;16;F
80433;1392,1385,1294,1285,688,1345,1404,977,1279,1179,1627,571,248,1184,1367;39;M
80467;575,1304,1345,1279,1504,186,1627,571,1077,1418,384,1367,1372;32;M
80472;384,1627,186,1504,1279,1392,1645,1294,1385,1285,688,977,1372,1367,248;49;F
80492;856,1380,1048,251,1279,1367,393,916,1361,1102,1269,1040,1077,1395;39;F
80502;634,1042,1350,1046,914,1045,1395,1367,1036,1372,1043,916;7;M
80506;1046,575,1048,914,1045,393,1043,916,1376;41;F
80540;1350,1046,914,1052,1040,186,1627,1045,1395,1418,384,1036,1372,393,1361;39;F
80549;715;42;F
80553;1392,938,384,1372,1036,1362,1102,1345,644,1404,1403,1391,1627,248,1367;79;F
80554;571,1285,855,1269,1350,1102,688,1404,251,248,384,1367,1369,1372,1376;25;F
80558;575;25;F
80561;983,1345,856,715,1285,1522,1391,1279,1040,1627,1376;35;F
80563;1645,575,957,1345,644,938,1040,1627,384,1367,1184;30;F
80612;1040,1391,644,1345,1645,1385,856;39;M
80614;1102,715,1042,1269,634,1645,1077,1418,384,1367;10;M
80622;1036,384,1304,856,1048,248,1369;41;F
80633;1269,251,1040,1077;34;F
80669;1380,1304,1048,251,1279,1040;41;F
80690;1077,1380,856,393,1102,1294,1042,634,1304,644,251,1045,1395,1418,1362;46;F
80707;1350,1046,1380,1304,1040,1395,1418,1369;31;F
80720;1285,1392,644,1391,1376,1361,856,1269,1279,1040,186,571,1367;44;F
80765;856,715,1285,644,1391,977,914,1279,1040,186,1627,571,1367;33;F
80818;634,1539,688,276,1403,1404,251,977,1279,571,1077,248,1418,1367,1372;40;F
80826;914,1285,1361,856,1102,715,1042,1269,1380,1304,1522,1048,251,1077,1418;33;F
80862;248;69;F
80872;1102,1285,1404,1613,248,1362,1052,1269,1294,1645,1077,1045,1184,384,1372;28;M
80875;1036,1504,856,1269,1279;36;F
80878;1304,1345,1404,1040,1418,1361,1380,634,1522,914,1386,1395,1369,1376,644;52;F
80941;1380,1645,1367,1372,1362;47;M
80953;1539,644,1404,1367,1372;65;F
80954;856,1102,1380,1285,1345,251,1279,1040;24;M
80963;644,1386,1279,1504,914,1345,1627,251,715,856,1269,1285,1040,384,1367;32;F
80966;1395,1045,1386,251,1345,1304,715,1361,1385,1046,1042,1645,1077,1040,1036;41;F
80993;1627,186,1504,1040,1404,1345,1392,855,1385,856,1645,1285,938,571,1367;37;M
81000;1645;61;M
81014;1048,1345,1036,856,1102,1380,1391,1040,1627;48;M
81022;1367,1376,1361,715,1042,634,1645,1285,1048,644,1386,1279,1077,1036,1369;36;F
81025;644,251,1045,1522,1395,856,1040,1613;54;F
81034;248,571,977,1403,1404,1345,276,688,1392,1645,856,957,644,384,983;25;F
81036;384,856,1385,1294,1182,634,1645,1392,644,251,977,186,571,1367,1372;44;F
81045;1362,916,1285,634,1102,1522,1345,644,1279,1040,856,1042,1269,1380,715;39;M
81088;1403,1539,1285,856,1392,1345,1404,1391,977,1279,571,248,384,1367,1372;35;M
81112;1036,1369,1372,393,1362,1040,977,575,1522,1048,1285,1269,1391,251,1279;32;F
81113;1279,186,1627,571,1184,248,384,1376,715,1403,1404,977,1418,1367,1372;43;F
81114;575,1376;78;F
81135;1376,856,1385,1294,1645,1522,1345,977,914,1040,571,1418,1367,1372,393;41;M
81168;1350,1046,914,1372,1043,916;46;F
81176;1046,1285,1367,1036,916,715;35;F
81191;1380,1285,1345,644,251,914,1040,1504,1627,571,1418,1367,1369,1372,393;38;F
81224;715,856,977,1279,1367,1372;30;M
81226;1036,393,1102,1376,856,715,1391,1386,1077,1367,384,1043,1522,1361,977;30;F
81236;1395,1418,384,856,1102,715,1294,1404,1403,1391,1504,186,571,1367,1372;27;M
81264;575;55;M
81275;1361,856,1102,1385,1269,634,1285,1392,1304,1345,644,914,1279,1040,1367;41;F
81289;248,1367,1372;27;M
81349;1404,1403,1179,571,248,1102,1645,575,1345,977,1504,1627,384,1367,1372;32;F
81360;634,983,688;31;M
81377;1294,1645,855,1285,1345,1279,186,1369,1376,1102,644,251,977,1372,1362;49;F
81380;856,644,1367,1179;42;M
81381;1372,977,1279,1391,1345,1285,1645,1269,856;35;M
81391;1418,186,1040,914,977,938,1391,1285,715,393,1369,1279,248,1269,251;33;F
81394;1395,248,1042,856,977,1367,1046,1269,1285,1522,644,914,1418,384,1372;33;F
81395;634,1522,644,1077,1418;41;F
81411;1627,186,1504,1179,1279,914,1403,1404,1345,688,1539,1285,1042,856,1372;28;F
81426;1645,957,1345,1403,1404,977,1279,1040,571,248,384,1367,1372,1043,1184;30;M
81443;1522,1645,1102,1036,715,384,1385,1380,1362,1304,1048,1040,856,644,251;29;F
81444;1040,1367,1369,1043,715,1385,1380,1645,983,1304,1048,957,1386,1184,1376;68;F
81485;1361,715,1645,1045,393,1042,1285,1048,644;22;F
81489;393,1045,1627,1391,1345,1522,1645,715,856,571,1418,384,1367,1036,1372;51;M
81499;186,1627,1077,571,977,1403,1404,644,855,634,1269,715,1385,856,248;28;F
81500;856,1285,1522,1040,1077,1367,1362,1376,1350,1046,914,1045,1036,1043,916;41;F
81505;634,1042,1522,644,1045,1418,393;4;F
81551;1627,1372,1362,1391,1404,1403,1345,1392,1285,1645,856,977,1504,1279,251;29;F
81554;1042,1522,1048,957,1418,1036,916,856,575,1391,1040,1504,1077,384,1362;11;M
81563;1077,251,634,1350,644,393;8;M
81605;1102,1385,715,1269,1285,251,1279,384;29;M
81608;1627,1077,384,1362,1376,1304,1391,1418,1367,1345,1504,1372,644,1279,1269;31;F
81618;384,1372,1369,1376,1367,1418,1627,1345,1304,1285,1042,856,1279;36;F
81619;1504,186,1627,1045,1350,575,1285,1522,1391,1279,248,1418,384,1367,1372;31;M
81644;1102,1042,1048,644,1391,384;34;F
81648;634,644;46;F
81655;575,1392,1404,1504,248;33;F
81670;571;62;F
81685;1391,1285,251,571,1077,1043,1362,1367,1372,1418,1504,1627,1345,1522,644;34;M
81716;1102,855,1392,1539,1522,688,1345,1404,1391,977,1504,248,1418,1367,1372;35;F
81768;856,1040,251,1345,1048,644;33;F
81783;938,251,1404,644,1345,1048,1539,1304,1392,1380,715,1385,1102,856;36;F
81800;1102,688,644,1376,1367,1418,186,1279,1403,276,856,1042,1645,1285,1048;24;F
81839;1391,1404,1403,1040,186,1077,1184,1392,1372,1269;31;M
81845;1645,1522,1391,251,914,1043,1376,856,1102,1350,1046,1269,1279,1418,1367;37;M
81865;1380,251,1040;27;F
81872;186,1184,1269,1182,1345,1042,1522,1052,1077,1045,1372,1376,634,644,1369;36;F
81892;251,1391,1403,1404,957,688,1285,856,715,1042,1269,1036,1376,1040,1627;36;M
81899;983,957;43;F
81902;1345,1385,1102,856,1294,1645,1392,1391,251,977,1040,571,384,1367,1372;26;F
81915;1392,688,1345,977,1279,1504,1285,1522,644,1404,1403,571,1367,1372,1362;43;F
81929;1403,1391,977,914,1279,186,1627,571,1077,248,1184,1418,1367,1372,715;35;M
81973;1042,575,1392,1040,384;50;F
81978;1404,1403,1179,571,1645,715,1285,1372,1367,186,1279,977;45;F
81985;634,1042,1294,1102,856,575,644,1391,1179,1504,384,1367,1372,1362,1376;30;M
82010;856,855,1392,571;44;F
82035;715,1361,1385,644,1045,1285;41;F
82038;1380,634,1304,1522,1048,644,1391,251,1040,1077,248,1418,384,1367,1036;15;F
82039;1345,914,1372,644,1279,1627,1418,1367,1040,1522,1304,1392,1380,856,1385;55;F
82040;1522,644,1613,1504,571,1077,1367,1036,1372;47;M
82042;1613,977,1040,186,1418,1372,1362,856;17;M
82052;1504,571,715,1362,1345,1372,1367,1627,1279,977,1391,1385,856,575,384;33;F
82060;1350,1285,1048,644,916,1269;40;F
82071;1042,1645,575,1048,1404,1391,1040,571,384,1367,1372;28;F
82076;251,1613,1045,384,1372,1369,393,1345,1048,1042,1077,1102,1391,571,1418;29;F
82082;571,1392;22;F
82099;384,1391,688,855,1645,248;38;M
82105;977,1504,186,571,1077,1045,1395,1184,1418,384,1367,1369,1043,1376,248;24;M
82133;251,914,1040,186,1627,571,248,1418,1367,1372,856,1285,1522,644,1077;36;F
82185;1380,634,1048,1279,1040,186,384,1372,1376;24;F
82190;1522,186,1367,1385,571,1285,914,1279,1418,393,1184,1627,1040,1269,1362;35;F
82200;1404,1372,1539,688,575;34;F
82224;977,276,1391,1645,1042,1380,688,1048,644,1613,251,1045,1418,393,1043;42;F
82257;1645,1385,1504,1367,1043;37;F
82279;1361,856,1046,1042,1645,1522,1052,644,1391,1504,1077,1045,1395,1418,1369;7;M
82285;1052,644,1404,1403,977,1386,571,1077,248,1184,384,1367,1036,1372,393;26;F
82296;715,1077;38;M
82301;1345,644,977,1040,856,1102,575,1522,1404,1391,1504,1627,571,384,1367;26;M
82328;1361,856,1046,1042,1645,1522,1052,644,1391,1504,1077,1045,1395,1418,1369;3;F
82330;1361,856,1385,1350,1380,1645,1304,1522,644,914,1040,1504,1418,393;30;F
82337;1102,1392,644,977,1504,1627,856,1645,575,1345,251,571,384,1367,1372;28;F
82354;1361,856,1046,1042,1645,1522,1052,644,1391,1504,1077,1045,1395,1418,1369;;M
82426;715;47;F
82443;1350,856,1042,1522,957,1345,251,977,1040,1627,1184,384,1372,393,916;19;F
82452;575,1539,1522,251,1279,856,1345,977,914,1179,1504,186,1372,1627,248;52;M
82462;1404,251,1367,1372;29;F
82617;1345,251,1279,1052;23;F
82699;1361,393,1376,856,1042,1269,1645,575,644,251,1279,1040,384,1367,1372;31;F
82703;1367,1372,1102,855,1522,1403,1036,1539,983,1404,248;32;M
82726;1269;41;F
82748;248;71;F
82761;1418,1367,1036,1372,393,1362,1376,856,1385,715,1269,1522,186,571,1395;45;M
82767;393,1077,1627,1040,1345,1522,1304,1285,1645,1391,251,977,384,1376;42;F
82790;914,1504,688,938,1279,1385,1102,856,1285,1345,977,1040,1372,384,1367;40;M
82797;856,1045,1102,1350,1046,1522,1391,1613,914,1395,1418,1367,1372,1043,916;36;F
82799;914,251,1345,1304,1285,575,1645,715,1385,856,1102,1391,1040,384,1367;41;F
82824;916,1367,1418,1077,1645,634,1380,1279,1391,715;32;M
82839;1102,1627,1345,1522,715,914,1036,856,1269,1380,1304,384,644,251,1040;45;F
82843;1279,1040,856,1102,1385,1294,1645,575,1345,644,1504,571,384,1367,1372;35;F
82853;1367,251;37;M
82860;1285,251,1279,186,1367,1345,715,1385,1102,856,1294,1645,575,571,384;44;M
82873;715,571,1179;39;F
82936;1385,1042,1380,1645,1392,1304,1404,1391,1040,1627,571,1367;18;F
82987;571,914,977,1404,688,1539,1380,715,1385,856,1361,186,1367,1372,1627;30;M
83008;571,856,1102,1385,715,1645,575,1392,1345,1391,251,1504;59;F
83022;856;46;M
83041;1052,1048,1522,855,1645,1380,715,1385,856,1345,1391,1040,1372;25;M
83046;1380,1645,1285,1304,251,1279,1040,1395,384,1367,1376,1036,1369,1372,393;31;F
83068;571,1418,393,1294,1269,855,1285,856,1385,1304,186,248,1367,1372,1362;35;M
83160;1102,1042,1182,1645,914,1045,1367,1380,856,1269,1345,644,938,1040,1279;34;F
83169;938,1040,1045,1036,1369,1043,1376,1350,1042,1182,1048,1391,251,1077,248;48;F
83209;1380,575,1285,251,1279,1040,186,1627,384,856,1304,1345,644,1367,1372;22;F
83243;856,1367,1372,571,1385,1418,1392,1285,1345,1504,644,1627,1522,1269,1279;35;M
83251;856,1392,1045,1361,1350,1046,1522,1048,644,1627,571,1395,1367,1372;65;F
83302;1418,856,1182,1645,1522,251,1362;32;F
83345;1102,1361,634,575,1048,983,1052,644,1386,1279,1504,1184,384,1367,1372;46;F
83348;1645,1392,276,186,1627,1367,1372,1376,856,1102,1304,1345,571,1395,384;38;F
83367;856,1102,1380,634,1304,644,1391,251,1040,1036;62;F
83393;856,1372,1539,1504,1404,1403,1179;27;M
83405;715,1376;39;F
83420;1522,276,384,1045,1391,1048,1042;40;M
83421;1645,1361,1040,1304,1182,1102,1380,1362,856,1392,1345,571,1385,251,1367;35;M
83438;855,1285,1539,1404,1522,575,1645,856,1504,571,1418,1367,1372,688,977;30;M
83467;1361,856,1304,1380,1345,1391,251,1040,1504,186,1367,1372,1369,393,1376;56;F
83500;983;40;F
83504;384,715,1269,575,1345,977,1040,1504,1367,1372,1102,856,1522,1627,1418;39;F
83540;384,1367,1362,1613;30;M
83581;1391,251,977,1040,186,856,1102,1385,1350,1046,914,1045,1043,1036,916;39;M
83620;855,688,1048,1345,1404,1391,1040,186,1627,1418,384,977,644,1367,1372;34;F
83622;856,1102,1404,1372,1392;31;M
83623;575,384,1367;55;M
83640;634,1385,856,384,644,688,855,1362,1645,248;40;M
83660;1385,856,1380,1645,251,914,1279,1040,1627,571,248,1367,1372,393,1043;26;F
83679;575,1102,1645,1285,1304,644,1372,1361,1380,1522,1048,1391,251,1040,393;30;F
83682;855,1294,1385,856,715,1269,1285,977,1279,1504,186,1627,571,1367,1372;41;M
83736;1391,1345,688,1539,1294,856,1102,715,1285,1522,977,1279,1418,1367,1036;33;F
83780;384;33;M
83788;688,977;42;M
83796;634,1645,1304,1048,977,1386,1040,571,1418,1367,1036,1369,1372,393,1376;21;F
83805;1042,1361,1392,1539,644,1404,1403,977,1386,1179,1627,1395,248,1418,1372;36;F
83828;1077,856,1046,1045,1627,1179,914,977,1345,1403,957,1522,1102,1184,1418;32;F
83839;1350,1645,1304,251,1040,1627;36;M
83842;715;37;F
83878;1367,1392,914,1077,1182,1645,1279,1504,856,1385,1294,634,1345,644,571;46;M
83880;1102,1345,634,1522,1404,977,1386,248;70;M
83886;688,977;10;M
83888;1345,251,977,1386,1040,1504,186,1627,571,1077,1045,248,1367,1372,1036;28;F
83896;276,1367,1376,1369,1372,1627,1179,1386,1403,1404,1052,1392,855,1645,1042;28;F
83908;688,977;8;F
83953;1036,1372,393;26;F
83955;251,914,1040,1504,384,1369,856,1042,1269,1304,1048,1391,1613,1627,1045;34;F
83965;1645,186,715,1102,856,688,276,1345,644,1404,1391,251,977,1367,1372;44;M
83983;1279,1627,186,977,644,1345,575,856,1350,634,1285,251,938,1040,916;32;F
84092;384;67;F
84136;276,384,1361,1294,1285,1345,1279,248,1102,1392,1404,1403,938,571,1077;37;F
84229;644,575,634,1042,384;30;F
84331;1403,856,1392,1404;39;M
84334;644;45;F
84345;644,1504,1386,1362,1392,634,1380,1102,856,251,1269,1391,1279,1040,384;36;F
84355;1404,1179,1403;65;F
84366;1036,1040,1627,1077;25;M
84372;1102,575,1403,1504,186,571,248,1184,384,1613;21;F
84399;1392,1391,1077,715;39;M
84440;856,1042,855,983,1285,1539,1048,1345,1403,1279,571,248,384,1367,1372;35;F
84461;1362,1102,855,1392,1380,1304,1539,1404,1386,1179,1418,1367,1372,1376;39;F
84467;856,1285,1403,1179,1627,1367,1362;35;M
84472;1048,1304,1385,856,1285,1279,1040,186,1627,571,1418,1367,1372,1294,1269;35;F
84491;856,1645,251,977,1279,248,384;43;M
84531;1361,856,1645,855,1392,1304,1522,1048,644,977,571,1045,1395,248,1376;65;F
84538;1522,856,1269,1285,1392,1345,644,977,914,1279,1040,1627,1418,1367,1372;36;M
84560;1404,1403;35;M
84563;1385,1102,715,1042,1391,251,248,856,1645,977,1279,1040,186,1367,1372;32;M
84565;1645,1304,1048,276,644,1391,251,1040,1077,1418,1367,1036,1372,1362,916;39;F
84569;1380,1285,1404,1279,571,384,1367,856,855,1345,644,251,186,1362;40;F
84597;1645,1395,644,1285,393,634,1627,251,856,1367,1077,855,1345,1386,1504;27;F
84600;1391,251,1040,1077;27;M
84613;715,1376;38;M
84635;1367,1376;42;F
84666;1269,1179,248,1627,1539,1404,1403;39;F
84698;1350,856,1102,1645,855,1345,1386,1279,1040,1077,1395,384,1372,1376,1362;23;M
84706;1102,1269,1645,575,1285,1522,251,1279,1040,1504,1627,571,1367,1380,1613;31;M
84717;715;10;F
84743;1279,1504,186,1627,571,248,1184,1367,856,1294,1345,977,1372,1613,384;30;F
84761;1102,1269,1279,1040,1367;25;F
84767;248,571,1386,977,251,1403,1404,1345,1539,688,1392,1385,1367;23;M
84795;251,1040;24;F
84802;1613;48;M
84804;1046,1380,1285,1522,1391,251,938,914,1040,1077,1418,1036,1369,1043,916;39;F
84828;1539,1404,1403,1179,1627,248;39;M
84897;856,1361,1179,1040,1627,1372,1376,1367,1184,248,571,977,1294,1102,1285;26;M
84909;1385,856,186,1367,855,977,688,1179,571,248,1372;40;F
84964;856,1385,1269,1645,1285,977,1279,1040,384,1367;33;M
84972;1304,1345,1391,938,1627,1376,856,1645,644,251,1040,1504,1418,1367,1372;29;F
84986;715;39;M
84990;1367,186,1522,856,715,1504,1077;13;M
85015;856,1102,1269,1645,1285,1522,1345,1279,1040,1362;37;M
85189;1269,1345,1404,1403,571,1376,1285,575,1645,977,1279,1504,248,384,1367;38;M
85205;1380,1040,1627,1345,1182,1042,1522,1077,644,1048,1367,1504;39;F
85212;1285,1345,1391,715;40;M
85219;1345,855,1385,856,1102,1269,1380,1285,1304,1391,914,1279,1040,1077,1367;44;F
85278;1367;33;F
85279;1380,715,1522,914,1362,856,1269,1285,644,1279,1040,1627,1395,1367,916;41;F
85294;1285,1392,1522,1048,1391,977,914,1279,1040,1504,1418,1367,1036,1372,393;31;F
85307;983,1392,1539,1345,1404,1403,1367,856,1102,1391,251,977,248,384,1372;37;M
85314;1350,1036,1043,1376,1380,634,575,1392,1048,186,571,1369,1645,644,384;50;F
85365;644,248;37;F
85411;1345,1404,1613,977,1386,1040,1395,1369,1376,1042,634,644,1627,1036,1362;26;F
85433;571;27;M
85453;1367,1418,186,251,1522,1102,1645,1052,1345,1391,977,1040,1504,384,1372;26;F
85460;1376,1361,634,575,1285,914,1279,1627,571,248,1036;35;F
85468;856,715,1522,644,1391,251,186,1627,1077,1418,1367,1362,916,248;12;M
85481;856,1345,977,1504,186,1627,571,1367,1372,634,1645,1048,644,251,1040;34;F
85498;856,1367,1385,1395,393,1380,1048,1052,1345,914,1504,571,1045,1036,1613;14;M
85516;1285,575,1361,1269,251,1040,1504,186,1077,1367;30;F
85547;1269,1522,644,1391,977,1627,571,1077,248,1418,384,1367,1372,393,1362;39;F
85553;1539,644,1404;42;F
85555;983;33;F
85559;856,1102,715,1380,251,571,1367,393,983;41;F
85587;248;57;M
85601;1504,571,1367;36;M
85662;715,856,1380,1269,1285,1522,644,914,1279,1040,1627,1395,1367,1362,916;45;M
85716;384,1045,186,1395,1036,856,1385,1380,1052,1613,914,1504,571,1367,393;51;F
85725;1385,1102,1269,1504,1077,1367,856,1294,1392,1391,1613;45;M
85739;1304,1182,1046,1350,856,251,1040,1043,916;39;F
85754;856,715,1269,1380,1285,1522,644,914,1279,1040,1627,1395,1367,1362,916;8;M
85759;715;45;M
85780;1102,1350,1269,1391,1279,1418,916;39;M
85806;1361,1182,1392,1279,1077,1376,1522,644,1040;43;M
85828;571,1395,1052,1345,977,856,384,1385,1380,1613,1504,1045,1367,1036,393;63;M
85844;715;10;M
85849;1345,1403,1504,1627,248,1372,1645,1404,1391,977,571,1395,1418,384,1367;65;M
85865;1627,644,1392,1380,634,1304,856,1269,1645,1345,1279,1504,186,571,1367;17;M
85898;1102,715,1285,1522,1345,1504,1418,1367;38;F
85899;1269,1304,251,571,1418,1372,1376,393,1361,1350,1504,1077,1367,1043,1345;34;F
85914;1046,1048,1369,1102,1350,1304,251,914,1040,1077,1045,1367,1372,1043,916;42;M
85917;1392,1404,914,1372,715,1042,1052,276,1345,1403,1613,571,1077,384,1036;21;M
85919;688,1345,1403,1404,1040,1184,1418,1385,1645,1504,571,248,384,1367,1372;24;M
85924;384,688,1042,1539,1403,1404,977,1040,1179,1372,1376,248;30;M
85983;1627,856,1102,1042,1392,1522,1345,644,1391,251,1077,1418,1369,1362,1613;40;M
85985;856,1294,1391,1613,1392;32;M
86033;977,1372;31;M
86099;644,1385,1102,1392,1522,1391,1279,1504,1627,856,715,1285,1418,1367,1372;39;M
86110;251,644,1361,856,1102,1304,1367,1504,1372,1376;24;M
86120;634,186;26;F
86133;1294,1285,1404,1392,1504,1345;32;M
86138;1385,1102,575,855,1285,1048,1361,856,1380,1392,1391,1613,1040,1504,1036;23;F
86151;983,957;30;M
86154;856,634,575,1392,644,1391,1504,1627;54;F
86176;715;45;M
86180;1285,1522,1391;30;F
86197;1385,1294,1645,1285,1345,1404,1403,1613,977,1279,186,571,384,1367,1372;37;M
86215;644,1279,1367,1372;47;F
86238;856,1182,1645,1391,251,1627,571,384;43;F
86256;1048,1372,1269,1392,1504,644,938,186,571,1077,248,1184,1367,634,1385;30;M
86260;1376,1077,186,1042,1046,1380,634,1304,1522,1345,644,251,1040,1372,1362;54;M
86272;1385,1042,1380,1304,1613,1367,1627;19;F
86307;1367,1418,1504,1279,977,1345,575,1372;9;F
86334;977,914,1279,186,1627,1372,1392,1539,1404,1403,251,1179,1504,1367,1376;34;F
86343;1269,1504,1367;51;F
86360;977,248;47;M
86397;856,1385,1645,1392,644,1391,977,914,1040,1627,571,1418,384,1367,1372;68;F
86439;1522,1048,1345,251,977,914,1040,1627,571,1077,1367,1036,1372,1376,575;43;M
86440;575;43;F
86446;1645,1279,1077,384,1294,855,1285,644,186,571,1367,856,688,248,1362;31;F
86465;856,715,1269,1522,1345,644,1391,977,1627,1418,384,1367,1372,1362,916;5;M
86474;1376;32;F
86499;384,1367,1372,1362,856,1385,1294,1391,571;43;F
86507;1645,1392,1391,977,1279,1504,186,571,1395,248,1418,384,1367,1372,1362;21;M
86550;393,1102,1380,634,1304,1522,644,251,1040,186,1395,1418,384,1367,1369;36;M
86561;1645,688,1048,276,1404,1391,251,977,1386,1040,571,1077,1372,1369,248;47;F
86577;1376,1102,1380,1645,1345,644,1040,1504,248,1372;31;F
86587;1345,1522,1294,1385,1102,856,1350,715,855,1392,1627,571,1077,1418,1367;36;F
86610;856,1613,1036,1102,1380,634,1304,1345,644,1391,977,1040,1395,1372,1362;54;F
86634;856,855,1392,1404,251,1279,1040,1504,1102,1345,1391,977,186,1627,1367;36;M
86656;715;12;M
86660;715;40;F
86664;1285,644,1613,977,1279,1040,1376;37;M
86671;1345,977,1294,715,1102,856,1362,1372,1367,1418,1077,1179,1279,1391,1269;42;M
86675;715;57;M
86682;1350,1046,1380,575,1391,251,938,914,1040,1504,1367,1372,1043,1362,916;40;F
86687;1350,1046,914,1045,1036,1043,916;47;F
86694;1043,1361,634,1418,1392,1539,644,1403,1404,251,1179,1504,248,1372,1362;25;M
86707;384,1269,186,1380,1102,575,1285,1304,1345,644,977,1279,1504,1627,1367;38;F
86748;715;10;M
86761;1042,575,1048,1391,977,914,1386,1102,1036,634,1403,1404,1040,384,1372;34;F
86762;384,1645,715,856,1361,1102,634,575,644,251,977,571,1367,1369,1372;28;F
86763;1077,1279,1285,1294,1392,1539,688,276,1345,1403,1404,571,977,1367,248;50;M
86778;1392,571,1285,1380,251,1367,914,1385,1304,1279,1645,938,634,644,1376;29;F
86810;688,1403,1404,384,1372,1294,1102,856,1645,1392,251,1040,1279,571,1367;33;M
86838;715,1392,644,186,1077,856,1385,1042,1052,1345,251,977,1279,1367,1372;52;M
86855;1269;43;F
86856;644,1040,384;32;M
86907;1304,855,1380,1269,1294,1361,856,1385,1645,1392,251,1279,1040,571,1367;38;F
86913;1403,186,571,1418,1385,1367,1627,1522,1285,856,1269,914,1279;41;M
86915;1046,914,1045,1036,1043,916,1350;46;F
86919;248,1418,1372,1376,1269,575,1504,186,983,634,1522,1040,571,1367,1184;37;M
86943;715;50;M
86970;1077,384,1362,1367,1627,1504,251,1522,856,1269,914,644;40;F
87005;644,248,1418;27;F
87018;856,1294,1380,1304,1613,977,1040,1367,1372,1036;62;F
87020;938;60;M
87039;1522,251,1040,1077,1395,1367,393,1285,1645,1380,1269,715;43;F
87053;1380,251,1040,186,1627,571,1184,1372,1367;27;M
87055;1376,1279,1380,1182,251,1043,644,1102,1350,1418,1362,1042,916,1077,1269;8;M
87082;916,715,1361,856,1350,1380,1052,1392,644,1391,1613,914,1040,1036,393;80;F
87093;1042,715,1102,1040,384,1367,1372;29;F
87100;1627,1077,1045,1395,384,1372,1369,1380,1048,644,1391,1613,1040,393,1043;41;F
87106;1392,1345,1404,1403,1391,1386,1040,1627,571,1367,856,1380,855,1304,644;54;M
87191;1285,688,1404,1403,1279,1504,186,1627,571,248,1184,1367,1372,856,1102;41;M
87197;186,571,1627,1040,1403,1404,1052,1269,1294,1361;30;M
87223;1046,856,1102,1350,1042,1645,1522,1391,251,914,1040,1504,1045,1418,1372;38;M
87381;186,1504,715,1350,634,1522,644,1077,1045,248,1367,1036,393,1043,916;37;F
87382;856,251,1040,571,1367;37;F
87417;1504,1627,1418,1362,1102,856,1269,1380,1285,1304,1040,251,1279,1367,1376;39;M
87434;1285,1345,1367,1372,1504,1043,393,1627,1361,1042,688,1048,644,977,384;22;F
87465;1392,1522,1418,1367,644;38;M
87486;276,1345,1404,1403,1391,1040,1504,1627,571,384,1367,1036,1369,1372,1043;20;M
87529;1048,634,1042,1350,1361,856,1645,644,1179,571,1395,384,1367,393,1362;43;M
87569;393,1362,1645,634,1361,1102,1042,575,1048,1036,1627,1504,186,1395,1376;27;M
87572;1391,1285,715,856,1042,1269,1380,634,1304,644,251,938,914,1040,1376;23;F
87588;1102,1048,1052,276,644,1386,571,1395,1418,1367,1036,1369,1372;24;M
87590;634,575,1304,276,1386,983,957,1391,384,1184;33;M
87630;855,1102,1361,856,1385,715,1294,1645,1392,1345,644,251,914,1040,571;52;F
87634;1369,1036,384,1367,1627,1504,1279,1391,1392,1361,856,1269,1380,575,251;30;F
87695;1380,634,1042,715,1350,914,1418,1367,1372,1102,1345,1522,688,276,1077;44;F
87703;715;10;F
87707;1345,1392,1285,1269,1042,1294,715,1385,1645,644,977,1279,571,384,1367;36;F
87710;1285,1052,644,1279,1040,1367,1504,251,856,1102,1645,1392,1345,1391,571;47;F
87737;1102,276,1372,248;58;M
87777;1345,1042,1380,634,1645,644,1404,1403,251,977,1279,1040,1372,1043,1376;30;M
87782;1304,634,1102,856,1361,1269,1380,1285,251,914,1279,1040,1504,1627,1036;22;F
87818;1367,384,1385,1182,575,1077,914,644,634,1042,1294,715,1102,856,1418;35;F
87853;571,384,1362,248,1403,644,1294,1385,1102,856,1645,1285,1279,1418,1367;46;M
87858;1345,977,1367,1269,1350,1046,1048,644,251,914,1045,1395,1036,1043,916;41;F
87872;1042,1345,1372,1045,571,634,1380,1102,856,1269,1386,1279,1367,644,251;41;F
87875;1385,1285,1539,1279,186,571,1045,248,1418,1504,1391,1404,977,1367,1372;43;M
87876;715,1269,1392,1522,634,644,186,1627,248,1367,1362,977,1385,855;5;F
87891;1362,1350,1046,1269,1048,1345,644,251,1045,1395,977,914,1036,1043,916;44;M
87910;1361,1385,1269,1380,1645,1285,1304,251,1040,384,1367,1036,1372,1362;40;F
87948;856,1269,855,1285,1522,688,276,1613,977,1391,251,1627,983,957;41;M
87979;1042,715,1385,1392,1504,1345,1418,856,977,1372,1627,1380;36;M
88009;856,1102,1350,1345,1391,251,977,1077,1418,1367,1372,1504,1392;31;F
88035;644,248,276,634;48;M
88074;1645,1304,1391,1279,1040,1077,1367,1372,393,1362,916;43;M
88105;1539,1285,1042,1385,1102,1392,1522,1345,251,977,186,571,1418,1367,1372;31;F
88132;1042,1182,1404,1403,251,1372,393,1362,715,1418,1367;37;F
88149;914,571,1418,916,856,1294,1645,1345,1391,977,1040,1077,1367,1372,1362;47;M
88188;1102,1522,251,1418,1372;34;F
88238;186,1279,1539,1285,1269,1294,1385,1645,688,1404,1403,977,248,384,1372;41;F
88245;983,957,251,1504,384,1184;32;F
88249;1102,856,1361,1418,1077,1042,715,1285,1345,644,251,1279,1367;40;M
88308;1269,1522,251,384,1102,644,1040;41;M
88325;856,1380,1385;46;F
88357;715;34;M
88362;715;30;F
88392;1102,1042,1522,251,1040,1279,1269;34;F
88428;634,1042,1294,1304,1048,1345,1369;36;F
88452;1380,634,575,1392,1304,644,251,977,1040,1504,1627,1395,1418,1046,1522;39;F
88459;1077,1350,1046,914,1040,1045,1036,1043,1362,916;38;F
88464;1372,1102,856,1269,1279;30;M
88503;977,1345,1385,1102,1042,1269,1645,1285,1048,1279,1040,384,1367,1043,1376;31;F
88508;1269,1285,1392,1522,1345,914,186,1077,251,1504,1627,1418,1367,856,1279;36;F
88515;715;40;F
88524;248;52;M
88540;1367,575,1285,1345,1279;36;M
88567;1645,1627,1613,1504,1392,1380,1362,1345,1285,1040,856,644,251;27;F
88595;856,715,1042,1285,644;8;M
88600;1036,248;61;F
88633;1645,1539,1392,1522,1613,1294,644,1504,1279,571,248,1367,1372;42;F
88651;1345,644,856,715,1294;11;F
88655;1380,1395,1361,1269,634,1522,644,1279,1077,1036,1369,393,1043,1418,916;36;F
88670;983,1279,1522,1627,1045,1367,1391,644,1392,856,1102,1269,1345,1613,1077;48;M
88674;1613;46;F
88701;938,1392,634,856,1380,1304,644,1613,251;39;F
88711;1042,1645,1304,1522,688,1052,644,977,1504,186,248,1418,384,1367,1372;12;F
88772;1645,1627,1613,1504,1392,1380,1362,1345,1285,1040,856,644,251;30;M
88794;1102,634,855,1048,1404,251,938,571,384,1036,1043,1376;51;F
88807;983,575,1279,977,688,1294,1285,1627,1504,1367,186,1391,957,384,1184;55;F
88850;251,1040;30;M
88923;1077,1045,248,1369,393,1179,186,1418,1367,1036,1372,1102,715;53;M
88955;1042,1048,1504;21;F
88973;1294,1645,1279,1504,1362,634,715,1269,1392,1179,1403,1404,1285,248,1367;52;F
88991;384,1627,856,1102,1042,1269,1285,644,1391,914,1279,1040,571,1077,1367;4;M
88995;715;39;F
89012;1613;24;M
89024;715,1522,1345,977,186,1627,571,1418,1367,1077,1372,1362,856,1385,1294;39;F
89048;1102,1345,1627,1522,1504,856,1392,1391,251,1279,1040,384,1372,1369,393;40;M
89053;644,1627,1361,1102,715,1380,1345,251,977,1040,571,384,1367,1376,1372;30;M
89068;1392;29;M
89072;914,1040,1504,186,1627,571,248,1184,1418,384,1367,1369,393,1043,1376;21;F
89077;1372,1345,1048,575,634,715,1042,1645,688,1052,644,248,1367,384,393;49;F
89078;1404,1392,1285,1269,634,1522,1345,644,1391,251,914,1279,1418,1367,1372;37;M
89104;1102,856,1376,1504,914,977,1391,1345,1539,1285,1645,1042,1404,248,1372;22;F
89127;1102,1385,1380,1304,644;42;F
89143;1269,634,1285,1392,1522,1345,644,1404,1391,251,1279,1418,1367,1372,393;37;F
89160;384,1380,1042,644,251,1367,1045,1372,1418,1350,1046,914,1036,1043,916;41;F
89207;856,1046,1350,1294,1042,1380,1304,1522,644,914,1040,1077,1045,1418,1362;44;M
89228;1294,1645,1285,1539,688,1404,1403,977,1279,186,571,248,384,1367,1372;48;M
89253;1613,1279,1361,856,634,1304,1048,1391,571,1040,1367,1645,644;30;F
89258;251,1404,983,855,1294,715,1385,1102,856,1269,1522,1345,1391,1279,1077;35;F
89262;1285,393,856,1380,1048,644,186,1279,1367,1043,634,1304,251,1040,571;34;F
89270;1269,634,1645,575,1522,251,1279,1285,644,1391,384,1367;35;M
89284;1345,1404,1391,384,1367,1392,855;21;F
89330;1367,1376,575,1645,1380,1269,856,1102,1285,1279,1395,384,1391,251,1040;31;F
89332;856,855,957,1404,1391,1627,1367;38;F
89335;1386,1418,384,856,1102,1645,1345,1391,1627,1361,644,1504,1367,1369,393;68;F
89360;1385,1294,1380,1645,575,1392,644,571,1376;46;F
89374;634,1392,688,977,1279,1040,186,1627,571,1367,856,393,1404,1362;39;M
89402;1385,856,1392,1522,1345,977,1504,186,571,1077,1418,384,1367,1372;31;F
89403;856,1269,1285,1392,1522,1345,251,914,1279,1504,186,1627,1077,1418,1367;5;M
89404;856,1102,1269,983,1392,1522,1345,644,1391,1613,1279,1627,1077,1045,1367;47;F
89408;1645,1304,644,251,1386,1040,1627,571,1036,1376;69;F
89456;1645,1372,393,715,1386,1042,1350,1048,1052,1045,1392,251;32;M
89457;1372,1418,1380,251,856,1376,1627,1345,1392,1522,1504,644,1391,1279,1077;32;F
89464;1042,1350,1046,575,914,1040,1504,1045,1036,393,1043,916;10;M
89527;856,1269,1285,1392,1522,1345,251,914,1279,1504,186,1627,1077,1418,1367;;M
89551;856,1102,1645,571,1367,1385,1294,1380,1304,1522,1391,1386,1395,1362,1376;21;M
89561;644,1385,1376,1645,1504,248,571,1372,1367,1294,384;43;F
89564;856,1350,1046,1294,1042,1380,1304,1522,644,914,1040,1077,1045,1418,1362;47;F
89610;856,251,1345,1285;25;M
89614;1345,644,1403,914,1179,1369,1372,1361,1522,1404,1386,1504,1627,393,1418;32;F
89630;856,1269,1285,1392,1522,1345,251,914,1279,1504,186,1627,1077,1418,1367;36;M
89642;1102,1269,251,1279,1040;33;F
89653;1385,856,1294,1645,644,571,1395;49;M
89704;856,1645,575,1392,1304,644,251,914,1279,1040,1504,384,1369,393,1376;45;M
89737;1539,1294,1042,1522,1392,856,1285,1367,1350,1046,914,1045,1036,1043,916;41;M
89747;856,1385,1522,1613,571,248,1372,1362;51;M
89750;1627,1285,1345,1279,1040,1504,1077,1046,1269,1380,1304,644,251,1369,1376;45;M
89751;856,1102,251,1040,1418;31;M
89756;977,1386,1279,1504,1077,1418,384,1367,1372,1376,1102,1522,1048,644,251;21;F
89764;715,1285;63;F
89803;1042,1350,1386,1645,1285,1345,1391,1613,1045,384,1367,1504,1040,1269,644;36;F
89819;1269,575,1285,1539,688,1345,644,1404,1403,1391,251,977,1367,1372,393;29;F
89825;384,1279,1385,715,1042,1645,1285,1345,644,571,248,1418,1367,1372,1376;46;M
89828;1269,575,1522,251,1179,1504,186,1376,1392,1539,1048,1345,1404,1403,1627;38;F
89878;1102,856,1385,1294,1380,1645,1304,1522,1391,1386,571,1395,1367,1362,1376;54;M
89896;1102,1391,251,1040,1362,1376,186,1285,1269,1279;38;M
89912;1392,251;37;F
89940;276,1391,1077,1395,1269,914,644;43;M
89968;1304,1048,1391,251;39;F
89976;384,1403,1361,634,1645,575,1392,1048,1345,644,938,1504,186,571,393;39;F
90013;1404,248,1042,1294,1102,1361,634,251,1040,186,384,1367,1369,1372,1362;23;M
90038;1392,1042,1645,1285,1391,914,1077,977,1269,1418,1385,575,1102,1627,251;36;M
90056;1279,1042,856,248,1385,1294,1645,1285,1392,1404,1403,186,571,1045,1367;56;M
90059;1504,575,715,1385,1367,1279,977,251,1391,1404,1345,1392,1522,1285,1102;32;F
90070;856,1042,1048,1345,1391,251,186,571,1372,1043,1376,1392,1404,914,1367;39;F
90075;276,575,1627,248,384,1372,1367;25;M
90079;1522,856,1385,1613,571,248,1372,1362;78;F
90084;251,1386,1279,1040,1627,571,1077,1395,1418,1367,1372,1043,1269,1294,856;30;M
90089;251,977,1386,1179,1504,1627,384,1369,1376,1102,1645,1404,1403,1036,1372;38;M
90118;1504,575;35;M
90124;1395,1369,393,186,1418,1367,1391,1102,644,715,856,634,251,1040,916;42;M
90129;1385,856,1179,1367,1279,251,1102,1392,1345,1404,1403,1504,571,1077,248;30;M
90142;251;28;F
90176;1385,1645,1285,1392,1403,1404,1279,186,248,1418,1367,1372;24;M
90230;715,856,1102,1645,1539,1285,1345,1391,251,1504,186,1077,1418,1369,1372;29;M
90244;1040,1367,856,1269,1285,1392,977,1504,1418,1304,1613,251,1279,1372,1362;51;M
90247;644,1391,1077;42;M
90262;1645,1392,1613,1627,1367,1036,1102,1380,575,1304,1391,251,1040,1504,1372;28;F
90265;1269,1285,1392,1304,1345,644,1404,1403,977,1279,1040,1077,1418,1367,1372;46;F
90269;1285,1522,1391,977,1077,1418,1102,715,1042,1645,1048,1345,644,186,1367;39;F
90294;977,914,1279,1504,186,1372,1077,1367,1285,1345,1404,1403;39;M
90297;1522,1077,1391,1385,1345,1367,1372,1418,571,1504,977,1392,1269,1285,1279;33;F
90334;1350,1046,914,1045,1036,1043,916;44;M
90335;1385,1645,1392,1391,1627,571,1077,1345,1362,1350,1294;30;M
90359;1102,1046,1380,1304,914;27;F
90372;1102,1645,1304,914,1504,384,1376;27;F
90374;1269,1285,1279,1504,384,916,1361,715,1042,1048,251,186,1418,1043,393;63;F
90376;1391,1077,856,1385,715,1269,1285,1345,1279,1504,186,571,1418,1367,1372;36;M
90382;1372,914,1613,1380,1046,1102,856,977,1040,1627,1077,1418,1304,1522,1391;37;F
90385;983,957;35;M
90393;856,715,1269,1392,1522,1345,251,977,1279,1040,1504,1418,1367,1372,1362;54;F
90427;1077,1392,1391,715,977,1279,186,1367,1418,571,1345,1285,1269,1385,856;3;F
90514;1304,1369,1269,571,1045,1367,856,1102,1042,1645,644,1504,1613,1279,1418;40;F
90531;1102,1392,1539,977,1627,1418,384,1367,1372,634,1040,251,1179,1404,1403;19;M
90538;1102,856,1376,1367,1504,938,251,1404,1052,634,1042,715,1380,1362,1372;24;M
90539;1645,1294,1385,1285,1403,1404,571,1367,1372;41;M
90544;384,1627,856,1392,1522,1504,186,1043,1385,1294,1345,1391,977,1418,1372;65;F
90556;571,186,575,1385,1046,1345,1522,856,1279,1418,1269,1285,688,977,1372;40;F
90567;715;38;M
90574;1042,1385,1102,856,1645,575,1404,1391,1504,571,384,1367,1372,1043,1362;70;M
90586;715;40;F
90591;715;9;M
90602;715;8;F
90610;644,1304,1285,634,1385,1102,856,1522,251,1279,1040,186,1627,1418,1367;39;F
90638;856,1645,855,1052,1040,1367,1362;23;M
90728;1048,1345,644,1391,977,1040,1627,1362,856,634,251,1077,1367,1036,1372;38;M
90734;856,1645,1392,1391,251;43;M
90810;186;50;M
90837;575,571,1367;45;M
90844;1403,186,1369,1361,1385,1645,1304,1539,1040,571,248,384;53;F
90891;1182,634,1522,1048,1345,644,1404,1613,938,1386,1040,186,571,1077,1367;53;F
90893;1504,1179,1345,688,1539,715,1385,856,855,1392,977,571,1367,1372,1362;30;M
90902;855,1345,644,1404,251,977,1504,1395,248,384,1367,1036,1369,1372,1376;50;F
90905;856,1391,1102,575,384;46;M
90932;1042,688,977,1367,1372;22;M
90938;856,1372,1392,1404,977,384;26;M
90965;1042,1380,634,1645,575,251,1040,1376;29;F
90979;1392,983,384,1372,1102,644,1391;45;F
90993;1184,248,571,715,977,1403,1345,575,1269,1294,1385,1285,1404,1279,1504;38;F
91025;1294,1285,1392,1539,1345,1404,1403,977,1279,571,248,1184,1367,1372,1362;28;M
91030;856,1102,575,1304,1345,644,914,1504,571,1418,1367,1036,393,1362,1376;23;M
91078;186,856,715,1380,1645,1304,1522,644,1391,251,938,914,1040,384,1367;38;M
91084;251,1504,1269;38;M
91110;1102,1391,1279,1045,644,715,1380;59;F
91168;384,1369,1043,1362,1376,634,855,1522,251,1367,393,1042,186,1418,1372;43;F
91176;1269,1522,1345,251,1279,1040,1504,1077;34;M
91185;571;53;M
91229;1385,856,715,1539,1048,644,977,1040,186,248,1418,384,1367,1036,1372;18;F
91258;1042,938,1077,1372,1539,715,1627,1392,1504,1404,1179;37;F
91280;1362,1369,251,1391,644,688,1522,1385,1102,1361,1372,977;34;F
91295;856,1046,715,634,1522,1504,1627,384,1102,1042,1367,1372,1043;28;M
91300;1294,1395,1077,571,1391,644,1385,856,1052,1392,1285,1645,1182,715,1376;64;F
91306;1350,914,1504,1045,1395,384,1367,1372,393,1043,1269,1645,1392,1522,644;41;F
91348;251,186,1627,1418,1385,1645,1504,1367,393,688,1345,1077,384,1372,1362;38;F
91352;1269,1294,1385,715,1645,977,571,248,1367,575,1285,1345,251,1279,1504;39;M
91377;1418,1043,856,1042,1522,1052,276,251,938,1040,1504,571,1077,1045,1367;29;F
91392;1294,1269,1645,575,1285,1539,644,1404,1403,977,1279,1504,248,384,1372;32;F
91449;1048,1522,1392,1285,1042,1385,1645,1269,1294,856,186,1418,1367,1372,1376;37;F
91491;1392,644,856,1269,575,1052,1345,977,1279,1504,1627,1418,384,1367,1372;31;F
91526;1048,1380,634,1392;20;F
91537;1522,1345,644,977,1627,1418,1367,1372,1269,1285,1048,251,1279,1040,393;37;F
91538;1504,571,1077,856,575,1285,1369,248,1418,1372,1279,1269,715,1102;38;M
91571;1404,1403,1179;39;M
91636;1102,1391,1077,1362,1504,1522;42;M
91665;1372,1102,1539,1404,1403,1179,1504;34;F
91722;251,1367;38;F
91770;1269,1279,1285,575;31;F
91815;977,1391,1522,1645,634,715,1385;34;F
91826;1367,251;6;M
91850;715,1385,1102,1350,1042,1539,688,1404,1391,251,977,1367,1372;31;M
91901;1645,688,977,248,1367,1362,1304,276,644,251,1504,186,384,1372,1376;27;F
91923;384,1362,644,1052,1048,1392,634,1380,1042,856;47;M
91940;1391,1345,1102,1042,1645;54;F
91971;1645,1418,1372,1376,1380,1285,1048,1345,251,1367,1369,1361,1102,1304,1040;52;F
91972;856,1269,1645,1522,1345,1613,1279,186,1627,571,1077,248,1367,1372,1418;41;M
91975;1345,1052,1522,1392,1102,715,1285,644,977,571,1077,1045,1367,1372,1362;43;F
91979;856,1102,1304,1345,644,1391,977,1040,571,1367,1036,1372,393;46;F
92023;856,1102,575;33;M
92040;1380,1304,644,1391,1386,1036,1372,1376;67;F
92056;1040,1392,856,1077;59;F
92118;1179,1418,1391,977,1386,1627,1361,1182,1392,1345,1403,251,186,571,1369;50;F
92146;1392,248,1372;56;F
92148;1403,1404,1269,1285,571,248,856,1385,1345,977,1279,186,1367,1372,1362;34;M
92162;1048,856,1102,715,1380,634,1285,1345,644,251,938,1040,1504,384,1367;56;F
92171;384,856,1102,1391,1279,1077,1367,1372;16;M
92181;856,1350,1046,1294,1042,1182,276,644,1391,1613,1077,1395,1418,1367,1362;41;M
92201;1380,1372,1367;24;F
92264;856,1042,1418,384,1367,571;25;M
92296;1380,1522,251,1392,1369,1372,1345,1385,571,1418,1376;35;F
92348;1522,715,634,1418,1367,1385,644,571,1077,1102,1391,1645,1182,384,856;40;F
92364;1627,1040,1386,1391,1392,1046,856,1380,1304,1522,644,251,914,1418,1367;35;F
92389;1077,1645,1040,1522,1392,571,251,644,1504,1380,856;32;F
92524;983,957;57;F
92547;1391;28;F
92557;1504,276,393,1040,914,251,644,1391,1048,855,1380,1042,575,384,1362;27;F
92560;1046,1269,1304,914,1627,1042,251,938,1279,1040,1504,1102,1367,1036,1376;31;F
92579;1040,1279,938,1403,1304,1285,983,1380,1294,856,251;28;M
92615;276,644,251,1040,856,634;34;M
92632;1042,1294,715,1361,1102,856,1385,1304,1380,1645,1048,977,1627,571,1372;42;F
92636;1372,1367,384,1418,1504,1042,715,1269,1645,1285,1522,251,977,1040,1627;39;F
92645;1042,715,1385,1102,856,1380,957,1345,1391,251,1184,1418,1367,1372,983;40;F
92650;1269;34;M
92680;1361,1645,575,1304,1048,251,977,1504,1367,1036,1369,1372,393,1043,1376;25;F
92701;715;38;M
92727;1418,1367,1385,1345,1404,1372,571,1279,977,1613,1392,1285,1645,1294,856;42;F
92737;1269,1372,644,856,1350,1046,1613,914,1045,1036,1043,916;39;M
92740;1418,571,1040,914,1345,1182,1294,251,1391,1385,856;35;M
92747;1102,1294,938,1504,186,571,248,1367,1036;32;F
92755;384,1376,856,1385,634,1645,1392,644,1404,977,571,248,1367,1372,393;54;F
92779;1102,1539,688,276,1345,1404,1403,1391,977,1279,186,571,248,1367,1372;47;M
92787;715,1522,1042,1269,634,1645,1345,644,977,1077,1418,384,1367;43;M
92806;644;49;F
92846;715,1504,1391,1345,1102,1077,856,644;43;M
92847;855;33;F
92861;575,1645,856,1102,1385,1294,1285,688,977,571,248,384,1367,1372,715;24;F
92928;248,186,1279,977,1391,1403,1404,1345,276,688,1392,1285,1269,1385,1102;48;F
92955;1285,393;42;M
92991;1369,1386,251,644,1522,1042,856,1361,1380,855,1304,914,1040,1395,1362;31;F
93044;634,856,1350,1046,1361,1345,977,1627,1418,1367,1522,644,916,1613,914;59;F
93047;1403,1404,1392,1179;38;M
93105;1613,1040,1077,384,1043,977,644,1522,856,1350,1042,1645,1045,1418,1372;39;M
93140;1040,186,1627,571,1042,1304,1345,251,1418,1367,1048,1522,1182,1102,856;30;F
93142;1285,1645,1522,1391,1279,1627,1077,1269,1392,644,251,914,1040,384,1367;48;F
93206;1182,1046,1361,1385,1102,856,1043,1036,384,1179,1040,938,1403,1404,715;26;F
93213;1403,977,1279,1504,571,1627,1077,1418,1367,575,1102,1392,1404,1391,384;47;F
93256;1345,644,1391,1522,251,1040,1077,1367,1362,1372,1418,186,977,1102,856;41;M
93278;856,1102,715,1042,1395,1269,634,1645,1285,1391,1279,384,1040,644,1392;50;M
93296;644,1279;37;F
93311;856,1102,1645,1285,1392,1077,1367,1372,983,1539,1179,1404,1403,1391;51;M
93354;1285,1391,1279,1504;35;F
93357;715,1285,251,1279,1367;39;F
93385;248,1362,1345,688,1392,855,1645,634,1102,575,1404,1627,384,1367,1372;46;M
93387;1418,1367,1036,1362,1376,1361,856,1102,1042,1645,1304,644,1391,1395,384;34;M
93425;856,644,938,1279,186,1627,571,1077,248,384,1367,1036,1369,1372,393;36;F
93433;1077,1269,1350,644,1045;42;F
93452;1504,1102,1362,248,688,1539,1645,1613,977,571,1418,384,1367,1372,1376;44;M
93453;1627,977,1404,1052,1392,856,248;34;M
93463;1380,1040,1367,571,1385,644,1395,856,1392,1627,634,1345,1504,1645,251;31;M
93490;1367,1504,1372,856,1345,1404,1403,1279,715,186,1077,248,1613,957,983;30;M
93507;634,1304,1048,644,914,1386,393,1376,715,1392,1522,251,1418,1043,916;38;F
93530;1627,1369,1362,1385,856,1042,575,644,1391,251,571,384,1367,393,1043;54;F
93541;715;27;F
93557;977,1367,1372,1418,1040,1380,1269,1102,1350,1046,914,1045,1036,1043,916;36;F
93558;1362,393,1045,1040,1345,1380,1102,856,1350,1042,1046,1036,916,914,1043;40;F
93576;1645,575,1285,688,1404,1391,977,1279,1504,571,384,1367,1372;32;F
93611;1345,1404,251,914,248,1418,1362,1269,634,1285,644,1279,571,1077,1367;43;F
93647;1269,1042,1048,1052,977,914,186,571,1077,1045,1418,1367,1372,1043,916;37;F
93667;688,1539,1380,715,1385,1102,1391,977,1362,1404,251;31;M
93685;688;29;M
93689;1285,634,1380,1102,856,1391,977,1279,1040,1504,1077,1418,1367,1036,1372;22;F
93772;1645,1367;48;M
93790;914,938,1048,575,1361,1380,1304,1522,1403,251,1504,1179,571,1418,715;30;F
93823;1403,914,1040,1392,1182,186,1345,856,1385,1294,1645,1504,1627,571,1367;30;F
93857;715,1385,1102,1285,856,977,384,1376;35;M
93877;1385,276,1042,1522,938,1361,644,251,1376,1345,977,186,1418,1367,1269;40;F
93915;575,1279,571,1367,1385,856,1613,1372,1627,251,914,1345,1392,1504,1269;35;M
93932;983;47;M
93963;1522,914,571,1372,1613;59;F
93971;1294,1645,575,1279,571,1367;35;F
93984;983,1052,644,1504,393,856,1645,855,1404,251,186,248,384,1367,1362;33;M
94010;1404;33;M
94040;688,1345,1404,1403,1391,977,1279,1504,186,1627,571,384,1367,1372,1376;31;F
94069;1403,1345,1539,575,715,1102,1404,977,1077,1418,1372;27;M
94072;1645,1522,571,1392,1504,1627,384,1367,856,1102,1345,644,977,1391,1613;45;F
94107;856,1102,715,634,1645,575,1285,1391,251,977,1040,1504,1367,1372;26;F
94113;1372,1392,688,251,914,715,1380,644,1504,1385,634,977,1040,186,571;39;F
94117;1102,856,1367,1418,1040,938,251;24;F
94118;938,1386,1395,1369,393,916,1102,251,1040,644,1279,1613,1367,1372,1376;21;F
94136;1042,855,1392,1404,251,1367,248;30;F
94166;938,977,1077,1036,1043,1392,251,1042,186,571,1418,1367,1372,1376;40;F
94193;1040,1504,186,1627,571,1077,1367,916,856,1269,1380,1391,914,1279,1418;38;F
94202;1102,983,957,1184;41;M
94222;1102,1042,634,1345,644,251,1362,1372,1369,1367,1304,1391,1040,1504,575;43;F
94239;1376,384,1040,1345,1048,1285,634,1361,715,644,1627,1367;36;F
94249;1392,1294,1385,856,1361,715,1539,1404,977,1179,571,1077,1367,1369,1372;29;M
94276;1350,1046,1042,1380,1522,1048,914,1040,1045,1395,1036,393,1043,1362,916;8;F
94314;715,856,1380,1522,1042,1269,1392,1304,1048,1391,914,1040,1045,1418,1043;40;M
94350;1385,1102,1361,1042,634,276,1345,644,938,1040,1077,1043,916;44;F
94352;251,1386,1279,1040,384,1367,1036,1372;26;M
94383;251,1522,1042,1269,1380,634,1304,644,914,1279,1040,1045,1369,393,1376;36;F
94421;1362,1395,571,856,1385,1294;22;M
94457;856,1645,983,957,276,644,1404,1403,977,1279,571,248,1184,1367,1372;32;M
94483;1372,1361,856,634,1304,1522,1048,1391,251,1279,1040,1504,1627,1367,1036;54;F
94502;1040,1279,186,1627,571,1418,1367,1369,1345,1285,1361,1372,634,1048,644;55;F
94520;1372,1367,1504,1345,856,1102,983,575,1285,251;30;M
94540;1279,1385,1294,1182,1645,1285,1392,1345,1404,1403,977,571,248,1367,1372;43;M
94546;571;37;F
94627;1539,1345,1279,571,1372,1367,977,688,1392,855;32;F
94681;1279,186,715,1361,1102,1380,575,1285,1345,1404,1391,251,1504,1184,1367;36;M
94727;1522,1345,644,1077,856,715,855,251,977,1372;42;F
94747;1418,1367,1345,1404,1403,1042,1285,251;25;M
94755;1404,1048,1392,1285,1645,1380,1361,1102,644,1403,1391,1179,1627,384,1367;54;F
94820;1042,855,1539,276,186,1362,1418,644,957,688,983;34;M
94826;1392,1269,1285,1345,1613,1294,1385,1279,1504,1627,571,248,384,1367,1372;24;M
94829;1367,251,1269,644,1040;34;M
94859;1042,1380,1285,1304,1345,644,251,914,1279,1040,1077,916,715;6;M
94862;856,1613,1385,1404,1403,1279,186,1627,571,1395,248,1036,384,1367,1372;27;M
94884;1392,644,1345,1077;49;M
94908;977,855,1285,1392,1279,856,1645,575,1345,644,1404,1391,1504,384,1372;62;F
94912;1361,1102,715,1645,1304,644,1391,251,977,1386,571,384,1367,1372,1376;35;F
94919;634,1102,1392,1304,644,1040,1627,1395,384,1362;45;F
94930;1372,1077,1269,1279,1367;36;M
94934;1522,1385,1102,856,1350,1285,1040,1504,1627,571,1077,1045,1395,1418,1367;32;M
94947;1369,384,1345,1392,1042,715,1350,1048,1404,1391,938,977,1367,1372,393;22;F
94955;1385,1285,977,1279,1392,688,1403,384,1367,1372;61;F
94973;856,1285,1404,1391,251,977,1279,1367,1372;41;M
94998;1294,856,1385,983,1403,1404,977,1179,571,1077,248,1367,384,1372;30;M
95004;1102,1403,856,571;29;M
95010;644,634,1350,1361,1042,1380,1285,1304,1279,1040,1077,1043,1362,916,715;8;F
95011;644,856;64;F
95032;1040,251,1362,977,856,1385,1182,715,1645,855,1392,1345,571,1367,1372;35;M
95037;1372,1279,1403,1404,1345,1285,1385,856,1645,384,1367,248;31;F
95054;1042,1522,1048,1052,186,1367,1179,1627;34;F
95087;1279,575,571,1367,1385,856,1613,1372,1627,251,914,1345,1392,1504,1269;30;F
95088;1404,1403,1391,251,977,1386,1040,1504,186,1395,1418,384,1367,1372,1376;33;F
95111;688,276,1391,186,1627,248,1418,384,1102,575,644,1404,977,1504,1372;51;F
95114;1386,1279,384,1372,1376,1042,1285,1048,1052,1345,644,1077,1045,1418,1367;31;F
95156;977,855,1269,715,856,1392,1404,1403,1391,1279,1627,571,1367,1504;36;F
95199;1345,1043,1404,251,1048,856,1645,1392,186,571,1372;32;F
95205;1504,1077,1395,384,1036,1376,856,1361,1042,1269,1304,1345,644,1391,1367;40;F
95238;1269,1102,1279,938,251,644,1042,384,248,1395,1404,1522,1285,1380,1043;38;M
95305;1367,938,856,1385,715,1522,1345,644,977,914,1040,1504,186,1627,571;49;F
95308;856,575,1504,1645,1102;39;F
95328;1345,644,1367,1036;76;M
95346;983;47;F
95377;1042,1361,1048,1052,1345,644,1404,1403,251,1504,186,1395,248,384,393;28;F
95417;1391,251,1395,1418,393,1043,1386,1361,1392,1048,1345,276,1040,248,384;64;F
95440;1539,855,1048,1052,1345,251,1504,1042,1102,983,1522,1403,1418,1367,1372;33;F
95443;1404,1403;67;F
95463;1372,1386,1304,1045,1043,916,1350,1279,1040,914,1395,644,1392,1522,1504;35;M
95482;1385,1269,1645,1077,248,393;35;M
95484;1102,938,251,1042,384,248,1395,1404,1522,1269,1285,1279,1380,644,1043;7;M
95559;715,1376;40;F
95567;384,1102,634,644,1040,186,1036,715,575,1285,251,1395,1367,1372,393;47;F
95586;1539,688,276,644,251,977,248,384;52;F
95592;1376,1048,1645,1380,1042,1385,856,571;20;F
95596;1048,688,1539,1392,855,1645,1361,914,1395,384,1367,393;34;F
95600;1404;54;F
95608;1385,1403,1404,186,571,248,1372;36;F
95626;1102,1385,1269,634,983,1285,1522,1345,1391,251,938,1279,186,575,1184;36;M
95629;1391,1279,1077,1418,384,1367,1376,1380,1522,1345,644,251,1504,1040,1269;34;F
95729;1645,575,384,634,715;49;F
95734;1385,856,688,1404,1403,1504,186,571,715,1372,1367;29;M
95738;1376,1036,1369,1043,1040,914,1391,1345,1048,1522,1304,1285,575,1269,1042;43;F
95793;715,1376;10;M
95809;1102,575,1504,1627,384;22;M
95826;1522,1391,251,1504,1627,1418,1362,914,1380,856,1613,1046,1350,1372,1040;30;F
95834;1645,575,1345,1613,384;25;M
95847;914,1045,1376,393,1369,938,644,957,634,1102,856,715,1391,1040,1627;53;M
95898;186,1077,384,1367;39;M
95949;1182,1294,1046,715,1102,1361,856,1042,1269,251,1040,1077,1367,1036,1043;35;F
95973;1418,1367,186,1279,977,1391,644,1522,1285,1385,1102,856,1372,1043,916;38;M
95983;715;7;M
95992;1385,1042,634,688,1345,1613,914,1504,1077,1418,1367,1372,1043,1362,916;29;M
95996;1385,1522,977,1627,1077,1418,384,1367,1372,1362;30;M
96006;1372,1367,1045,186,914,977,1391,1345,1392,715,1362,1418,644,1522,856;37;F
96011;715;87;M
96049;634,1392,1345,1613,1404,1504,1367,1372;17;F
96106;715;43;M
96117;688,1539,1392,1285,575,715,1102,1345,1391,1404,1367,1372;37;F
96125;1395,1367,1376,1362,1372,634,575,1504,1627,856,1522,1345,1613,1040,1077;31;F
96126;715;59;F
96128;1380,1304,1042,1350,1269,634,1522,644,251,914,1040,1045,1369,393,1376;3;M
96154;384;28;M
96175;575,1048,957,276,1391,1386,1627,384,393,856,1380,1645,644,251,1367;30;M
96188;715;64;M
96285;1418,1367,914,1048,1102,856,1269,1285,1392,1522,1345,1391,251,1279,1627;37;M
96297;1391,384,1376,1404,644,248;26;M
96341;1102,1294,1345,1391,571,1367;65;F
96344;1048,575,1350,1102,856,914;38;F
96428;1504,1372,393,1362,1294,1645,575,1304,1391,977,571;35;F
96479;1367,1279,1645,1392,644,1613,571,1362;53;M
96490;575,688,1404,1403,1391,1040,1179,1504,1627,571,248,384,1367,1036,1372;37;M
96520;248,1367,1294,1645,1285,644,1613,1279,571,1184,384,1043,1052,1404,1403;25;F
96550;856,1522,1345,1613,977,914,1279,186,1504,1627,571,1077,1418,1367,1372;38;M
96588;1627,715;47;M
96597;1042,1269,644,914,1279,1367,393;48;F
96613;856,1102,1304,644,1367;50;F
96690;634,1522,644,1613,1386,1040,1627;70;F
96756;1285,1392,688,1539,1645,1345,977,1504,571,248,276,1404,384,1367,1372;59;F
96774;855,1042,1391,914,1279,1040,1376,1392,1077,1645,575,1385,644,384,1504;29;M
96784;251,1040,1627,1395,384,1367,1369,1043,916,1048,1391,914,1077,1045,1036;42;F
96785;571,1504,644,1522,1102,575,1391,856,1042,1040,384,1043,1645,1048,251;23;F
96798;634,1645,688,1345,644,1391,251,977,1504,186,1395,248,384,393,1043;55;F
96802;1385,1392,1539,1403,1179,1372;47;M
96811;384;23;F
96815;1294,1385,715,1645,1522,644,977,1279,1504,186,1627,571,1077,1418,1367;31;F
96866;1102,1042,1285,1048,251,914,1279,1504,1395,1043,393,1372,1369,1367,1345;31;F
96886;1269,1392,1404,1367;45;M
96934;1184,1372,688,1361,1385,1539,1404,1403,977,1279,186,571,248,384,1367;39;F
96943;1395,1046,1042,1645,1522,1367,1362,1043,384,1504,1040,1279,1391,1404,575;33;F
96956;1418,1522,1372,644,1539,1345,688,977,248,1279,1403,1404,1285,856,1077;35;M
96967;1504,1522,715,634,1627,1367,1418,856,1404,977,688,1391,276,248,1372;57;F
97039;1645,1102,1048,276,1345,1391,251,1386,1040,1395,248,1418,384,393,1043;88;F
97042;1102,1392,1539,1345,1404,1391,251,977,1504,1627,1077,248,1418,1367,1372;32;M
97098;1304,1345,644,977,1627,571,1376,1294,384,1367,1102,1645,575,1504,1372;48;F
97154;1052,1048,1522,1046,1350,856,1361,1042,1645,575,1040,1418,384,1043,916;23;F
97162;1380,1361,1042,644,1345,856,715,1269,983,1285,914,1040,251,186,1367;53;M
97180;1102,688,977;34;M
97186;1179,186,571,1077,1367,1372,983,1269,1294,1385,1102,856,1392,1404,1403;44;M
97242;571,1294,856,1385,1645,1285,1345,1404,251,1279,1504,384,1367,1372,1362;43;F
97287;1372,914,856,1361,1040,1179,1369,393,1391,1403,1404,1048,1304,1539,1376;60;F
97288;1391,1404,1522,1392,1285,1294,856,1269,251,1279,1040,1504,1627,1367,1372;33;M
97289;1361,1102,715,634,1645,1539,1048,1345,644,1404,1403,251,1179,1367,1362;51;F
97292;1367,1294,1182,1392,1504,1613,1052,1350,644,1077,1345,1645,1046,634,1418;34;F
97331;1040,1102,644,1404,1403,1077,1376;28;F
97341;1269,634,575,1392,1367,1504,1386,1391,1345,1048,1539,1285,1645,1380,1385;23;F
97348;1367,1645,1372;51;F
97351;914,1627,856,1042,1285,644,1369,384,1367,1036,1043,1269,1645,1279,938;39;M
97376;1627,1504,1386,1391,1403,1539,575,1645,1392,571;23;F
97407;856,1102,1385,644,251,1504,1627;47;M
97412;1279,571,1184,248,1367,393,1294,1040,186,856,1385,384,1345,977,1372;30;F
97429;1369,1043,1391,575,644,1077,384,1418,1376,1361,855,1048,1386,186,393;55;F
97432;1350,1042,1380,1304,1522,1040,1504,1102,1269,1345,1391,1627,1418,1367,1372;34;M
97435;856,1294,634,276,644,248,1418,1372;35;F
97437;1380,1392,1404,1179,1045,1367;59;F
97441;914,1285,634,1380,186,1627,571,1077,248,1184,1418,1367,1369,1372,1043;31;M
97473;1386,1040,1269,644;39;F
97489;1391,977,1077,1418,1367,1372,1362,856,1269,1304,644,251,914,1279,1040;31;F
97495;1504,1345,1048,1043,1645,1380,715,1102,575,1404,977,251,384,1367,1372;24;F
97502;1522,1345,1380,1404,1391,251,977,1040,1504,1627,1077,1184,384,1367,1372;42;F
97504;248,1418,1522,1285,1269,715,1385,856,1345,644,977,1279,1367,1372,1362;34;M
97528;983,957;38;F
97545;1345,644,1391,384,1052,855,1294,248,1367;21;F
97564;1392,1522,1345,1391,251,977,1504,571,1077,1367,1036,1372,1362;33;M
97581;1380,1522,1048,1345,644,251,977,1077,856,1042,1279,1040,384,1367,1362;21;F
97588;1386,1403,276,688,1392,1294,1102,1645,575,1285,1391,938,1279,1040,384;41;F
97610;1285,1345,1362,856,1418,1367,715;34;F
97662;1285,1345,644,1372,634;43;F
97671;1279,186,1627,1036,1043,1376,1372,1367,384,1504,977,1391,688,1522,1102;38;F
97680;1645,1345,384,715,1361,575,251,977,1279,1040,1504,1627,1367,1372,393;24;F
97781;1350,1376,1361,1042,1522,644,1404,1391,1179,1418,1367,1036,1372,393,1043;28;F
97786;1285,1404,715;39;M
97798;1392,1522,644,1404,1403,1386,1036,1504,1179;40;M
97803;1048,1386,1395,1045,1036,1043,1362,1361,1042,1380,1304,644,251,1369,393;27;F
97834;1179,1418,1369,1372,393,1102,1385,715,1046,1042,1269,855,1645,1539,1522;39;M
97836;1361,1539,1385,1042,1392,276,1404,1391,1045,248,393;64;F
97862;715,1345,1404,251,977,1367;41;M
97863;856,715,1042,1645,575,1522,1345,186,571,916,384;43;F
97889;1285,1372,1645,1294,1345,1392,856,644,938,1504,1279,384,1627,571,1367;35;F
97909;1077,1040,914,1380,1369,1182,856,251,571;33;F
97912;1184,384,1372,856,1102,1182,1269,688,957,1345,1391,1613,977,248,1367;9;F
97935;715,1645,1345,1391,251,1367,856,1269,1285,1279,1418,384,1372;40;F
97950;571,1418,1372,248,1285,1385,1102,1048,1404,1403,1391,1040,384,1367,1613;27;M
97965;1418,1391,1345,1042,715,1102,856,644,1404,1403,251,977,914,1386,1179;37;F
97972;1504,1102,1645,575,1285,1404,1391,977,1179,1077,1045,384,1367,1036,1372;48;F
98007;571,1036,1369,1372,1385,856,1361,634,1345,644,384,1367;25;F
98028;276,1403,571,1385,1294,855,983,1392,1345,1404,1504,1077,248,1418,1372;40;M
98039;1391,1367,1102,1539,1403,251,384,1372,916,1345,1404,1392,1504,715,1285;30;M
98058;856,1385,1294,1380,634,855,1539,644,1404,1403,977,1040,384,1372;32;M
98059;1042,1304,1048,1386,186,1045,1362,634,1645,977,914,384,1367,1369,1372;24;F
98069;384,1418,1627,1504,1361,1345,1391,1279,1367,1285,575,1645,1269,1102,856;37;M
98072;1102,1269,1285,1522,1345,644,1391,977,1279,1627,1077,1418,1367,1372,1362;34;F
98130;1052,1048,644,1522,575,1102,1279,1350,1046,1042,634,1285,914,1040,1045;8;F
98198;856,1385,1294,1645,1392,644,1391,251,1279,1040,1504,186,1627,571,1372;31;M
98205;1102,856,1385,1350,1182,1285,1392,1522,644,251,1279,571,1077,916,1418;54;M
98226;1040,186,1102,715,634,1367,251,571,1418,384,1048,1645,1042,1385,856;38;F
98227;251,1504,1418,1102,1385,715,1042,634,1345,644,977,571,248,384,1367;32;M
98228;644,1269,1040,1386;11;M
98235;715,1042,1392,1539,1522,1048,1404,1403,251,1040,1179,1418,1367,1369,1372;35;M
98406;1350,1046,634,1285,1048,1052,644,914,1279,1040,1045,1036,393,1043,916;5;M
98459;1345,1522,1285,575,1645,1294,715,1102,1380,1391,1040,1279,1036,1367,1077;40;M
98464;575,977,1040,1504,1627,1418,384,1367,1102,1048,1404,1403,1391,571,1376;33;M
98468;856,1102,634,1391,251,1504,1077,1418,384,393;38;F
98476;1418,957,1184,983;40;F
98490;715;4;M
98501;384;51;F
98503;1361,1645,855,1048,1345,977,1386,186,1369,393;29;F
98513;1645,384,276,248;44;F
98522;1269,1522,1345,1279,1077,1418,1367,1372;32;M
98524;1040,1522,1361,186,571,1376,1285,1042,1102,1391,1269,251,1045,1418,1367;31;M
98536;1385,1294,983,1392,855,276,1345,1404,1403,1504,571,1077,248,1418,1372;2;M
98541;1372,1036,1077,1042,715,634,1285,1345,644,1404,1403,251,1040,1179,1367;39;M
98543;1269,1102,1392,1522,1504,644,1391,1613,251,914,1279,186,1627,1045,1418;44;F
98554;856,715,1380,575,186,384,1367,1372;30;M
98565;715;10;M
98578;715,1404,1403,1179,186,1627;27;M
98582;688,1052,1345,276,1404,1403,1391,1279,1040,571,248,384,1367,1036,1372;25;M
98587;1504,1367,1102,1361,644,186,688,251,977,248,1418,1369,1372,393,1043;48;F
98600;1418,1102,1182;38;F
98611;384,856,1102,1385,1294,1645,1392,1345,1391,251,977,1504,571,1367,1372;45;F
98643;1539,688,276,1385,1645,575,1304,644,1404,251,977,571,384,1504,1367;32;F
98676;1042,634,1304,1048,1052,644,1391,251,938,1040,1395,1036,1369,393,1043;36;F
98690;1345,1418,1376,1539,1403,1504,1404,1627,571,248,1184,1367,1372,1294;28;F
98699;1042,186,1627,1102,688,276,1345,1404,977,1504,1395,1418,1367,1372,393;31;F
98711;1385,1294,571,1077,1367,1372,1362;25;M
98721;1345,1392,1627,1522,1504;33;M
98752;1361,1269,1380,634,1345,644,1040,1179,1627,1395,384,1367,1102,1385,1645;38;M
98805;1042,1046,715,1102,1269,644,1279,186,1077,1418,1367,1372,1043,1362,916;40;F
98810;856,1285,977,1279,186,1077,575,1345,644,1504,1627,248,1418,1367,1372;39;F
98836;1040,186,1627,1077,1362,248,1102,1385,1042,634,1304,1522,644,1418,384;41;F
98873;1361,1102,1504,688,644,251,977,186,248,1418,1367,1369,1372,393,1043;12;F
98884;1392,715,1522,1404,1391,1077;47;M
98955;1404,1403,1627,1395,644,1345,1285,634,1102,1504,1645,575,1279,1367,384;32;M
98987;1385,715,1645,1392,1345,644,1391,251,186,1627,571,1077,1418,1367,1362;43;F
98994;1539,688,276,1404,1403,977,1279,1179,186,1627,571,248,1184,1367,1372;74;M
99000;1102,688,1345,856,1385,715,1285,251,977,1040,1627,571,1418,384,1367;20;F
99004;1504,1179,1404,1539,1102,1372;34;M
99026;571,856,1102,855,977,1040,186,1361,1380,1304,1404,1403,251;47;F
99037;688,1404,977,914,1279,1040,1504,571,1372,856,1294,1345,644,384,1367;43;F
99049;1345,1391,1613,251,977,914,1040,1504,1627,571,1077,1184,384,1367,1372;38;F
99051;1361,1102,688,644,251,977,1504,186,248,1418,1367,1369,1372,393,1043;8;F
99070;1048,856,1269,1285,1304,644,1404,1403,1279,1040,1077,1367,393;39;F
99086;688,1539,1392,855,1042,1102,1404,1403,1391,251,977,1179,186,1372,1376;40;M
99090;1404,248;31;M
99110;1645,1404,1403,1385,1376,1361,1345,1304,1294,1102,1048,1045,1040,856,644;42;F
99139;1392,276,1404,1391,248,384,1367,1372;33;F
99145;1367;30;F
99154;977,688;45;F
99237;1294,1385,1504,186,571,384,1367,1372;32;F
99267;1391,1052,1304,575,1645,1042,1613,1279;32;F
99269;715,916;34;M
99272;1304,856,1269,1522,1345,644,1391,1613,977,914,1279,1040,1504,1418,1367;38;F
99303;571,1418,1367,1392,1345,393,1362,1385,856,1182,1645,1052,251,1504,1627;30;F
99305;688,977;12;F
99309;1613,1294,688,1048,248,644,1404,977,1040,1504,186,384,1367,1372,393;30;F
99362;634,644;51;F
99364;715,186,856,1269,575,1285,1522,1345,1391,914,1279,1504,1627,1418,1367;42;F
99365;715,1102,1385,575,1392,1522,1345,1404,1504,1627,571,1077,1418,384,1367;54;F
99372;715,1042,1645,251,1627,571,384,856;27;M
99377;688,977;7;F
99380;276,644,977,1361,1182,983,1391,688;45;M
99395;1372,1367,1418,248,1077,1627,977,1391,1404,1345,688,1522,1539,1392,855;37;F
99398;644,1269,1040,1386;39;M
99447;1522,1645,1042,715,1102,856,1361,1380,1392,1404,1403,1395,1418,1367,393;38;F
99459;1380,1645,251,384;25;F
99500;634,644;10;M
99512;977,1613,1391,1404,644,1345,1269,715,856,1102,1645,575,1077,1048,1279;28;F
99536;855,1522,977,1279,1504,186,1418,1367,1369,1372,1043,856,1645,644,251;41;F
99548;1345,1613,1040,1504,384;59;F
99551;1361,1385,715,634,1102,1350,1046,1294,1042,644,571,1077,1045,1418,1372;44;F
99592;634,644;16;M
99610;1380,1040,1392,1613;43;F
99629;1345,1048,1285,1102,1350,634,644,251,977,1045,1369,715,1395,916,1376;39;F
99630;1539,1522,688,1345,644,1403,1404,1391,977,1279,1504,384,1367,1036,1372;30;M
99651;1285,1403,1404,1504,1367,715,1391,186;42;M
99652;186,1279,1285,1102,1385,1645,977,1179,384,1372,1403,1404,688,1539,248;39;F
99668;634,644;77;F
99697;715,1380,634,1645,644,1386,393,1036,384,1040,1391,1522,1304,1102,1361;53;F
99728;715;79;F
99731;977,1345,1539,856,251,1627,1361,575,1304,1040,1504,1367,1036,1372,393;35;F
99782;1403,1404;62;F
99787;1052,1042,1269,1345,251,1040,1504,1627,1077,248,384,1367,1372,1362,1043;26;M
99827;1285,1392,1391,251,1279,186,1627,571,384,1367,1372;49;F
99835;1403,1404,1179,1539,1392,1369,1036,1395;71;F
99836;715;81;M
99870;1367,1184,1179,1369,1279,1376,916,914,1045,1036,1040,384,1391,1395,393;70;M
99881;1645,1345,1045,1367,1269,1294,644,1279,571,1285,1179,1504,384,1372;26;M
99893;715;74;F
99901;1395,248;43;F
99904;1380,1345,1391,1386,1504,186,1627,571,1102,1385,1294,1304,251,1040;77;M
99948;1269,1304,1522,1345,1391,251,977,1279,1040,1077,1418,1367,1372,393,1362;37;F
99979;1345,977,1279,393,1376,1361,715,1042,1522,1404,1391,1077,1418,384,1367;37;F
99993;856,1102,1385,1182,1380,1645,575,1522,251,977,1504,1077,1418,384,1372;45;M
99999;938;56;F
100024;1285,1404,1403,977,1279,186,248,1385,1294,1645,1392,1345,1627,571,1367;49;M
100027;1367,1395,1504,1386,644,251,393;31;F
100041;1645,575,1345,1404,1627,384,1367,1372,248;36;F
100057;1285,1345,1403,977,186,1627,1102,1392,1539,1404,1391,1179,1372,1367,1362;61;M
100094;977,1279,1504,384,916,1102,856,1645,1285,571;42;M
100120;1522,1048,1345,644,1391,1613,251,914,1040,1077,1045,1418,1367,1036,1372;43;F
100126;1345,1404,1179,186,1042,1403,977,1279,1077,248,1184,1285,1418,1367,1372;43;F
100139;938;44;F
100157;1042,1102,856,1285,644,1391,251,1040,1395,1418,1367,1036,1372,1362,715;42;F
100229;1627,1345,1645,1042,715,571;32;M
100240;1046,1043,1376,276,1304,644,914,1040,1418,1036,393,1361,856,1522,938;34;M
100242;1184,1361,1645,1304,186,571,856,1385,1294,1380,644,1040,1418,1367,1372;41;F
100246;1345,1385,1102,1294,1645,1367,856,1350,1613,914,571;44;M
100277;1645,575,1392,1522,1613,977,1504,1627,1077,384,1367,1372,1362,1345,644;46;M
100295;1269,1391,1279,1040,1627,571,1077,1418,1367;33;M
100302;571,1279,1385,1294,1285,856,1645;26;M
100304;1042,575,1613,1077,384,1048,1345,1102,1350,1385,1645,856,571,1367,1372;39;F
100362;1269,575,1345,1391,1077,1418,856,1102,1380,251;40;F
100385;1372,1380,855,977,1627,248,856,1385,1645,1392,1345,1391,1279,571,1367;62;M
100390;1269,251,1279,1040,1362;29;F
100408;1269,1392,1279,1077;35;F
100415;644,1077,384,1376,856,1385,1645,1392,1345,251,1627,571,1418,1367,1372;39;F
100444;1627,1279,644,1345,1048,1645,856,1102,1269,1285,1391,914,1040,1367,1036;32;F
100457;1645;49;F
100505;856,1102,715,1392,1048,1345,251,938,1504,571,384,1367,393;34;F
100517;1042,575,983,855,1102,1380,1645,1392,1539,1404,977,1179,384,1367,1372;34;F
100555;1350,1345,1182,1627,1504,1367,856,1392,1522,1391,1077;37;M
100557;1645,1102,1269,251,977,1036,393;30;F
100590;1367,1418,571,1627,1040,1279,251,644,715,1385,1102,856;29;F
100606;1102,384,1504;36;F
100621;1102,1385,856,634,1391,251,938,1040,644,186,1367;35;F
100639;1645,251,1040,1077,248,1043,575,1285,856,977,1504,186,1627,1367,1372;29;F
100740;1403,1269,1392,1285,1304,251,1279,1040,186,1367,1362;28;M
100788;856,1102,1269,1380,634,1645,1392,1304,644,1391,251,1279,1285;33;M
100816;1294,1385,856,1645,1404,1403,977,1279,1040,1504,186,1627,571,1045,1077;32;F
100824;644,1404,1403,1391,251,977,914,1279,1504,248,1418,1367,1372,393,1043;32;M
100874;644,1269,1040,1386;7;F
100883;856,1285,1345,1404,1279,571,1367;33;F
100895;1391,1345,1048,1522,1392,1350,1279,1504,1418,384,1367,1102,1385,1042,1285;28;M
100914;186,1279,1391,1403,855,1042,1385,715,1539,1404,251,977,1418,1367,1372;29;F
100926;1102,1042,575,1522,1048,251,977,1504,1036,1372;31;F
100955;1645,1269,1294,1385,1102,1345,644,251,977,1040,571,248,384,1367,1372;28;F
100961;1345,1645,856,1285,688,1403,251,1040,1627,571,1077,384,1367,1369,1372;29;M
100962;251,1504,914,1345,634,1350,856,1522,1391,384,1418,916,1102,1269,1077;39;F
100965;1285,248,1294,688,1627,1102,634,1645,855,1345,644,977,1504,384,1367;54;M
100987;1372,938,1522,1345,914,1040,1418,916,1269,634,1285,644,1279,1627,1077;37;F
100989;644,1269,1040,1386;4;M
101001;1042,1102,1350,1285,1539,1345,1403,1404,1391,251,1279,1040,1627,384,1045;28;M
101021;1392,634,1539,688,1345,644,1404,1403,977,1279,186,571,1418,1367,1372;25;F
101040;1385,1380,644,914,1036,1361,1304,1048,977,938,1040,186,1367,1372,393;24;F
101067;1504,1627,1418,1077,1367,1036,1372,856,1102,634,1369,1362,384,251,1380;49;F
101090;1645,575,1304,1522,1048,1040,1504,186,1627,571,248,384,1367,1372,1376;19;F
101097;1376,1369,1522,1285,855,1042,1102,1345,251,1279,1179,186,1395,1367,1372;27;F
101100;575,1279,977,1391,1403,1404,1285,1645,1102,1372;48;F
101103;1404,634,248,1376;34;F
101129;1179,1539,1627,1376,983,1362,1392,1391,1403,1404,644,248,1345,688,977;38;M
101134;856,1645,688,1048,1404,1403,977,1040,1504,571,248,1184,384,1367,1372;24;F
101135;856,1645,855,1392,1345,1391,977,571,1077,1418,1367,1372;41;F
101143;1361,1345,1504,1385,715,1042,1645,1048,393,1367,914,938,1391,644,856;42;F
101175;1285,571,1077,688,1294,1269,1645,1392,1345,1279,1627,1418,1048,1040,1367;31;F
101196;1077,571,1504,1040,1279,977,1404,1345,1052,1522,1392,1385,1102,856,1269;32;M
101222;1042,1395,1045,715,1376,1285,1522,1404,1403,1391,938,977,1386,1077,1418;39;M
101235;1404,1403,251,977,914,1279,1179,1504,186,1627,571,384,1367,1372,1362;28;M
101253;1504,571,1372,1380,1269,1042,1294,1102,856,1404,251,384,1367,1645,248;43;M
101275;1345,1269,1285,251,977,1279,1504,571,1077,248,1045,1418,384,1367,1372;33;F
101276;1645,251,1040,1627,384,1367;32;F
101306;393,1036,1367,1045,1504,1391,644,1048,1285,1645,634,1102;36;M
101317;634,251,1362,1345,1403,1404,644;31;F
101356;644,1403,1391,1279,1504,1627,1102,634,1645,1285,1179,571,384,1367,1372;37;F
101370;1294,715,856,1385,1184,1418,1285,251,977,1040,571,248,1367,1036,1372;27;F
101389;644,1040,186,856,1645,575,1392,1304,977,1279,1504,571,384,1367,1372;35;F
101414;1048,644,1404,1403,914,1504,1045,1102,715,1645,977,1279,248,1367,1372;31;F
101424;1385,1294,1376,1045,1367,1102,1285,1345,1404,1403,1279,1504,1042,1645,384;39;F
101467;1391,1403,1345,688,1042,715,1392,251,977,1504,571,1418,1367,1372,393;34;F
101474;1504,1627,248,1179,1279,251,1645,1285,1539,688,957,276,1404,384,1403;46;F
101490;1376,1361,1350,1386,1040,1045,1395,1036,1369,393,1043,1042,1048,1052,644;39;F
101503;856,1385,715,1345,251,186,1077,1367,1362;42;M
101533;1404,1391,977,1279,1504,186,1627,571,1045,1184,248,1418,384,1367,1372;19;M
101614;715;44;M
101617;1391,1179,186,1627,1077,1395,1380,856,983,251,1279,1040,384,1369,1362;31;M
101633;1043,1304,1077;35;F
101648;938,1361,983,1269,1404,1403,251,1040,1504,186,248,1372,1645,575,384;40;F
101670;1613,1386,1040,1627,1077,1418,1102,856,1380,575,644,384,1367,1372,1362;73;F
101673;1418,1372,977,1362,1367,1279,251,1391,1345,1392,1645,1102,856,1385,715;39;F
101688;1285,1367,1345,1504,634,1627,1372,1403,1269,1279;30;F
101712;856,1304,1522,251,977,1040,248,1418,1367,1372;36;M
101745;1362,1102,1522,856,1392,251,1040,571,1372;31;M
101750;983,1391,384;23;F
101757;1048,1269,1042,1102,1361,634,1285,1345,938,251,914,1040,384,1369,1367;23;F
101808;1645,1042,856,1102,1048,644,1040,384,1036,1392,1391,1345,1372,977,1504;30;F
101839;1522,1627,1077,384,1367,1372,1362,1376,1040,977,1345,715,1385,1102,856;70;F
101864;634,1042,715,1102,856,1361,1380,1269,1392,644,1391,1367,1036,1372,1362;32;F
101865;856,1385,1294,1522,688,1052,644,1404,1403,186,571,1395,1418,1367,1372;69;M
101902;1372,1362,856,1102,1645,575,1285,1539,1345,1404,1403,251,977,914,1179;29;F
101904;1392,1182,1385,856,1361,1304,1345,644,1613,1040,1395,1367,1036,1372,1362;45;F
101905;1404;60;M
101914;1385,1645,1052,644,1040,1627,1077,1418,1362;33;M
101949;1350,856,1042,1380,1285,1304,644,1391,251,914,1040,1627,1045,1372,1043;44;F
101956;856,1102,1385,715,1645,1285,251,1279,1040,571,1418,1367,1372,384,1362;11;F
101959;856,1385,1294,571;40;M
101964;1361,186,1504,1040,251,1391,634,1380,1042,715,914,1627,1372,1043,916;34;F
102008;1345,1391,977,1645,634,1102,1285,1048,251,1279,1040,384,1627,1367,1372;49;M
102032;1279,1179,1627,571,1045,248,1367,1372,1362,856,1385;28;M
102046;1404,1504,393,1362,1361,688,1345,644,1391,251,977,1077,384,1367,1372;29;F
102115;186,914,575,715,1385,1361,1269,1380,1304,644,251,1386,1040,1367,1036;40;F
102130;688,1345,644,1404,1391,1279,1179,1184,248,1418,384,1367,1372,393,1362;36;F
102139;715,1042,1522,1048,1052,1504,1077,1045,1395,1036,1043,916;51;F
102145;1504,1418,1627,1036,1376,1269,1380,1048,644,251,1386,1040,1369,393,1362;38;F
102152;1040,914,977,1345,1304,1645,1102,1361,856,1269,1380,1285,1391,251,1279;27;F
102159;1522,1285,855,1645,1385,1102,856,715,251,1279,571,1418,384,1367,1362;8;M
102200;575,1367,251;42;M
102218;1046,1042,1304,856,1395,1362,1380,575,1391,393,1376;37;F
102221;1391,1077,1040,1362,715,1627,977,1385,1102,856,1386,384,1367,1372,1376;73;M
102254;856,571,1372;34;M
102278;856,715,1380,634,1285,1392,1304,1048,1345,251,1386,1279,1040,384,1043;46;F
102284;1285,1522,644,251,977,186,1077,1395,1362,856,1385,1645,1345,1367,715;39;M
102306;1372,1645,1269,1385,1294,1392,1285,1539,688,1052,1403,1404,977,1077,248;45;M
102329;384,1045,1077,914,1345,634,644,1391,1613,1395,1367,1362;44;M
102335;1613,856,1279,1269,1392;29;M
102385;1392,1102,1391,1404,1345,276,688,855,715,856,1504,1627,248,1367,1372;43;F
102405;1345,977,1504,1367,393,1361,575,1285,1304,1048,1279,1040,186,1077,384;46;F
102417;977,1042,1380,1645,688,1048,276,644,1391,1613,251,1045,1418,393,1043;11;M
102427;1613,1285,1380,1392,1345,644,251,1077,1418,1367,1369,1372,393,916,1376;37;F
102436;1627,393,1042,1645,575,251,1386,1504,384,1376;32;F
102443;1403,1645,1285,1539,688,1345,1404,977,1279,1040,1627,248,1418,384,1372;29;M
102485;571,1504,977,1391,856,1102,914,1279,1040,1627,1362,1376,1269,1285,1372;35;M
102496;1385,1102,856,634,575,644,251,914,1279,1040,186,571,384,1367,1369;63;M
102499;1361,1380,251,1040,1504,384,1367,1036,1369,1372;42;F
102527;1345,644,1404,938,977,914,1504,186,1627,571,384,1367,1036,1372,1043;25;M
102529;1367,1391,1042,1294,856,1102,1385,1048,1350,1046,914,1045,1036,1043,916;41;F
102531;1539,1404,1077,248,1369,393;34;F
102535;1042,1380,1645,688,1048,276,644,1391,1613,251,977,1045,1418,393,1043;7;M
102548;977,644,186,571,1285,1367,1613,1386,1385,1372,1345,1294,1279,1040,856;40;F
102559;1045,1369,1042,634,1522,644;42;F
102574;248,688,1539,1269,1102,1645,575,644,1418,384,1367,1372,1385,1294,571;39;F
102605;1385,1102,856,715,1380,688,1391,251,1040,1504,186,248,1418,1367,1372;30;F
102614;977,938,1102,1380,634,575,251,1040,384,1372,1376,1391,1184,957,983;25;F
102623;1279,1179,1504,1627,571,248,1372,1367,1184,856,1385,575,1285,186,1418;33;F
102628;575,688,251,1504,186,1627,248,384,1367,1372;50;F
102629;1269,575,1304,1376,1392,1645,634,1042,644,251,1367,1372,571,1045,384;40;F
102630;1391,1269,251;35;F
102631;1367,1376,1372,1036,1418,1627,1040,1386,914,644,1345,1522,1304,1645,856;30;F
102654;644,1645,1102,856,1345,1613,251,384,1077,571,1362,1504,1294,1385;36;M
102655;1392,1539,1404,914,1386,1040,1367,393,1522,1285,1380,1042,1102,644,1391;37;M
102683;715,856,251,1040,186,571,384,1036,1362,1645,1539,1627,248;27;F
102684;1048,1042,1645,575,1285,1052,1404,1386,1279,1504,1395,384,1367,1372,1376;27;F
102741;1184,1404,1043,957,1279,1285,855,1294,1385,856,571,1403,1367,1361,983;39;F
102753;1042,1392,1304,1539,1345,1404,1403,1391,1179,571,1418,1367;27;F
102757;1403,1504,248,1372,1294,1285,1392,1345,1391,1279,571,856,251,1040,1367;28;M
102766;715,688,1372,977,1418,1522;33;F
102779;1350,715,856,1102,1294,1404,1403,1504,977,1279,186,1418,384,1367,1372;30;F
102819;1345,977,1279,1040,248,1367,1102,1645,1391,914,1418,1522,644,1613,1077;38;F
102828;856,688,1404,977,1372,575,1367,248,1048,855,1645,384;49;F
102876;1367;36;M
102880;688,634,1380,1361,644,1404,251,1395,384;36;F
102887;715,575,1392,393,1539,1404,1403,1179,1367,1376;35;F
102888;1645,1294,715,1385,1102,856,1372;33;M
102890;1539,688,1345,1404,1403,571,1184,1418,1361,977,1367,1372,1362,1376,248;34;M
102898;1182,1285,1613,1539,957,276,1404,1403,1391,1077,1385,1345;31;F
102917;1102,1042,1645,1048,1052,1345,1404,251,1386,1627,1367,1036,1369,1372,1376;30;F
102920;715,1404;11;M
102940;248,856,1102,715,1380,634,1285,1539,688,1345,1404,977,1350,644,1391;34;M
102948;644,1052,1048,1522,575,1645,634,1046,856,715,1380,1040;21;F
102971;1645,856,1269,1380,634,1304,1048,1391,251,1279,1040,186,1504,1627,384;31;F
102978;1294,1539,1403,977,1279,1504,1184,1418,1372,1367,1380,1040,1627,856,1391;37;M
102998;1404,977,1279,1504,1385,1269,571,248,856,1645,1285,1345,1040,384,1367;32;M
103013;1350,1046,914,1045,1036,393,1043,916;7;M
103025;856,1102,1385,1294,1645,1345,644,1613,251,1504,571,1077,384,1362;36;F
103044;1269,1645,575,1040,186,1627,384,1285,1392,1345,1403,1404,1279,571,1367;32;M
103067;1361,1102,1269,575,1285,1304,644,251,938,1386,1279,1040,1367,393,1376;29;F
103085;1627,571,1367,1036,1372,1504,977,1391,1048,1380,1102,856,1042,1645,575;33;F
103105;1391,1645,575,384;53;M
103122;1269,1350,1361,1385,1046,1042,1380,634,983,688,1048,1345,1391,1386,393;35;F
103126;1350,575,688,1052,1345,644,1404,1391,977,1627,1395,248,384,1367,1372;24;M
103176;1385,1392,1404,1391,1376;34;F
103186;1385,855,1539,688,276,1345,1404,1403,1391,1179,1367,634,1392,644,248;52;F
103188;1645,644,977,1279,1385,1102,856,1392,251,1504,1627,571,1367,1036,1372;30;F
103210;1102,1385,575,1304,1345,1391,977,1279,1504,186,571,248,1418,1367,1372;33;F
103258;1380,1042,1522,1345,1040,1504,384,1367,1372,1361,856,1385,1294,1645,571;35;F
103264;1285,1048,1345,1391,1077,1367,1036;38;M
103265;1376,1367,1504,1279,1522,1285,1645,1269,1046,1385,1102,856,1042,644,1391;32;F
103295;1361,1645,1392,1404,251,1386,1179,1376;56;F
103304;1102,1361,1304,1048,571,1376,1504,1627,977,1392,1380,1269,1042,1294,856;40;M
103321;1279,384,1367,1372,1376,186,1040,1386,251,1391,1345,1645,1269,1102,856;37;M
103322;1269,1285,1345,1279,1040,571,1372;30;F
103338;856,1102,276,251,977,1279,1367,1372,393;33;F
103341;1040,1392,715,1385,1376,1042,1304,1345,251,938,977,1504,571,1418,1372;22;F
103343;983;33;F
103344;1380,634,1392,1304,1522,1613,251,914,644,1391,938,1040,1077,1395,1036;51;F
103388;1102,856,1285,575,1392,1304,914,1279,1504,1627,571,1077,1362,384,1367;46;F
103418;1042,688,1052,644,1403,1040,1045,1395,248,384,1043;41;F
103429;957;37;F
103447;1345,688,1539,1362,644,1404,248;43;M
103475;634,1372,571,1040,1385,1102,1645,1345,1391,251,977,186,384,1367;42;F
103479;1269,1522,977,1179,1627,1184,1385,1645,1392,571,1045,248,384,1367,1372;29;F
103528;1627,1385,1645,575,1539,688,1345,1403,1404,977,1279,1504,384,1367,1372;34;M
103544;1539,938,914,1040,1077,1367,1102,1048,1404,1391,251,977,1279,1504,1627;21;F
103553;1367,384,1391,1345,1304,1102,856,1627,1040,914,644,1392;36;M
103556;634,1645,1395,384,1043,855,1345,1391,1367,1372;37;F
103560;1539,1345,1403,1404;40;F
103608;1102,1404,1627,1077,248;33;M
103609;1350,715,1046,1522,1345,251,1040,186,1627,1418,1367,1372,1269,1391,916;36;F
103623;1102,856,715,1042,1645,1345,1391,977,1040,1504,186,1418,384,1367,1372;34;M
103627;1184,1372,1046,1385,1645,983,688,571,248,977,384,1404,1279,1627,1367;23;F
103632;855,983,1404,1403,1504,248,1385,1294,1392,1345,644,571,1077,1418,1372;38;F
103635;1042,1645,644,186,1627,1362,856,634,1285,1404,1040;23;M
103650;1372,977,251,1042,1522,1345,644,1391,1613,1077,1395,1367,393,1362;41;F
103681;1380,715,1102,856,1042,1645,1392,1345,251,1279,1040,571,1418,384,1367;33;F
103698;1052,1392,1285,1645,1380,1042,1385,856,1102,575,251,1040,1504,1627,384;31;M
103705;1046,1102,856,1077,248,1372,1269,715;40;F
103781;251,1395,1367,856,1269,1285,644,1279,1040,1376;36;F
103790;914,1045,1102,1350,1042,575,1052,1345,251,1040,1504,1367,1372,1376,1036;29;M
103795;1385,856,1285,1504,1627,1367,1404;32;F
103797;856,1046,1645,983,1285,1048,644,251,1279,1504,1077,1395,248,1372,1043;36;M
103801;715,1042,644,938,977,1294,1269,1645,1285,1048,1345,1391,571,384,1367;23;M
103802;977,1279,1179,186,1367,1372,1392,1285,1102,1042,1645,575,1539,571,384;28;F
103843;715;64;F
103858;251,914,1279,1392,1539,688,1404,1391,977,1040,186,248,1367,1372,1376;53;F
103879;1539,1367;34;M
103909;1380,634,1043,1361,1350,1376,1042;30;F
103929;1036,1369,916,1376,1392,1645,1380,634,1042,715,1345,1404,1386,856,1361;25;M
103951;1269,1391,715;11;F
103952;1102,1645,644,1418,1362,1376;41;M
104010;1345,644,1404,1403,914,571,186,715;8;F
104020;1102,1042,634,1392,1304,914,1077,1362,856,1380,1269,1613,251,1040,1369;42;F
104022;1042;35;F
104030;715;14;M
104033;1350;10;M
104038;1372,1036,248,1077,644,1345,1304,1182,1046,1350,1102,856,1269,715;9;M
104042;1391,251,938,1279,1179,384,1367,1372,1376,644,248,1403,1404,1539,1102;34;F
104044;1392;27;M
104045;977,1279,571,248,251,1504,186,1645,688,1404,384,1367,1372;62;F
104060;1418,914,1345,1294,715,1385,856,1285,1404,977,1279,1040,1367,1372;17;F
104064;1392,1345,977,1372,251,914,1040,1362;25;M
104084;393,916,1418,1077,914,856,715,1269,1285,644,251,1040,1367;9;M
104111;1645,1285,1304,186,1627,571,1391,1345,856,251,1040,384,1367,1036,1372;32;F
104113;1077,1045,384,393,1376,1304,1052,644,938;27;F
104120;251,1504,856,1269,1645,575,1304,644,914,1040,571,1418,384,1367,1372;30;F
104131;1102,1042,1052,1345,1391,251,855,1269,856,1645,688,977,1504,1367,1372;31;F
104174;1279,1285,1404,1403,1504,571,1418,715;43;M
104201;914,1386,1040,1179;53;F
104210;1042,1380,855,1392,1304,1522,688,977,1386,1040,248,1369,393,634,644;36;F
104223;1627,1395,1046,1042,1380,1645,1304,1048,1052,1040,1077,1045,384,1036,1043;28;F
104231;688,1404,1403,251,977,914,1279,1040,1504,186,1627,571,1395,1367,1372;43;F
104235;644,1102,1042,1269,1380,634,914,1279,1040,1504,1627,1077,1395,1418,916;41;M
104240;1386,1395,1036,1376,634,644;49;F
104257;1385,1380,1391,186,571,248,1367;33;M
104269;715,1042,1102,1269,1380,634,644,914,1279,1040,1504,1627,1077,1395,916;11;F
104281;1077,248,1645,1046,1350,1385,715,1269,1522,977,914,1040,1418,1367,1372;31;F
104307;1304,1380,1102,1048,251,977,1386,1279,1040,1627,1395,248,1367,1372,1043;36;F
104319;1350,1042,1645,983,1522,1048,957,1052,1345,644,1391,1184,1367,1372,393;35;F
104347;1285,384,1345,1404,1403,977,1279,1504,186,1627,571,248,1184,1367,1372;29;F
104355;856,1102,1645,1285,384,1367;74;F
104360;1645,1350,1102,856,1042,1380,688,1345,1404,251,1040,1627,1367,1036,1372;25;F
104390;1304,715,1361,1102,1046,1380,634,1522,1052,1345,1391,914,1040,1042,644;38;F
104405;855,1385,1102,1042,1645,1304,1052,1391,251,977,1040,384,1367,1036,1372;23;F
104408;1043,856,1361,1385,1294,1380,1304,1345,644,251,914,571,393;30;F
104409;1418,1269,1040,1627,393;31;M
104410;856,715,1269,1285,1304,1522,1345,251,1279,1040,1077,1418,1367,1372,1362;7;F
104418;856,1350,575,1522,644,1391,1504,1077,1045,1395,1418,1367,1372,1043,916;36;M
104432;1350,715,1395,1504,1040,634,393,1369,1367,1077,186,644,1048,1522,916;33;F
104446;1539,1385,1645,1285,1392,186,1372,1367,248,1279,1403,688,977,1345,1269;33;F
104452;1279,1627,856,1102,715,1269,575;38;M
104453;1404,1403,977,1179,1504,571,384,1367,1372,715;2;M
104483;1042,1522,1048,644,248;24;F
104513;1102,1048,248,634,1052,644,1404,1395;72;M
104515;1048,1391,1042,715;40;M
104530;1361,977,1042,1386,1045;27;M
104569;1269,1380,634,1304,644,1404,938,977,1040,1627,571,1077,1418,1369,1372;32;F
104606;977,1367,1184,571;38;F
104626;186,1369,1279,1376,1269,856,1304,644,251,1040,1627,1367;24;M
104677;1627,571,1367,1372,1385,1285,1522,688,1345,1403,1404,251,977,1040,1418;41;M
104694;1102,1269,1285,957,276,1345,644,977,1613,1040,571,248,384,1367,1372;33;M
104713;1522,1539,855,715,1102,1404,251,977;31;F
104721;1380,1040,393;41;F
104773;1380,1391,251,1040,571,1077,1418;43;M
104812;1367,1613,1404,1392,715,1269,1385,856,1372,1285,1345,914,977,1279,1040;39;M
104814;1522,1418,1392,1539,1404,1403,1179,1372;37;F
104823;1046,1042,1269,1380,1392,1522,1048,644,1391,251,914,1279,1418,1367,1036;39;F
104828;644,1052,957,1522,1102,1361,1048,1345,1391,977,1077,1418,384,1372,1362;40;F
104833;1367,1372,977,1392,1403,1179,1404,1539,248,1627,1345,1285,1504,1376,1362;27;F
104844;1645,1294,715,1362,1367,1418,1345,856,1102,1269,1285,1391,251,977,1279;29;F
104853;1285,1392,248,1367,856,1102,1269,1645,575,251,1504,384;31;M
104860;1645,1285,1418,715,1392,1522,1345,1613,251,977,1040,1077,1367,393,1362;8;M
104881;1627,571,1404,1539,1294,715,1385,1102,634,276,1345,1391,977,1367,1372;33;M
104889;1102,1350,1294,1645,1052,977,571,1367,1372;25;M
104896;983,1042,1102,1269,1645,575,1285,251,914,1386,1040,1627,1045,1367,1372;28;M
104919;1040,938,1052,688,1539,1042,1102,715,1645,644,571,248,384,1367,1372;51;M
104936;634,644,248;52;F
104957;1504,393,1395,644,1052,1304,1392,1361,1645,1391,1613,938,248,384,1036;47;F
104984;1294,1350,1385,1102,856,251,977,1386,1395,1042,644,1077,1418,1362,916;35;F
105005;1350,1046,914,571,1045,1036,1043,916;39;F
105030;1385,251,855,856,1345,715,1285,1395,1372,1403,1627,1392,1362,1404,1539;27;M
105074;856,1102,1042,1269,1380,634,644,914,1279,1040,1504,1627,1077,1395,1043;8;F
105090;1504,1645,1392,644,1613,914;58;M
105091;1404,1345,688,1539,1285,575,1645,1042,715,1350,1102,855,977,186,1372;29;M
105151;1403,634,1042,1380,1392,1048,644,1386,1040,1361,1539,1404,1077,1036,393;31;F
105162;1077,1182,983,1285,1392,1539,957,276,1403,1404,1391,1279,1504,1385,1613;20;M
105164;856,634,1645,1345,644,1040,571,384;40;F
105191;688,634,715,1102,384,1367,1372;23;F
105218;1361,1042,634,1539,1052,1404,1040,384,1367,393;26;F
105235;688,1539,1285,1294,1385,1645,1052,1345,644,1404,1403,384;41;F
105248;1392,1179,1404,1403,1504;27;F
105261;634,644,248;55;M
105265;1392,251,384,1367,1504,1040,1645,1391,914,1279,856,1385,1294,1285,571;48;M
105311;1522,1285,1645,1269,1042,1102,856,1350,1046,914,1045,1036,1043,916;6;F
105319;1385,1285,1404,251,1504,1077,1362,856,1294,634,1052,1391,571,248,1367;49;F
105349;1285,1404,248,1184,1294,1279,1403,1345,688,1392,1645,575,977,393,384;39;F
105355;1380,634,1645,575,1052,276,644,1391,251,1040,1627,571,1077,384,393;29;F
105382;1046,1350,1102,1304,1052,644,251,938,1386,1040,571,1045,384,1376,1372;35;F
105387;1361,575,1048,644,1627,571,384;19;F
105393;1504,914,977,276,1048,1294,1102,1269,1391,1386,1279,1627,1367,1036,393;35;F
105401;715,1042,856,1102,1269,1380,634,644,1279,1040,1504,1627,1077,1395,916;41;F
105407;856,1102,1385,715,1046,1294,1380,1645,1285,1392,1304,914,1627,1367,1036;69;F
105442;1102,855,1539,688,1403,186,384,393,634,1404,977,1179,248,1367,1372;32;F
105444;575,1392,1304,1539,251,1504,1367,1404,1627,1376;29;F
105463;1102,1645,575,1285,1539,1404,1403,571,384,1367,1372;42;F
105469;1392,634,1345,1048,644,1613,914,1369;50;F
105475;1504,1385,1102,856,1269,1285,1522,1345,644,977,1279,1418,1367,715,1042;40;F
105496;1285,1404,1403,1279,1040,571,393,1077,248,856,276,644,688,977,1367;40;M
105517;1372,1367,1040,575,1645,856,384;29;M
105526;1372,1350,1046,914,1045,1036,1043,916;38;M
105535;1404,1285,571,186,977,1345,1522,1294,1385,715,1645,251,1367;61;F
105537;1372,916,1504,1040,1386,977,644,1052,688,1539,634,1385,1182,1304,1522;35;F
105539;251,1182,1361,1504,1380,1385,1102,1392,1042,856,1367,384,1372,393,1376;29;F
105571;571,1385;31;M
105592;1285,1279,1504,1627,1036,1043,914,251,1613,1304,575,1380,1269,1361,1040;44;F
105612;251,186,1627,1522,688,276,1345,1404,977,1504,248,1418,1367,1372,916;39;F
105614;715,1042,1645,1392,1367,1372,1613,1361,1285,1345,977,1279,1040,384,644;19;F
105629;1504,1627,856,1102,715,1042,1269,1380,634,644,1279,1040,1077,1395,916;2;F
105642;1036,1372,393,1043,1376,1042,1361,1522,1345,1040,1627,1077,1045,384,1367;27;F
105655;715,1376;39;F
105667;1350,1046,914,1045,1036,1043,916;91;F
105707;1345,1391,1279,1392,1285,1372,856,1404,1403,1385,1504,1627,1367,1645,384;37;F
105738;571,1367,1036,1372,1043,1627,644,1345,856,1102,1385,1294,1042,1048,1052;13;F
105805;1418,1042,1048,1052,1613;34;M
105833;1294,1279,1367,856,1102,1385,1645,1285,1392,1345,384,571,1391,644,634;77;F
105834;1404,1403,977,1279,1179,1627,1045,1036,1376,1645,575,571,384,1367,1372;32;M
105857;1645,1385,571,1418,384,1367,1036,916,1376,1042,1380,1304,1048,1040,1372;28;F
105895;1179,1372,1404,977,248;22;F
105903;1350,1042,1269,1522,644,1367,1504,1627,1045,1418;38;F
105941;1269,856,1539,1385,1392,1345,688,1403,1179,571,1504,575,1404,1627,1372;28;M
105959;977;65;F
105967;977,251,1391,1404,1345,1522,1392,1046,1350,1102,1042,1645,1077,248,1367;24;M
105971;856,1385,1269,1285,1279,186,1418,1372,715,1042,1522,644,1504,1367;9;F
105972;1392,1102,1380,1522,1345,644,1391,977,1386,1040,1077,1369,1372;33;F
106015;384,1372,688,977;55;F
106086;1645,1372,855,186,1367,1285,1627,251,856,1522,575,1362,1345,1077,1504;26;M
106090;983,1184,1367;62;F
106096;1046,715,1361,1102,1385,1380,1304,1345,1391,251,1367,1036,1043,1362,1376;25;F
106123;1372,1102,1042,1645,1391,251,1386,571,1077,384,1036,1367,393,1043,1376;39;F
106144;575,1392,688,1345,251,977,1279,1040,1504,1627,1077,1367,1372,393,1376;31;M
106148;1367,644,856,1269,1380,1645,1285,1392,251,977,1279,1040;27;M
106166;1042,575,1304,1048,1391,1613,251,1386,1040,1045,384,1372;33;F
106177;688,1392,1294;25;M
106181;1040,1294,1304,1385,1613,977,571,1345,1404,186,248,1418,1367,1372,1376;32;M
106201;855,634,1380,1269,1361,715,1345,251,1385,1042,1645,1040,384,1367,1372;31;F
106215;1350,1046,1645,644,914,384,1367,1372,1043,916;32;F
106237;1385,856,715,1042,1269,1285,1345,644,977,1279,1504,186,1418,1367;7;F
106255;251,856,644,1613,571,1367,1385,1294,1380,1304,1391,1386,1395,1362,1376;43;M
106260;1627,251,644,1367,1645,856,575,393,1504,186,248;37;M
106291;384,983,715,1361,1376,1043,393,1386,251,1404,1345,1048,1391,1367,1036;49;F
106292;715,688,186,1627,1045,1385,1345,1404,977,1504,571,1367,1372,1362,248;32;F
106326;1179;55;F
106328;1392,1539,1345,1404,1403,1179,1367;37;M
106388;1385,856,715,1042,1269,1285,1522,644,977,1279,1504,186,1418,1367;41;M
106392;856,1404,1504,1627,571,1077,1372,1362,1285,1345,1403,1391;53;M
106398;1042,575,1391,384,1372;37;F
106416;1046,1361,1042,634,1645,688,1048,1052,644,977,1395,248,1418,1367,1372;41;F
106423;977,1376;37;M
106498;1504,1613;65;M
106531;634;47;F
106540;1367,856,1385,1504;40;M
106566;644,1052,634,1102,856;18;M
106579;1385,1102,856,1380,634,575,1304,1048,1504,1036,1372,251,1391,1285,1040;36;F
106581;856,1392,1304,1048,1613,251,977,914,1279,1040,1418,1036,1372,916;45;F
106596;1179;22;M
106597;856,1102,1269,1613,251,1040;46;F
106600;715,1504,1418,1522,938,1040,1179,1077,384,1376;34;F
106601;575,1645,1345,977,1627,1395,1372,856,1385,715,1285,644,914,1279,1367;34;F
106635;1102,1380,644,1391,251,1627,571,1367,1372;31;F
106665;1627,914,1522,1645,1391,977,571,1372,1362,1385,1102;43;M
106689;1269,1645,1285,1048,938,384,1369,856,634,1304,644,1391,251,1040,1367;28;F
106694;1539,1404,1403,1285,1179;31;M
106713;977;75;M
106765;1269,1042,856,1102,1380,1285,1418,1367,1372;27;F
106766;1404,1345,1645,715,1269,1380,1285,251,977,914,1279,1504,384,1367,1372;33;F
106774;1403,977,1179,186,571,1045,384,1367,1372,1043,1392,1539,1404,1345,688;26;F
106783;1504,1279,977,1345,957,1285,1042,1102,856,1385,1645,575,571,384,1367;23;F
106794;1385,1539,1404,1403,1279,1179,248,1372,856,1102,186,571,1418,1367;32;M
106828;715,855,1392,1539,1345,1403,1179,1418,1367,1045,644,1052,1404,856,1077;32;F
106864;1350,1046,914,1045,1036,1043,916;65;M
106868;1404,1391,248,1367,393,1372;49;M
106898;1269,634,1285,644,1391,1279,1627,384,1367,1372,1376;27;F
106910;916,983,276,1362,1376,1391,1345,248,644,1361,634,1304,688,977,1395;40;F
106924;715,1385,1504,1179,1279,977,1403,1627,1367,1269,688,1404,1418,1372,1345;25;F
106941;1046,1042,1269,1522,1345,1391,1613,251,938,977,914,1040,1077,1043,1045;38;F
106949;1350,1046,914,1045,1036,1043,916;57;F
106951;856,1102,1350,1046,1380,634,1645,1392,1522,251,1042,1304,1613;40;M
106953;977,1279,916,1392,644,1040,1395,1376,1418,1372;41;F
106966;1367,1418,1627,914,977,251,1391,644,634,715,1385,856,1036,1376;35;M
106968;1380,1391,1040,1627;34;F
106982;1102,1052,1345,1627,1376,248,977,688,1042,1304,644,1391,251,1372;28;F
106993;1392,644;3;M
106994;1404,1102,1522,1392,1285,1504,1627,856,1385,1645,1391,977,186,571,1367;41;F
107002;1345,1269,715,1391,1077,1418,384,1367;36;M
107021;856,1385,715,1294,1645,1522,1345,644,1391,977,1504,571,1418,1367,1372;92;M
107032;856,1102,1269,634,251,384,1372,1367,186,1627,1504,575,1385,1645,248;43;F
107037;1522,1077,1627,1504,977,251,1391,644,1392,1404,1418,384,1367,1372,1376;49;F
107046;1380,1392,1522,1345,1391,1627,1077,856,1269,1285,251,1040,1279,1418,1367;40;F
107076;1269,644,938,977,914,1418,1367,1372;42;F
107089;856,1385,715,1294,1392,1345,977,1504,186,1627,571,1367,1372;21;M
107103;1361,1391,977,914,1504,1040,251,1345,1048,575,1645,1380,1042,384,644;30;F
107113;914,1386,384,393,1043,856,715,1285,251,1040,1077,916,1369,1362;41;F
107123;1404,1403,977,914,1386,1279,186,1627,571,1045,248,1184,1418,1367,1372;36;F
107128;688,1539,1392,983,1042,1102,1645,1285,251,977,1040,1367,1372;28;M
107149;1304,1048,186,1627,571,856,1380,1645,1285,1345,1613,938,1279,1504,1372;36;M
107153;1613,856,1392,1077;48;F
107171;1102,1042,1052,977,571,1395,1418,1367,1372;48;M
107190;575,1504,186,571,248,1043,1385,856,634,644,938,1040,384,1369,393;37;F
107202;1376,1304,1613,1077,715,1392,1504,856,1102,1522,1345,1391,977,1372,1362;24;M
107239;1522,1504,1627,571,1645,575,1392,1345,1613,977,1279,1418,384,1367,1372;46;F
107252;1179;66;M
107263;1361,1042,634,1645,1304,1048,1052,1345,1391,1386,1504,1395,1367,1369,1372;28;F
107274;1361,856,1294,1042,634,1645,575,1052,251,1040,1627,384,1392,1504;31;F
107284;855,1304,1522,688,1404,1403,1391,1179,186,1184,384,1367,248;37;F
107293;856,1294,1182,575,1627,571,1077,1367,1372,916;33;F
107319;1380,1522,251,938,1040,1504,1627,571,248,1418,1367;38;F
107332;1645;40;M
107336;1418,1367,1294,856,1645,1285,1522,1345,644;44;M
107340;1522,1418,1392,1539,1404,1403,1179,1372;37;M
107356;1372;32;M
107365;1372,248,1627,1040,977,1391,1403,1404,1345,1539,1392,1285,575,1269,1102;29;M
107381;1350,1102,856,1042,855,1048,1052,1391,1613,1045,1077,1395,384,1367,1372;44;F
107397;1367,1418,1077,1504,1345,1522,1285,715;42;F
107414;384;25;F
107436;1392,644,977,186,251,1285,634,1645,1376;52;F
107451;1350,1046,1048,251,1386;48;M
107458;856,1046,1269,1285,1522,1345,644,914,1040,1279,186,1627,571,1418,1367;3;M
107460;1391,856;26;F
107479;276,1046,855,983,1052,1391,1386,1179,186,1045,248,1042,1392,1345,1372;29;F
107506;1392,1052,1404,1504,186,856,1077;37;M
107514;634,1285,644,1391,251,1367,1372,1376;30;F
107518;1645,634,1350,1285,1077,1367;38;M
107535;1042,1361,1269,1380,634,1645,1392,1304,251,914,1040,1367,1036,1369,393;39;F
107542;1385,1361,1042,1645,1048,1404,248,1504,1367;24;F
107543;1179;85;F
107553;1285,1392,1539,688,1040,1361,1048,644,1404,1403,1179,1367,1372,393,1362;48;M
107574;1395,1036,1369,393,1361,634,1539,1522,1048,186,248,644,1504,1367;41;F
107579;1404,644,1269,1294,1350,1046,1645,914,1045,1036,1043,916;60;F
107580;1345,644,1504,1627,856,1102,634,1645,1391,1040,384,1367;32;M
107583;1627,1077,856,1102,1042,634,855,644,1391,571,248,1367;41;F
107586;977,688,855,856,1269,1285,1539,1345,1403,1404,1391,1279,186,1372;24;M
107599;1372,1294,715,1392,1179,688,276,1345,1404,1403,1613,1504,571,1184,248;30;M
107642;1385,856,715,1269,1380,1285,1522,1391,251,1279,1040,1627,1077,1418,1367;41;M
107656;1539,1403,1404,1645,1102,1372,1367,384;30;M
107659;977,1504,186,914,575,1645,1102,1380,1304,251,1040,384,1367,1372,393;47;F
107672;938,1395,1279,1403,1404,1345,1539,1285,1350,715,1042,1645,575,1504,384;29;F
107707;1645,634,1285,384,393,1376;37;F
107726;1046,856,1385,715,1269,1285,1522,1345,644,1279,1040,1627,571,1418,1367;1;M
107727;1391,251,977,1077,1372,1362,715,1269,634,1522,644,1504,186,1627,1367;31;F
107734;715,1522,644,1391,977,1279,1040,1504,1418,1367,1036,1362,1385,1285,1077;5;F
107741;1645,575,1386,1504,186,248,384,393,1043;36;F
107745;1102,1380,634,575,1392,1345,1404,644,1391,1504,1367;73;F
107767;1361,575,1392,1345,644,251,977,1504,1418,384,1036,1369,1372,393,1362;26;F
107799;715,575,1285,977,186,1627,1367,1372;35;M
107847;1179;58;M
107882;1350,715,1294,1285,1392,1403,1404,251,914,1504,571,1045,1418,1367,1376;29;M
107896;983,1376,957;58;M
107945;248,1376,715,1294,1285,1539,1345,1403,1404;29;F
108012;186;45;F
108034;1392,1361,1102,1380,1304,1404,1391,251,977,186,1627,1367,1036,1369,1372;37;F
108042;1042,938,977,1386,1040,1504,186,1367,1361,384,251,1403,957,983,575;26;F
108046;1294,983,1404,1391,1362,1279,1040,1285,856,1269;26;M
108066;1345,1102,1179,186,571,1362,1279,856,1392,1285,1404,1403,977,1367,1372;29;M
108072;1345,1392,1285,855,1645,1269,1403,938,1386,1279,384,1036,1372,186,248;34;M
108076;1046,856,1269,1285,1392,644,1613,914,1627,1077,1045,1418,1367,1372,916;43;F
108106;1350,1042,855,1539,688,1048,957,1345,251,977,571,248,384,1367,1372;37;F
108152;1418,1369,393,1043,1380,1285,1304,1522,251,938,1279,1040,1504,1627,1077;33;F
108189;1361,1102,1304,1048,384,1369,1376;42;F
108207;1522,1504,1627;20;M
108239;1182,1285,1392,1345,1391;29;F
108242;1367,1043,186,1504,644,1048,634,1042,856,1380,251,1040,571,1372,393;41;F
108249;1392,1539,688,1404,1403,1391,1179,1077,248,1362;34;M
108262;1404,1403,251,938,977,1279,1040,1179,186,1627,571,1077,1184,1367,1372;24;M
108314;1294,1385,856,1645,1392,1040,186,571,1367;59;F
108358;715;40;M
108397;688,977;41;M
108409;1404,1403,1392,1385,856,1269,1285,1279,1367;13;M
108419;914,1279,1627,571,248,1367,1102,634,1285,1304,644,1040,1179,1376,1372;30;F
108429;1361,1042,1403,1279,1040,1077,248,1367,1369;30;M
108476;1040,186,571,1077,248,1418,1367,1345,688,575,715,1102,1385,856,1372;37;F
108480;977,1627,571,1184,1279,1040,1404,1403,1048,1285,1645,715,856,1376,1395;28;M
108500;1361,1042,1304,248,634,855,1504,983,1345,1077,1392,977,1376,644,1391;34;F
108507;1613;18;M
108516;1042,634,1627,1077,644,1418,1367,1372,1102,1304,1391,977,1040,393,1043;39;M
108521;1285,856,1385,1294,1645,1392,1522,644,1279,571,1418,1367;38;F
108527;983,1182,276,1077,856,1404,715,1645,688,977,1504,1627,248,1367,1372;34;F
108529;634,1052,1345,644,251,914,1179,1504,384,1367,1369,856,1048,977,1372;26;M
108530;1539,1404,1403,977,1179;27;M
108557;1385,715,1042,1380,1345,1391,1040,1504,1418,1182,634,575,1304,251,384;40;F
108570;1380,1522,1391,977,1040,1504,1395,1418,1367,1372,1362,916;44;M
108575;1367,393,384,1627,251,1391,1182,1102,856;42;M
108584;1042,1048,1391,1418,1372,1362,1522,251,1367;32;F
108606;1627,571,384,1504,1285,1345,1042,644,1045,1376,1294,1279,1367,1385,1269;34;F
108638;1380,1304,1522,1391,1040,1362,1042,1269,1279,1077,1418,1367;34;F
108646;1539,688,1345,1391,977,571,1367,1372;31;F
108651;1102,856,1380,1504,1040,1627,251;27;F
108694;856,1385,715,1294,1392,644,977,1627,1372;69;M
108751;856,1102,1385,1042,634,855,644,1391,571,248,1367;5;F
108772;186,248;67;M
108783;1385,571,248,1504,1627,1036,1102,1392,1345,1391,1404,1403,1179,1367,1372;39;M
108784;1042,855,1522,1391,251,977,914,1386,1279,1040,1077,1045,1418,1367,1369;36;M
108801;1522,1285,855,1042,715,1350;3;M
108807;983,575,1361,1102,1042,1522,1048,186,1345,977,248,384,1036,1372,393;38;F
108868;1350,1046,1304,1392,251,914,1045,1395,1036,1043,916;38;M
108872;1042,251,977,1627,1367,856,1362;15;M
108894;1403,1404,983,957;35;M
108907;571,1077,1372,916,1627,251,248,644,1367,1645,856,575,393,1504,186;38;F
108922;1645,1285,1304,1048,1391,251,1040,1179,1504,1627,1369,1372,393,1418,1367;38;F
108928;1179;85;F
108932;1392,1522,1367,1376;43;F
108965;1042,1294,1385,1102,856,1645,1522,977,1040,1504,186,571,384,1367,1372;50;F
108966;1345,977,186,1627,571,1418,384,1372,575,1392,1404,1403,1179,1504,1367;38;M
108983;977,571,248,1372;37;M
108999;1372,1077,1504,1040,977,251,634,1380,1294,1102,575,1304,644,571,384;27;F
109035;1294,1380,575,1391,1504,384,1036,251;28;F
109041;1385,1522,1279,1627,856,1392,1391;38;F
109080;644,1048,634,575,1645,1380,1042,715,1102,856,1304,251,1504,1627,571;31;F
109186;251,1345,688,1539,1392,856,1285,1404,1367,1372,1362;33;M
109199;1042,1627,1045,1043,856,1361,1304,1522,1613,1504,1418,1367,1372,393;26;F
109211;856,1102,1182,634,1304,1048,1052,644,571,1184,384;31;F
109213;1367,251,1392,1385,856,1269,1285,1404,1403,1279;10;M
109217;186,248;64;F
109225;1269,1392,644,1345,1504,1418,1036,1369,393;29;F
109244;1627,1077,1285,1345,1403,1404,1613,1279,571,1385,1102,856,1269,1392,1367;31;M
109250;1279,1403,983,957;28;F
109251;1385;49;M
109255;1350,1361,575,914,1386,1077,1367,1372,1376,856,1102,1285,1048,1391,1040;37;F
109261;1040,914,251,1391,1345,855,1645,715,1385,856,644,977,186,1367,1372;44;F
109275;1392,1522,1345,644,1391,938,977,1386,1279,1504,1627,571,1367,1036,1372;28;M
109276;1392,1627,1391,644,1304,1613,856,1269,1380,1345,251,1279,1040,571,1367;36;F
109280;856,1102,1380,575,1392,1048,1404,1391,251,977,1040,1504,384,1367,1372;27;F
109283;1102,856,1385,715,1269,575,1285,1522,1345,977,1279,1504,1627,384,1367;41;M
109302;1294,1380,1304,251,1040,571,1077,1045,1395,1367;71;F
109308;1304,1522,914,1504,1627,1077,1362,856,715,1269,1645,1345,644,1391,1367;32;F
109322;1367,914,1380,251,1040;31;F
109335;384,1367,856,1102,1645,575,251;36;F
109337;1391,856,634,1048,938,186,571,1367,1036,1043,916,644,1294,1645,384;45;F
109367;1102,856,634,983,1048,1345,644,1391,977,1040,186,1367,1036,1369,393;27;F
109370;1102,1385,1269,1380,1645,575,571,1392,1048,644,251,1279,1040,248,384;32;F
109382;1376,1350,1046,1182,1645,1304,1522,644,1404,1040,1627,571,1418,1036,916;41;M
109405;1279,1269,1392,977,1504;49;M
109420;855,688,1048,957,1345,644,1404,1391,977,571,248,384,1367,1372;40;F
109421;1102,1042,575,1052,251,977,914,1040,1504,571,248,1367,1369,1372,393;28;F
109424;1285,855,1042,1522,1404,1102,688,276,251,977,1077,1045,248,1418,1372;40;F
109502;644,1613,1418,1367,1362,1627,1279,914,1391,1522,634,1269,1102,856,1077;35;M
109542;1102,1269,1285,1304,251,1279,1040,1077,1367,1376;35;F
109549;1279,1627,571,1395,1418,1367,1369,1372,1362,1048,644,251,1042,1040,1077;37;F
109570;1285,1304,251,1279,1040,1077,916,1376;9;M
109579;1613;46;M
109587;1380,634,1645,575,1345,1391,977,1040,1077,1367,1392,856,644,1613;45;M
109595;1269,1285,1304,1404,251,1279,1040,1077,1376;7;F
109597;1042,634,1539,644,1504,571,1395,1046,1522,1404,251,1418,1367,1372,393;35;F
109616;1627,1077,384,1367,1372,1504,1179,1391,1403,1404,1345,1539,1392,855,1645;26;M
109632;1042,634,1522,644,1077,916,1362,575,1392,1404,251,1627,1395,1418,384;39;F
109659;977,1179,1372,1403,1404,276,688,1504,248,644,1345,856,855,1367,1645;33;M
109661;1376,384,571,186,1504,1040,977,575,1385,1304,251,1418,1367,1036,1372;31;F
109668;1077,1613,1345,1539,1372,1391,1403,1404,1392,855,1645,1102,1179,1367,384;25;F
109699;1361,1042,251,914,1395,384,1367,1036,1372,393;37;M
109701;1404,1279,1504,1627,715,855,384,1362,856,1285,644,1391,1045,1077,1043;36;M
109759;1294,1392,1504,1627,571,1285,1539,1403,977,1179,384,1367,1645,1404,1372;73;F
109760;1522,1279,1395,1376,1036,251,644,1052,1285,1645,634,1380,1269,1385,1042;29;M
109780;1285,1645,856,1380,634,1304,1052,644,251,1040,1395,1376;38;F
109812;1102,1304,1522,1048,1345,1391,977,1040,1504,1627,1077,1418,384,1367,1372;71;F
109854;1645,575,1285,1304,1522,1048,977,1040,1504,186,1077,384,1367,1372,393;80;M
109859;1645,634,1385,856,1380,251,977,1040,1077,715,1504;30;F
109880;1392,855,1380,1391,1345,186,1040,634,856,1036;21;M
109881;1361,1269,1380,251,1279,1040;45;M
109898;855,715,1404,977,1040,186,1627,1367,1372;30;M
109906;715,1042,1182,1285,1522,251,1279,1627,1077,1367,1372,1269,575,1504,1418;34;F
109912;1613;42;F
109916;1380,1392,1304,1522,1613,914,1040,1627,571,1077,1418,1367,1372,644,1504;40;M
109958;1395,977,688,1304,634,1361,644,248,1345,1391,1376,1362,276,983,916;1;F
109972;856,1385,1294,1380,1285,1392,1345,1404,1403,977,1279,248,1367,1372;44;M
110013;1345,1522,1285,634,715,1504,1386,1391,1304,1380,1102,856,1361,393,1040;54;M
110041;1269,1279,1077;58;F
110046;1361,856,715,1269,1285,1304,1539,957,977,1504,186,1418,384,1367,1372;35;F
110073;856,1102,634,1645,1392,1522,1345,644,1391,1613,914,1279,1627,1077,1045;42;M
110093;1285,1404,977,1279,248;53;M
110107;1392,1539,1048,1345,1404,1403,1279,1040,1504,1627,571,1372,1645,1367,1376;29;F
110112;1645,1285,1345,644,1391,251,1279,1040,1627,571,1077,1418,1367,1372,1362;42;F
110114;1522,1048,1404,1391,1279,1504,1627,571,1369,1392,1345,644,251,914,1040;36;F
110199;1043,384,1391,1645,1042,856,1294,1392,1345,1613,251,977,1627,571,1372;45;M
110203;1048,1391,1042,575,1392,1404,251,938,1504,1627,1395,384,1036,1362,916;39;M
110211;1504,1645,1269,1102,856,1380,1304,1522,1345,644,1391,1418,1367,1372,1376;1;M
110268;983,276,1391,1345,248,644,1361,634,1304,688,977,1395,1362,916,1376;6;M
110269;571,248,1391,1345,856,1269,1285,1279,1367;44;M
110316;1269,251,1279,1040,384,916;48;M
110356;715,1285,1392,1279,186,1627,571,1077,248,1102,644,1613,977,1367,1372;64;M
110376;1042,575,634,644,1404,1403,251,1040,1179,1504,1627,1045,248,1367,1376;48;F
110402;1042,1380,1645,1392,1304,1345,644,1391,251,1627,571,1418,1367,1369,1376;34;F
110435;1391,1385,1102,856,1294,634,1645,1048,644,186,571,384,1367,1043,916;7;F
110449;856,1522,1345,1102,251;59;F
110516;1385,977,1279,1077,1372,1522,1345,644,1403,1404,1627,1418,1367,916,1376;37;F
110533;856,1294,1645,1304,1345,644,1391,977,1040,571,384,1367,1372;34;M
110543;1404,1403,186,856,1102,1385,715,1645,1285,1345,1179,1627,248,384,1367;50;F
110545;1040,1504,1048,1369,1418,1184,1362,644,1627,251,1380,1345,1395,1522,1392;33;M
110568;1304,1040,1404,715,1285,1367;32;F
110575;1380,1182,1350,1102,1504,1045,856,1385,1645,1522,1391,1613,1627,1418,1367;68;F
110601;1539,1285,1294,1385,856,1269,688,644,186,1184,1367,1372;40;M
110632;688,1392,1380,1285,1304,1404,1391,251,1386,1372,571,1367,715,186,1539;32;M
110645;1279,1627,571,1294,715,1184,1367,1372,977,1404,276,688,1539,1102,248;40;M
110653;644,1391,1627,1395,856,1380,634,1645,575,1304,1048,251,1040,393,1367;31;F
110664;856,1361,1046,1380,914,1279,1362,1376,1269,1304,251,1040;35;M
110679;856,575,1391,1040,1504,1627;40;F
110720;1645,634,1294,715,1102,575,1392,688,1391,1504,571,384,1367,1372;24;M
110760;715;37;F
110775;1391,977,384,1372,1522,1361,856,1046,1380,1304,1345,644,1418,1367,1376;39;M
110777;1504,1279,977,1613,1403,1404,1345,688,1392,1285,855,1269,1539;21;M
110780;1504,688,1522,1385,1304,1102,715,1380,251,977,1627,1418,1367,1036,1372;31;M
110795;1522,1304,575,1052,957,1504,1045,1040,1048,1392,1645,1042,1182,1345,1372;26;F
110840;644,1345,1052,957,1048,1539,1392,1645,1269,1285,1522,1391,1627,1036,1418;29;F
110940;1285,1102,634,644,1391,1040,1395;69;F
110949;856,644,1391,571,1077,384,1372;42;F
110953;571,248,1385,856,1391,1522,1269,1279,1077,1418,1367,1372,393;36;M
110963;1279,1102,977,688,1294,1285,1627,1504,1367,186,1391,983,957,384,1184;55;M
110978;1376,1052,1522,1304,856,1042,1380,1645,1345,644,1391,251,1077,393,1362;31;M
110996;1404,1045,1418,1367,1345,1042,634,1645,1048,957,1052,644,1391,1504,384;24;F
110999;1345,1040,1367,644;32;F
111012;1304,276,1404,1504,1077,1345,644,248,384;39;F
111053;1392,1522,1048,1345,644,1404,1391,251,914,1279,1040,1504,1627,571,1369;6;F
111069;1040,384,1367,1376,856,1102,1380,1269,1645,1285,1345,1391,251,914,1279;63;F
111078;856,1102,715,1294,1285,1522,1279,1040,1504,1367;31;M
111123;715,856,1042,977,1350,1285,1522,644,1345,251,1504,1627,1418,1367,1372;33;M
111152;1042,688,1052,1345,644,977,186,571,248,1418,384,1367,1372,393,1376;25;F
111157;1285,1376,634,1645,1304,644,1391,186,1372;39;M
111173;983;30;F
111191;983,1376;31;M
111237;1369,393,1350,1182,1345,644,1391,251,571,856,1304,1522,1613,1372,1376;33;F
111281;856,1380,1285,1304,1048,1391,251,914,1386,1040;35;F
111292;186,384,1385,1182,1345,644,1613,914,1179,571,1645,1294,1279,1040,1077;39;M
111316;1539,1392,1042,1294,715,1269,1285,1522,1391,977,384,1367,1372,916,1376;38;F
111342;1345,914,1627,1372,1042,1269,1285,251,1279,1504,1418,384,1367,1036,1376;33;F
111350;575,571,384,1372,1362;31;M
111355;1539,1285,1182,1043,715,1385,1046,1304,1404,1403,914,1386,1040,1367,1372;25;F
111357;1345,1045,856,1304,1048,1279,1539,1376,1627,644,1269,393,1040,1386,251;34;F
111359;1345,1391,276,248,688,977,644,1361,634,983,1304,1395,1362,916,1376;44;M
111362;1613;12;M
111365;1504,957,1522,1304,715,1042,1269,1048,1052,1391,1386,1395,1367,1372,1043;41;F
111388;856,1385,983,1345,644,1391,251,1504,1627,571,1077,1045,248,384,1367;29;M
111389;1279,1504,1627,1392,1522,1048,1345,644,1404,1391,251,914,1040,571,1369;3;F
111394;1279,1040,1179,1376,688,1403,983,1391,575,957,251,1504,186,1184,384;26;M
111401;856,1645,575,1285,1345,1404,1391,1504,186,1077,1367;34;F
111406;571,1269,248,186,1627,1345,1613,977,1040,1367,1372,575,855,1102,856;27;F
111459;1645,1045,1369,393,1372,856,715,1042,1522,1345,1627,1077,1418,1043,1361;31;F
111473;1182,1345,1504,1418,1372,1645,1392,634,715,856,1294,571,644,1385,1367;45;M
111479;1077;40;M
111491;855,1392,1403,1391,1279,571,248,1367,1645,1404;40;M
111503;856,1385,1052,1403,251,1627,186,571,1045,248,1367,1372,1043;27;M
111534;1613;14;F
111535;1504,1539,1392,1627,571;31;M
111536;856,1385,634,1285,1304,688,1048,1404,1279,1040,1504,571,1367,1645,1372;40;F
111579;856,1380,575,1522,1304,1048,1345,977,1040,1504,384,1367,1036,1369,1372;28;M
111627;1504,1391,1539,1392,1350,1046,1522,1048,1345,1404,1627,1418,1367,1036,1372;36;F
111639;914,1279,1392,1522,1048,1345,644,1404,1391,251,1040,1504,1627,571,1369;35;M
111657;1539,1392,1102,1404,1403,251,977,1279,1179,1504,186,248,384,1367,1372;32;M
111787;1285,1645,1294,856,1279,1269,1613,644,1392;48;M
111813;1385,1361,856,1102,1294,1042,1645,575,688,644,938,977,571,1367,1372;31;F
111819;1182,1380,938,1369,393,856,634,1392,1391,251,1040,1504,571,384,1036;26;F
111831;1392,1285,1522,1048,1345,1404,1391,977,1279,1504,1077,1418,384,1367,1372;46;F
111906;1380,1269,1522,688,977,1627,1367,1372,1385,856,1304,251,1504,571,1418;38;F
111915;571;43;F
111989;1102,1304,1522,1279,1040,1504,1077,1418,384,1367,1372,1362,1376;64;F
111991;1269,1345,644,914,1627,1367,1376,1304,1522,1048,251,1040,1077,1045,916;33;F
112046;1048,1345,1404,1403,1391,977,914,1279,186,571,248,1418,1367,1372,1376;39;F
112054;1392;31;F
112056;1367,1645,1361,983,957,1184;48;M
112064;1367,1504,575;33;M
112074;856,1077,644,248;38;F
112101;983,1102,856,1385,1269,644,1386,1627,1036;41;F
112125;856,1345,1627,571,1285,644,1404,1403,1391,251,1279,1040,186,1077,384;38;F
112135;1042,1350,1269,1380,1285,1345,644,251,914;41;F
112144;1350,1046,1392,1045,1395,1036,1043,916;6;M
112151;1395,1345,1522,1385,1504,856,1645,644,1613,251,977,571,248,1367,1372;38;M
112155;1391,1627,248,1362,1645,1522,688,276,1345,977,1504,1367,1372,1376,1077;27;F
112198;1077;8;F
112205;1392,977,248,1102,276,251,1645,384,1184,571,856,1404,1345,186,1367;31;F
112273;1102,634,1285,1345,644,1391,1040,1395,393;45;F
112281;251,1040,1269;31;F
112282;977,571;2;M
112300;1102,1645,575,1345,1613,977,571,1627,1077,384,1367,1372,1385,1391,1504;32;M
112331;1627,914,1391,1102,1385,715,1380,634,575,1522,644,251,1040,1504,856;27;M
112332;1418,1369,1043,251,1048,1522,1304,1380,1046,1385,856,186,1627,571,1367;46;F
112338;1367,1046,1645,983,1627,384,1279,1404,977,571,688,248,1184,1372,1385;24;M
112386;1350,1046,1392,251,914,1395,1036,1043,1362,916;;M
112389;251;40;F
112390;1048,1376,1385,1042,1380,634,1645,688,715,1522,644,1504,1627,1395,856;41;M
112467;1504,1392,1385,1645,1367,1345,1182,1102,856,855,644,575,571,384;39;M
112482;1077;6;F
112487;1367;55;M
112517;1380;46;F
112531;856,1294,1385,1042,634,1522,1372,1645,251,571,1367;47;M
112533;856,1102,715,1285,1345,977,1040,916,1077,1418,1367,1372;38;F
112590;1102,1269,1345,1627,1045,1418,1367,1362,856,1392,1522,1391,1613,1279,1077;42;F
112597;856,1385,1522,1345,1504,186,1627,571,1077,1045,1418,384,1367,393,1362;5;F
112598;1040;33;M
112602;186,856,1522,1077,1279,1385,1391,977,1367,1372;26;M
112608;1102,715,1269,1645,1285,1539,1345,1404,1391,977,1504,186,384,1367,1372;34;M
112610;856,1042,575,634,1392,1522,644,251,938,1504,186,571,1077,1367,1043;36;F
112621;1385,1102,856,1048,1391,977,186,571,1372,1043,1362,1304,1040,938;21;F
112623;1042,1522,914,1036,1418,1077,1052,1048,1350,1304,916,1040,1613,644;45;F
112642;1269,1522,1391,1627,1418;35;M
112644;1385,1294,1645,855,1392,186,1522,1345,644,977,1627,571,248,1367,1372;54;F
112648;977,644,938,1040,1077,1418,855,1645,1345,251,1367,384,1369,1372,1043;26;F
112692;1294,1504,1627,186,1418,1367,1372,1279,1539,1392,1285,1645,1385,715,384;37;F
112701;1042,1304,1522,644,977,251,1279,1040,1627,1045,1418,1367,1372,916,1376;34;M
112712;1285,1279,1367,1392,384,1043,1102,855,575,1504,186,1627,571,1077;25;M
112734;1627,186,1504,1279,1345,1048,688,1539,1392,1404,1045,1102,977,1367,1372;30;M
112741;575,715,1361,1269,1285,384;50;F
112743;856,1385,1294,1627,571,1367;44;F
112746;977,384,1048,1522,1392,1102,856,1385,1645,1504,1077,1395,1418,1367,1372;36;F
112753;1269;39;F
112766;1362,186,983,634,1404,1403,251,938,977,1040,1627,1367;26;M
112780;1077,571;10;M
112795;856,1385,1042,1304,1613,914,1040,1504,1367,1372;23;M
112862;1102,715,1042,634,1522,1404,977,1395,1418,1367,1372;38;F
112863;715,1285,1392,1522,1048,1345,1391,977,1179,1504,1627,1077,384,1367,1372;74;F
112865;856,1102,1385,1380,1392,1522,644,251,1279,1040,571,1367,1627;43;F
112877;715,1046,1350,1102,856,1042,1269,1285,644,1279,1040,1077,1418,1367,916;42;M
112882;856,1376,1304,1040,1367,1102,1385,1269,1645,575,1052,1391,1504,186,384;30;F
112894;1350,715,1380,634,1285,1345,1418,393,1522,1391,251,977,1040,1367,916;34;F
112895;1362,856,1345,1182,1367,1504;36;M
112933;1539,1345,1404,1403,1179,1372,1269,1285,1391,251,1279,1040,1504,1627,393;35;F
112943;983;36;F
112951;1345,1403,1279,1179,186,571,1372,393,855,575,1392,1404,977,1504,1367;32;F
113009;1285,1522,1345,1391,914,186,1418,1385,856,1361,251,1627,384,1367,1036;33;F
113013;1350,1042,1269,1304,1048,1345,251,938,1279,1040,1395,384,1369,1372,1376;30;F
113051;1285,1504,1367,384,1077,571,644,1345,1392,855,1645,1182,1385,1102,856;40;F
113135;1350,393,1395,1045,1036,1043,916;40;F
113151;1404,251,938,1179,1627,384,393,1367;27;F
113184;248,186,384,1645,1627,1391,1385,1367,1294,1269,1182,1045,856,644,571;29;M
113217;1391,251,914,1040,1504,1627,1045,1395,248,1418,384,1036,1372,393,1376;40;F
113224;1504,1279,914,1403,1345,1522,1285,1645,1102,1392,856,1404,571,1367,1294;42;M
113233;1391,384;31;F
113256;1345,1048,1645,1042,1395,1036,1613,251,914,1045,1043,916,1392,1046,1350;37;F
113298;1285,855,856,1385,715,1539,688,1345,1404,1403,977,1627,248,1367,1372;28;M
113317;644,1361;31;M
113323;393,1345,1036,1367,1372,1391,1361,1380,1392,1304,251,977,1040,248,1369;46;F
113330;1369,1046,1042,855,634,1522,1391,1627,1418,384,1372,1645,251,1040,644;34;M
113351;1042,1285,644,1404,1403,251,1179,1077,1395,1418,1367,1036,1372;77;F
113375;571,186,914,938,1539,1042,1645,688,1404,251,248,1418,384,1367,1372;29;F
113385;1380,575,1522,1345,1362,1367,1418,1627,186,1504,1279,1285,1269,251,1040;36;M
113390;1392,1048,1404,1391,251,977,914,248,1367,1036,1372,1043;23;F
113439;916,1386,186,1077,1045,384,1376,856,1350,1042,1048,644,1391,1036,393;32;F
113463;1418,1367,1372,1043;34;M
113485;1042,1645,575,1285,1345,644,1391,251,1279,1418,1367,1392,1504,1269,1522;2;F
113495;1391,1304,1285,1046,856,1380,1645,1345,1077,1418,1367,1372,1369,1040,251;32;M
113509;1376,384,1045,1504,251,1391,1345,1304,1285,575,1645,634,1042,715,1350;28;F
113511;1361,1380,1392,1539,688,1345,1404,1403,251,977,1179,384,1367,1372,1362;39;M
113594;1102,1269,1391,1376,251,1279,1040;32;F
113596;1367,1372,1046,1385,1184,1627,1279,1404,384,977,248,571,688,983,1645;52;F
113620;1627,1504,1279,1386,914,1345,1048,1522,1304,1392,1285,1385,1102,856,1269;36;M
113635;571,248,1367,1372,1102,1285,1522,1345,1404,1403,1391,251,1179,1418;40;F
113665;1392,1294,1627,384,1367,1285,1385,1102,856,1345,644,251,1613,1077,1362;35;M
113703;384,1040,856,644;60;F
113747;1645,1392,1285,1042,1102,1052,276,1345,644,1404,1391,1279,1627,571,1367;38;M
113751;1182,715,856,1361,1385,1294,1645,1304,1048,393,1372,1367;29;F
113758;1385,715,1182,855,1539,957,1102,688,1345,1404,977,248,1367,1372,1362;34;F
113759;575,634,856,1380,1052,251,914,1040,384,1367,1369,1372,393,1043,1376;36;M
113779;1403,1404,688,1539,1294,1361,1102,1269,1645,1285,1345,644,1279,1367,1372;44;F
113783;1522,1345,1391,1504,1627,1077,1418,1367;33;F
113791;251,1040;34;M
113807;644,251,938,1040,186,571,1077,248,1418,1367,1036,1372,393,1043,1376;67;F
113810;1345,1269,1361,1380,1285,1391,1279,1040,384,1372;38;M
113818;186,1395,1184,1418,1367,1372,1539,1285,1645,1385,1627,1179,715,1404;29;F
113822;1077,856,1361,1294,1380,634,1285,1522,1048,644,1613,1040,1395,1418,384;59;F
113831;1102,634,575,1345,644,251,1504,856,1052,1279,1040,1077,248,393,1184;30;F
113855;1042,1380,1285,1304,1052,251,938,1040,1627,1077,384,1369,1372,1376,1043;27;F
113861;856,1345,1043,1367,634,1645,644,1391,938,1040,1045;54;F
113862;1179;39;M
113890;1048,1345,1391,1040,1627,1350,1046,1380,914,1043,1045,1395,1036,1372,916;46;F
113892;1285,855,1042,1385,1294,1539,688,1345,1404,1403,977,1279,186,571,248;33;F
113902;1345,1392,855,634,1385,1361,1404,251,938,914,1040,1504,248,384,1367;29;F
113921;1304,1040,186,1627,1077,1395,384,1036,715,856,1102,1042,1522,1345,1418;32;F
113931;1042,1285,1522,1345,938,1040,1418,384,1036,1372;24;F
113950;251,977,856,1102,1046,1269,1285,1522,1391,914,1279,1040,384,1367,1372;29;F
113952;1042,1102,1269,1040,1627,1077,1395,1367,1372;29;F
113965;1285,1345,644,1404,1403,977,1179,186,571,1395,384,1418,1367,1372,1376;31;F
113981;983,1367,1645,856,251,248,1392,977,644,1179,1403,1539,1404;28;F
113982;186,1367,1279,1404,384,977,248,571,688,983,1645,1385,1046,1372,1184;55;M
113991;914,1504,1627,1372,1345,1539,1042,1102,1269,644,1391,251,977,1040,384;32;F
113997;856,1385,715,1269,1285,571,1045,1376,1645,1392,1522,1279,1504,1627,1367;38;F
114075;1042,1645,1048,644,1045,384,1367,856,1385,1294,1392,1345,1504,1627,571;27;F
114095;1418,1367,1040,251,1052,1304,1380,1042,1294,1362,1627,1269;30;M
114108;1043,1036,384,1380,1392,1539,1345,1404,251,977,1040,1504,186,1367;25;M
114112;1522,575,1102,1361,393,1043,1376,1645,1304,938,856,251,1613,1040,384;29;F
114129;1627,1504,977,1404,1345,715,1385,1102,856,1285,644,1613,1279,1077,384;61;F
114134;1285,1048,1345,644,1391,914,1386,1040,1367,1372,1361;23;F
114147;1045,384,1036,1043,916,644;16;M
114214;1102,276,384,688,1404,1403,1391,248;45;F
114218;1645,1392,1539,688,1404,1391,977,571,1395,248,1367,1036,1372;22;M
114222;1179;4;M
114305;1380,575,1304,1048,1345,1391,251,977,914,1040,1504,186,384,1367,1036;30;F
114310;856,1102,1269,1522,276,644,1391,1627,1077;39;M
114322;1361,1042,1102,1380,1304,1048,644,1391,1613,251,1040,1036,1369,1372,393;44;F
114324;1042,1304,1522,1048,251,938,1386,1040,1627,1418,1036,393,1376;28;F
114331;856,1385,715,1042,1380,634,1645,1522,688,1048,644,1504,1627,1395,1376;4;M
114344;1367,384,1645,977,856,1102,1392,1345,1404,1403,1613,1504,571,1077,1372;26;M
114360;644,1376,1184,1385,1367,1539,1403,1645,1418,1345,1504,1040,1372,1386,1269;32;M
114405;856,1102,1269,575,251,1040,1504,1627,1367;31;F
114417;1040,1045,1350,1380,1392,1345,1613,1043,1042,1269,1522,251,938,914,1418;41;F
114422;856,634,276,1040,384,1613;67;M
114451;1345,1403,1404,977,1045,384,393,1350,1042,1392,1077,1385,644,1613,1372;36;F
114466;1385,983,1279,856,644,1077,248,1367,1372;33;M
114494;1102,1279,1045,1367,1043,1042,1418,856,1269,1522;38;M
114537;856,1385,715,1042,1380,634,1645,1522,688,1048,644,1504,1627,1395,1376;9;M
114622;1385,1345,644,1391,914,1362,1367,1361,856,1102,1042,1380,1645,1386,1040;30;F
114623;715,1042,1539,644,1404,1376,1403,977,1179,1504,248,1367,1645,1372,384;33;F
114627;1627,571,248,1367,393,983,1539,688,1522,1345,1404,977,1077,1418,1372;30;M
114662;856,938,1077,1036,1372,1362;36;F
114677;983,1392,575,1645,1294,856,1102,688,1404,977,1040,1077,1045,1362,1367;26;F
114728;856,1102,1269,1380,1645,575,1345,1391,1386,1504,1627;35;M
114748;715,1294,1285,1345,1404,251,977,1279,186,571,1367,1372;26;M
114752;1522,1404,1539;36;F
114789;1367;44;F
114873;1361,1350,634,1392,644,938,186,1367,1376;36;M
114875;393,1369,1627,571,1367,1362,186,1391,1345,1392,1645,1385,856;9;M
114901;1361,1102,1380,575,1304,938,856,1645,1285,251,1040,571,384,1367,1036;29;F
114915;1182,1385,856,1102,715,1042,1269,1285,1522,1345,644,977,186,1362,1077;35;F
114932;1372,1539,1645,1350,1385,1052,1403,1391,977,1386,1504,384,1367,1036,1376;32;F
114951;1269;35;F
115019;1045,384,1376,855,1404,715,1046,1539,1367,977,1392,688,856,644,248;38;F
115043;1345,688,1304,575,1380,1269,1182,1350,1046,1042,1522,1077,384,1372,916;41;M
115061;393,1380,634,644;66;M
115075;1367;17;F
115077;1376,1522,644,1395,1418,856,1627,715,1380,1362,938,251,1040,1304,1372;31;M
115089;634,938,1386,571,384,1036,1361,1613,1645,1504,1345,1040,251,644,1385;37;F
115094;1645,634,644,1391,1613,1627,248,1362,1077,1345,1392,856,1102,1042,1372;38;M
115107;248,1345,1392,983,855,1645,1294,1385,1627,1077,1504,1179,1350,1102,856;35;F
115112;1539,1077,1418,1367,1372,248;42;F
115114;914,977,1052,1042,715,1102,1376,644,1391,251,1504,1627,384,1367,1372;13;F
115154;1361,856,1042,1380,1645,1048,1345,644,938,1376,1367;51;F
115172;1036,1369,1372,1361,1102,715,1380,1645,1304,688,1048,1391,251,977,1040;59;M
115239;1367;12;F
115246;1304,1418,393,248,571,1279,1403,1404,575,688,1345,977,1367,1372,1376;39;M
115288;1048,276,1522,855,1294,1385,1645,1285,1345,977,1040,571,1391,1042,384;39;F
115294;715;10;M
115299;1372,1077,1627,1504,1279,1102,1042,1345,977,384,1367;50;F
115317;1504,1627,715,1345,571,1392,1294,1385,856,1367,384,1045,1048,1645,1522;27;M
115336;251,977,1392,1404,248;33;F
115346;1627,186,1040,914,977,251,1391,644,1345,1522,1392,715,1385,1102,856;6;M
115373;1361,856,1304,1048,644,938,1040,1627,1045,384,1367,1036,1369,393,1043;50;M
115403;1613,571,1367,1386,1372,1395,1391,1380,1362,1294,1304,1385,1376;28;M
115408;634,644,1372;39;M
115410;715;39;F
115428;856;41;M
115437;634,1404,914,1279,571,1627,1040,1391,1304,1285,1645,1269,1294,1385,856;51;F
115457;856,1269,1285,1345,251,1279,1077,1418,1367;37;M
115466;1036,1372,1361,1102,1042,634,1645,575,1048,644,1404,1403,1391,1040,384;34;M
115515;1386,644,1522,983,1645,715,1385,856;29;F
115538;1627,914,1052,856,1645,575,1048,1391,251,938,1040,1504,384,1372,1043;25;F
115557;856,715,251,1385,571,384,1367,1372;27;F
115582;856,1102,1385,1269,1285,1392,1304,1522,1048,1345,914,1386,1279,1504,1627;35;F
115604;938,1403,1345,957,1046,1350,1385,1392,1048,1052,644,977,1077;31;F
115625;856,715,1294,1645,1285,1392,1522,644,1279,571,1418,1367;40;M
115658;1627,1504,1372,977,186,856,1645,1285,1345,644,1404,251,1279,571,1045;75;F
115670;1350,914,1036,1043;39;F
115710;1392,1040;29;F
115720;644,1391,1077,1367,384;53;F
115724;644,1645,856,1385,715,1269,575,1285,1345,977,1279,1504,1627,384,1367;40;F
115727;1385,856,1102,1269,1285,1392,1304,1522,1048,1345,914,1386,1279,1627,1504;;F
115761;715,1269,1285,1304,1539,688,977,186,571,1077,384,1367,1372;32;F
115803;715;7;M
115804;1046,1269,575,251,1504,1418,916;36;F
115824;1404,1403;19;M
115870;1345,644,1613,1369,251,1040,1077,1350,1046,1522,914,1045,1036,1043,916;41;F
115909;1042,1102,1269,1522,644,251,1279;34;F
115922;1350,1042,634,1304,1522,1345,1404,977,1040,1504,1418,384,1367,1372,1362;32;M
115965;856,644,251,384;42;F
116021;1350,1285,1392,1522,1345,1404,1403,1279,1504,186,571,1045,248,1367,1043;42;M
116030;977,1627,1077;45;M
116116;1367,957,1304,1361,855,856,1369,571,1042,1040,1385,977,1380,688,186;90;F
116117;1367,1504,1372,855,1279,644,1345,1645,571,1385,384,977,1102,1391,1395;82;F
99999916999;1392,1539,688,1345,1404,977,1627,571,384,1372;23;F
99999929482;1395,1048,1613,251,1040,1077,384,1367,1036,1362,1304,575,1380,856;47;F